/*
 * Decompiled with CFR 0.152.
 */
package com.inet.remote.gui.structure;

import com.inet.annotations.InternalApi;
import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.config.structure.provider.ConfigValidator;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.StringFunctions;
import com.inet.remote.gui.emoji.EmojiData;
import com.inet.remote.gui.structure.CustomEmojiUploadItemListConfigProperty;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class CustomEmojiConfigStructureProvider
extends AbstractStructureProvider {
    public static final String CATEGORY_EMOJI = "category.emoji";
    public static final String GROUP_CUSTOMUPLOADS = "emoji.custom.uploads";
    public static final CustomEmojiConfigStructureProvider INSTANCE = new CustomEmojiConfigStructureProvider();

    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
    }

    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
    }

    public URL getCategoryIcon(@Nonnull String categoryKey) {
        switch (categoryKey) {
            case "category.emoji": {
                return ((Object)((Object)this)).getClass().getResource("emoji_48.svg");
            }
        }
        return null;
    }

    public void addPropertyGroupsTo(@Nonnull Set<ConfigPropertyGroup> configPropertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "category.emoji": {
                configPropertyGroups.add(new ConfigPropertyGroup(100, GROUP_CUSTOMUPLOADS, this.translate(settings, GROUP_CUSTOMUPLOADS, new Object[0])));
                break;
            }
        }
    }

    public void addPropertiesTo(@Nonnull Set<ConfigProperty> configProperties, @Nonnull String propertyGroupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "emoji.custom.uploads": {
                configProperties.add((ConfigProperty)new CustomEmojiUploadItemListConfigProperty(this, this.a(settings, false), settings));
            }
        }
    }

    private List<CustomEmojiUploadItemListConfigProperty.EmojiEntry> a(ConfigStructureSettings configStructureSettings, boolean bl) {
        String string;
        if (!bl && !StringFunctions.isEmpty((String)(string = configStructureSettings.getChangedValue("custom.emoji.upload")))) {
            return (List)new Json().fromJson(string, (Type)new JsonParameterizedType(ArrayList.class, new Type[]{CustomEmojiUploadItemListConfigProperty.EmojiEntry.class}));
        }
        return EmojiData.getCustomEmojis().stream().map(persistenceEntry -> new CustomEmojiUploadItemListConfigProperty.EmojiEntry(persistenceEntry.getName(), this.a(persistenceEntry.getBytes()))).collect(Collectors.toList());
    }

    private String a(byte[] byArray) {
        return "data:image/svg+xml;base64," + Base64.getEncoder().encodeToString(byArray);
    }

    public void validate(@Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings) {
        Object object;
        Object object2;
        if ("addemojicustom.emoji.upload".equals(categoryKey)) {
            object2 = new ConfigValidator(messages, settings);
            if (object2.checkNotEmpty("shortname")) {
                object = settings.getValue("shortname");
                if (!((String)object).matches("[a-z0-9-_]+")) {
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "customemoji.shortname.invalid", new Object[0]), "shortname"));
                } else if (EmojiData.getEmojiDescriptionsMap().entrySet().stream().anyMatch(arg_0 -> CustomEmojiConfigStructureProvider.a((String)object, arg_0))) {
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "customemoji.shortname.predefined", new Object[]{object}), "shortname"));
                }
            }
            if (object2.checkNotEmpty("emojidata") && !((String)(object = settings.getValue("emojidata"))).startsWith("data:image/svg+xml;base64,")) {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "customemoji.emojidata.nosvg", new Object[0]), "emojidata"));
            }
        }
        if (CATEGORY_EMOJI.equals(categoryKey)) {
            object2 = this.a(settings, false);
            object = new HashSet();
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                CustomEmojiUploadItemListConfigProperty.EmojiEntry emojiEntry = (CustomEmojiUploadItemListConfigProperty.EmojiEntry)iterator.next();
                if (((HashSet)object).contains(emojiEntry.shortname)) continue;
                ((HashSet)object).add(emojiEntry.shortname);
                if (object2.stream().filter(emojiEntry2 -> emojiEntry2.shortname.equalsIgnoreCase(emojiEntry.shortname)).count() > 1L) {
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "customemoji.shortname.duplicate", new Object[]{emojiEntry.shortname}), "custom.emoji.upload"));
                    continue;
                }
                if (!EmojiData.getEmojiDescriptionsMap().entrySet().stream().anyMatch(entry -> !((String)entry.getKey()).startsWith("$") && ((EmojiData.EmojiDescription)entry.getValue()).getNames() != null && ((EmojiData.EmojiDescription)entry.getValue()).getNames().contains(emojiEntry.shortname))) continue;
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "customemoji.shortname.predefined", new Object[]{emojiEntry.shortname}), "custom.emoji.upload"));
            }
        }
    }

    public ConfigStructure.SaveState save(String key, String value, @Nonnull ConfigStructureSettings settings) {
        if ("custom.emoji.upload".equals(key)) {
            List<CustomEmojiUploadItemListConfigProperty.EmojiEntry> list = this.a(settings, false);
            List<CustomEmojiUploadItemListConfigProperty.EmojiEntry> list2 = this.a(settings, true);
            List<String> list3 = list.stream().map(emojiEntry -> emojiEntry.shortname).collect(Collectors.toList());
            list2.removeIf(emojiEntry -> list.contains(emojiEntry));
            list.removeIf(emojiEntry -> list2.contains(emojiEntry));
            for (CustomEmojiUploadItemListConfigProperty.EmojiEntry emojiEntry2 : list2) {
                EmojiData.deleteCustomEmoji(emojiEntry2.shortname);
            }
            for (CustomEmojiUploadItemListConfigProperty.EmojiEntry emojiEntry2 : list) {
                EmojiData.saveCustomEmoji(emojiEntry2.shortname, emojiEntry2.emojidata, list3.indexOf(emojiEntry2.shortname));
            }
            EmojiData.saveCustomSortOrder(list3);
            return ConfigStructure.SaveState.SAVE;
        }
        return super.save(key, value, settings);
    }

    private static /* synthetic */ boolean a(String string, Map.Entry entry) {
        return !((String)entry.getKey()).startsWith("$") && ((EmojiData.EmojiDescription)entry.getValue()).getNames() != null && ((EmojiData.EmojiDescription)entry.getValue()).getNames().contains(string);
    }
}

