/*
 * Decompiled with CFR 0.152.
 */
package com.inet.remote.gui.modules.website;

import com.inet.annotations.InternalApi;
import com.inet.cache.MemoryStoreMap;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.plugin.website.WebsiteDownloadConnector;
import com.inet.plugin.website.data.WebsiteDownloadResponseData;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.remote.gui.modules.website.data.WebsiteDownloadRequestProductData;
import com.inet.remote.gui.modules.website.data.WebsiteDownloadResponseProductData;
import com.inet.shared.utils.Version;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@InternalApi
public class WebsiteDownloadHandler
extends ServiceMethod<WebsiteDownloadRequestProductData, WebsiteDownloadResponseProductData> {
    private static final MemoryStoreMap<String, WebsiteDownloadResponseData> ba = new MemoryStoreMap(43200, false);
    private static final WebsiteDownloadResponseData bb = new WebsiteDownloadResponseData();
    private String product;
    private String bc;
    private boolean bd;

    public WebsiteDownloadHandler(String product, String variant) {
        this.product = product;
        this.bc = variant;
    }

    public WebsiteDownloadHandler(String product, String variant, boolean includeMinorVersion) {
        this(product, variant);
        this.bd = includeMinorVersion;
    }

    @Override
    public WebsiteDownloadResponseProductData invoke(HttpServletRequest req, HttpServletResponse resp, WebsiteDownloadRequestProductData payload) {
        Version version;
        Object object = payload == null ? null : payload.getMajorVersion();
        boolean bl = payload == null ? false : payload.isBeta();
        Object object2 = this.getKey();
        if (object != null) {
            version = new Version((String)object);
            object = "" + version.getMajor();
            if (this.bd) {
                object = (String)object + "." + version.getMinor();
            }
            object2 = (String)object2 + "-" + (String)object;
            if (bl) {
                object2 = (String)object2 + "-beta";
            }
        }
        if (ba.containsKey(object2)) {
            return WebsiteDownloadResponseProductData.from((WebsiteDownloadResponseData)ba.get(object2));
        }
        version = WebsiteDownloadConnector.connectorFor((String)this.product, (String)this.bc, (String)object);
        WebsiteDownloadResponseData websiteDownloadResponseData = null;
        try {
            websiteDownloadResponseData = version.getWebsiteDownloadResponseData(bl);
            if (bl) {
                websiteDownloadResponseData.getDownloadLinks().removeIf(downloadLink -> !downloadLink.getLink().contains("/beta/"));
                if (websiteDownloadResponseData.getDownloadLinks().isEmpty()) {
                    websiteDownloadResponseData = null;
                }
            }
        }
        catch (IOException iOException) {
            LogManager.getApplicationLogger().debug((Object)("Could not complete request for product download: " + iOException.getLocalizedMessage()));
        }
        if (websiteDownloadResponseData == null) {
            websiteDownloadResponseData = bb;
        }
        ba.put(object2, (Object)websiteDownloadResponseData);
        return WebsiteDownloadResponseProductData.from(websiteDownloadResponseData);
    }

    private String getKey() {
        if (StringFunctions.isEmpty((String)this.bc)) {
            return this.product;
        }
        return this.product + "_" + this.bc;
    }

    @Override
    public String getMethodName() {
        return "websitedownload_getdata_" + this.getKey();
    }

    @Override
    public short getMethodType() {
        return 1;
    }

    public static void clearDownloadCache() {
        ba.clear();
    }
}

