/*
 * Decompiled with CFR 0.152.
 */
package com.inet.remote.gui.emoji;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.classloader.I18nMessages;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.ReaderSearchTree;
import com.inet.lib.util.StringFunctions;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ApplicationDescription;
import com.inet.remote.gui.RemoteGuiServerPlugin;
import com.inet.thread.ServerLock;
import com.inet.thread.ThreadUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class EmojiData {
    private static HashMap<@Nonnull String, @Nonnull String> aw;
    private static HashMap<String, EmojiDescription> ax;
    private static HashMap<String, String> ay;
    private static ReaderSearchTree<Map.Entry<String, String>> az;
    static final I18nMessages MSG;
    private static final List<a> categories;

    @Nonnull
    public static @Nonnull HashMap<@Nonnull String, @Nonnull String> getShortNameMap() {
        HashMap<@Nonnull String, @Nonnull String> hashMap = aw;
        if (hashMap == null) {
            Object object;
            Object object2;
            hashMap = new HashMap();
            try {
                object2 = EmojiData.class.getResourceAsStream("/META-INF/resources/webjars/twemoji/emoji-shortname.json");
                try {
                    object = (HashMap)new Json().fromJson((InputStream)object2, (Type)new JsonParameterizedType(HashMap.class, new Type[]{String.class, String.class}), null, null);
                    if (object != null) {
                        hashMap = object;
                    }
                }
                finally {
                    if (object2 != null) {
                        ((InputStream)object2).close();
                    }
                }
            }
            catch (IOException iOException) {
                RemoteGuiServerPlugin.LOGGER.error((Throwable)iOException);
            }
            object2 = EmojiData.getCustomEmojis();
            object = object2.iterator();
            while (object.hasNext()) {
                PersistenceEntry persistenceEntry = (PersistenceEntry)object.next();
                hashMap.put(persistenceEntry.getName(), "$" + persistenceEntry.getName());
            }
            aw = hashMap;
        }
        return hashMap;
    }

    public static String getCharacterForShortName(String shortName) {
        String string = EmojiData.getShortNameMap().get(shortName);
        if (string == null) {
            return ":" + shortName + ":";
        }
        return EmojiData.convertCodeToCharacter(string);
    }

    public static String convertCodeToCharacter(String code) {
        if (code.startsWith("$")) {
            return ":" + code.substring(1) + ":";
        }
        code = code.toLowerCase();
        @Nonnull String[] stringArray = code.split("-");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.appendCodePoint(Integer.parseInt(string, 16));
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static HashMap<String, EmojiDescription> getEmojiDescriptionsMap() {
        HashMap<String, EmojiDescription> hashMap = ax;
        if (hashMap == null) {
            Object object;
            Object object2;
            hashMap = new HashMap();
            try {
                object2 = EmojiData.class.getResourceAsStream("/META-INF/resources/webjars/twemoji/emoji-code.json");
                try {
                    object = (HashMap)new Json().fromJson((InputStream)object2, (Type)new JsonParameterizedType(HashMap.class, new Type[]{String.class, EmojiDescription.class}), null, null);
                    if (object != null) {
                        hashMap = object;
                    }
                }
                finally {
                    if (object2 != null) {
                        ((InputStream)object2).close();
                    }
                }
            }
            catch (IOException iOException) {
                RemoteGuiServerPlugin.LOGGER.error((Throwable)iOException);
            }
            object2 = EmojiData.getCustomSortOrder();
            object = EmojiData.getCustomEmojis();
            Iterator<PersistenceEntry> iterator = object.iterator();
            while (iterator.hasNext()) {
                PersistenceEntry persistenceEntry = iterator.next();
                EmojiDescription emojiDescription = EmojiData.a(persistenceEntry.getName(), object2.indexOf(persistenceEntry.getName()));
                hashMap.put("$" + persistenceEntry.getName(), emojiDescription);
            }
            ax = hashMap;
        }
        return hashMap;
    }

    private static EmojiDescription a(String string, int n) {
        EmojiDescription emojiDescription = new EmojiDescription();
        emojiDescription.c = "custom";
        emojiDescription.n = List.of(string);
        emojiDescription.s = n == -1 ? Integer.MAX_VALUE : 1000000000 + n;
        return emojiDescription;
    }

    @Nullable
    public static EmojiDescription getEmojiDescription(String code) {
        return EmojiData.getEmojiDescriptionsMap().get(code);
    }

    @Nonnull
    public static ReaderSearchTree<Map.Entry<String, String>> getUnicodeSearchTree() {
        ReaderSearchTree readerSearchTree = az;
        if (readerSearchTree == null) {
            ArrayList<AbstractMap.SimpleEntry<String, String>> arrayList = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
            for (String string : EmojiData.getEmojiDescriptionsMap().keySet()) {
                arrayList.add(new AbstractMap.SimpleEntry<String, String>(string, EmojiData.convertCodeToCharacter(string)));
            }
            az = readerSearchTree = new ReaderSearchTree(arrayList, entry -> (String)entry.getValue());
        }
        return readerSearchTree;
    }

    @Nonnull
    public static HashMap<String, String> getTextEmojiMap() {
        HashMap<String, String> hashMap = ay;
        if (hashMap == null) {
            hashMap = new HashMap();
            try (InputStream inputStream = EmojiData.class.getResourceAsStream("/META-INF/resources/webjars/twemoji/emoji-texts.json");){
                HashMap<String, String> hashMap2 = (HashMap<String, String>)new Json().fromJson(inputStream, (Type)new JsonParameterizedType(HashMap.class, new Type[]{String.class, String.class}), null, null);
                if (hashMap2 != null) {
                    hashMap = hashMap2;
                }
            }
            catch (IOException iOException) {
                RemoteGuiServerPlugin.LOGGER.error((Throwable)iOException);
            }
            ay = hashMap;
        }
        return hashMap;
    }

    public static URL findEmojiImageURL(String code) {
        Object object;
        if (((String)(code = ((String)code).toLowerCase())).startsWith("$") && (object = EmojiData.getCustomEmoji(((String)code).substring(1))) != null) {
            try {
                return new URL("data:image/svg+xml;base64," + Base64.getEncoder().encodeToString(object.getBytes()));
            }
            catch (MalformedURLException malformedURLException) {
                RemoteGuiServerPlugin.LOGGER.error((Throwable)malformedURLException);
            }
        }
        if (((String)code).startsWith("00")) {
            code = ((String)code).substring(2, 4) + "-20e3";
        }
        if ("a9-20e3".equals(code)) {
            code = "a9";
        }
        if ("ae-20e3".equals(code)) {
            code = "ae";
        }
        if ((object = EmojiData.class.getResource("/META-INF/resources/webjars/twemoji/assets/svg/" + (String)code + ".svg")) == null) {
            code = ((String)code).replace("-fe0f", "");
        }
        object = EmojiData.class.getResource("/META-INF/resources/webjars/twemoji/assets/svg/" + (String)code + ".svg");
        return object;
    }

    public static List<a> getCategories() {
        ArrayList<a> arrayList = new ArrayList<a>(categories);
        boolean bl = EmojiData.hasCustomEmojis();
        if (bl) {
            arrayList.add(1, new a("custom", ":$$:", () -> ApplicationDescription.get().getRemoteGuiInformation().getTitle()));
        }
        return arrayList;
    }

    public static boolean hasCustomEmojis() {
        return Persistence.getInstance().resolve("customemoji").exists();
    }

    public static List<PersistenceEntry> getCustomEmojis() {
        List list = Persistence.getInstance().resolve("customemoji").getChildren();
        list.removeIf(persistenceEntry -> "_customsortorder".equals(persistenceEntry.getName()));
        List<String> list2 = EmojiData.getCustomSortOrder();
        Comparator comparator = Comparator.naturalOrder();
        list.sort((persistenceEntry, persistenceEntry2) -> {
            int n = Integer.compare(list2.indexOf(persistenceEntry.getName()), list2.indexOf(persistenceEntry2.getName()));
            if (n != 0) {
                return n;
            }
            return comparator.compare(persistenceEntry.getName(), persistenceEntry2.getName());
        });
        return list;
    }

    public static PersistenceEntry getCustomEmoji(String shortname) {
        PersistenceEntry persistenceEntry = Persistence.getInstance().resolve("customemoji/" + shortname);
        if (!persistenceEntry.exists()) {
            return null;
        }
        return persistenceEntry;
    }

    public static void deleteCustomEmoji(String shortname) {
        try (ServerLock serverLock = ThreadUtils.getWriteLock((Object)shortname);){
            Persistence.getInstance().resolve("customemoji/" + shortname).deleteTree();
            EmojiData.getEmojiDescriptionsMap().remove("$" + shortname);
            EmojiData.getShortNameMap().remove(shortname);
        }
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Only reading base64 image data.")
    public static void saveCustomEmoji(String shortname, String base64ImageData, int sortOrder) {
        try (ServerLock serverLock = ThreadUtils.getWriteLock((Object)shortname);){
            try (OutputStream outputStream = Persistence.getInstance().resolve("customemoji/" + shortname).getOutputStream();
                 InputStream inputStream = new URL(base64ImageData).openStream();){
                IOFunctions.copyData((InputStream)inputStream, (OutputStream)outputStream);
                EmojiData.getEmojiDescriptionsMap().put("$" + shortname, EmojiData.a(shortname, sortOrder));
                EmojiData.getShortNameMap().put(shortname, "$" + shortname);
            }
            catch (Throwable throwable) {
                RemoteGuiServerPlugin.LOGGER.error(throwable);
            }
        }
    }

    public static void saveCustomSortOrder(List<String> sortOrder) {
        try (ServerLock serverLock = ThreadUtils.getWriteLock((Object)"customsortorder");){
            if (sortOrder == null || sortOrder.isEmpty()) {
                Persistence.getInstance().resolve("customemoji/_customsortorder").deleteTree();
                return;
            }
            try (OutputStream outputStream = Persistence.getInstance().resolve("customemoji/_customsortorder").getOutputStream();){
                new Json().toJson(sortOrder, outputStream);
            }
            catch (Throwable throwable) {
                RemoteGuiServerPlugin.LOGGER.error(throwable);
            }
        }
    }

    public static List<String> getCustomSortOrder() {
        block14: {
            try (ServerLock serverLock = ThreadUtils.getReadLock((Object)"customsortorder");){
                List list;
                PersistenceEntry persistenceEntry = Persistence.getInstance().resolve("customemoji/_customsortorder");
                if (!persistenceEntry.exists()) break block14;
                InputStreamReader inputStreamReader = new InputStreamReader(persistenceEntry.getInputStream());
                try {
                    list = (List)new Json().fromJson((Reader)inputStreamReader, (Type)new JsonParameterizedType(ArrayList.class, new Type[]{String.class}));
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            inputStreamReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        RemoteGuiServerPlugin.LOGGER.error(throwable3);
                        break block14;
                    }
                }
                inputStreamReader.close();
                return list;
            }
        }
        return Collections.emptyList();
    }

    public static List<EmojiMatch> searchEmojis(String phrase) {
        ArrayList<EmojiMatch> arrayList = new ArrayList<EmojiMatch>();
        if (phrase.length() > 1 && phrase.startsWith(":") && phrase.endsWith(":")) {
            phrase = phrase.substring(1, phrase.length() - 1);
        } else if (phrase.startsWith(":")) {
            phrase = phrase.substring(1);
        }
        String string = phrase.toLowerCase();
        Set<Map.Entry<String, String>> set = EmojiData.getShortNameMap().entrySet();
        for (Map.Entry<String, String> entry : set) {
            if (entry.getKey().equals(string)) {
                arrayList.add(new EmojiMatch((String)entry.getValue(), ":" + (String)entry.getKey() + ":", 0, true));
                continue;
            }
            if (((String)entry.getKey()).startsWith(string)) {
                arrayList.add(new EmojiMatch((String)entry.getValue(), ":" + (String)entry.getKey() + ":", 1, true));
                continue;
            }
            if (((String)entry.getKey()).contains("_" + string) || ((String)entry.getKey()).contains("-" + string) || ((String)entry.getKey()).contains("+" + string)) {
                arrayList.add(new EmojiMatch((String)entry.getValue(), ":" + (String)entry.getKey() + ":", 2, true));
                continue;
            }
            if (!((String)entry.getKey()).contains(string)) continue;
            arrayList.add(new EmojiMatch((String)entry.getValue(), ":" + (String)entry.getKey() + ":", 3, true));
        }
        if (!StringFunctions.isEmpty((String)phrase)) {
            Map.Entry<String, String> entry;
            String string2 = ":" + phrase;
            entry = ":" + phrase.toLowerCase();
            set = EmojiData.getTextEmojiMap().entrySet();
            for (Map.Entry<String, String> entry2 : set) {
                if (entry2.getKey().equals(string2)) {
                    arrayList.add(new EmojiMatch(entry2.getValue(), entry2.getKey(), 0, false));
                    continue;
                }
                if (entry2.getKey().equalsIgnoreCase(string2)) {
                    arrayList.add(new EmojiMatch(entry2.getValue(), entry2.getKey(), 1, false));
                    continue;
                }
                if (entry2.getKey().startsWith(string2)) {
                    arrayList.add(new EmojiMatch(entry2.getValue(), entry2.getKey(), 2, false));
                    continue;
                }
                if (!entry2.getKey().toLowerCase().startsWith((String)((Object)entry))) continue;
                arrayList.add(new EmojiMatch(entry2.getValue(), entry2.getKey(), 3, false));
            }
        }
        arrayList.sort((emojiMatch, emojiMatch2) -> {
            int n = Integer.compare(emojiMatch.getSortPriority(), emojiMatch2.getSortPriority());
            if (n != 0) {
                return n;
            }
            int n2 = Integer.compare(emojiMatch.getSortOrder(), emojiMatch2.getSortOrder());
            if (n2 != 0) {
                return n2;
            }
            return emojiMatch.getEmojiShortName().compareToIgnoreCase(emojiMatch2.getEmojiShortName());
        });
        return arrayList;
    }

    static {
        MSG = new I18nMessages("com.inet.remote.gui.emoji.i18n.LanguageResources", EmojiData.class);
        categories = new ArrayList<a>(){
            {
                this.add(new a("Recently Used", ":clock3:", () -> MSG.getMsg("category.recentlyused", new Object[0])));
                this.add(new a("Smileys & Emotion", ":grinning:", () -> MSG.getMsg("category.smileysemotion", new Object[0])));
                this.add(new a("People & Body", ":technologist:", () -> MSG.getMsg("category.peoplebody", new Object[0])));
                this.add(new a("Animals & Nature", ":penguin:", () -> MSG.getMsg("category.animalsnature", new Object[0])));
                this.add(new a("Food & Drink", ":coffee:", () -> MSG.getMsg("category.fooddrink", new Object[0])));
                this.add(new a("Activities", ":soccer:", () -> MSG.getMsg("category.activities", new Object[0])));
                this.add(new a("Travel & Places", ":oncoming_automobile:", () -> MSG.getMsg("category.travelplaces", new Object[0])));
                this.add(new a("Objects", ":bulb:", () -> MSG.getMsg("category.objects", new Object[0])));
                this.add(new a("Symbols", ":infinity:", () -> MSG.getMsg("category.symbols", new Object[0])));
                this.add(new a("Flags", ":checkered_flag:", () -> MSG.getMsg("category.flags", new Object[0])));
            }
        };
    }

    @JsonData
    public static class EmojiDescription {
        private String c;
        private String v;
        private int s;
        private List<String> n;
        private List<String> t;

        private EmojiDescription() {
        }

        public String getCategory() {
            return this.c;
        }

        public List<String> getNames() {
            return this.n;
        }

        public int getSortOrder() {
            return this.s;
        }

        @Nullable
        public List<String> getTextEmojis() {
            return this.t;
        }

        public String getVariationParent() {
            return this.v;
        }
    }

    public static class a {
        private String categoryKey;
        private String emojiShortname;
        private Supplier<String> aA;

        public a(String string, String string2, Supplier<String> supplier) {
            this.categoryKey = string;
            this.emojiShortname = string2;
            this.aA = supplier;
        }

        public String getCategoryKey() {
            return this.categoryKey;
        }

        public String t() {
            return this.emojiShortname;
        }

        public String getDisplayName() {
            return this.aA.get();
        }
    }

    @JsonData
    public static class EmojiMatch {
        private String code;
        private int sortPriority;
        private int sortOrder = Integer.MAX_VALUE;
        private EmojiDescription emojiDescription;
        private boolean matchedByShortName;
        private String emojiShortName;

        public EmojiMatch(String code, String emojiShortName, int sortPriority, boolean matchedByShortName) {
            this.code = code;
            this.emojiShortName = emojiShortName;
            this.sortPriority = sortPriority;
            this.matchedByShortName = matchedByShortName;
            this.emojiDescription = EmojiData.getEmojiDescription(code);
            if (this.emojiDescription != null) {
                this.sortOrder = this.emojiDescription.getSortOrder();
            }
        }

        public EmojiDescription getEmojiDescription() {
            return this.emojiDescription;
        }

        public String getCode() {
            return this.code;
        }

        public String getEmojiShortName() {
            return this.emojiShortName;
        }

        public String getCleanEmojiShortName() {
            if (this.emojiShortName.startsWith(":") && this.emojiShortName.endsWith(":")) {
                return this.emojiShortName.substring(1, this.emojiShortName.length() - 1);
            }
            return this.emojiShortName;
        }

        public int getSortPriority() {
            return this.sortPriority;
        }

        public int getSortOrder() {
            return this.sortOrder;
        }

        public boolean isMatchedByShortName() {
            return this.matchedByShortName;
        }
    }
}

