'use strict';(function(){angular.module("clearreportsApp").service("indexedDB",[function(){var $this=this;class Store{constructor(dbName="inetsoftware-store",storeName="inetsoftware"){this.dbName=dbName;this.storeName=storeName}_withIDBStore(txMode,callback){const request=window.indexedDB.open(this.dbName);request.onupgradeneeded=()=>request.result.createObjectStore(this.storeName);const dbp=promisifyRequest(request);return dbp.then(db=>callback(db.transaction(this.storeName,txMode).objectStore(this.storeName)))}}
let defaultStore;function getDefaultStore(){if(!defaultStore)defaultStore=new Store;return defaultStore}$this.createCustomStore=function(storeName,dbName="inetsoftware-store"){return new Store(dbName,storeName)};function promisifyRequest(request){return new Promise((resolve,reject)=>{request.oncomplete=request.onsuccess=()=>resolve(request.result);request.onabort=request.onerror=()=>reject(request.error)})}function eachCursor(customStore,callback){return customStore._withIDBStore("readonly",store=>
{store.openCursor().onsuccess=function(){if(!this.result)return;callback(this.result);this.result.continue()};return promisifyRequest(store.transaction)})}$this.get=function(key,customStore){const store=customStore||getDefaultStore();return store._withIDBStore("readonly",_store=>promisifyRequest(_store.get(key)))};$this.set=function(key,value,customStore){const store=customStore||getDefaultStore();return store._withIDBStore("readwrite",_store=>{_store.put(value,key);return promisifyRequest(_store.transaction)})};
$this.setMany=function(entries,customStore){const store=customStore||getDefaultStore();return store._withIDBStore("readwrite",_store=>{entries.forEach(entry=>_store.put(entry[1],entry[0]));return promisifyRequest(_store.transaction)})};$this.getMany=function(keys,customStore){const store=customStore||getDefaultStore();return store._withIDBStore("readonly",_store=>Promise.all(keys.map(key=>promisifyRequest(_store.get(key)))))};$this.del=function(key,customStore){const store=customStore||getDefaultStore();
return store._withIDBStore("readwrite",_store=>{_store.delete(key);return promisifyRequest(_store.transaction)})};$this.clear=function(customStore){const store=customStore||getDefaultStore();return store._withIDBStore("readwrite",_store=>{_store.clear();return promisifyRequest(_store.transaction)})};$this.keys=function(customStore){const items=[],store=customStore||getDefaultStore();return eachCursor(store,cursor=>items.push(cursor.key)).then(()=>items)};$this.values=function(customStore){const items=
[],store=customStore||getDefaultStore();return eachCursor(store,cursor=>items.push(cursor.value)).then(()=>items)};$this.entries=function(customStore){const items=[],store=customStore||getDefaultStore();return eachCursor(store,cursor=>items.push([cursor.key,cursor.value])).then(()=>items)};return this}])})();