import {DataService} from './dataservice.js';
import {KytosElement} from './kytos-element.js';
import {KytosI18n} from './kytos-i18n.js';
import {KytosRepeat,KytosRepeatItem} from './kytos-repeat.js';
import {MyTest} from './my-test.js';

export class DataTest extends KytosElement {

    dataBindingModel = {
        data: 'hehe',
        error: 'uiuiui, kaputt!',
        inner: {
            abc: 'abc'
        },
        datetime: {
            value: 0,
            display: ''
        },
		myArray: [{
			x: 'val1'
		},{
			x: 'val2'
		},{
			x: 'val3'
		},{
			x: 'val5'
		}]
    };
    
    template = `<div class="panel">
                    <div class="panel-body">
                        <h2>Data Service Test - <span k-i18n="loadingApplication"></span></h2>
                        <h3 k-repeat-item="dataBindingModel.myArray"><span k-i18n="apply"></span> {{item.x}} at index {{index}}</h3>
                        <div class="input-group">
                            <input type="text" k-bind="dataBindingModel.userinput" class="form-control">
                            <div class="input-group-btn">
                                <button class="btn btn-primary">
                                    Fetch Data
                                </button>
                            </div>
                        </div>
                        <br>
                        <div>
                            <h3>Response Data:</h3>
                            <pre>Input: {{dataBindingModel.userinput}}</pre>
                            <pre>Lustig: {{dataBindingModel.data}}</pre>
                            <pre>Extern: {{dataBindingModel.content}}</pre>
                            <pre>Inner Model: {{dataBindingModel.inner.abc}}</pre>
                            <pre>Deferred Model: {{dataBindingModel.deferred.huhu}}</pre>
                            <pre>Current Date: {{dataBindingModel.datetime.display}} + ({{dataBindingModel.datetime.value}})</pre>
                        </div>
                        <div>
                            <h3>Response Error:</h3>
                            <pre>{{dataBindingModel.error}}</pre>
                            <pre k-bind="dataBindingModel.error"></pre>
                        </div>
    					<my-test id="toberemoved"></my-test>
                    </div>
                </div>
				
				<div>
					<k-repeat class="repeat-table">
						<table class="table">
							<thead>
								<tr><th>Index</th><th>Item</th><th>my-test</th></tr>
							</thead>
							<tbody>
								<tr k-repeat>
									<td>{{index}}</td>
									<td>{{item.label}}</td>
									<td><my-test val="my-test at index {{index}}"></my-test></td>
								</tr>
							</tbody>
						</table>
					</k-repeat>
					<k-repeat class="list-group repeat-list">
						<div k-repeat class="list-group-item" style="display: flex; gap: 15px;">
							<div index="{{index}}">Item {{index}}:</div>
							<div>&nbsp;&nbsp;&nbsp;&nbsp;<strong>{{item.label}}</strong></div>
							<my-test val="Here at index {{index}} with the custom my-test element :-)"></my-test>
							
							<k-repeat class="list-group repeat-inner-list">
								<div k-repeat index="{{index}}">Item {{index}}: {{item.label}}</div>
							</k-repeat>
						</div>
					</k-repeat>
					<k-repeat class="repeat-menu dropdown open">
						<button type="button" class="btn btn-default btn-withcaret" data-toggle="dropdown"><span>MENU</span></button>
						<ul class="dropdown-menu">
							<li><a href=""><span>first fixed entry</span></a></li>
							<li><a href=""><span>second fixed entry</span></a></li>
							<li k-repeat class="divider"></li>
							<li k-repeat><a href=""><span>Repeated entry at index {{index}}: {{item.label}}</span></a></li>
							<li k-repeat><a href=""><span>Repeated (again) entry at index {{index}}: {{item.label}}</span></a></li>
						</ul>
					</k-repeat>
				</div>
				
				`;

    init()  {
        let instance = this;
        
        setTimeout(function() {
			instance.dataBindingModel.myArray.splice(3,0,{x:'val4 (new)'});
//			instance.dataBindingModel.myArray[3] = {x:'val4 (new)'};
	        setTimeout(function() {
				instance.dataBindingModel.myArray.splice(0);
		        setTimeout(function() {
					instance.dataBindingModel.myArray.splice(0,0,{x:'lonly item'});
				}, 2000);
			}, 2000);
		}, 2000);
		
        setTimeout(function() {
            instance.dataBindingModel.data="xxx";
            instance.dataBindingModel.inner.abc="def";
            instance.dataBindingModel.deferred = {
                huhu : "yeah, bin deferred!"
            };
            setTimeout(function() {
                instance.dataBindingModel.deferred.huhu="yeah, bin deferred und geändert!!!";
            },5000);
        },5000);
		
        setTimeout(function() {
            instance.querySelector('#toberemoved').remove();
        },10000);

        setInterval(function() {
            let date = new Date();
            instance.dataBindingModel.datetime.value = date.getTime();
            instance.dataBindingModel.datetime.display = date.toString();
        },1000);
    };
	
	#updateListsInUI() {
		this.querySelector('k-repeat.repeat-table').itemList = this.#itemList;
		this.querySelector('k-repeat.repeat-menu').itemList = this.#itemList;
		this.querySelector('k-repeat.repeat-list').itemList = this.#itemList;
		for (let instance of this.querySelectorAll('k-repeat.repeat-inner-list')) {
			instance.itemList = this.#itemList;
		}
	};
	
	#handleButtonClick = e => {
        let target = e.currentTarget;
        target.setAttribute('disabled', 'true');
        this.fetchData();
        target.removeAttribute('disabled');
    };
	
	#handleInputChange = e => {
	    this.dataBindingModel.userinput = e.target.value;
    };
	
	#itemList = undefined;
    
    attached() {
        this.querySelector('button').addEventListener('click', this.#handleButtonClick );
		this.querySelector('input').addEventListener('input', this.#handleInputChange);
		
		this.#itemList = [{label: 'abc'}, {label: 'def'}, {label: 'ghi'}];
		this.#updateListsInUI();
		
        let instance = this;
		setTimeout(function() {
		    instance.#itemList.splice(3,0,{label: 'xyz'});
			instance.#updateListsInUI();
			setTimeout(function() {
			    instance.#itemList.splice(0,1);
				instance.#itemList[1] = {label: '123456 :-)'};
				instance.#updateListsInUI();

			}, 5000);
		}, 5000);
		
		let intervalId = setInterval(function() {
			instance.#itemList.push({label:  new Date().toString()});
			instance.#updateListsInUI();
			if (instance.#itemList.length>10) {
				clearInterval(intervalId);
			}
        },800);
    };
	
	detached() {
		this.querySelector('button').removeEventListener('click', this.#handleButtonClick);
		this.querySelector('input').removeEventListener('input', this.#handleInputChange);
	};
    
    // Festlegen, welche Attribute überwacht werden sollen
    static get observedAttributes() {
        return ['content'];
    };

    attributeChangedCallback(attributeName, oldValue, newValue) {
        this.dataBindingModel[attributeName] = newValue;
    };

    fetchData() {
		DataService.execute({
			command: 'usersandgroups.servicedata',
			data: { test: 'value' },
			success: (data) => {
				this.dataBindingModel.data = JSON.stringify(data);
                this.dataBindingModel.userinput = new Date().toString();
                this.dataBindingModel.error = '<script>alert("haha");</script>';
			    this.#itemList.push({label: 'Response: '+this.dataBindingModel.data});
			    this.#updateListsInUI();
			},
			error: (errorMessage) => {
				console.error('Heul: '+errorMessage);
				this.dataBindingModel.error = errorMessage;
			}
		});
		DataService.execute({
			command: 'usersandgroups.userdetails',
			data: { id: '000011' },
			success: (data) => {
				console.log(data);
			},
			error: (errorMessage) => {
				console.error('Heul: '+errorMessage);
				this.dataBindingModel.error = errorMessage;
			}
		});
    }

}-

customElements.define('data-test',DataTest);
