'use strict';

// CODELAB: Update cache names any time any of the cached files change.
const CACHE_NAME = 'offline-v4';

// CODELAB: Add list of files to cache here.
const FILES_TO_CACHE = [
    'weblib/pwaoffline'
];

self.addEventListener('install', (evt) => {
    // CODELAB: Precache static resources here.
    evt.waitUntil(
                  caches.open(CACHE_NAME).then((cache) => {
                      console.log('[ServiceWorker] Pre-caching offline page');
                      return cache.addAll(FILES_TO_CACHE);
                  })
    );
    self.skipWaiting();
});

self.addEventListener('activate', (evt) => {
  // CODELAB: Remove previous cached data from disk.
  evt.waitUntil(
                caches.keys().then((keyList) => {
                  return Promise.all(keyList.map((key) => {
                    if (key !== CACHE_NAME) {
                      console.log('[ServiceWorker] Removing old cache', key);
                      return caches.delete(key);
                    }
                  }));
                })
            );
  self.clients.claim();
});

self.addEventListener('fetch', (evt) => {
    // CODELAB: Add fetch event handler here.
    if (evt.request.mode !== 'navigate') {
      // Not a page navigation, bail.
      return;
    }
    // Ignore login requests, because of a bug in chrome with localhost
    if (evt.request.url.indexOf(self.location.origin + '/login') == 0) {
        return;
    }
    evt.respondWith(
        fetch(evt.request)
            .catch(() => {
              return caches.open(CACHE_NAME)
                  .then((cache) => {
                    return cache.match('weblib/pwaoffline');
                  });
            })
    );
});

var getNotificationTargetURL = function(targetUrl, baseURL) {
    if (!targetUrl) {
        return targetUrl;
    }
    var lowerCaseURL = targetUrl.toLowerCase();
    if (lowerCaseURL.indexOf('http://') == 0 || lowerCaseURL.indexOf('https://') == 0) {
        return targetUrl;
    }
    return baseURL + targetUrl;
};

var matchingLength = function(url, target) {
    if (url.length>target.length) {
    url = url.substring(0,target.length);
  }
    if (target.length>url.length) {
    target = target.substring(0,url.length);
  }
  var matchCount = 0;
  for (var i=0; i<url.length; i++) {
    if (url[i] != target[i]) {
        break;
    }
    matchCount++;
  }
  return matchCount;
};

self.addEventListener('notificationclick', (evt) => {
    if (evt.notification.data != undefined) {
        // Get all the Window clients
        evt.waitUntil(clients.matchAll({ type: 'window' }).then(clientsArr => {
            // If a Window tab matching the targeted URL already exists, focus that;
            var targetURL = getNotificationTargetURL(evt.notification.data, self.registration.scope);
            const hadWindowToFocus = clientsArr.some(windowClient => windowClient.url === targetURL ? (windowClient.focus && windowClient.focus(), true) : false);
            // Otherwise, open a new tab to the applicable URL and focus it.
            if (!hadWindowToFocus) {
                if (!clientsArr.length || targetURL.indexOf(self.registration.scope)<0) { // No opened window or external URL
                    clients.openWindow(targetURL).then(windowClient => windowClient ? (windowClient.focus && windowClient.focus()) : null);
                } else {
                    var lastClient = clientsArr[clientsArr.length-1];
                    if (clientsArr.length>1) {
                        var currentMatchingLength = 0;
                        for (var i=clientsArr.length-1; i>=0; i--) {
                            var clientWindow = clientsArr[i];
                            var matchLength = matchingLength(clientWindow.url, targetURL);
                            if (matchLength > currentMatchingLength) {
                                currentMatchingLength = matchLength;
                                lastClient = clientWindow;
                            }
                        }
                    }
                    
                    lastClient.focus && lastClient.focus();
                    lastClient.postMessage("navigateto:"+targetURL);
                }
            }
        }));
    }
    evt.notification.close();
});

self.addEventListener('push', (evt) => {
    var noti = evt.data.json();
    
    var sendNoti = async () => {
        var existingNotis = await self.registration.getNotifications({
            tag: noti.id
        }); 
        try {
            for (var i=0; i<existingNotis.length; i++) {
                existingNotis[i].close();
            }
        } catch (error) {
            console.error("Error closing notifications: "+error);
        }
        
        var options = {
            body: noti.message,
            icon: noti.groupingKey ? 'start/?method=notification_getgroupicon&notificationgroupkey='+noti.groupingKey : 'images/design/logo?height=128&runtimemode=default&icononly=true',
            badge: noti.groupingKey ? 'start/?method=notification_getgroupicon&notificationgroupkey='+noti.groupingKey : 'images/design/logo?height=128&runtimemode=default&icononly=true',
            tag: noti.id,
            requireInteraction: noti.critical
        };
        if (noti.targetUrl) {
            options.data = noti.targetUrl;
        }
        return self.registration.showNotification(noti.title, options);
    };
    evt.waitUntil(sendNoti());
    
});
