/*
 * Decompiled with CFR 0.152.
 */
package com.inet.remote.gui.modules.importexport;

import com.inet.annotations.InternalApi;
import com.inet.http.ClientMessageException;
import com.inet.http.upload.AttachmentDescription;
import com.inet.http.utils.MimeTypes;
import com.inet.id.GUID;
import com.inet.lib.util.IOFunctions;
import com.inet.remote.gui.RemoteGuiServerPlugin;
import com.inet.remote.gui.modules.importexport.ExportableWidget;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;

@InternalApi
public interface GenericImportHandler<Folder extends ExportableWidget, Widget extends ExportableWidget> {
    public static final String FOLDER_NAME = "folder.name";

    default public void iterateParts(HttpServletRequest req, List<AttachmentDescription> attachments, List<String> errorMessages, List<String> existingPathes, AtomicInteger importedCount, boolean validateFirst, boolean forceOverwrite, Folder folder) {
        for (int i = 0; i < attachments.size(); ++i) {
            AttachmentDescription attachmentDescription = attachments.get(i);
            try {
                Part part = req.getPart("attachment" + i);
                this.handleUpload(attachmentDescription, part, folder, errorMessages, existingPathes, importedCount, validateFirst, forceOverwrite);
                continue;
            }
            catch (Throwable throwable) {
                RemoteGuiServerPlugin.LOGGER.warn((Object)throwable);
                errorMessages.add(RemoteGuiServerPlugin.MSG.getMsg("genericimport.import.error", new Object[]{attachmentDescription.getName()}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void handleUpload(AttachmentDescription attDesc, Part part, Folder folder, List<String> errorMessages, List<String> existingPathes, AtomicInteger importedCount, boolean validateFirst, boolean forceOverwrite) throws IOException {
        if ("application/zip".equals(part.getContentType()) || "application/zip".equals(MimeTypes.getMimeType((String)attDesc.getName()))) {
            File file = File.createTempFile("widgetimport", ".zip");
            try {
                Object object;
                try (Closeable closeable = new FileOutputStream(file);){
                    object = part.getInputStream();
                    try {
                        IOFunctions.copyData((InputStream)object, (OutputStream)closeable);
                    }
                    finally {
                        if (object != null) {
                            ((InputStream)object).close();
                        }
                    }
                }
                closeable = new ZipFile(file);
                try {
                    object = ((ZipFile)closeable).entries();
                    block25: while (object.hasMoreElements()) {
                        ZipEntry zipEntry = (ZipEntry)object.nextElement();
                        try {
                            String[] stringArray = zipEntry.getName().split("/");
                            GUID gUID = folder.getId();
                            for (int i = 0; i < stringArray.length; ++i) {
                                String string = stringArray[i];
                                Folder Folder = this.getFolderById(gUID);
                                if (Folder == null && !validateFirst) {
                                    throw new ClientMessageException("no current folder", (Throwable)new FileNotFoundException());
                                }
                                if (i == stringArray.length - 1 && !zipEntry.isDirectory()) {
                                    if (string.startsWith("._") || string.equals(".DS_Store") || string.equals(FOLDER_NAME) || this.listOfFilesForFolder().contains(string)) continue block25;
                                    this.importWidget(((ZipFile)closeable).getInputStream(zipEntry), Folder, existingPathes, validateFirst, forceOverwrite);
                                    if (validateFirst) continue;
                                    importedCount.incrementAndGet();
                                    continue;
                                }
                                if (string.equals("__MACOSX") || string.equals(".Trashes")) continue block25;
                                Object object2 = "";
                                for (int j = 0; j <= i; ++j) {
                                    object2 = (String)object2 + stringArray[j];
                                    object2 = (String)object2 + "/";
                                }
                                ZipEntry zipEntry2 = ((ZipFile)closeable).getEntry((String)object2 + FOLDER_NAME);
                                if (zipEntry2 != null) {
                                    string = IOFunctions.readString((InputStream)((ZipFile)closeable).getInputStream(zipEntry2), (Charset)StandardCharsets.UTF_8);
                                }
                                gUID = this.importFolder(validateFirst, (ZipFile)closeable, string, Folder, (String)object2);
                            }
                        }
                        catch (Exception exception) {
                            RemoteGuiServerPlugin.LOGGER.debug((Object)exception);
                            errorMessages.add(RemoteGuiServerPlugin.MSG.getMsg("genericimport.import.error", new Object[]{attDesc.getName() + " (" + zipEntry.getName() + ")"}) + ": " + exception.getMessage());
                        }
                    }
                }
                finally {
                    ((ZipFile)closeable).close();
                }
            }
            finally {
                file.delete();
            }
            return;
        }
        try (InputStream inputStream = part.getInputStream();){
            this.importWidget(inputStream, folder, existingPathes, validateFirst, forceOverwrite);
            if (!validateFirst) {
                importedCount.incrementAndGet();
            }
        }
    }

    public GUID importFolder(boolean var1, ZipFile var2, String var3, Folder var4, String var5) throws IOException;

    public void importWidget(InputStream var1, Folder var2, List<String> var3, boolean var4, boolean var5) throws IOException;

    @Nullable
    public Folder getFolderById(GUID var1);

    public List<String> listOfFilesForFolder();
}

