/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.taskplanner;

import com.inet.helpdesk.plugins.quickticket.client.config.data.CreateOrEditQuickTicketResponse;
import com.inet.helpdesk.plugins.quickticket.client.shared.data.QuickTicketDescription;
import com.inet.helpdesk.plugins.quickticket.taskplanner.TaskOverview;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskExecution;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import com.inet.taskplanner.server.api.event.TaskEvent;
import com.inet.taskplanner.server.api.event.TaskEventListener;
import com.inet.taskplanner.server.api.history.ExecutionHistory;
import com.inet.taskplanner.server.api.history.HistoryEntry;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobFactory;
import com.inet.taskplanner.server.internalapi.NextExecutionDescription;
import com.inet.taskplanner.server.internalapi.NextExecutionTimeChecker;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TasksWithQTs
implements TaskEventListener {
    private Map<GUID, Set<GUID>> qtsWithJob = null;
    private Map<GUID, Set<GUID>> qtsWithAction = null;
    private static final TasksWithQTs INSTANCE = new TasksWithQTs();

    public static TasksWithQTs getInstance() {
        return INSTANCE;
    }

    public boolean isAvailable() {
        return SystemPermissionChecker.checkAccess((Permission)TaskPlanner.PERMISSION_TASKPLANNER);
    }

    public boolean isTaskPlannerAdminAvailable() {
        return SystemPermissionChecker.checkAccess((Permission)TaskPlanner.PERMISSION_TASKPLANNER_ADMIN);
    }

    public boolean createNewTaskPossible() {
        JobFactory jobFactory = (JobFactory)ServerPluginManager.getInstance().getSingleInstanceByName(JobFactory.class, "quickticket.taskplanner.createfromquickticketjob", false);
        return jobFactory.isAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (this.qtsWithJob != null) {
            return;
        }
        TasksWithQTs tasksWithQTs = this;
        synchronized (tasksWithQTs) {
            this.qtsWithJob = new ConcurrentHashMap<GUID, Set<GUID>>();
            this.qtsWithAction = new ConcurrentHashMap<GUID, Set<GUID>>();
            TaskPlanner taskPlanner = TaskPlanner.getInstance();
            taskPlanner.registerEventListener((TaskEventListener)this);
            List allTaskIDs = taskPlanner.getAllTaskIDs();
            for (GUID id : allTaskIDs) {
                this.checkForQTTasks(id);
            }
        }
    }

    private void checkForQTTasks(GUID taskId) {
        List resultActions;
        TaskDefinition taskDefinition = TaskPlanner.getInstance().getTaskDefinition(taskId);
        if (taskDefinition == null) {
            return;
        }
        List jobs = taskDefinition.getJobs();
        if (jobs != null && !jobs.isEmpty()) {
            for (JobDefinition job : jobs) {
                String qtIdStr;
                if (!"quickticket.taskplanner.createfromquickticketjob".equals(job.getExtensionName()) || StringFunctions.isEmpty((String)(qtIdStr = job.getProperty("quickticketid")))) continue;
                try {
                    GUID qtId = GUID.valueOf((String)qtIdStr);
                    Set taskIDs = this.qtsWithJob.computeIfAbsent(qtId, k -> ConcurrentHashMap.newKeySet());
                    taskIDs.add(taskId);
                }
                catch (IllegalArgumentException qtId) {}
            }
        }
        if ((resultActions = taskDefinition.getResultActions()) != null && !resultActions.isEmpty()) {
            for (ResultActionDefinition resultAction : resultActions) {
                String qtIdStr;
                if (!"result.applyquickticket".equals(resultAction.getExtensionName()) || StringFunctions.isEmpty((String)(qtIdStr = resultAction.getProperty("quickticketid")))) continue;
                try {
                    GUID qtId = GUID.valueOf((String)qtIdStr);
                    Set taskIDs = this.qtsWithAction.computeIfAbsent(qtId, k -> ConcurrentHashMap.newKeySet());
                    taskIDs.add(taskId);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    @Nonnull
    public Set<GUID> getTasksIDsWithQuickTicketJob(GUID qtID) {
        this.initialize();
        Set<GUID> taskIds = this.qtsWithJob.get(qtID);
        if (taskIds == null) {
            return Collections.emptySet();
        }
        return new HashSet<GUID>(taskIds);
    }

    @Nonnull
    public List<TaskOverview> getTasksWithQuickTicketJob(GUID qtID) {
        this.initialize();
        ArrayList<TaskOverview> tasks = new ArrayList<TaskOverview>();
        Set<GUID> taskIds = this.qtsWithJob.get(qtID);
        if (taskIds == null) {
            return tasks;
        }
        for (GUID id : taskIds) {
            TaskOverview taskOverview = this.convertTaskToTaskOverview(id);
            if (taskOverview == null) continue;
            tasks.add(taskOverview);
        }
        return tasks;
    }

    @Nonnull
    public Set<GUID> getTasksIDsWithQuickTicketAction(GUID qtID) {
        this.initialize();
        Set<GUID> taskIds = this.qtsWithAction.get(qtID);
        if (taskIds == null) {
            return Collections.emptySet();
        }
        return new HashSet<GUID>(taskIds);
    }

    @Nonnull
    public List<TaskOverview> getTasksWithQuickTicketAction(GUID qtID) {
        this.initialize();
        ArrayList<TaskOverview> tasks = new ArrayList<TaskOverview>();
        Set<GUID> taskIds = this.qtsWithAction.get(qtID);
        if (taskIds == null) {
            return tasks;
        }
        for (GUID id : taskIds) {
            TaskOverview taskOverview = this.convertTaskToTaskOverview(id);
            if (taskOverview == null) continue;
            tasks.add(taskOverview);
        }
        return tasks;
    }

    @Nullable
    public TaskOverview convertTaskToTaskOverview(GUID taskId) {
        List lastExecutions;
        ExecutionHistory executionHistory;
        TaskPlanner taskPlanner = TaskPlanner.getInstance();
        TaskExecution taskExecution = taskPlanner.getTaskExecution(taskId);
        if (taskExecution == null) {
            return null;
        }
        TaskDefinition taskDefinition = taskPlanner.getTaskDefinition(taskId);
        if (taskDefinition == null) {
            return null;
        }
        TaskOverview task = new TaskOverview();
        task.setId(taskExecution.getTaskID());
        task.setName(taskDefinition.getName());
        task.setDescription(taskDefinition.getDescription());
        task.setActive(taskDefinition.isActivated());
        GUID ownerId = taskExecution.getOwnerId();
        if (ownerId != null) {
            GUID currentUserAccountID;
            UserAccount userAccount = UserManager.getRecoveryEnabledInstance().getUserAccount(ownerId);
            if (userAccount != null) {
                task.setOwnerId(ownerId);
                task.setOwnerDisplayName(userAccount.getDisplayName());
            }
            task.setAccessible(ownerId.equals((Object)(currentUserAccountID = UserManager.getInstance().getCurrentUserAccountID())) || SystemPermissionChecker.checkAccess((Permission)TaskPlanner.PERMISSION_TASKPLANNER_ADMIN));
        }
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, ClientLocale.getThreadLocale());
        dateFormat.setTimeZone(ClientTimezone.getTimeZone());
        NextExecutionDescription nextExecution = NextExecutionTimeChecker.getNextExecution((TaskDefinition)taskDefinition);
        if (nextExecution != null) {
            Object nextExec = null;
            if (nextExecution.getTimestamp() > 0L) {
                nextExec = dateFormat.format(new Date(nextExecution.getTimestamp()));
                if (!nextExecution.isExact()) {
                    nextExec = "~" + (String)nextExec;
                }
            }
            task.setNextExecution((String)nextExec);
        }
        if ((executionHistory = taskExecution.getExecutionHistory()) != null && (lastExecutions = executionHistory.getLastExecutions()) != null && !lastExecutions.isEmpty()) {
            List errors;
            HistoryEntry historyEntry = (HistoryEntry)lastExecutions.get(lastExecutions.size() - 1);
            long executionStartTime = historyEntry.getExecutionStartTime();
            if (executionStartTime > 0L) {
                task.setLastExecution(dateFormat.format(new Date(executionStartTime)));
            }
            if ((errors = historyEntry.getErrors()) != null && !errors.isEmpty()) {
                task.setFaulty(true);
            }
        }
        return task;
    }

    public void addTaskPlannerDetails(CreateOrEditQuickTicketResponse response) {
        QuickTicketDescription desc = response.getDesc();
        GUID qtId = desc.getQuickTicketId();
        if (qtId != null) {
            HashSet<GUID> allTaskIds = new HashSet<GUID>();
            allTaskIds.addAll(this.getTasksIDsWithQuickTicketJob(qtId));
            allTaskIds.addAll(this.getTasksIDsWithQuickTicketAction(qtId));
            ArrayList<TaskOverview> tasks = new ArrayList<TaskOverview>();
            for (GUID taskId : allTaskIds) {
                TaskOverview taskOverview = this.convertTaskToTaskOverview(taskId);
                if (taskOverview == null) continue;
                tasks.add(taskOverview);
            }
            response.setReferencingTasks(tasks);
        }
        response.setCreateNewTasksPossible(this.createNewTaskPossible());
        response.setTaskPlannerAvailable(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTaskId(GUID taskId) {
        TasksWithQTs tasksWithQTs = this;
        synchronized (tasksWithQTs) {
            Iterator<Map.Entry<GUID, Set<GUID>>> iteratorJobs = this.qtsWithJob.entrySet().iterator();
            while (iteratorJobs.hasNext()) {
                Map.Entry<GUID, Set<GUID>> entry = iteratorJobs.next();
                Set<GUID> taskIds = entry.getValue();
                if (!taskIds.remove(taskId) || !taskIds.isEmpty()) continue;
                iteratorJobs.remove();
            }
            Iterator<Map.Entry<GUID, Set<GUID>>> iteratorActions = this.qtsWithAction.entrySet().iterator();
            while (iteratorActions.hasNext()) {
                Map.Entry<GUID, Set<GUID>> entry = iteratorActions.next();
                Set<GUID> taskIds = entry.getValue();
                if (!taskIds.remove(taskId) || !taskIds.isEmpty()) continue;
                iteratorActions.remove();
            }
        }
    }

    public void notify(TaskEvent event) {
        switch (event.getType()) {
            case ADDED: 
            case MODIFIED: 
            case REMOVED: {
                this.removeTaskId(event.getTaskID());
                this.checkForQTTasks(event.getTaskID());
                break;
            }
        }
    }
}

