/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.taskplanner;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketManager;
import com.inet.helpdesk.plugins.quickticket.taskplanner.CreateTicketFromQuickTicketJob;
import com.inet.helpdesk.plugins.quickticket.taskplanner.QuickTicketSelectFieldGenerator;
import com.inet.http.servlet.SessionStore;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldCondition;
import com.inet.taskplanner.server.api.field.LabelField;
import com.inet.taskplanner.server.api.field.LinkField;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.job.ConditionInfo;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobFactory;
import com.inet.taskplanner.server.api.job.JobInfo;
import com.inet.taskplanner.server.api.job.JobSummaryInfo;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CreateTicketFromQuickTicketJobFactory
extends JobFactory<CreateTicketFromQuickTicketJob> {
    private static final QuickTicketSelectFieldGenerator QT_GEN = new QuickTicketSelectFieldGenerator();
    public static final String EXTENSION_NAME = "quickticket.taskplanner.createfromquickticketjob";
    private ArrayList<LocalizedKey> quickTicketsData;

    public CreateTicketFromQuickTicketJobFactory() {
        super(EXTENSION_NAME);
    }

    public JobInfo getInformation(@Nullable GUID guid) {
        String name = QuickTicketServerPlugin.MSG.getMsg("CreateFromQuickTicket", new Object[0]);
        String description = QuickTicketServerPlugin.MSG.getMsg("CreateFromQuickTicketDesc", new Object[0]);
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/quickticket/taskplanner/images/quickticket_32.png");
        String helpKey = "taskplanner.job.quickticket";
        ArrayList<Object> fields = new ArrayList<Object>();
        QuickTicketManager qtManager = this.getQuickTicketManagerInstance();
        this.quickTicketsData = QT_GEN.generateQTIDs(qtManager);
        if (this.quickTicketsData.size() > 0) {
            SelectField s = new SelectField("quickticketid", QuickTicketServerPlugin.MSG.getMsg("CreateFromQuickTicket.QuickTicket", new Object[0]), this.quickTicketsData);
            s.setValue(this.quickTicketsData.get(0).getKey());
            fields.add(s);
            if (SystemPermissionChecker.checkAccess((Permission[])new Permission[]{HdPermissions.TEMPLATE_DEFINITION, Permission.CONFIGURATION})) {
                for (LocalizedKey qt : this.quickTicketsData) {
                    String targetURL = "configmanager/page/configuration.quicktickets/editquickticket/" + qt.getKey();
                    String rootURL = SessionStore.getRootURL();
                    targetURL = rootURL != null ? rootURL + targetURL : "../" + targetURL;
                    LinkField l = new LinkField("link." + qt.getKey(), "", targetURL, QuickTicketServerPlugin.MSG.getMsg("EditQuickticket", new Object[]{qt.getDisplayName()}));
                    ArrayList<FieldCondition> conditions = new ArrayList<FieldCondition>();
                    conditions.add(FieldCondition.visible((Field)s, (FieldCondition.OP)FieldCondition.OP.equals, (String)qt.getKey()));
                    l.setConditions(conditions);
                    fields.add(l);
                }
            }
            TextField f = new TextField("quickticketsubject", QuickTicketServerPlugin.MSG.getMsg("CreateFromQuickTicket.QuickTicketSubject", new Object[0]));
            fields.add(f);
        } else {
            LabelField label = new LabelField("CreateFromQuickTicket.NoQuickTickets", QuickTicketServerPlugin.MSG.getMsg("CreateFromQuickTicketLabel", new Object[0]), QuickTicketServerPlugin.MSG.getMsg("CreateFromQuickTicket.NoQuickTickets.text", new Object[0]));
            fields.add(label);
        }
        return new JobInfo(this.getExtensionName(), name, description, iconURL, helpKey, new ConditionInfo(new ArrayList()), fields, (List)new ArrayList<String>(){
            {
                this.add("Ticket ID");
            }
        });
    }

    protected QuickTicketManager getQuickTicketManagerInstance() {
        return (QuickTicketManager)ServerPluginManager.getInstance().getSingleInstance(QuickTicketManager.class);
    }

    protected void validate(@Nonnull JobDefinition definition, @Nullable GUID guid) throws ValidationException {
        Map props = definition.getProperties();
        if (props.get("quickticketid") == null) {
            throw new ValidationException(new String[]{QuickTicketServerPlugin.MSG.getMsg("CreateFromQuickTicket.QuickTicketMissing", new Object[0])});
        }
    }

    public JobSummaryInfo getSummary(@Nonnull JobDefinition definition) {
        ArrayList<SummaryEntry> summary = new ArrayList<SummaryEntry>();
        String quickticketid = definition.getProperty("quickticketid");
        if (quickticketid == null) {
            summary.add(new SummaryEntry("", QuickTicketServerPlugin.MSG.getMsg("CreateQuickTicketNeedQuickTicket", new Object[0])));
            return new JobSummaryInfo(summary, new ArrayList());
        }
        String quickticketname = this.quickTicketsData.stream().filter(k -> k.getKey().equals(quickticketid)).findFirst().map(LocalizedKey::getDisplayName).orElse(QuickTicketServerPlugin.MSG.getMsg("CategoryNoLonger", new Object[0]));
        summary.add(new SummaryEntry("", QuickTicketServerPlugin.MSG.getMsg("CreateFromQuickTicketSummaryInfoValue", new Object[]{quickticketname})));
        return new JobSummaryInfo(summary, new ArrayList());
    }

    protected CreateTicketFromQuickTicketJob createInstanceFrom(@Nonnull JobDefinition definition, @Nullable GUID taskID) {
        return new CreateTicketFromQuickTicketJob(definition, taskID);
    }

    public List<ResultFlavor> getResultFlavors(JobDefinition jobDefinition) {
        return new ArrayList<ResultFlavor>();
    }

    protected void validateCondition(@Nonnull JobDefinition jobDefinition) throws ValidationException {
    }

    public boolean isAvailable() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        return currentUserAccount != null && TicketManager.getTicketActionChecker().checkCurrentUserHasPermissionToExecuteAction(-33);
    }
}

