/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.client.ticketlist.handler;

import com.inet.field.SelectOption;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.extensions.AddAttachmentsExtensionData;
import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableQuickTicketVO;
import com.inet.helpdesk.plugins.quickticket.api.MutableApplicableActionData;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketException;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketManager;
import com.inet.helpdesk.plugins.quickticket.client.config.data.QuickTicketActionDescription;
import com.inet.helpdesk.plugins.quickticket.client.shared.QuickTicketHandlerUtils;
import com.inet.helpdesk.plugins.quickticket.client.ticketlist.data.ApplyQuickTicketActionRequest;
import com.inet.helpdesk.plugins.quickticket.client.ticketlist.data.ApplyQuickTicketActionResponse;
import com.inet.helpdesk.plugins.ticketlist.api.data.ActionDescription;
import com.inet.helpdesk.plugins.ticketlist.api.editing.ApplyActionRendererProvider;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ApplyQuickTicketAction
extends ServiceMethod<ApplyQuickTicketActionRequest, ApplyQuickTicketActionResponse> {
    public String getMethodName() {
        return "quickticket.applyquickticketaction";
    }

    public short getMethodType() {
        return 1;
    }

    public ApplyQuickTicketActionResponse invoke(HttpServletRequest req, HttpServletResponse resp, ApplyQuickTicketActionRequest payload) throws IOException {
        boolean editStepActionForInquiryTextAdded = false;
        try {
            Integer newTicketID = null;
            Integer ticketID = payload.getTicketID();
            Map<String, String> ticketValues = payload.getValues();
            GUID ownerId = payload.getOwnerId();
            List<QuickTicketActionDescription> actionValues = payload.getActionValues();
            QuickTicketManager quickTicketManager = (QuickTicketManager)ServerPluginManager.getInstance().getSingleInstance(QuickTicketManager.class);
            ReaStepTextVO inquiryText = QuickTicketHandlerUtils.extractStepText(ticketValues);
            ExtensionArguments qtAttachmentExtArg = ExtensionArguments.create();
            LinkedList<LargeContent> attachmentsData = QuickTicketHandlerUtils.extractAttachmentData(req);
            if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
                QuickTicketHandlerUtils.fillAttachmentNamesOfExistingAttachments(qtAttachmentExtArg, payload.getExistingAttachments());
                List<LargeContent> attachmentsWithData = QuickTicketHandlerUtils.syncAttachmentDescriptionsWithAttachmentData(payload.getFieldAttachments(), attachmentsData);
                if (attachmentsWithData != null) {
                    qtAttachmentExtArg.put(AttachmentsServerPlugin.EXTARG_ATTACHMENTS, (Object)new AddAttachmentsExtensionData(attachmentsWithData));
                }
            }
            MutableTicketData ticketData = new MutableTicketData();
            if (ticketValues != null && !ticketValues.isEmpty()) {
                if (ownerId != null && !ticketValues.containsKey(Tickets.FIELD_OWNER_GUID.getKey())) {
                    ticketValues.put(Tickets.FIELD_OWNER_GUID.getKey(), new Json().toJson((Object)new SelectOption(ownerId.toString(), ownerId.toString())));
                }
                List fieldDefinitions = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class).stream().filter(tfd -> tfd.getEditDefinition() != null).collect(Collectors.toList());
                for (TicketFieldDefinition def : fieldDefinitions) {
                    FieldEditDefinition editDefinition = def.getEditDefinition();
                    if (editDefinition == null || !ticketValues.containsKey(editDefinition.getFieldKey())) continue;
                    try {
                        editDefinition.updateTicketData(ticketData, ticketValues);
                    }
                    catch (Throwable t) {
                        throw new ClientMessageException(def.getDisplayName() + ": " + t.getMessage());
                    }
                }
            }
            ArrayList<MutableApplicableActionData> actionsData = new ArrayList<MutableApplicableActionData>();
            if (actionValues != null) {
                actionValues.forEach(av -> {
                    HashMap<String, String> values = av.getActionValues();
                    ActionDescription actionDescription = av.getActionDescription();
                    try {
                        MutableReaStepText stepText = MutableReaStepText.of((ReaStepTextVO)QuickTicketHandlerUtils.extractStepText(values));
                        MutableReaStepData reaStepData = new MutableReaStepData();
                        ExtensionArguments extensionArguments = ExtensionArguments.create();
                        ActionVO actionVO = TicketManager.getTicketActionChecker().getActionByUniqueID(actionDescription.getUid(), -1);
                        ApplyActionRendererProvider.getInstance().prepareReastepActionData(reaStepData, stepText, extensionArguments, actionVO, values, req, av.getEditDuration(), null);
                        if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
                            QuickTicketHandlerUtils.fillAttachmentNamesOfExistingAttachments(extensionArguments, av.getExistingAttachments());
                            List<LargeContent> attachmentsWithDataForStep = QuickTicketHandlerUtils.syncAttachmentDescriptionsWithAttachmentData(av.getAttachments(), attachmentsData);
                            if (attachmentsWithDataForStep != null) {
                                extensionArguments.put(AttachmentsServerPlugin.EXTARG_ATTACHMENTS, (Object)new AddAttachmentsExtensionData(attachmentsWithDataForStep));
                            }
                        }
                        actionsData.add(new MutableApplicableActionData(actionDescription.getUid(), reaStepData, stepText.toVO(), extensionArguments));
                    }
                    catch (Throwable t) {
                        HDLogger.error((Object)t);
                        throw new ClientMessageException(QuickTicketServerPlugin.CLIENT_MSG.getMsg("quickticket.error.withaction", new Object[]{actionDescription.getDisplayName(), t.getMessage()}));
                    }
                });
            }
            if (inquiryText != null || !qtAttachmentExtArg.getIncludedExtArgs().isEmpty()) {
                TicketVO ticket;
                if (inquiryText != null && ticketID != null && (ticket = TicketManager.getReaderForSystem().getTicket(ticketID.intValue())) != null) {
                    ReaStepTextVO originalInquiryText = TicketManager.getReaderForSystem().getReaStepText(ticket.getInitialReaStepID());
                    inquiryText = ReaStepTextVO.concatenateOriginalInitialTextWithNewOne((ReaStepTextVO)inquiryText, (ReaStepTextVO)originalInquiryText);
                }
                String editStepTextActionUniqueID = ((ActionVO)ActionManager.getInstance().get(-22)).getUniqueID();
                MutableApplicableActionData editInquiryTextActionData = new MutableApplicableActionData(editStepTextActionUniqueID, new MutableReaStepData(), inquiryText, qtAttachmentExtArg);
                actionsData.add(0, editInquiryTextActionData);
                if (ticketID != null) {
                    editStepActionForInquiryTextAdded = true;
                }
            }
            if (ticketID != null) {
                ApplicableQuickTicketVO customizedQT = ApplicableQuickTicketVO.create(payload.getQuickTicketID(), ticketData, ExtensionArguments.create(), actionsData);
                quickTicketManager.applyQuickTicket(ticketID, customizedQT);
            } else {
                String subject;
                String string = subject = ticketValues == null ? null : ticketValues.get(Tickets.FIELD_SUBJECT.getKey());
                if (StringFunctions.isEmpty(subject) && (inquiryText == null || inquiryText.isEmpty())) {
                    throw new ClientMessageException(Tickets.MSG.getMsg("error.actionRequiresText", new Object[0]));
                }
                ApplicableQuickTicketVO customizedQT = ApplicableQuickTicketVO.create(payload.getQuickTicketID(), ticketData, ExtensionArguments.create(), actionsData);
                newTicketID = quickTicketManager.createNewTicketWithQuickTicket(customizedQT);
            }
            return new ApplyQuickTicketActionResponse(newTicketID);
        }
        catch (QuickTicketException qtae) {
            Integer actionIndex;
            String message = qtae.getMessage();
            Throwable cause = qtae.getCause();
            if (cause instanceof IllegalArgumentException) {
                HDLogger.debug((Object)qtae);
            } else {
                HDLogger.error((Object)qtae);
            }
            if (cause != null && !StringFunctions.isEmpty((String)cause.getMessage())) {
                message = cause.getMessage();
            }
            if ((actionIndex = qtae.getActionIndex()) != null && editStepActionForInquiryTextAdded) {
                actionIndex = actionIndex - 1;
            }
            message = QuickTicketHandlerUtils.generateErrorMsgForAction(qtae.getActionDisplayName(), actionIndex, message);
            throw new ClientMessageException(message);
        }
    }
}

