/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.client.shared;

import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentFilePathBuilder;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.helpdesk.plugins.quickticket.AddQuickTicketAttachmentsActionExtensionFactory;
import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFieldRendererId;
import com.inet.helpdesk.plugins.ticketlist.api.data.SavedAttachmentData;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.http.ClientMessageException;
import com.inet.http.upload.AttachmentDescription;
import com.inet.lib.util.StringFunctions;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.http.upload.AttachmentType;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class QuickTicketHandlerUtils {
    @SuppressFBWarnings(value={"SERVLET_CONTENT_TYPE"}, justification="Check for uploads from the client. Manipulation only results in ignoring attachments. No security problem here.")
    public static LinkedList<LargeContent> extractAttachmentData(HttpServletRequest req) {
        LinkedList<LargeContent> attachmentsData = new LinkedList<LargeContent>();
        try {
            Part part;
            int i = 0;
            String contentType = req.getContentType();
            while (contentType != null && contentType.startsWith("multipart") && (part = req.getPart("attachment" + i++)) != null) {
                LargeContent lc = new LargeContent(new LargeContent.InputStreamProvider(){

                    public InputStream getStream() {
                        try {
                            return part.getInputStream();
                        }
                        catch (Exception e) {
                            HDLogger.error((Object)e);
                            return null;
                        }
                    }

                    public long getSize() {
                        return part.getSize();
                    }
                });
                lc.setName(part.getSubmittedFileName());
                attachmentsData.add(lc);
            }
        }
        catch (ServletException | IOException se) {
            HDLogger.error((Object)se);
            throw new ClientMessageException(se.getMessage());
        }
        return attachmentsData;
    }

    public static ReaStepTextVO extractStepText(Map<String, String> values) {
        if (values != null && values.containsKey(TicketFieldRendererId.htmleditor.name())) {
            String stepContent = values.remove(TicketFieldRendererId.htmleditor.name());
            boolean htmlContent = Boolean.valueOf(values.remove(TicketFieldRendererId.htmlcontent.name()));
            stepContent = htmlContent ? TicketTextFunctions.prepareHtmlTextForSaving((String)TicketTextFunctions.correctAttachmentPathesForServer((String)stepContent)) : TicketTextFunctions.convertToPlainText((String)stepContent);
            return ReaStepTextVO.of((String)stepContent, (boolean)htmlContent);
        }
        return null;
    }

    public static void fillAttachmentNamesOfExistingAttachments(ExtensionArguments extArgs, List<SavedAttachmentData> existingAttachments) {
        if (existingAttachments != null && !existingAttachments.isEmpty()) {
            Set<String> attachmentNames = existingAttachments.stream().map(SavedAttachmentData::getFileName).collect(Collectors.toSet());
            AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData attachmentsExtensionData = new AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData(attachmentNames);
            extArgs.put(AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES, (Object)attachmentsExtensionData);
        }
    }

    public static List<LargeContent> syncAttachmentDescriptionsWithAttachmentData(List<AttachmentDescription> attachmentsDescr, LinkedList<LargeContent> attachmentsData) {
        if (attachmentsDescr != null && !attachmentsDescr.isEmpty() && attachmentsData != null && attachmentsData.size() >= attachmentsDescr.size()) {
            ArrayList<LargeContent> attachmentsWithData = new ArrayList<LargeContent>(attachmentsDescr.size());
            for (AttachmentDescription attachmentDescription : attachmentsDescr) {
                LargeContent currentContent = attachmentsData.removeFirst();
                currentContent.setContentType(AttachmentType.valueOf((String)attachmentDescription.getAttachmentType().name()));
                currentContent.setLastModified(attachmentDescription.getLastModified());
                currentContent.setName(attachmentDescription.getName());
                attachmentsWithData.add(currentContent);
            }
            return attachmentsWithData;
        }
        return null;
    }

    public static List<LargeContent> convertToLargeContent(List<SavedAttachmentData> attachmentsDescr) {
        ArrayList<LargeContent> attachmentsWithData = new ArrayList<LargeContent>(attachmentsDescr.size());
        if (attachmentsDescr != null) {
            for (SavedAttachmentData savedAttachmentData : attachmentsDescr) {
                try {
                    LargeContent currentContent = QuickTicketHandlerUtils.convertToLargeContent(savedAttachmentData);
                    attachmentsWithData.add(currentContent);
                }
                catch (SQLException sQLException) {}
            }
        }
        return attachmentsWithData;
    }

    private static LargeContent convertToLargeContent(SavedAttachmentData attachmentData) throws SQLException {
        PersistenceEntry entry;
        AttachmentFileRow file;
        AttachmentKey key;
        AttachmentService attService;
        AttachmentRow row;
        if (attachmentData != null && (row = (attService = (AttachmentService)ServerPluginManager.getInstance().getSingleInstance(AttachmentService.class)).getAttachment(key = AttachmentFilePathBuilder.convertRestfulPathToKey((String)("Attachments/" + AttachmentOwnerType.getTypeForId((int)attachmentData.getTypeId()).getAttachmentSubContext() + "/" + attachmentData.getOwnerId() + "/" + attachmentData.getStepId() + "/" + attachmentData.getFileName() + "/")))) != null && (file = attService.getAttachmentFile(row.getChecksum(), row.getFileLength())) != null && (entry = AppDataLocation.getAttachmentFile((String)file.getFilePath())) != null) {
            LargeContent lc = new LargeContent(new LargeContent.InputStreamProvider(){

                public InputStream getStream() {
                    try {
                        return entry.getInputStream();
                    }
                    catch (Exception e) {
                        HDLogger.error((Object)e);
                        return null;
                    }
                }

                public long getSize() {
                    return row.getFileLength();
                }
            });
            lc.setContentType(AttachmentType.valueOf((String)AttachmentType.Attachment.name()));
            lc.setLastModified(attachmentData.getLastModified());
            lc.setName(attachmentData.getFileName());
            return lc;
        }
        return null;
    }

    public static String generateErrorMsgForAction(String actionDisplayName, @Nullable Integer actionIndex, String message) {
        if (!StringFunctions.isEmpty((String)actionDisplayName) || actionIndex != null) {
            int actionIndexInt;
            Object actionName = "";
            int n = actionIndexInt = actionIndex == null ? -1 : actionIndex + 1;
            if (actionIndexInt > 0) {
                actionName = (String)actionName + actionIndexInt;
            }
            if (!StringFunctions.isEmpty((String)actionDisplayName)) {
                if (actionIndex != null) {
                    actionName = (String)actionName + ". ";
                }
                actionName = (String)actionName + actionDisplayName;
            }
            message = QuickTicketServerPlugin.CLIENT_MSG.getMsg("quickticket.error.withaction", new Object[]{actionName, message});
        }
        return message;
    }
}

