/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket;

import com.inet.error.PersistenceException;
import com.inet.helpdesk.core.data.TicketDataConnector;
import com.inet.helpdesk.core.error.HDErrors;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.ActionCheckError;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.WithAdditionalReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.utils.StringConcatenator;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.ExternalImageAttachmentAdder;
import com.inet.helpdesk.plugins.attachments.server.extensions.AddAttachmentsExtensionData;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentDescription;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.quickticket.AddQuickTicketAttachmentsActionExtensionFactory;
import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.ReaStepFieldQuickTicketId;
import com.inet.helpdesk.plugins.quickticket.api.AutoReactAndAuthChecker;
import com.inet.helpdesk.plugins.quickticket.api.MutableApplicableActionData;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketException;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.http.upload.AttachmentType;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ApplyQuickTicketActionExtensionFactory
implements TicketActionExtensionFactory {
    public static final ExtensionArguments.ExtArg<ApplyQuickTicketActionExtensionData> EXTARG_APPLY_QUICK_TICKET_DATA = new ExtensionArguments.ExtArg<ApplyQuickTicketActionExtensionData>(){

        public String getKey() {
            return "ticketextension.applyquickticket";
        }

        public Class<ApplyQuickTicketActionExtensionData> getValueType() {
            return ApplyQuickTicketActionExtensionData.class;
        }

        public String toJson(ApplyQuickTicketActionExtensionData value) {
            throw new UnsupportedOperationException("ExtArg with key=\"" + this.getKey() + "\" is not intended to be serialized");
        }

        public ApplyQuickTicketActionExtensionData fromJson(String jsonData) {
            throw new UnsupportedOperationException("ExtArg with key=\"" + this.getKey() + "\" is not intended to be serialized");
        }

        public ApplyQuickTicketActionExtensionData copyValue(ApplyQuickTicketActionExtensionData value) {
            return value.copy();
        }
    };

    public TicketActionExtension createIfApplicable(OperationChangedTicket ticket, ActionVO action, ExtensionArguments arguments, MutableReaStepData reaStepData) {
        if (action.getId() != -33) {
            return null;
        }
        ApplyQuickTicketActionExtensionData extData = (ApplyQuickTicketActionExtensionData)arguments.get(EXTARG_APPLY_QUICK_TICKET_DATA);
        if (extData != null) {
            return new ApplyQuickTicketActionExtension(extData, (TicketDataConnector.MailNotification)arguments.get(ExtensionArguments.EXTARG_AUTO_MAIL));
        }
        return null;
    }

    public static class ApplyQuickTicketActionExtensionData {
        private GUID quickTicketID;
        private int quickTicketIntID;
        private MutableTicketData ticketData;
        private List<MutableApplicableActionData> actionsData;

        public ApplyQuickTicketActionExtensionData(GUID quickTicketID, int quickTicketIntID, @Nonnull MutableTicketData ticketData, @Nonnull List<MutableApplicableActionData> actionsData) {
            this.quickTicketID = quickTicketID;
            this.quickTicketIntID = quickTicketIntID;
            this.ticketData = ticketData;
            this.actionsData = actionsData;
        }

        public GUID getQuickTicketID() {
            return this.quickTicketID;
        }

        public int getQuickTicketIntID() {
            return this.quickTicketIntID;
        }

        public MutableTicketData getTicketData() {
            return this.ticketData;
        }

        public List<MutableApplicableActionData> getActionsData() {
            return this.actionsData;
        }

        public ApplyQuickTicketActionExtensionData copy() {
            ArrayList<MutableApplicableActionData> copyOfActionsData = new ArrayList<MutableApplicableActionData>();
            this.actionsData.stream().forEach(e -> copyOfActionsData.add(e.copy()));
            return new ApplyQuickTicketActionExtensionData(this.quickTicketID, this.quickTicketIntID, this.ticketData.copy(), copyOfActionsData);
        }

        public int hashCode() {
            return Objects.hash(this.actionsData, this.quickTicketID, this.quickTicketIntID, this.ticketData);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ApplyQuickTicketActionExtensionData other = (ApplyQuickTicketActionExtensionData)obj;
            return Objects.equals(this.actionsData, other.actionsData) && Objects.equals(this.quickTicketID, other.quickTicketID) && this.quickTicketIntID == other.quickTicketIntID && Objects.equals(this.ticketData, other.ticketData);
        }
    }

    public static class ApplyQuickTicketActionExtension
    implements TicketActionExtension {
        private final TicketDataConnector.MailNotification mailNotification;
        private ApplyQuickTicketActionExtensionData extData;

        public ApplyQuickTicketActionExtension(@Nonnull ApplyQuickTicketActionExtensionData extData, TicketDataConnector.MailNotification mailNotification) {
            this.extData = extData;
            this.mailNotification = mailNotification;
        }

        public void extendTicketAction(ActionVO action, OperationChangedTicket ticket, OperationNewReaStep reaStep, TicketSubOperations operations) {
            this.addAdditionalReaStepData(this.extData, reaStep, reaStep.getFields());
            try (UserAccountScope scope = UserAccountScope.createPrivileged();){
                MutableReaStepData reaStepData;
                ExtensionArguments extArgs;
                GUID resID;
                int ticketID = ticket.getTicketId();
                TicketVO ticketBefore = ticket.getOldTicket().orElse(ticket.createIntermediateTicketVO());
                List<MutableApplicableActionData> dataOfActionsToApply = this.extData.getActionsData();
                Map<String, ActionVO> actionsToApplyByUniqueID = this.findActionsByUniqueIDsOrThrow(action.getDisplayValue(), ticketID, dataOfActionsToApply);
                List<Integer> idsOfActionsToApply = dataOfActionsToApply.stream().map(e -> ((ActionVO)actionsToApplyByUniqueID.get(e.getUniqueActionID())).getId()).collect(Collectors.toList());
                AutoReactAndAuthChecker.AutoReactAndAuthCheckResult autoActionsCheckResult = AutoReactAndAuthChecker.check(ticketBefore, idsOfActionsToApply);
                if (autoActionsCheckResult.isReactivationRequired()) {
                    ActionVO reactivateAction = (ActionVO)ActionManager.getInstance().get(-2);
                    try {
                        ExtensionArguments extArgs2 = this.createExtensionArgsWithInjectedInfos();
                        extArgs2.put(ExtensionArguments.EXTARG_IMPLICIT_AUTO_ACTION, (Object)Boolean.TRUE);
                        MutableReaStepData reaStepData2 = new MutableReaStepData();
                        this.addAdditionalReaStepData(this.extData, reaStep, reaStepData2);
                        operations.applyActionWithChecks(ticket, reaStepData2, ReaStepTextVO.empty(), reactivateAction, extArgs2, true);
                    }
                    catch (Exception ex) {
                        throw new QuickTicketException(ex.getMessage(), (Throwable)ex, null, reactivateAction.getDisplayValue());
                    }
                }
                if (ticketBefore.isDispatched() && this.extData.getTicketData().containsKey((TicketField)Tickets.FIELD_RESOURCE_GUID)) {
                    resID = (GUID)this.extData.getTicketData().get((TicketField)Tickets.FIELD_RESOURCE_GUID);
                    if (resID == null) {
                        throw new IllegalArgumentException(QuickTicketServerPlugin.MSG.getMsg("applyquickticketextension.errormessage.resource.notnull", new Object[0]));
                    }
                    this.extData.getTicketData().remove((TicketField)Tickets.FIELD_RESOURCE_GUID);
                    if (!Objects.equals(ticketBefore.getResourceID(), resID)) {
                        ActionVO escalateAction = (ActionVO)ActionManager.getInstance().get(8);
                        try {
                            extArgs = this.createExtensionArgsWithInjectedInfos();
                            extArgs.put(ExtensionArguments.EXTARG_RESOURCE_ACTION_EXTENSION_DATA, (Object)ExtensionArguments.ResourceActionExtensionData.forEscalationOfActiveTicket((GUID)resID, (boolean)true));
                            extArgs.put(ExtensionArguments.EXTARG_IMPLICIT_AUTO_ACTION, (Object)Boolean.TRUE);
                            reaStepData = new MutableReaStepData();
                            this.addAdditionalReaStepData(this.extData, reaStep, reaStepData);
                            operations.applyActionWithChecks(ticket, reaStepData, ReaStepTextVO.empty(), escalateAction, extArgs, true);
                        }
                        catch (Exception ex) {
                            throw new QuickTicketException(ex.getMessage(), (Throwable)ex, null, escalateAction.getDisplayValue());
                        }
                    }
                }
                if (!ticket.isNew()) {
                    try {
                        operations.updateTicketDataWithChecks(ticket, this.extData.getTicketData());
                        MutableReaStepData reaStepData3 = new MutableReaStepData();
                        this.addAdditionalReaStepData(this.extData, reaStep, reaStepData3);
                        ticket.createFieldChangeReaStepsIfNeeded(reaStepData3);
                    }
                    catch (Exception ex) {
                        ActionVO fieldChangeAction = (ActionVO)ActionManager.getInstance().get(-29);
                        throw new QuickTicketException(ex.getMessage(), (Throwable)ex, null, fieldChangeAction.getDisplayValue());
                    }
                }
                if (autoActionsCheckResult.isAuthorizationRequired()) {
                    resID = (GUID)ticket.getFieldValue((TicketField)Tickets.FIELD_RESOURCE_GUID);
                    ActionVO authorizeAction = (ActionVO)ActionManager.getInstance().get(5);
                    try {
                        extArgs = this.createExtensionArgsWithInjectedInfos();
                        extArgs.put(ExtensionArguments.EXTARG_RESOURCE_ACTION_EXTENSION_DATA, (Object)ExtensionArguments.ResourceActionExtensionData.forAuthorizationOfTicket((GUID)resID));
                        extArgs.put(ExtensionArguments.EXTARG_IMPLICIT_AUTO_ACTION, (Object)Boolean.TRUE);
                        reaStepData = new MutableReaStepData();
                        this.addAdditionalReaStepData(this.extData, reaStep, reaStepData);
                        operations.applyActionWithChecks(ticket, reaStepData, ReaStepTextVO.empty(), authorizeAction, extArgs, true);
                    }
                    catch (Exception ex) {
                        throw new QuickTicketException(ex.getMessage(), (Throwable)ex, null, authorizeAction.getDisplayValue());
                    }
                }
                TicketPermissionContext ticketPermissionInfo = TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticketBefore);
                for (int index = 0; index < dataOfActionsToApply.size(); ++index) {
                    MutableApplicableActionData actionData = dataOfActionsToApply.get(index);
                    ActionVO actionToApply = actionsToApplyByUniqueID.get(actionData.getUniqueActionID());
                    try {
                        TicketVO intermediateTicketVO = ticket.createIntermediateTicketVO();
                        if (actionToApply.getId() == -22) {
                            boolean hasChangedInquiryText;
                            ActionCheckError errormsg = TicketManager.getTicketActionChecker().checkAction(actionToApply, intermediateTicketVO, ticketPermissionInfo);
                            if (errormsg != null) {
                                throw HDErrors.createExceptionForCode((ActionCheckError)errormsg);
                            }
                            ExtensionArguments extArgs3 = actionData.getExtensionArguments();
                            this.addInjectedInfos(extArgs3);
                            int initialReaStepID = ticketBefore.getInitialReaStepID();
                            ReaStepTextVO reaStepText = actionData.getReaStepText();
                            AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData qtAttExtData = (AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData)extArgs3.remove(AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES);
                            if (reaStepText != null) {
                                extArgs3.put(ExtensionArguments.EXTARG_CHANGED_REA_STEP, (Object)ExtensionArguments.EditReastepTextActionExtensionData.create((int)initialReaStepID, (ReaStepTextVO)reaStepText));
                                ApplyQuickTicketActionExtensionData extDataWithQuickTicketID = new ApplyQuickTicketActionExtensionData(this.extData.getQuickTicketID(), this.extData.getQuickTicketIntID(), new MutableTicketData(), Collections.emptyList());
                                extArgs3.put(EXTARG_APPLY_QUICK_TICKET_DATA, (Object)extDataWithQuickTicketID);
                                MutableReaStepData reaStepData4 = actionData.getReaStepData();
                                this.addAdditionalReaStepData(this.extData, reaStep, reaStepData4);
                                try (WithAdditionalReaStepData addReaStepData = WithAdditionalReaStepData.create((MutableReaStepData)reaStepData4);){
                                    operations.applyActionEditReaStepText(ticket, extArgs3);
                                }
                            }
                            if (!ServerPluginManager.getInstance().isPluginLoaded("attachments")) continue;
                            ArrayList<String> uniqueNamesOfAddedAttachments = new ArrayList<String>();
                            if (qtAttExtData != null) {
                                uniqueNamesOfAddedAttachments.addAll(AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsActionExtension.addQuickTicketAttachments(ticketID, initialReaStepID, this.extData.getQuickTicketIntID(), qtAttExtData));
                            }
                            if (hasChangedInquiryText = ticket.getChangedReaSteps().stream().anyMatch(e -> Objects.equals(initialReaStepID, e.getReaStepId()))) continue;
                            AddAttachmentsExtensionData attExtData = (AddAttachmentsExtensionData)extArgs3.get(AttachmentsServerPlugin.EXTARG_ATTACHMENTS);
                            if (attExtData != null) {
                                uniqueNamesOfAddedAttachments.addAll(this.addNonEmbeddedAttachments(ticketID, initialReaStepID, attExtData.getAttachments()));
                            }
                            this.addReaStepDocumentingAddedAttachments(uniqueNamesOfAddedAttachments, ticket, operations);
                            continue;
                        }
                        ExtensionArguments extArgs4 = actionData.getExtensionArguments();
                        this.addInjectedInfos(extArgs4);
                        ApplyQuickTicketActionExtensionData extDataWithQuickTicketID = new ApplyQuickTicketActionExtensionData(this.extData.getQuickTicketID(), this.extData.getQuickTicketIntID(), new MutableTicketData(), Collections.emptyList());
                        extArgs4.put(EXTARG_APPLY_QUICK_TICKET_DATA, (Object)extDataWithQuickTicketID);
                        MutableReaStepData reaStepData5 = actionData.getReaStepData();
                        this.addAdditionalReaStepData(this.extData, reaStep, reaStepData5);
                        operations.applyActionWithChecks(ticket, reaStepData5, actionData.getReaStepText(), actionToApply, extArgs4, true);
                        ticket.createFieldChangeReaStepsIfNeeded(reaStepData5);
                        continue;
                    }
                    catch (Exception ex) {
                        throw new QuickTicketException(ex.getMessage(), (Throwable)ex, index, actionToApply.getDisplayValue());
                    }
                }
            }
        }

        private void addAdditionalReaStepData(ApplyQuickTicketActionExtensionData extData, OperationNewReaStep reaStep, MutableReaStepData reaStepData) {
            reaStepData.put((ReaStepField)ReaStepVO.FIELD_GROUP_REASTEP, (Object)reaStep.getReaStepId());
            reaStepData.put((ReaStepField)ReaStepFieldQuickTicketId.INSTANCE, (Object)extData.getQuickTicketID());
        }

        private ExtensionArguments createExtensionArgsWithInjectedInfos() {
            ExtensionArguments extensionArguments = ExtensionArguments.create();
            this.addInjectedInfos(extensionArguments);
            return extensionArguments;
        }

        private void addInjectedInfos(ExtensionArguments extensionArguments) {
            if (this.mailNotification != null) {
                extensionArguments.put(ExtensionArguments.EXTARG_AUTO_MAIL, (Object)this.mailNotification);
            }
        }

        private List<String> addNonEmbeddedAttachments(int ticketID, int stepID, List<LargeContent> attachments) {
            ExternalImageAttachmentAdder externalImageAttAdder = (ExternalImageAttachmentAdder)ServerPluginManager.getInstance().getSingleInstance(ExternalImageAttachmentAdder.class);
            List nonEmbeddedAttachments = attachments.stream().filter(e -> Objects.equals(e.getContentType(), AttachmentType.Attachment)).collect(Collectors.toList());
            ArrayList<String> uniqueNamesOfAddedAttachments = new ArrayList<String>();
            try {
                for (LargeContent att : nonEmbeddedAttachments) {
                    AttachmentDescription attDesc = externalImageAttAdder.addAttachment(AttachmentOwnerType.TicketAttachment, ticketID, stepID, att);
                    uniqueNamesOfAddedAttachments.add(attDesc.getFileName());
                }
            }
            catch (IOException exc) {
                throw new PersistenceException((Throwable)exc);
            }
            return uniqueNamesOfAddedAttachments;
        }

        private void addReaStepDocumentingAddedAttachments(List<String> uniqueNamesOfAddedAttachments, OperationChangedTicket ticket, TicketSubOperations operations) {
            if (uniqueNamesOfAddedAttachments.isEmpty()) {
                return;
            }
            String allAttFileNames = String.join((CharSequence)", ", uniqueNamesOfAddedAttachments);
            String prefix = QuickTicketServerPlugin.MSG.getMsg("AddedFromQuickTicket", new Object[0]) + " ";
            String stepDesc = prefix + allAttFileNames;
            ReaStepTextVO stepText = ReaStepTextVO.empty();
            int maxAttFileNamesLength = 255 - prefix.length();
            if (allAttFileNames.length() > maxAttFileNamesLength) {
                stepDesc = prefix + StringConcatenator.concatAndShortenIfNeeded(uniqueNamesOfAddedAttachments, (int)maxAttFileNamesLength);
                stepText = ReaStepTextVO.of((String)(prefix + allAttFileNames), (boolean)false);
            }
            MutableReaStepData stepData = new MutableReaStepData();
            stepData.put((ReaStepField)ReaStepVO.FIELD_DESC, (Object)stepDesc);
            ActionVO action = (ActionVO)ActionManager.getInstance().get(-21);
            operations.applyAction(ticket, stepData, stepText, action, this.createExtensionArgsWithInjectedInfos());
        }

        private Map<String, ActionVO> findActionsByUniqueIDsOrThrow(String applyQtActionDisplayName, int ticketID, List<MutableApplicableActionData> actionsData) {
            HashMap<String, ActionVO> actionsByUniqueID = new HashMap<String, ActionVO>();
            for (int index = 0; index < actionsData.size(); ++index) {
                MutableApplicableActionData entry = actionsData.get(index);
                String uniqueActionID = entry.getUniqueActionID();
                ActionVO action = TicketManager.getTicketActionChecker().getActionByUniqueID(uniqueActionID, ticketID);
                if (action == null) {
                    String errorMsg = String.format("Could not find action with uniqueActionID \"%s\", which can be applied to ticket with ID \"%d\".", uniqueActionID, ticketID);
                    throw new QuickTicketException(errorMsg, (Throwable)new IllegalStateException(errorMsg), index, applyQtActionDisplayName);
                }
                actionsByUniqueID.put(uniqueActionID, action);
            }
            return actionsByUniqueID;
        }
    }
}

