/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.eventlog;

import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.logging.EventLog;
import java.util.Locale;
import java.util.Properties;
import javax.annotation.Nonnull;

public enum QuickTicketEventsForTemplateEventLog {
    QuickTicketCreated,
    QuickTicketUpdated,
    QuickTicketDeleted;

    private static final EventLog<QuickTicketEventsForTemplateEventLog> TEMPLATE_EVENT_LOG;

    public void log(@Nonnull GUID qtID, @Nonnull String qtName, Object ... extraParams) {
        Object[] params;
        Properties props = new Properties();
        props.setProperty("id", qtID.toString());
        props.setProperty("name", qtName);
        String msgKey = "eventlog." + this.name();
        if (this == QuickTicketUpdated && extraParams.length > 0) {
            props.setProperty("oldname", extraParams[0].toString());
            msgKey = msgKey + "WithChangedName";
        }
        if (extraParams == null || extraParams.length == 0) {
            params = new Object[1];
        } else {
            params = new Object[extraParams.length + 1];
            System.arraycopy(extraParams, 0, params, 1, extraParams.length);
        }
        params[0] = qtName;
        String msg = QuickTicketServerPlugin.MSG.getMsg(Locale.getDefault(), msgKey, params);
        String data = new Json().toJson((Object)props);
        TEMPLATE_EVENT_LOG.log((Enum)this, msg, data, new Object[]{qtName});
    }

    static {
        TEMPLATE_EVENT_LOG = EventLog.register((String)"helpdesktemplate");
    }
}

