/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.client.config.handler;

import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketManager;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketVO;
import com.inet.helpdesk.plugins.quickticket.client.config.data.CreateTaskRequest;
import com.inet.helpdesk.plugins.quickticket.client.config.data.CreateTaskResponse;
import com.inet.helpdesk.plugins.quickticket.taskplanner.TasksWithQTs;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.time.RepeatInterval;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class CreateTask
extends ServiceMethod<CreateTaskRequest, CreateTaskResponse> {
    public String getMethodName() {
        return "quickticket.createtask";
    }

    public short getMethodType() {
        return 1;
    }

    public CreateTaskResponse invoke(HttpServletRequest req, HttpServletResponse resp, CreateTaskRequest payload) throws IOException {
        GUID currentUserAccountID = UserManager.getInstance().getCurrentUserAccountID();
        if (!SystemPermissionChecker.checkAccess((Permission)TaskPlanner.PERMISSION_TASKPLANNER) || currentUserAccountID == null) {
            throw new AccessDeniedException(TaskPlanner.PERMISSION_TASKPLANNER);
        }
        GUID qtId = payload.getQuickTicketId();
        if (qtId == null) {
            throw new ClientMessageException(QuickTicketServerPlugin.CLIENT_MSG.getMsg("configuration.quickticket.edit.notfound", new Object[0]));
        }
        QuickTicketManager quickTicketManager = (QuickTicketManager)ServerPluginManager.getInstance().getSingleInstance(QuickTicketManager.class);
        QuickTicketVO quickTicket = quickTicketManager.getQuickTicket(qtId);
        if (quickTicket == null) {
            throw new ClientMessageException(QuickTicketServerPlugin.CLIENT_MSG.getMsg("configuration.quickticket.edit.notfound", new Object[0]));
        }
        TaskDefinition taskDef = new TaskDefinition("Serial Task: " + quickTicket.getQuickTicketName());
        TriggerDefinition trigger = new TriggerDefinition("trigger.time");
        long now = System.currentTimeMillis();
        long today = now / 1000L / 60L / 60L / 24L * 24L * 60L * 60L * 1000L;
        trigger.setProperty("start.day", String.valueOf(today));
        trigger.setProperty("start.time", "0");
        trigger.setProperty("repeat.select", RepeatInterval.NONE.name());
        taskDef.addTrigger(trigger);
        JobDefinition job = new JobDefinition("quickticket.taskplanner.createfromquickticketjob");
        job.setProperty("quickticketid", qtId.toString());
        taskDef.addJob(job);
        GUID taskId = TaskPlanner.getInstance().addTask(taskDef, currentUserAccountID);
        return new CreateTaskResponse(taskId, TasksWithQTs.getInstance().convertTaskToTaskOverview(taskId));
    }
}

