/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.setup.scheduledtasks;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.quickticket.api.MutableApplicableActionData;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketFolderStructureVO;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketFolderVO;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketManager;
import com.inet.helpdesk.plugins.quickticket.setup.scheduledtasks.ScheduledTaskDataSet;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.trigger.TimeTriggerBuilder;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.time.MonthlyDay;
import com.inet.taskplanner.server.api.trigger.time.RepeatInterval;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;

@InternalApi
public class ScheduledTasksMigrator {
    public static final String TASK_DISPLAY_NAME_PREFIX = "Scheduled Task: ";
    public static final String QT_FOLDER_NAME = "Scheduled Tasks";
    private final ZonedDateTime migrationDateTime;
    private GUID targetUser;

    public ScheduledTasksMigrator(@Nonnull ZonedDateTime migrationDateTime, GUID targetUser) {
        if (migrationDateTime == null) {
            throw new IllegalArgumentException("migrationDateTime must not be null");
        }
        if (targetUser == null) {
            throw new IllegalArgumentException("targetUser must not be null");
        }
        this.targetUser = targetUser;
        this.migrationDateTime = migrationDateTime;
    }

    public List<ScheduledTaskDataSet> loadData(@Nonnull Connection con) throws SQLException {
        ArrayList<ScheduledTaskDataSet> data = new ArrayList<ScheduledTaskDataSet>();
        String sql = "SELECT * FROM tblSerienaufgaben LEFT JOIN tblUser ON tblSerienaufgaben.UsrID = tblUser.UsrID LEFT JOIN tblRessourcen ON tblSerienaufgaben.ResID = tblRessourcen.ResID";
        try (Statement stm = con.createStatement();
             ResultSet rs = stm.executeQuery(sql);){
            while (rs.next()) {
                ScheduledTaskDataSet row = new ScheduledTaskDataSet();
                row.setScheduledTaskID(rs.getInt("SerID"));
                row.setDisplayName(rs.getString("Aufgabenbez"));
                row.setSubject(rs.getString("Betreff"));
                row.setCategoryID(rs.getInt("BetID"));
                row.setTicketText(rs.getString("Auftrag"));
                row.setIsHTML(rs.getBoolean("ishtml"));
                row.setTicketOwnerID(GUID.valueOf((String)rs.getString("UserUUID")));
                String resID = rs.getString("GroupUUID");
                row.setResourceID(StringFunctions.isEmpty((String)resID) ? null : GUID.valueOf((String)resID));
                row.setPriorityID(rs.getInt("PriID"));
                row.setClassificationID(rs.getInt("KlaID"));
                row.setItilID(rs.getInt("ItiID"));
                row.setCustomField1(rs.getString("BunFeld1"));
                row.setCustomField2(rs.getString("BunFeld2"));
                row.setCustomField3(rs.getString("BunFeld3"));
                row.setCustomField4(rs.getString("BunFeld4"));
                row.setIdentifier(rs.getString("spezFeld"));
                row.setIntervalType(rs.getInt("Typ"));
                row.setDayOption(rs.getInt("DayOption"));
                row.setIntervalTypeOption(rs.getInt("TypOption"));
                Timestamp aktionStart = rs.getTimestamp("AktionStart");
                Long startExecutionDate = aktionStart == null ? null : Long.valueOf(aktionStart.getTime());
                row.setStartExecutionDate(startExecutionDate);
                Timestamp aktionNext = rs.getTimestamp("AktionNext");
                Long nextExecutionDate = aktionNext == null ? null : Long.valueOf(aktionNext.getTime());
                row.setNextExecutionDate(nextExecutionDate);
                Timestamp aktionEnd = rs.getTimestamp("AktionEnd");
                Long endExecutionDate = aktionEnd == null ? null : Long.valueOf(aktionEnd.getTime());
                row.setEndExecutionDate(endExecutionDate);
                int timeInterval = rs.getInt("TimeInterval");
                row.setTimeInterval(timeInterval == 0 ? 1 : timeInterval);
                data.add(row);
            }
        }
        return data;
    }

    public ScheduledTaskMigrationResult migrateData(@Nonnull ScheduledTaskDataSet data) {
        QuickTicketManager qtManager = (QuickTicketManager)ServerPluginManager.getInstance().getSingleInstance(QuickTicketManager.class);
        try (UserAccountScope scope = UserAccountScope.createPrivileged();){
            GUID qtID = this.createQuickTicketBasedOn(qtManager, data);
            try {
                ScheduledTaskMigrationResult scheduledTaskMigrationResult = this.createTaskPlannerTaskBasedOn(data, qtID);
                return scheduledTaskMigrationResult;
            }
            catch (Throwable t) {
                try {
                    qtManager.deleteQuickTicket(qtID);
                }
                catch (Throwable t2) {
                    SetupLogger.LOGGER.error((Object)("Could not remove Quick-Ticket with ID=\"" + String.valueOf(qtID) + "\", which was created during unsuccessful migration of scheduled task with ID=\"" + data.getScheduledTaskID() + "\"."));
                    SetupLogger.LOGGER.error(t2);
                }
                throw t;
            }
        }
    }

    private GUID createQuickTicketBasedOn(@Nonnull QuickTicketManager qtManager, @Nonnull ScheduledTaskDataSet st) {
        MutableTicketData ticketData = new MutableTicketData();
        ticketData.putValidOrDefaultValue((TicketField)Tickets.FIELD_SUBJECT, (Object)st.getSubject());
        if (st.getCategoryID() > 0) {
            ticketData.putValidOrDefaultValue((TicketField)Tickets.FIELD_CATEGORY_ID, (Object)st.getCategoryID());
        }
        ticketData.put((TicketField)Tickets.FIELD_OWNER_GUID, (Object)st.getTicketOwnerID());
        if (st.getResourceID() != null) {
            ticketData.put((TicketField)Tickets.FIELD_RESOURCE_GUID, (Object)st.getResourceID());
        }
        ticketData.put((TicketField)Tickets.FIELD_PRIORITY_ID, (Object)st.getPriorityID());
        ticketData.put((TicketField)Tickets.FIELD_CLASSIFICATION_ID, (Object)st.getClassificationID());
        ticketData.put((TicketField)Tickets.FIELD_ITIL_ID, (Object)st.getItilID());
        BiConsumer<TicketField, String> putIfNotEmpty = (field, value) -> {
            if (!StringFunctions.isEmpty((String)value)) {
                ticketData.putValidOrDefaultValue(field, value);
            }
        };
        putIfNotEmpty.accept(Tickets.getFieldByKey((String)"custom1"), st.getCustomField1());
        putIfNotEmpty.accept(Tickets.getFieldByKey((String)"custom2"), st.getCustomField2());
        putIfNotEmpty.accept(Tickets.getFieldByKey((String)"custom3"), st.getCustomField3());
        putIfNotEmpty.accept(Tickets.getFieldByKey((String)"custom4"), st.getCustomField4());
        putIfNotEmpty.accept((TicketField)Tickets.FIELD_IDENTIFIER, st.getIdentifier());
        String actionUniqueID = ((ActionVO)ActionManager.getInstance().get(-22)).getUniqueID();
        ReaStepTextVO inquiryText = ReaStepTextVO.of((String)st.getTicketText(), (boolean)st.isHTML());
        MutableApplicableActionData editInquiryTextActionData = new MutableApplicableActionData(actionUniqueID, new MutableReaStepData(), inquiryText, ExtensionArguments.create());
        ArrayList<MutableApplicableActionData> actionsData = new ArrayList<MutableApplicableActionData>();
        actionsData.add(editInquiryTextActionData);
        if (st.getResourceID() != null) {
            String authActionUniqueID = ((ActionVO)ActionManager.getInstance().get(5)).getUniqueID();
            ExtensionArguments extArgs = ExtensionArguments.create();
            extArgs.put(ExtensionArguments.EXTARG_RESOURCE_ACTION_EXTENSION_DATA, (Object)ExtensionArguments.ResourceActionExtensionData.forAuthorizationOfTicket((GUID)st.getResourceID()));
            MutableApplicableActionData authTicketActionData = new MutableApplicableActionData(authActionUniqueID, new MutableReaStepData(), ReaStepTextVO.empty(), extArgs);
            actionsData.add(authTicketActionData);
        }
        GUID qtID = qtManager.createQuickTicket(st.getDisplayName(), ticketData, ExtensionArguments.create(), actionsData);
        GUID folderID = this.getOrCreateQtFolder(qtManager);
        qtManager.setFolder(qtID, folderID);
        return qtID;
    }

    private GUID getOrCreateQtFolder(@Nonnull QuickTicketManager qtManager) {
        for (QuickTicketFolderStructureVO.NodeVO node : qtManager.getFolderStructure().getNodes()) {
            QuickTicketFolderVO folder = node.getFolder();
            if (!QT_FOLDER_NAME.equals(folder.getFolderName())) continue;
            return folder.getID();
        }
        return qtManager.createFolder(null, QT_FOLDER_NAME, null);
    }

    private ScheduledTaskMigrationResult createTaskPlannerTaskBasedOn(@Nonnull ScheduledTaskDataSet st, @Nonnull GUID qtID) {
        String taskDisplayName = TASK_DISPLAY_NAME_PREFIX + st.getDisplayName();
        TaskDefinition taskDef = new TaskDefinition(taskDisplayName);
        boolean missingNextExecutionTime = st.getNextExecutionDate() == null;
        boolean nextExecutionTimeInPast = false;
        if (!missingNextExecutionTime) {
            ZonedDateTime nextExecDateAndTime = this.millisToZonedDateTime(st.getNextExecutionDate());
            nextExecutionTimeInPast = nextExecDateAndTime.isBefore(this.migrationDateTime);
        }
        if (missingNextExecutionTime || nextExecutionTimeInPast) {
            taskDef.setActivated(false);
        }
        AtomicBoolean losslesslyMigrated = new AtomicBoolean(true);
        this.createTimeTriggersBasedOn(st, losslesslyMigrated).stream().forEach(e -> taskDef.addTrigger(e));
        if (st.getEndExecutionDate() != null && Instant.ofEpochMilli(st.getEndExecutionDate()).isAfter(Instant.now())) {
            losslesslyMigrated.set(false);
        }
        JobDefinition createTicketFromQtJobDef = new JobDefinition("quickticket.taskplanner.createfromquickticketjob");
        createTicketFromQtJobDef.setProperty("quickticketid", qtID.toString());
        taskDef.addJob(createTicketFromQtJobDef);
        GUID taskID = TaskPlanner.getInstance().addTask(taskDef, this.targetUser);
        return new ScheduledTaskMigrationResult(qtID, taskID, losslesslyMigrated.get());
    }

    private List<TriggerDefinition> createTimeTriggersBasedOn(@Nonnull ScheduledTaskDataSet st, @Nonnull AtomicBoolean losslesslyMigrated) {
        ZonedDateTime nextExecDateAndTime = null;
        nextExecDateAndTime = st.getNextExecutionDate() != null ? this.millisToZonedDateTime(st.getNextExecutionDate()) : (st.getStartExecutionDate() != null ? this.millisToZonedDateTime(st.getStartExecutionDate()) : this.migrationDateTime.withHour(10).withMinute(0).withSecond(0).withNano(0));
        switch (st.getIntervalType()) {
            case 1: {
                return this.createTriggersForDailyIntervals(st, nextExecDateAndTime, losslesslyMigrated);
            }
            case 2: {
                return this.createTriggersForWeeklyIntervals(st, nextExecDateAndTime, losslesslyMigrated);
            }
            case 3: {
                return this.createTriggersForMonthlyIntervals(st, nextExecDateAndTime, losslesslyMigrated);
            }
        }
        return Collections.emptyList();
    }

    private ZonedDateTime millisToZonedDateTime(long millis) {
        Instant instant = Instant.ofEpochMilli(millis);
        return ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    private List<TriggerDefinition> createTriggersForDailyIntervals(ScheduledTaskDataSet st, ZonedDateTime nextExecDateAndTime, AtomicBoolean losslesslyMigrated) {
        ArrayList<TriggerDefinition> triggerDefs = new ArrayList<TriggerDefinition>();
        if (st.getDayOption() == 1) {
            while (nextExecDateAndTime.getDayOfWeek().getValue() > DayOfWeek.FRIDAY.getValue()) {
                nextExecDateAndTime = nextExecDateAndTime.plusDays(1L);
            }
            triggerDefs.add(new TimeTriggerBuilder().withStartDate(nextExecDateAndTime).withRepeating(RepeatInterval.WORKDAYS).create());
        } else {
            switch (st.getTimeInterval()) {
                case 1: {
                    triggerDefs.add(new TimeTriggerBuilder().withStartDate(nextExecDateAndTime).withRepeating(RepeatInterval.DAILY).create());
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    triggerDefs.add(this.createDailyCustomTriggerDef(nextExecDateAndTime, st.getTimeInterval()));
                    break;
                }
                case 7: {
                    triggerDefs.add(new TimeTriggerBuilder().withStartDate(nextExecDateAndTime).withRepeating(RepeatInterval.WEEKLY).create());
                }
            }
        }
        return triggerDefs;
    }

    private List<TriggerDefinition> createTriggersForWeeklyIntervals(ScheduledTaskDataSet st, ZonedDateTime nextExecDateAndTime, AtomicBoolean losslesslyMigrated) {
        ArrayList<TriggerDefinition> triggerDefs = new ArrayList<TriggerDefinition>();
        if (st.getTimeInterval() == 1 || st.getTimeInterval() == 2) {
            while (!this.doesDayOfWeekMatch(st, nextExecDateAndTime)) {
                nextExecDateAndTime = nextExecDateAndTime.plusDays(1L);
            }
        }
        switch (st.getTimeInterval()) {
            case 1: {
                triggerDefs.add(this.createTimeTriggerDef(nextExecDateAndTime, RepeatInterval.WEEKLY));
                break;
            }
            case 2: {
                triggerDefs.add(this.createTimeTriggerDef(nextExecDateAndTime, RepeatInterval.TWOWEEKS));
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                triggerDefs.add(this.createWeeklyCustomTriggerDef(nextExecDateAndTime, st.getTimeInterval(), st.getDayOption()));
            }
        }
        return triggerDefs;
    }

    private List<TriggerDefinition> createTriggersForMonthlyIntervals(ScheduledTaskDataSet st, ZonedDateTime nextExecDateAndTime, AtomicBoolean losslesslyMigrated) {
        int timeInterval = st.getTimeInterval();
        if (timeInterval == 1) {
            return this.createTriggersForMonthlyIntervals_1_month(st, nextExecDateAndTime);
        }
        if (timeInterval == 2) {
            return this.createTriggersForMonthlyIntervals_any_months(st, nextExecDateAndTime, 2);
        }
        if (timeInterval == 3) {
            return this.createTriggersForMonthlyIntervals_3_or_12_months(st, nextExecDateAndTime, 3);
        }
        if (timeInterval == 4) {
            return this.createTriggersForMonthlyIntervals_any_months(st, nextExecDateAndTime, 4);
        }
        if (timeInterval >= 5 && timeInterval <= 11) {
            return this.createTriggersForMonthlyIntervals_any_months(st, nextExecDateAndTime, timeInterval);
        }
        if (timeInterval == 12) {
            return this.createTriggersForMonthlyIntervals_3_or_12_months(st, nextExecDateAndTime, 12);
        }
        if (timeInterval >= 13 && timeInterval <= 36) {
            return this.createTriggersForMonthlyIntervals_any_months(st, nextExecDateAndTime, timeInterval);
        }
        return Collections.emptyList();
    }

    private List<TriggerDefinition> createTriggersForMonthlyIntervals_1_month(ScheduledTaskDataSet st, ZonedDateTime nextExecDateAndTime) {
        ArrayList<TriggerDefinition> triggerDefs = new ArrayList<TriggerDefinition>();
        switch (st.getIntervalTypeOption()) {
            case 0: {
                switch (st.getDayOption()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        triggerDefs.add(this.createMonthlyTimeTriggerDef(nextExecDateAndTime, this.dayOptionToMonthlyDayCardinality(st.getDayOption())));
                        break;
                    }
                    case 5: {
                        nextExecDateAndTime = this.addDaysToReachSpecifiedDayOfMonth(nextExecDateAndTime, 15);
                        triggerDefs.add(this.createMonthlyTimeTriggerDef(nextExecDateAndTime, MonthlyDay.INITIAL));
                    }
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                triggerDefs.addAll(this.createTriggersForMonthlyIntervals_any_months(st, nextExecDateAndTime, 1));
            }
        }
        return triggerDefs;
    }

    private int intervalTypeOptionToCustomMonthlyDay(int intervalTypeOption) {
        switch (intervalTypeOption) {
            case 0: {
                return 8;
            }
            case 1: {
                return 9;
            }
            case 2: {
                return DayOfWeek.MONDAY.getValue();
            }
            case 3: {
                return DayOfWeek.TUESDAY.getValue();
            }
            case 4: {
                return DayOfWeek.WEDNESDAY.getValue();
            }
            case 5: {
                return DayOfWeek.THURSDAY.getValue();
            }
            case 6: {
                return DayOfWeek.FRIDAY.getValue();
            }
            case 7: {
                return DayOfWeek.SATURDAY.getValue();
            }
            case 8: {
                return DayOfWeek.SUNDAY.getValue();
            }
        }
        throw new IllegalArgumentException("Illegal=" + intervalTypeOption);
    }

    private MonthlyDay dayOptionToMonthlyDayCardinality(int dayOption) {
        switch (dayOption) {
            case 0: {
                return MonthlyDay.FIRST;
            }
            case 1: {
                return MonthlyDay.SECOND;
            }
            case 2: {
                return MonthlyDay.THIRD;
            }
            case 3: {
                return MonthlyDay.FOURTH;
            }
            case 4: {
                return MonthlyDay.LAST;
            }
        }
        throw new IllegalArgumentException("dayOption=" + dayOption);
    }

    private List<TriggerDefinition> createTriggersForMonthlyIntervals_3_or_12_months(ScheduledTaskDataSet st, ZonedDateTime nextExecDateAndTime, int monthlyInterval) {
        ArrayList<TriggerDefinition> triggerDefs = new ArrayList<TriggerDefinition>();
        switch (st.getIntervalTypeOption()) {
            case 0: {
                RepeatInterval repeatInterval = switch (monthlyInterval) {
                    case 3 -> RepeatInterval.QUARTERLY;
                    case 12 -> RepeatInterval.YEARLY;
                    default -> throw new IllegalArgumentException("Incorrect value of monthly interval: " + monthlyInterval);
                };
                switch (st.getDayOption()) {
                    case 0: {
                        nextExecDateAndTime = nextExecDateAndTime.withDayOfMonth(1);
                        triggerDefs.add(this.createTimeTriggerDef(nextExecDateAndTime, repeatInterval));
                        break;
                    }
                    case 1: {
                        nextExecDateAndTime = nextExecDateAndTime.withDayOfMonth(2);
                        triggerDefs.add(this.createTimeTriggerDef(nextExecDateAndTime, repeatInterval));
                        break;
                    }
                    case 2: {
                        nextExecDateAndTime = nextExecDateAndTime.withDayOfMonth(3);
                        triggerDefs.add(this.createTimeTriggerDef(nextExecDateAndTime, repeatInterval));
                        break;
                    }
                    case 3: {
                        nextExecDateAndTime = nextExecDateAndTime.withDayOfMonth(4);
                        triggerDefs.add(this.createTimeTriggerDef(nextExecDateAndTime, repeatInterval));
                        break;
                    }
                    case 4: {
                        triggerDefs.addAll(this.createTriggersForMonthlyIntervals_any_months(st, nextExecDateAndTime, monthlyInterval));
                        break;
                    }
                    case 5: {
                        nextExecDateAndTime = nextExecDateAndTime.withDayOfMonth(15);
                        triggerDefs.add(this.createTimeTriggerDef(nextExecDateAndTime, repeatInterval));
                    }
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                triggerDefs.addAll(this.createTriggersForMonthlyIntervals_any_months(st, nextExecDateAndTime, monthlyInterval));
            }
        }
        return triggerDefs;
    }

    private List<TriggerDefinition> createTriggersForMonthlyIntervals_any_months(ScheduledTaskDataSet st, ZonedDateTime nextExecDateAndTime, int monthlyInterval) {
        ArrayList<TriggerDefinition> triggerDefs = new ArrayList<TriggerDefinition>();
        switch (st.getDayOption()) {
            case 5: {
                nextExecDateAndTime = this.addDaysToReachSpecifiedDayOfMonth(nextExecDateAndTime, 15);
                triggerDefs.add(this.createMonthlyCustomTriggerDef(nextExecDateAndTime, monthlyInterval, MonthlyDay.INITIAL, this.intervalTypeOptionToCustomMonthlyDay(st.getIntervalTypeOption())));
                break;
            }
            default: {
                triggerDefs.add(this.createMonthlyCustomTriggerDef(nextExecDateAndTime, monthlyInterval, this.dayOptionToMonthlyDayCardinality(st.getDayOption()), this.intervalTypeOptionToCustomMonthlyDay(st.getIntervalTypeOption())));
            }
        }
        return triggerDefs;
    }

    private ZonedDateTime addDaysToReachSpecifiedDayOfMonth(ZonedDateTime date, int dayOfMonth) {
        while (date.getDayOfMonth() != dayOfMonth) {
            date = date.plusDays(1L);
        }
        return date;
    }

    private TriggerDefinition createTimeTriggerDef(ZonedDateTime startDate, RepeatInterval repeatInterval) {
        TimeTriggerBuilder builder = new TimeTriggerBuilder().withStartDate(startDate).withRepeating(repeatInterval);
        if (repeatInterval == RepeatInterval.MONTHLY && startDate.getDayOfMonth() >= 28) {
            builder.withMonthlyDay(MonthlyDay.LAST);
        }
        return builder.create();
    }

    private TriggerDefinition createMonthlyTimeTriggerDef(ZonedDateTime startDate, MonthlyDay dayOfMonth) {
        return new TimeTriggerBuilder().withStartDate(startDate).withRepeating(RepeatInterval.MONTHLY).withMonthlyDay(dayOfMonth).create();
    }

    private TriggerDefinition createWeeklyCustomTriggerDef(ZonedDateTime startDate, int timeInterval, int dayOption) {
        TriggerDefinition definition = new TriggerDefinition("trigger.time");
        definition.setProperty("start.day", String.valueOf(startDate.toEpochSecond() * 1000L));
        definition.setProperty("start.time", String.valueOf(startDate.toEpochSecond() * 1000L));
        definition.setProperty("repeat.select", RepeatInterval.CUSTOM.name());
        definition.setProperty("custom.intervaltype", String.valueOf(2));
        definition.setProperty("custom.interval", String.valueOf(timeInterval));
        definition.setProperty("custom.weekly.dayofweek", DayOfWeek.of(dayOption + 1).name());
        return definition;
    }

    private TriggerDefinition createMonthlyCustomTriggerDef(ZonedDateTime startDate, int timeInterval, MonthlyDay cardinality, int dayOfMonthSelection) {
        TriggerDefinition definition = new TriggerDefinition("trigger.time");
        definition.setProperty("start.day", String.valueOf(startDate.toEpochSecond() * 1000L));
        definition.setProperty("start.time", String.valueOf(startDate.toEpochSecond() * 1000L));
        definition.setProperty("repeat.select", RepeatInterval.CUSTOM.name());
        definition.setProperty("custom.intervaltype", String.valueOf(3));
        definition.setProperty("custom.interval", String.valueOf(timeInterval));
        definition.setProperty("custom.monthly.cardinality", cardinality.name());
        definition.setProperty("custom.monthly.day", String.valueOf(dayOfMonthSelection));
        return definition;
    }

    private TriggerDefinition createDailyCustomTriggerDef(ZonedDateTime startDate, int dailyInterval) {
        if (dailyInterval < 2 || dailyInterval > 6) {
            throw new IllegalArgumentException("Incorrect value of daily interval: " + dailyInterval);
        }
        TriggerDefinition definition = new TriggerDefinition("trigger.time");
        definition.setProperty("start.day", String.valueOf(startDate.toEpochSecond() * 1000L));
        definition.setProperty("start.time", String.valueOf(startDate.toEpochSecond() * 1000L));
        definition.setProperty("repeat.select", RepeatInterval.CUSTOM.name());
        definition.setProperty("custom.intervaltype", String.valueOf(1));
        definition.setProperty("custom.interval", String.valueOf(dailyInterval));
        return definition;
    }

    private boolean doesDayOfWeekMatch(ScheduledTaskDataSet st, ZonedDateTime date) {
        return st.getDayOption() == date.getDayOfWeek().getValue() - 1;
    }

    public static class ScheduledTaskMigrationResult {
        private GUID quickTicketID;
        private GUID taskID;
        boolean losslesslyMigrated;

        public ScheduledTaskMigrationResult(@Nonnull GUID quickTicketID, @Nonnull GUID taskID, boolean losslesslyMigrated) {
            this.quickTicketID = quickTicketID;
            this.taskID = taskID;
            this.losslesslyMigrated = losslesslyMigrated;
        }

        @Nonnull
        public GUID getQuickTicketID() {
            return this.quickTicketID;
        }

        @Nonnull
        public GUID getTaskID() {
            return this.taskID;
        }

        public boolean isLosslesslyMigrated() {
            return this.losslesslyMigrated;
        }
    }
}

