/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.client.ticketlist.handler;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableQuickTicketVO;
import com.inet.helpdesk.plugins.quickticket.api.AutoReactAndAuthChecker;
import com.inet.helpdesk.plugins.quickticket.client.shared.QuickTicketHandlerUtils;
import com.inet.helpdesk.plugins.quickticket.client.ticketlist.data.ValidateQuickTicketActionRequest;
import com.inet.helpdesk.plugins.quickticket.client.ticketlist.data.ValidateQuickTicketActionResponse;
import com.inet.http.ClientMessageException;
import com.inet.remote.gui.angular.ServiceMethod;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

public class ValidateQuickTicketAction
extends ServiceMethod<ValidateQuickTicketActionRequest, ValidateQuickTicketActionResponse> {
    public String getMethodName() {
        return "quickticket.validatequickticketaction";
    }

    public short getMethodType() {
        return 1;
    }

    public ValidateQuickTicketActionResponse invoke(HttpServletRequest req, HttpServletResponse resp, ValidateQuickTicketActionRequest payload) throws IOException {
        TicketVO ticket;
        Integer ticketID = payload.getTicketID();
        List<Integer> actionIds = payload.getActionIds();
        if (actionIds != null) {
            actionIds.forEach(aId -> {
                ActionVO action = (ActionVO)ActionManager.getInstance().get(aId.intValue());
                if (action.isDeleted()) {
                    throw new ClientMessageException(QuickTicketServerPlugin.CLIENT_MSG.getMsg("ticketlist.quickticket.apply.validate.deletedaction", new Object[]{action.getDisplayValue()}));
                }
            });
            ApplicableQuickTicketVO.throwIfContainsActionIDsInIncorrectOrder(actionIds);
        }
        if (ticketID != null && (ticket = TicketManager.getReader().getTicket(ticketID.intValue())) != null) {
            int index;
            AutoReactAndAuthChecker.AutoReactAndAuthCheckResult check = AutoReactAndAuthChecker.check(ticket, actionIds);
            int n = index = actionIds == null ? -1 : actionIds.indexOf(5);
            if (index >= 0 && (ticket.isDispatched() || check.isAuthorizationRequired())) {
                ActionVO action = (ActionVO)ActionManager.getInstance().get(5);
                String errorMsg = QuickTicketHandlerUtils.generateErrorMsgForAction(action.getDisplayValue(), index, QuickTicketServerPlugin.CLIENT_MSG.getMsg("ticketlist.quickticket.apply.validate.multipleauth", new Object[0]));
                throw new ClientMessageException(errorMsg);
            }
            return new ValidateQuickTicketActionResponse(check.isReactivationRequired(), check.isAuthorizationRequired());
        }
        return new ValidateQuickTicketActionResponse(false, false);
    }
}

