/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.api;

import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketException;
import com.inet.id.GUID;
import com.inet.remote.gui.angular.usersorgroupsselection.UsersOrGroupsSelection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class QuickTicketFolderVO {
    private final GUID parentID;
    private final GUID folderID;
    private final String folderName;
    private final List<UsersOrGroupsSelection.SelectedMember> memberships;

    private QuickTicketFolderVO(@Nullable GUID parentID, GUID folderID, String folderName, List<UsersOrGroupsSelection.SelectedMember> memberships) {
        QuickTicketFolderVO.throwIfIdIsInvalid(folderID);
        QuickTicketFolderVO.throwIfNameIsInvalid(folderName);
        if (Objects.equals(parentID, folderID)) {
            throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.folder.validParent", new Object[0]));
        }
        this.parentID = parentID;
        this.folderID = folderID;
        this.folderName = folderName;
        this.memberships = memberships;
    }

    public static QuickTicketFolderVO create(@Nullable GUID parentID, GUID folderID, String folderName, List<UsersOrGroupsSelection.SelectedMember> memberships) {
        return new QuickTicketFolderVO(parentID, folderID, folderName, memberships);
    }

    public static QuickTicketFolderVO create(@Nullable GUID parentID, GUID folderID, String folderName) {
        return new QuickTicketFolderVO(parentID, folderID, folderName, null);
    }

    @Nullable
    public GUID getParentID() {
        return this.parentID;
    }

    public GUID getID() {
        return this.folderID;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.folderName == null ? 0 : this.folderName.hashCode());
        result = 31 * result + (this.folderID == null ? 0 : this.folderID.hashCode());
        result = 31 * result + (this.parentID == null ? 0 : this.parentID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuickTicketFolderVO other = (QuickTicketFolderVO)obj;
        if (this.folderName == null ? other.folderName != null : !this.folderName.equals(other.folderName)) {
            return false;
        }
        if (this.folderID == null ? other.folderID != null : !this.folderID.equals((Object)other.folderID)) {
            return false;
        }
        if (this.parentID == null ? other.parentID != null : !this.parentID.equals((Object)other.parentID) && (this.parentID == null ? other.parentID != null : !this.parentID.equals((Object)other.parentID))) {
            return false;
        }
        return !(this.memberships == null ? other.memberships != null : !this.memberships.equals(other.memberships));
    }

    public static void throwIfIdIsInvalid(GUID folderID) {
        if (folderID == null) {
            throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.folder.validID", new Object[0]));
        }
    }

    public static void throwIfNameIsInvalid(String folderName) {
        if (folderName == null) {
            throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.folder.validName", new Object[0]));
        }
        if (folderName.trim().isEmpty()) {
            throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.folder.validName", new Object[0]));
        }
        if (folderName.length() > 100) {
            throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.folder.nameLength", new Object[]{Integer.toString(100)}));
        }
    }

    public List<UsersOrGroupsSelection.SelectedMember> getFolderPermission() {
        return this.memberships;
    }
}

