/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.client.shared.handler;

import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.plugins.quickticket.api.LoadQuickTicketUtil;
import com.inet.helpdesk.plugins.quickticket.client.shared.data.AvailableQuickTicketsRequest;
import com.inet.helpdesk.plugins.quickticket.client.shared.data.AvailableQuickTicketsResponse;
import com.inet.helpdesk.plugins.quickticket.client.shared.data.QuickTicketSelectEntry;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class LoadAvailableQuickTickets
extends ServiceMethod<AvailableQuickTicketsRequest, AvailableQuickTicketsResponse> {
    private boolean includeDetails;

    public LoadAvailableQuickTickets(boolean includeDetails) {
        this.includeDetails = includeDetails;
    }

    public String getMethodName() {
        return "quickticket.loadavailablequicktickets";
    }

    public short getMethodType() {
        return 1;
    }

    public AvailableQuickTicketsResponse invoke(HttpServletRequest req, HttpServletResponse resp, AvailableQuickTicketsRequest payload) throws IOException {
        List<QuickTicketSelectEntry> entries = new ArrayList<QuickTicketSelectEntry>();
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            return new AvailableQuickTicketsResponse(entries);
        }
        if (!HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount) && !SystemPermissionChecker.checkAccess((Permission[])new Permission[]{HdPermissions.TEMPLATE_DEFINITION, Permission.CONFIGURATION})) {
            return new AvailableQuickTicketsResponse(entries);
        }
        if (!this.includeDetails && !TicketManager.getTicketActionChecker().checkCurrentUserHasPermissionToExecuteAction(-33)) {
            return new AvailableQuickTicketsResponse(entries);
        }
        String filter = null;
        if (this.includeDetails) {
            filter = payload.getSearchfilter();
        }
        entries = LoadQuickTicketUtil.getQuickTicketEntries(filter, this.includeDetails);
        this.sortRecursivly(entries);
        AvailableQuickTicketsResponse availableQuickTicketsResponse = new AvailableQuickTicketsResponse(entries);
        return availableQuickTicketsResponse;
    }

    private void sortRecursivly(List<QuickTicketSelectEntry> entries) {
        if (entries == null || entries.isEmpty()) {
            return;
        }
        Comparator<QuickTicketSelectEntry> qtComparator = new Comparator<QuickTicketSelectEntry>(){

            @Override
            public int compare(QuickTicketSelectEntry o1, QuickTicketSelectEntry o2) {
                if (o1.isFolder() != o2.isFolder()) {
                    return o1.isFolder() ? -1 : 1;
                }
                return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
            }
        };
        entries.sort(qtComparator);
        for (QuickTicketSelectEntry entry : entries) {
            this.sortRecursivly(entry.getChildren());
        }
    }
}

