/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.client.config.handler;

import com.inet.helpdesk.plugins.quickticket.client.config.data.ListDeletableTasksRequest;
import com.inet.helpdesk.plugins.quickticket.client.config.data.ListDeletableTasksResponse;
import com.inet.helpdesk.plugins.quickticket.taskplanner.TasksWithQTs;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.Executable;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskExecution;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;

public class ListDeletableTasks
extends ServiceMethod<ListDeletableTasksRequest, ListDeletableTasksResponse> {
    public String getMethodName() {
        return "quickticket.deletequickticketorfolder.listdeletabletasks";
    }

    public short getMethodType() {
        return 1;
    }

    public ListDeletableTasksResponse invoke(HttpServletRequest req, HttpServletResponse resp, final ListDeletableTasksRequest payload) throws IOException {
        final HashMap<String, Integer> deletedTasks = new HashMap<String, Integer>();
        final HashMap<String, Integer> corruptedTasks = new HashMap<String, Integer>();
        final HashMap<String, String> deletedTaskNames = new HashMap<String, String>();
        ServerPluginManager.getInstance().runIfPluginLoaded("taskplanner.helpdesk", () -> new Executable(){

            public void execute() {
                TasksWithQTs tasksWithQTs = TasksWithQTs.getInstance();
                HashSet<GUID> tasksToBeDeleted = new HashSet<GUID>();
                tasksToBeDeleted.addAll(tasksWithQTs.getTasksIDsWithQuickTicketAction(payload.getId()));
                tasksToBeDeleted.addAll(tasksWithQTs.getTasksIDsWithQuickTicketJob(payload.getId()));
                tasksToBeDeleted.forEach(tId -> {
                    String displayName;
                    TaskExecution taskExecution = TaskPlanner.getInstance().getTaskExecution(tId);
                    if (taskExecution == null) {
                        return;
                    }
                    GUID ownerId = taskExecution.getOwnerId();
                    if (ownerId == null) {
                        return;
                    }
                    UserAccount userAccount = UserManager.getInstance().getUserAccount(ownerId);
                    String string = displayName = userAccount == null ? ownerId.toString() : userAccount.getDisplayName();
                    if (tasksWithQTs.isTaskPlannerAdminAvailable() || ownerId.equals((Object)UserManager.getInstance().getCurrentUserAccountID())) {
                        TaskDefinition taskDefinition = TaskPlanner.getInstance().getTaskDefinition(tId);
                        if (taskDefinition != null) {
                            String taskName = taskDefinition.getName();
                            Integer count = deletedTasks.computeIfAbsent(displayName, k -> 0);
                            deletedTasks.put(displayName, count + 1);
                            Object namesList = (String)deletedTaskNames.get(displayName);
                            if (StringFunctions.isEmpty((String)namesList)) {
                                namesList = "\"" + taskName + "\"";
                            } else if (count < 3) {
                                namesList = (String)namesList + ", \"" + taskName + "\"";
                            } else if (count == 3) {
                                namesList = (String)namesList + ", ...";
                            }
                            deletedTaskNames.put(displayName, namesList);
                        }
                    } else {
                        Integer count = corruptedTasks.computeIfAbsent(displayName, k -> 0);
                        corruptedTasks.put(displayName, count + 1);
                    }
                });
            }
        });
        return new ListDeletableTasksResponse(deletedTasks, corruptedTasks, deletedTaskNames);
    }
}

