/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.taskplanner;

import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.WithAdditionalReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableQuickTicketVO;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketManager;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketVO;
import com.inet.helpdesk.plugins.taskplanner.server.HDTaskPlannerDataListener;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.error.TaskExecutionException;
import com.inet.taskplanner.server.api.job.ConditionDefinition;
import com.inet.taskplanner.server.api.job.Job;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import com.inet.taskplanner.server.api.job.ResultContainer;
import com.inet.usersandgroups.api.user.UserManager;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class CreateTicketFromQuickTicketJob
extends Job {
    public static final String PROPERTY_QUICKTICKET_SUBJECT = "quickticketsubject";
    public static final String PROPERTY_QUICKTICKET_ID = "quickticketid";
    private final GUID quickticketid;
    private final String quickticketsubject;
    private GUID taskID;

    public CreateTicketFromQuickTicketJob(JobDefinition definition, @Nullable GUID taskID) {
        super(definition.getCondition());
        this.taskID = taskID;
        Map properties = definition.getProperties();
        if (properties.get(PROPERTY_QUICKTICKET_ID) != null) {
            this.quickticketid = GUID.valueOf((String)((String)properties.get(PROPERTY_QUICKTICKET_ID)));
            this.quickticketsubject = (String)properties.get(PROPERTY_QUICKTICKET_SUBJECT);
        } else {
            this.quickticketid = null;
            this.quickticketsubject = null;
        }
    }

    public JobResultContainer run() throws TaskExecutionException {
        GUID currentUserAccID;
        if (this.quickticketid == null) {
            throw new TaskExecutionException((Throwable)new IllegalArgumentException(QuickTicketServerPlugin.MSG.getMsg("CreateFromQuickTicket.QuickTicketMissing", new Object[0])));
        }
        QuickTicketManager qtManager = this.getQtManager();
        QuickTicketVO quickTicket = qtManager.getQuickTicket(this.quickticketid);
        if (quickTicket == null) {
            throw new TaskExecutionException((Throwable)new IllegalArgumentException(QuickTicketServerPlugin.MSG.getMsg("CreateFromQuickTicket.QuickTicketNoLonger", new Object[0])));
        }
        ApplicableQuickTicketVO qtVO = quickTicket.toApplicable();
        MutableTicketData ticketData = qtVO.getTicketData();
        if (!StringFunctions.isEmpty((String)this.quickticketsubject)) {
            ticketData.put((TicketField)Tickets.FIELD_SUBJECT, (Object)this.quickticketsubject);
        }
        if ((currentUserAccID = UserManager.getInstance().getCurrentUserAccountID()) == null) {
            throw new TaskExecutionException((Throwable)new IllegalStateException("No user is logged in."));
        }
        int newTicketWithQuickTicket = -1;
        try (WithAdditionalReaStepData addReaStepData = WithAdditionalReaStepData.create((ReaStepField)ReaStepVO.FIELD_TASKPLANNER_TASKID, (Object)this.taskID);){
            ApplicableQuickTicketVO aQTVO = this.createApplicableQuickTicketVO(qtVO, ticketData);
            newTicketWithQuickTicket = qtManager.createNewTicketWithQuickTicket(aQTVO);
            HDTaskPlannerDataListener.getRegisteredInstance().addCreatedTicketForTask(this.taskID, newTicketWithQuickTicket);
        }
        HashMap<String, CallSite> metaProperties = new HashMap<String, CallSite>();
        if (newTicketWithQuickTicket >= 1) {
            metaProperties.put("Ticket ID", (CallSite)((Object)(newTicketWithQuickTicket + " ")));
        }
        return new ResultContainer(new ArrayList(), metaProperties);
    }

    protected ApplicableQuickTicketVO createApplicableQuickTicketVO(ApplicableQuickTicketVO qtVO, MutableTicketData ticketData) {
        return ApplicableQuickTicketVO.create(this.quickticketid, ticketData, qtVO.getExtensionArguments(), qtVO.getActionsData());
    }

    protected QuickTicketManager getQtManager() {
        return (QuickTicketManager)ServerPluginManager.getInstance().getSingleInstance(QuickTicketManager.class);
    }

    protected boolean evaluateCondition(ConditionDefinition conditionDefinition) {
        return false;
    }
}

