/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.client.config;

import com.inet.config.structure.model.ConfigPage;
import com.inet.config.structure.model.ConfigSearchSuggestion;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.api.LoadQuickTicketUtil;
import com.inet.helpdesk.plugins.quickticket.client.shared.data.QuickTicketSelectEntry;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class QuickTicketConfigPage
implements ConfigPage {
    public String getPageKey() {
        return "configuration.quicktickets";
    }

    public String getParentKey() {
        return "configuration.templates";
    }

    public String getShortDisplayName() {
        return QuickTicketServerPlugin.CLIENT_MSG.getMsg("configpage.configuration.quicktickets", new Object[0]);
    }

    public String getFullDisplayName() {
        return QuickTicketServerPlugin.CLIENT_MSG.getMsg("configpage.configuration.quicktickets.fulldisplayname", new Object[0]);
    }

    public String getDescription() {
        return QuickTicketServerPlugin.CLIENT_MSG.getMsg("configpage.configuration.quicktickets.description", new Object[0]);
    }

    public URL getIconURL() {
        return this.getClass().getResource("/com/inet/helpdesk/plugins/quickticket/images/quickticket_48.png");
    }

    public String getRelativeTemplateUrl() {
        return "weblib/configuration.quickticket.html";
    }

    public boolean isAccessAllowed() {
        return SystemPermissionChecker.hasAnyPermission((UserAccount)UserManager.getInstance().getCurrentUserAccount(), (Permission[])new Permission[]{Permission.CONFIGURATION, HdPermissions.TEMPLATE_DEFINITION});
    }

    public String getHelpKey() {
        return "configuration.quickticket";
    }

    public List<ConfigSearchSuggestion> getSearchSuggestions(String searchTerm, Map<String, String> properties) {
        ArrayList<ConfigSearchSuggestion> suggestions = new ArrayList<ConfigSearchSuggestion>();
        if (searchTerm != null && !searchTerm.isEmpty()) {
            if (QuickTicketServerPlugin.CONFIG_PAGE.getFullDisplayName().toLowerCase().contains(searchTerm.toLowerCase())) {
                suggestions.add(new ConfigSearchSuggestion(QuickTicketServerPlugin.CONFIG_PAGE.getFullDisplayName(), "page/configuration.quicktickets/", HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.templates", new Object[0]), 20, true));
            }
            List<QuickTicketSelectEntry> entries = LoadQuickTicketUtil.getQuickTicketEntries(searchTerm, true);
            suggestions.addAll(this.createConfigSearchSuggestions(entries));
        }
        return suggestions;
    }

    private List<ConfigSearchSuggestion> createConfigSearchSuggestions(List<QuickTicketSelectEntry> entries) {
        ArrayList<ConfigSearchSuggestion> suggestions = new ArrayList<ConfigSearchSuggestion>();
        for (QuickTicketSelectEntry quickTicketSelectEntry : entries) {
            if (quickTicketSelectEntry.getSortId() > 0) {
                String folderId = quickTicketSelectEntry.getFolderId();
                Object path = "page/configuration.quicktickets";
                String type = "";
                if (folderId != null) {
                    type = QuickTicketServerPlugin.CLIENT_MSG.getMsg("configpage.configuration.quicktickets", new Object[0]);
                    path = (String)path + "/folder/" + folderId + "/editquickticket/" + quickTicketSelectEntry.getKey();
                } else {
                    type = QuickTicketServerPlugin.CLIENT_MSG.getMsg("configpage.configuration.quicktickets", new Object[0]);
                    path = (String)path + "/folder/" + quickTicketSelectEntry.getKey();
                }
                suggestions.add(new ConfigSearchSuggestion(quickTicketSelectEntry.getDisplayName(), (String)path, type, quickTicketSelectEntry.getSortId()));
            }
            suggestions.addAll(this.createConfigSearchSuggestions(quickTicketSelectEntry.getChildren()));
        }
        return suggestions;
    }
}

