/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.api;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableActionData;
import com.inet.helpdesk.plugins.quickticket.api.MutableApplicableActionData;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ApplicableActionDataVO
implements ApplicableActionData {
    private final String uniqueActionID;
    private final MutableReaStepData reaStepData;
    private final ReaStepTextVO reaStepText;
    private final ExtensionArguments extArgs;

    private ApplicableActionDataVO(String uniqueActionID, MutableReaStepData reaStepData, ReaStepTextVO reaStepText, ExtensionArguments extArgs) {
        if (uniqueActionID == null) {
            throw QuickTicketException.forIAE("uniqueActionID must not be null");
        }
        if (uniqueActionID.trim().isEmpty()) {
            throw QuickTicketException.forIAE("uniqueActionID must not be empty after trim");
        }
        if (reaStepData == null) {
            throw QuickTicketException.forIAE("reaStepData must not be null");
        }
        ApplicableActionDataVO.throwIfUndefinedStepTextIsNotAllowed(uniqueActionID, reaStepText);
        if (extArgs == null) {
            throw QuickTicketException.forIAE("extArgs must not be null");
        }
        this.uniqueActionID = uniqueActionID;
        this.reaStepData = reaStepData.copy();
        this.reaStepText = reaStepText;
        this.extArgs = ExtensionArguments.copyOf((ExtensionArguments)extArgs);
    }

    public static ApplicableActionDataVO create(String uniqueActionID, MutableReaStepData reaStepData, ReaStepTextVO reaStepText, ExtensionArguments extArgs) {
        return new ApplicableActionDataVO(uniqueActionID, reaStepData, reaStepText, extArgs);
    }

    @Override
    public String getUniqueActionID() {
        return this.uniqueActionID;
    }

    @Override
    public MutableReaStepData getReaStepData() {
        return this.reaStepData.copy();
    }

    @Override
    public ReaStepTextVO getReaStepText() {
        return this.reaStepText;
    }

    @Override
    public ExtensionArguments getExtensionArguments() {
        return ExtensionArguments.copyOf((ExtensionArguments)this.extArgs);
    }

    public boolean isEqualToDataFrom(MutableApplicableActionData mutableData) {
        if (mutableData == null) {
            return false;
        }
        if (!this.uniqueActionID.equals(mutableData.getUniqueActionID())) {
            return false;
        }
        if (!this.reaStepData.equals((Object)mutableData.getReaStepData())) {
            return false;
        }
        if (!Objects.equals(this.reaStepText, mutableData.getReaStepText())) {
            return false;
        }
        return this.extArgs.equals((Object)mutableData.getExtensionArguments());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.extArgs == null ? 0 : this.extArgs.hashCode());
        result = 31 * result + (this.reaStepData == null ? 0 : this.reaStepData.hashCode());
        result = 31 * result + (this.reaStepText == null ? 0 : this.reaStepText.hashCode());
        result = 31 * result + (this.uniqueActionID == null ? 0 : this.uniqueActionID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicableActionDataVO other = (ApplicableActionDataVO)obj;
        if (this.extArgs == null ? other.extArgs != null : !this.extArgs.equals((Object)other.extArgs)) {
            return false;
        }
        if (this.reaStepData == null ? other.reaStepData != null : !this.reaStepData.equals((Object)other.reaStepData)) {
            return false;
        }
        if (this.reaStepText == null ? other.reaStepText != null : !this.reaStepText.equals((Object)other.reaStepText)) {
            return false;
        }
        return !(this.uniqueActionID == null ? other.uniqueActionID != null : !this.uniqueActionID.equals(other.uniqueActionID));
    }

    public String toString() {
        return "ApplicableActionDataVO [uniqueActionID=" + this.uniqueActionID + ", reaStepData=" + String.valueOf(this.reaStepData) + ", reaStepText=" + String.valueOf(this.reaStepText) + ", extArgs=" + String.valueOf(this.extArgs) + "]";
    }

    @Override
    public MutableApplicableActionData toMutable() {
        return new MutableApplicableActionData(this.getUniqueActionID(), this.getReaStepData(), this.getReaStepText(), this.getExtensionArguments());
    }

    @Override
    public ApplicableActionDataVO toImmutable() {
        return this;
    }

    public static void throwIfUndefinedStepTextIsNotAllowed(@Nonnull String uniqueActionID, @Nullable ReaStepTextVO reaStepText) {
        String actionEditReaStepTextUniqueID;
        if (reaStepText == null && !Objects.equals(actionEditReaStepTextUniqueID = ((ActionVO)ActionManager.getInstance().get(-22)).getUniqueID(), uniqueActionID)) {
            throw QuickTicketException.forIAE("reaStepText must not be null for action with ID \"" + uniqueActionID + "\"");
        }
    }
}

