/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.setup;

import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketManager;
import com.inet.helpdesk.plugins.quickticket.swing.shared.ConstrainedQuickTicketVO;
import com.inet.helpdesk.shared.model.QuickTicketDataSet;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class OldQuickTicketTableMigrator {
    public List<QuickTicketDataSet> loadData(@Nonnull Connection con) throws SQLException {
        ArrayList<QuickTicketDataSet> data = new ArrayList<QuickTicketDataSet>();
        try (Statement stm = con.createStatement();
             ResultSet rs = stm.executeQuery("SELECT * FROM tblQuickTicket");){
            while (rs.next()) {
                QuickTicketDataSet row = new QuickTicketDataSet();
                row.setQuiID(rs.getInt("QuiID"));
                row.setName(rs.getString("Bezeichnung"));
                row.setResID(rs.getInt("ResID"));
                row.setPriID(rs.getInt("PriID"));
                row.setProcessingTime(rs.getInt("Aufwand"));
                row.setBetID(rs.getInt("BetID"));
                row.setSubject(rs.getString("Betreff"));
                row.setBunFeld1(rs.getString("BunFeld1"));
                row.setBunFeld2(rs.getString("BunFeld2"));
                row.setBunFeld3(rs.getString("BunFeld3"));
                row.setBunFeld4(rs.getString("BunFeld4"));
                row.setIdentifier(rs.getString("spezFeld"));
                row.setTicketText(rs.getString("Auftrag"));
                row.setIshtml(rs.getBoolean("ishtml"));
                row.setProcessingText(rs.getString("BearbeitungsText"));
                row.setIshtmlPt(rs.getBoolean("ishtmlBT"));
                row.setAktID(rs.getInt("DefAktID"));
                row.setItiID(rs.getInt("ItiID"));
                row.setKlaID(rs.getInt("KlaID"));
                row.setAutomailSetting(rs.getInt("Automails"));
                data.add(row);
            }
        }
        return data;
    }

    public void migrateData(@Nonnull List<QuickTicketDataSet> data) {
        QuickTicketManager qtManager = (QuickTicketManager)ServerPluginManager.getInstance().getSingleInstance(QuickTicketManager.class);
        HashMap<Integer, GUID> oldQuickIDToNewGUID = new HashMap<Integer, GUID>();
        try (UserAccountScope scope = UserAccountScope.createPrivileged();){
            for (QuickTicketDataSet qt : data) {
                ConstrainedQuickTicketVO.convertOldQuickTicketDataSetAndDo(qt, false, (name, ticketData, extArgs, actionsData) -> {
                    GUID guid = qtManager.createQuickTicketFromOldSwingClientData(qt.getName(), ticketData, extArgs, actionsData);
                    oldQuickIDToNewGUID.put(qt.getQuiID(), guid);
                    return null;
                });
            }
        }
        this.migrateTaskplannerTasksIfActive(oldQuickIDToNewGUID);
    }

    private void migrateTaskplannerTasksIfActive(Map<Integer, GUID> oldQuickIDToNewGUID) {
        if (ServerPluginManager.getInstance().isPluginLoaded("taskplanner")) {
            SetupLogger.LOGGER.info((Object)"Migrate QuickTicket-Jobs in taskplanner");
            TaskPlanner taskPlanner = TaskPlanner.getInstance();
            taskPlanner.getAllTaskIDs().forEach(taskId -> {
                TaskDefinition taskDefinition = taskPlanner.getTaskDefinition(taskId);
                boolean wasUpdated = false;
                List jobs = taskDefinition.getJobs();
                for (int i = 0; i < jobs.size(); ++i) {
                    JobDefinition job = (JobDefinition)jobs.get(i);
                    if (!job.getExtensionName().equals("taskplanner.helpdesk.createfromquickticketjob")) continue;
                    String idStr = job.getProperty("quickticketid");
                    if (idStr == null || idStr.trim().isEmpty()) {
                        wasUpdated = true;
                        JobDefinition newJob = new JobDefinition("quickticket.taskplanner.createfromquickticketjob");
                        newJob.setProperty("quickticketsubject", job.getProperty("quickticketsubject"));
                        taskDefinition.removeJob(job);
                        taskDefinition.addJob(newJob);
                        continue;
                    }
                    try {
                        Integer id = Integer.valueOf(idStr);
                        GUID newGUID = (GUID)oldQuickIDToNewGUID.get(id);
                        if (newGUID != null) {
                            wasUpdated = true;
                            JobDefinition newJob = new JobDefinition("quickticket.taskplanner.createfromquickticketjob");
                            newJob.setProperty("quickticketid", newGUID.toString());
                            newJob.setProperty("quickticketsubject", job.getProperty("quickticketsubject"));
                            taskDefinition.removeJob(job);
                            taskDefinition.addJob(newJob);
                            continue;
                        }
                        SetupLogger.LOGGER.warn((Object)QuickTicketServerPlugin.MSG.getMsg("setup.error.quickTicketNotFound", new Object[]{taskId.toString(), id}));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        SetupLogger.LOGGER.error((Object)String.format("Old quickticket taskplanner task %s has no valid id! id=%d", taskId.toString(), idStr));
                    }
                }
                if (wasUpdated) {
                    taskPlanner.updateTask(taskId, taskDefinition);
                    SetupLogger.LOGGER.info((Object)("Updated task " + String.valueOf(taskId)));
                }
            });
        } else {
            SetupLogger.LOGGER.info((Object)"Taskplanner: not activated!");
        }
    }

    public QuickTicketDataSet createDataOfQuickTicketPasswordZurucksetzen() {
        QuickTicketDataSet row = new QuickTicketDataSet();
        row.setQuiID(1);
        row.setName("Passwort zur\u00fccksetzen");
        row.setResID(2);
        row.setPriID(60);
        row.setItiID(5);
        row.setKlaID(0);
        row.setProcessingTime(15);
        row.setSubject("Passwort zur\u00fccksetzen");
        row.setTicketText("Passwort vergessen");
        row.setIshtml(false);
        row.setProcessingText("Passwort zur\u00fcckgesetzt");
        row.setIshtmlPt(false);
        row.setAktID(2);
        row.setAutomailSetting(0);
        row.setBunFeld1(null);
        row.setBunFeld2(null);
        row.setBunFeld3(null);
        row.setBunFeld4(null);
        row.setIdentifier(null);
        row.setBetID(0);
        return row;
    }
}

