/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.client.config.handler;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.extensions.AddAttachmentsExtensionData;
import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.api.MutableApplicableActionData;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketException;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketManager;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketProcessingTime;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketVO;
import com.inet.helpdesk.plugins.quickticket.api.SendMailFromQuickTicketExtensionData;
import com.inet.helpdesk.plugins.quickticket.client.config.data.QuickTicketActionDescription;
import com.inet.helpdesk.plugins.quickticket.client.config.data.SaveQuickTicketRequest;
import com.inet.helpdesk.plugins.quickticket.client.shared.QuickTicketHandlerUtils;
import com.inet.helpdesk.plugins.quickticket.client.shared.data.QuickTicketDescription;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFieldRendererId;
import com.inet.helpdesk.plugins.ticketlist.api.data.ActionDescription;
import com.inet.helpdesk.plugins.ticketlist.api.data.EditDuration;
import com.inet.helpdesk.plugins.ticketlist.api.data.RecipientsCombined;
import com.inet.helpdesk.plugins.ticketlist.api.data.SavedAttachmentData;
import com.inet.helpdesk.plugins.ticketlist.api.data.Sender;
import com.inet.helpdesk.plugins.ticketlist.api.editing.ApplyActionRendererProvider;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SaveQuickTicket
extends ServiceMethod<SaveQuickTicketRequest, Void> {
    public String getMethodName() {
        return "quickticket.savequickticket";
    }

    public short getMethodType() {
        return 1;
    }

    public Void invoke(HttpServletRequest req, HttpServletResponse resp, SaveQuickTicketRequest payload) throws IOException {
        boolean editStepActionForInquiryTextAdded = false;
        try {
            QuickTicketDescription qtDescription = payload.getQuickTicketDescription();
            GUID qtId = qtDescription.getQuickTicketId();
            String quickTicketName = qtDescription.getQuickTicketName();
            GUID quickTicketFolderId = qtDescription.getQuickTicketFolder();
            List fieldDefs = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
            QuickTicketManager quickTicketManager = (QuickTicketManager)ServerPluginManager.getInstance().getSingleInstance(QuickTicketManager.class);
            HashMap<String, String> fieldValues = payload.getFieldValues();
            ArrayList<QuickTicketActionDescription> actionValues = payload.getActionValues();
            if (!StringFunctions.isEmpty((String)quickTicketName)) {
                List<Object> quickTicketsInFolder = Collections.emptyList();
                quickTicketsInFolder = quickTicketFolderId == null ? quickTicketManager.listQuickTicketsUnassignedToFolders() : quickTicketManager.listQuickTicketsInFolder(quickTicketFolderId);
                Set existingQTNames = quickTicketsInFolder.stream().filter(f -> {
                    if (qtDescription.getQuickTicketId() == null) {
                        return true;
                    }
                    return !qtDescription.getQuickTicketId().equals(f);
                }).map(f -> {
                    QuickTicketVO quickTicket = quickTicketManager.getQuickTicket((GUID)f);
                    if (quickTicket != null) {
                        return quickTicket.getQuickTicketName();
                    }
                    return null;
                }).collect(Collectors.toSet());
                if (existingQTNames.contains(quickTicketName)) {
                    throw new ClientMessageException(QuickTicketServerPlugin.CLIENT_MSG.getMsg("configuration.quickticket.edit.save.error.duplicatename", new Object[0]));
                }
            }
            MutableTicketData fieldsData = new MutableTicketData();
            for (TicketFieldDefinition definition : fieldDefs) {
                FieldEditDefinition editDefinition;
                if (definition == null || fieldValues == null || (editDefinition = definition.getEditDefinition()) == null || !fieldValues.containsKey(editDefinition.getFieldKey())) continue;
                int size = fieldsData.getIncludedFields().size();
                try {
                    editDefinition.updateTicketData(fieldsData, fieldValues);
                    if (size != fieldsData.getIncludedFields().size()) continue;
                    throw new IllegalArgumentException(QuickTicketServerPlugin.CLIENT_MSG.getMsg("configuration.quickticket.edit.save.error.fieldmustbeset", new Object[0]));
                }
                catch (Throwable t) {
                    throw new ClientMessageException(definition.getDisplayName() + ": " + t.getMessage());
                }
            }
            LinkedList<LargeContent> attachmentsData = QuickTicketHandlerUtils.extractAttachmentData(req);
            ExtensionArguments qtAttachmentExtArg = ExtensionArguments.create();
            if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
                ArrayList<SavedAttachmentData> existingAttachments;
                if (!payload.isDuplicate()) {
                    QuickTicketHandlerUtils.fillAttachmentNamesOfExistingAttachments(qtAttachmentExtArg, payload.getExistingAttachments());
                }
                List<LargeContent> attachmentsWithData = QuickTicketHandlerUtils.syncAttachmentDescriptionsWithAttachmentData(payload.getFieldAttachments(), attachmentsData);
                if (payload.isDuplicate() && (existingAttachments = payload.getExistingAttachments()) != null && !existingAttachments.isEmpty()) {
                    List<LargeContent> additionalAttachmentsWithData = QuickTicketHandlerUtils.convertToLargeContent(payload.getExistingAttachments());
                    if (attachmentsWithData == null) {
                        attachmentsWithData = new ArrayList<LargeContent>();
                    }
                    attachmentsWithData.addAll(additionalAttachmentsWithData);
                }
                if (attachmentsWithData != null) {
                    qtAttachmentExtArg.put(AttachmentsServerPlugin.EXTARG_ATTACHMENTS, (Object)new AddAttachmentsExtensionData(attachmentsWithData));
                }
            }
            ArrayList<MutableApplicableActionData> actionsData = new ArrayList<MutableApplicableActionData>();
            ReaStepTextVO inquiryText = QuickTicketHandlerUtils.extractStepText(fieldValues);
            if (inquiryText != null || !qtAttachmentExtArg.getIncludedExtArgs().isEmpty()) {
                ActionVO editReaStepTextAction = (ActionVO)ActionManager.getInstance().get(-22);
                actionsData.add(new MutableApplicableActionData(editReaStepTextAction.getUniqueID(), new MutableReaStepData(), inquiryText, qtAttachmentExtArg));
                editStepActionForInquiryTextAdded = true;
            }
            if (actionValues != null) {
                actionValues.forEach(av -> {
                    HashMap<String, String> values = av.getActionValues();
                    ActionDescription actionDescription = av.getActionDescription();
                    try {
                        EditDuration duration;
                        String actionUid = actionDescription.getUid();
                        ActionVO actionByUniqueID = TicketManager.getTicketActionChecker().getActionByUniqueID(actionUid, -1);
                        if (actionByUniqueID.isDeleted()) {
                            throw new IllegalArgumentException(QuickTicketServerPlugin.CLIENT_MSG.getMsg("configuration.quickticket.edit.save.error.deletedaction", new Object[]{actionByUniqueID.getDisplayValue()}));
                        }
                        MutableReaStepText stepText = MutableReaStepText.of((ReaStepTextVO)QuickTicketHandlerUtils.extractStepText(values));
                        MutableReaStepData reaStepData = new MutableReaStepData();
                        ExtensionArguments extensionArguments = ExtensionArguments.create();
                        ActionVO actionVO = TicketManager.getTicketActionChecker().getActionByUniqueID(actionDescription.getUid(), -1);
                        ApplyActionRendererProvider.getInstance().prepareReastepActionData(reaStepData, stepText, extensionArguments, actionVO, values, req, null, null, false);
                        SendMailFromQuickTicketExtensionData.EmailEntry svSender = null;
                        List<SendMailFromQuickTicketExtensionData.EmailEntry> svreceiversTo = Collections.emptyList();
                        List<SendMailFromQuickTicketExtensionData.EmailEntry> svreceiversCC = Collections.emptyList();
                        List<SendMailFromQuickTicketExtensionData.EmailEntry> svreceiversBCC = Collections.emptyList();
                        String recipients = values.get(TicketFieldRendererId.recipients.name());
                        if (!StringFunctions.isEmpty((String)recipients)) {
                            RecipientsCombined recipientsCombined = (RecipientsCombined)new Json().fromJson(recipients, RecipientsCombined.class);
                            Sender sender = recipientsCombined.getSender();
                            ArrayList receiversTo = recipientsCombined.getRecipients();
                            ArrayList receiversCC = recipientsCombined.getCC();
                            ArrayList receiversBCC = recipientsCombined.getBCC();
                            if (sender != null) {
                                SendMailFromQuickTicketExtensionData.EmailEntryType entryType = SendMailFromQuickTicketExtensionData.EmailEntryType.CUSTOM;
                                if (sender.getIconType() == Sender.IconType.ownerid) {
                                    entryType = SendMailFromQuickTicketExtensionData.EmailEntryType.USER;
                                }
                                if (sender.getIconType() == Sender.IconType.resourceid) {
                                    entryType = SendMailFromQuickTicketExtensionData.EmailEntryType.RESOURCE;
                                }
                                if (sender.getIconType() == Sender.IconType.statusid) {
                                    entryType = SendMailFromQuickTicketExtensionData.EmailEntryType.MAILBOX;
                                }
                                svSender = new SendMailFromQuickTicketExtensionData.EmailEntry(sender.getIconValue(), sender.getDisplayName(), sender.getEmail(), entryType);
                            }
                            if (receiversTo != null) {
                                svreceiversTo = receiversTo.stream().map(to -> new SendMailFromQuickTicketExtensionData.EmailEntry(to.getId() == null ? null : to.getId().toString(), to.getDisplayName(), to.getEmail(), to.getId() == null ? SendMailFromQuickTicketExtensionData.EmailEntryType.CUSTOM : SendMailFromQuickTicketExtensionData.EmailEntryType.USER)).collect(Collectors.toList());
                            }
                            if (receiversCC != null) {
                                svreceiversCC = receiversCC.stream().map(cc -> new SendMailFromQuickTicketExtensionData.EmailEntry(cc.getId() == null ? null : cc.getId().toString(), cc.getDisplayName(), cc.getEmail(), cc.getId() == null ? SendMailFromQuickTicketExtensionData.EmailEntryType.CUSTOM : SendMailFromQuickTicketExtensionData.EmailEntryType.USER)).collect(Collectors.toList());
                            }
                            if (receiversBCC != null) {
                                svreceiversBCC = receiversBCC.stream().map(bcc -> new SendMailFromQuickTicketExtensionData.EmailEntry(bcc.getId() == null ? null : bcc.getId().toString(), bcc.getDisplayName(), bcc.getEmail(), bcc.getId() == null ? SendMailFromQuickTicketExtensionData.EmailEntryType.CUSTOM : SendMailFromQuickTicketExtensionData.EmailEntryType.USER)).collect(Collectors.toList());
                            }
                        }
                        SendMailFromQuickTicketExtensionData extData = new SendMailFromQuickTicketExtensionData(svSender, svreceiversTo, svreceiversCC, svreceiversBCC);
                        extensionArguments.put(QuickTicketServerPlugin.EXTARG_SEND_MAIL_FROM_QT_DATA, (Object)extData);
                        if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
                            QuickTicketHandlerUtils.fillAttachmentNamesOfExistingAttachments(extensionArguments, av.getExistingAttachments());
                            List<LargeContent> attachmentsWithDataForStep = QuickTicketHandlerUtils.syncAttachmentDescriptionsWithAttachmentData(av.getAttachments(), attachmentsData);
                            if (attachmentsWithDataForStep != null) {
                                extensionArguments.put(AttachmentsServerPlugin.EXTARG_ATTACHMENTS, (Object)new AddAttachmentsExtensionData(attachmentsWithDataForStep));
                            }
                        }
                        if ((duration = av.getEditDuration()) != null) {
                            Integer durationValue = null;
                            String value = duration.getValue();
                            if (!StringFunctions.isEmpty((String)value)) {
                                try {
                                    durationValue = Integer.valueOf(value);
                                }
                                catch (NumberFormatException nfe) {
                                    throw new ClientMessageException(Tickets.MSG.getMsg("error.invalidDuration", new Object[0]));
                                }
                            }
                            if (durationValue != null) {
                                ProcessingTime processingTime = QuickTicketProcessingTime.createRelativeProcessingTime(durationValue);
                                reaStepData.put((ReaStepField)ReaStepVO.FIELD_PROCESSING_TIME, (Object)processingTime);
                            }
                        }
                        actionsData.add(new MutableApplicableActionData(actionDescription.getUid(), reaStepData, stepText.toVO(), extensionArguments));
                    }
                    catch (Throwable t) {
                        HDLogger.error((Object)t);
                        throw new ClientMessageException(QuickTicketServerPlugin.CLIENT_MSG.getMsg("quickticket.error.withaction", new Object[]{actionDescription.getDisplayName(), t.getMessage()}));
                    }
                });
            }
            if (qtId == null) {
                qtId = quickTicketManager.createQuickTicket(quickTicketName, fieldsData, ExtensionArguments.create(), actionsData);
            } else {
                QuickTicketVO updatedQuickTicket = QuickTicketVO.create(qtId, quickTicketName, fieldsData, ExtensionArguments.create(), actionsData);
                quickTicketManager.updateQuickTicket(updatedQuickTicket);
            }
            quickTicketManager.setFolder(qtId, quickTicketFolderId);
            return null;
        }
        catch (QuickTicketException qtae) {
            Integer actionIndex;
            String message = qtae.getMessage();
            Throwable cause = qtae.getCause();
            if (cause instanceof IllegalArgumentException) {
                HDLogger.debug((Object)qtae);
            } else {
                HDLogger.error((Object)qtae);
            }
            if (cause != null && !StringFunctions.isEmpty((String)cause.getMessage())) {
                message = cause.getMessage();
            }
            if ((actionIndex = qtae.getActionIndex()) != null && editStepActionForInquiryTextAdded) {
                actionIndex = actionIndex - 1;
            }
            message = QuickTicketHandlerUtils.generateErrorMsgForAction(qtae.getActionDisplayName(), actionIndex, message);
            throw new ClientMessageException(message);
        }
    }
}

