/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.client.config.handler;

import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketFolderStructureVO;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketManager;
import com.inet.helpdesk.plugins.quickticket.client.config.data.DeleteQuickTicketOrFolderRequest;
import com.inet.helpdesk.plugins.quickticket.taskplanner.TasksWithQTs;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.plugin.Executable;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.taskplanner.server.api.TaskExecution;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashSet;
import javax.annotation.Nonnull;

public class DeleteQuickTicketOrFolder
extends ServiceMethod<DeleteQuickTicketOrFolderRequest, Void> {
    public String getMethodName() {
        return "quickticket.deletequickticketorfolder";
    }

    public short getMethodType() {
        return 1;
    }

    public Void invoke(HttpServletRequest req, HttpServletResponse resp, final DeleteQuickTicketOrFolderRequest payload) throws IOException {
        QuickTicketManager quickTicketManager = (QuickTicketManager)ServerPluginManager.getInstance().getSingleInstance(QuickTicketManager.class);
        if (payload.isFolder()) {
            QuickTicketFolderStructureVO.NodeVO folder = quickTicketManager.getFolderStructure().find(payload.getId());
            if (folder != null) {
                boolean isEmpty = this.isEmptyFolder(folder, quickTicketManager);
                if (!isEmpty) {
                    throw new ClientMessageException(QuickTicketServerPlugin.CLIENT_MSG.getMsg("configuration.quicktickets.notempty", new Object[0]));
                }
                quickTicketManager.deleteFolder(payload.getId());
            }
        } else {
            quickTicketManager.deleteQuickTicket(payload.getId());
            if (payload.isDeleteTasks()) {
                ServerPluginManager.getInstance().runIfPluginLoaded("taskplanner.helpdesk", () -> new Executable(){

                    public void execute() {
                        TasksWithQTs tasksWithQTs = TasksWithQTs.getInstance();
                        HashSet<GUID> tasksToBeDeleted = new HashSet<GUID>();
                        tasksToBeDeleted.addAll(tasksWithQTs.getTasksIDsWithQuickTicketAction(payload.getId()));
                        tasksToBeDeleted.addAll(tasksWithQTs.getTasksIDsWithQuickTicketJob(payload.getId()));
                        tasksToBeDeleted.removeIf(tId -> {
                            TaskExecution taskExecution = TaskPlanner.getInstance().getTaskExecution(tId);
                            if (taskExecution == null) {
                                return true;
                            }
                            GUID ownerId = taskExecution.getOwnerId();
                            if (ownerId == null) {
                                return true;
                            }
                            return !ownerId.equals((Object)UserManager.getInstance().getCurrentUserAccountID()) && !tasksWithQTs.isTaskPlannerAdminAvailable();
                        });
                        for (GUID taskId : tasksToBeDeleted) {
                            TaskPlanner.getInstance().removeTask(taskId);
                        }
                    }
                });
            }
        }
        return null;
    }

    private boolean isEmptyFolder(@Nonnull QuickTicketFolderStructureVO.NodeVO folderNode, QuickTicketManager quickTicketManager) {
        if (!quickTicketManager.listQuickTicketsInFolder(folderNode.getFolder().getID()).isEmpty()) {
            return false;
        }
        for (QuickTicketFolderStructureVO.NodeVO child : folderNode.getChildren()) {
            if (this.isEmptyFolder(child, quickTicketManager)) continue;
            return false;
        }
        return true;
    }
}

