/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.api;

import com.inet.annotations.InternalApi;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.LocalizedKeyWithIcon;
import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.quickticket.AddQuickTicketAttachmentsActionExtensionFactory;
import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableActionDataVO;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketFolderStructureVO;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketFolderVO;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketManager;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketVO;
import com.inet.helpdesk.plugins.quickticket.client.shared.data.QuickTicketSelectEntry;
import com.inet.helpdesk.plugins.quickticket.client.shared.data.QuickTicketSelectEntryDetail;
import com.inet.helpdesk.plugins.quickticket.taskplanner.TasksWithQTs;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.Executable;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.usersorgroupsselection.UsersOrGroupsSelection;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@InternalApi
public class LoadQuickTicketUtil {
    public static List<QuickTicketSelectEntry> getQuickTicketEntries(String searchTerm, boolean includeDetails) {
        QuickTicketSelectEntry entry;
        UserManager um = UserManager.getInstance();
        UserGroupManager uag = UserGroupManager.getInstance();
        UserAccount currentUserAccount = um.getCurrentUserAccount();
        if (currentUserAccount == null) {
            return new ArrayList<QuickTicketSelectEntry>();
        }
        GUID userId = currentUserAccount.getID();
        Set groupsForUser = uag.getGroupsForUser(userId);
        boolean isAdminGroup = groupsForUser.contains(uag.getGroup(UsersAndGroups.GROUPID_ADMIN));
        boolean userIsAdmin = currentUserAccount.getAccountType().equals((Object)UserAccountType.Administrator);
        boolean userHasPermission = SystemPermissionChecker.hasAnyPermission((GUID)currentUserAccount.getID(), (Permission[])new Permission[]{HdPermissions.TEMPLATE_DEFINITION, Permission.CONFIGURATION});
        boolean hasPermission = includeDetails ? isAdminGroup || userIsAdmin || userHasPermission : isAdminGroup || userIsAdmin;
        ArrayList<QuickTicketSelectEntry> entries = new ArrayList<QuickTicketSelectEntry>();
        QuickTicketManager quickTicketManager = (QuickTicketManager)ServerPluginManager.getInstance().getSingleInstance(QuickTicketManager.class);
        QuickTicketFolderStructureVO folderStructure = quickTicketManager.getFolderStructure();
        if (folderStructure != null) {
            List<QuickTicketFolderStructureVO.NodeVO> children = folderStructure.getNodes();
            for (QuickTicketFolderStructureVO.NodeVO node : children) {
                boolean folderMatch = searchTerm != null && node.getFolder().getFolderName().toLowerCase().indexOf(searchTerm.toLowerCase()) >= 0;
                String filter = folderMatch ? "" : searchTerm;
                entry = new QuickTicketSelectEntry(node.getFolder().getID().toString(), node.getFolder().getFolderName(), null, folderMatch ? 20 : -1);
                if (!LoadQuickTicketUtil.userHasPermissionToEntry(quickTicketManager, entry, userId, hasPermission)) continue;
                int childCount = LoadQuickTicketUtil.listQuickTickets(quickTicketManager, entry.getChildren(), node, filter, includeDetails, userId, hasPermission, uag, um);
                if (includeDetails) {
                    entry.addDetail(new QuickTicketSelectEntryDetail(QuickTicketServerPlugin.CLIENT_MSG.getMsg("configuration.quicktickets.detail.quickticketcount", new Object[]{childCount}), childCount));
                    if (hasPermission && node.getFolder().getFolderPermission() != null) {
                        ArrayList<LocalizedKey> userMembers = new ArrayList<LocalizedKey>();
                        ArrayList<LocalizedKey> groupMembers = new ArrayList<LocalizedKey>();
                        try {
                            node.getFolder().getFolderPermission().stream().forEach(a -> {
                                if (a.getType().equals((Object)Type.user)) {
                                    UserAccount userAccount = um.getUserAccount(a.getId());
                                    if (userAccount != null) {
                                        userMembers.add(new LocalizedKey(a.getId().toString(), userAccount.getDisplayName()));
                                    }
                                } else {
                                    UserGroupInfo group = uag.getGroup(a.getId());
                                    if (group != null) {
                                        groupMembers.add(new LocalizedKey(a.getId().toString(), group.getDisplayName()));
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            throw new ClientMessageException(e.getMessage());
                        }
                        entry.setUserMembers(userMembers);
                        entry.setGroupMembers(groupMembers);
                    }
                }
                if (!StringFunctions.isEmpty((String)filter) && childCount <= 0 && !folderMatch) continue;
                entries.add(entry);
            }
        }
        List<GUID> unassignedQuickTicketIDs = quickTicketManager.listQuickTicketsUnassignedToFolders();
        for (GUID qtID : unassignedQuickTicketIDs) {
            int sortPrio;
            QuickTicketVO quickTicket = quickTicketManager.getQuickTicket(qtID);
            if (quickTicket == null || (sortPrio = LoadQuickTicketUtil.matchFilter(searchTerm, quickTicket)) <= 0) continue;
            entry = new QuickTicketSelectEntry(qtID.toString(), quickTicket.getQuickTicketName(), "root", sortPrio);
            if (includeDetails) {
                LoadQuickTicketUtil.addQuickTicketDetails(entry, quickTicket);
            }
            entries.add(entry);
        }
        return entries;
    }

    public static boolean checkFolderPermissionsForQuickTicket(GUID qtID) {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            return false;
        }
        GUID userId = currentUserAccount.getID();
        UserGroupManager ugm = UserGroupManager.getInstance();
        Set groupsForUser = ugm.getGroupsForUser(userId);
        boolean isAdminGroup = groupsForUser.contains(ugm.getGroup(UsersAndGroups.GROUPID_ADMIN));
        boolean userIsAdmin = currentUserAccount.getAccountType().equals((Object)UserAccountType.Administrator);
        if (isAdminGroup || userIsAdmin) {
            return true;
        }
        if (!SystemPermissionChecker.hasAnyPermission((UserAccount)currentUserAccount, (Permission[])new Permission[]{Permission.CONFIGURATION, HdPermissions.TEMPLATE_DEFINITION}) && !HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount)) {
            return false;
        }
        QuickTicketManager quickTicketManager = (QuickTicketManager)ServerPluginManager.getInstance().getSingleInstance(QuickTicketManager.class);
        QuickTicketFolderStructureVO folderStructure = quickTicketManager.getFolderStructure();
        if (folderStructure != null && LoadQuickTicketUtil.checkFolderAndChildrenForQuickTicket(folderStructure.getNodes(), qtID, userId, quickTicketManager)) {
            return true;
        }
        List<GUID> unassignedQuickTicketIDs = quickTicketManager.listQuickTicketsUnassignedToFolders();
        return unassignedQuickTicketIDs.contains(qtID);
    }

    private static boolean checkFolderAndChildrenForQuickTicket(List<QuickTicketFolderStructureVO.NodeVO> nodes, GUID qtID, GUID userId, QuickTicketManager quickTicketManager) {
        for (QuickTicketFolderStructureVO.NodeVO node : nodes) {
            QuickTicketSelectEntry entry = new QuickTicketSelectEntry(node.getFolder().getID().toString(), node.getFolder().getFolderName(), null, -1);
            if (!LoadQuickTicketUtil.userHasPermissionToEntry(quickTicketManager, entry, userId, false)) continue;
            List<GUID> quickTicketsInFolder = quickTicketManager.listQuickTicketsInFolder(node.getFolder().getID());
            if (quickTicketsInFolder.contains(qtID)) {
                return true;
            }
            if (!LoadQuickTicketUtil.checkFolderAndChildrenForQuickTicket(node.getChildren(), qtID, userId, quickTicketManager)) continue;
            return true;
        }
        return false;
    }

    private static List<GUID> collectQuickTicketIds(List<GUID> listQuickTicketsInFolder, List<QuickTicketFolderStructureVO.NodeVO> folders, QuickTicketManager quickTicketManager) {
        for (QuickTicketFolderStructureVO.NodeVO nodeVO : folders) {
            listQuickTicketsInFolder.addAll(quickTicketManager.listQuickTicketsInFolder(nodeVO.getFolder().getID()));
            LoadQuickTicketUtil.collectQuickTicketIds(listQuickTicketsInFolder, nodeVO.getChildren(), quickTicketManager);
        }
        return listQuickTicketsInFolder;
    }

    private static int listQuickTickets(QuickTicketManager quickTicketManager, List<QuickTicketSelectEntry> entries, QuickTicketFolderStructureVO.NodeVO node, String filter, boolean includeDetails, GUID userId, boolean userHasPermission, UserGroupManager uag, UserManager um) {
        int childCount = 0;
        List<QuickTicketFolderStructureVO.NodeVO> children = node.getChildren();
        boolean subFolderMatch = filter != null && node.getFolder().getFolderName().toLowerCase().indexOf(filter.toLowerCase()) >= 0;
        String subFilter = filter;
        if (subFolderMatch) {
            subFilter = "";
        }
        if (children != null) {
            for (QuickTicketFolderStructureVO.NodeVO child : children) {
                QuickTicketSelectEntry entry = new QuickTicketSelectEntry(child.getFolder().getID().toString(), child.getFolder().getFolderName(), null, -1);
                if (!LoadQuickTicketUtil.userHasPermissionToEntry(quickTicketManager, entry, userId, userHasPermission)) continue;
                int subChildCount = LoadQuickTicketUtil.listQuickTickets(quickTicketManager, entry.getChildren(), child, subFilter, includeDetails, userId, userHasPermission, uag, um);
                if (includeDetails) {
                    entry.addDetail(new QuickTicketSelectEntryDetail(QuickTicketServerPlugin.CLIENT_MSG.getMsg("configuration.quicktickets.detail.quickticketcount", new Object[]{subChildCount}), subChildCount));
                    if (userHasPermission && child.getFolder().getFolderPermission() != null) {
                        ArrayList<LocalizedKey> userMembers = new ArrayList<LocalizedKey>();
                        ArrayList<LocalizedKey> groupMembers = new ArrayList<LocalizedKey>();
                        try {
                            child.getFolder().getFolderPermission().stream().forEach(a -> {
                                if (a.getType().equals((Object)Type.user)) {
                                    userMembers.add(new LocalizedKey(a.getId().toString(), um.getUserAccount(a.getId()).getDisplayName()));
                                } else {
                                    groupMembers.add(new LocalizedKey(a.getId().toString(), uag.getGroup(a.getId()).getDisplayName()));
                                }
                            });
                        }
                        catch (Exception e) {
                            throw new ClientMessageException(e.getMessage());
                        }
                        entry.setUserMembers(userMembers);
                        entry.setGroupMembers(groupMembers);
                    }
                }
                if (!StringFunctions.isEmpty((String)subFilter) && subChildCount <= 0 && !subFolderMatch) continue;
                entries.add(entry);
                childCount += subChildCount;
            }
        }
        GUID folderId = node.getFolder().getID();
        List<GUID> quickTicketsInFolder = quickTicketManager.listQuickTicketsInFolder(folderId);
        QuickTicketFolderVO folder = quickTicketManager.getFolder(folderId);
        if (userHasPermission || LoadQuickTicketUtil.userHasPermissionToFolder(folder, userId)) {
            for (GUID qtID : quickTicketsInFolder) {
                int sortPrio;
                QuickTicketVO quickTicket = quickTicketManager.getQuickTicket(qtID);
                if (quickTicket == null || (sortPrio = LoadQuickTicketUtil.matchFilter(filter, quickTicket)) <= 0) continue;
                QuickTicketSelectEntry entry = new QuickTicketSelectEntry(qtID.toString(), quickTicket.getQuickTicketName(), folderId.toString(), sortPrio);
                if (includeDetails) {
                    LoadQuickTicketUtil.addQuickTicketDetails(entry, quickTicket);
                }
                entries.add(entry);
                ++childCount;
            }
        }
        return childCount;
    }

    private static boolean userHasPermissionToFolder(QuickTicketFolderVO folder, GUID userId) {
        ArrayList<GUID> usersInList = new ArrayList<GUID>();
        ArrayList<GUID> GroupsInList = new ArrayList<GUID>();
        Set groupsForUser = UserGroupManager.getInstance().getGroupsForUser(userId);
        List<UsersOrGroupsSelection.SelectedMember> folderPermission = folder.getFolderPermission();
        if (folderPermission == null) {
            return true;
        }
        for (UsersOrGroupsSelection.SelectedMember qtFolderPermission : folderPermission) {
            if (qtFolderPermission.getType() == Type.user) {
                usersInList.add(qtFolderPermission.getId());
                continue;
            }
            GroupsInList.add(qtFolderPermission.getId());
        }
        if (usersInList.contains(userId)) {
            return true;
        }
        for (UserGroupInfo userGroups : groupsForUser) {
            if (!GroupsInList.contains(userGroups.getID())) continue;
            return true;
        }
        return false;
    }

    private static boolean userHasPermissionToEntry(QuickTicketManager quickTicketManager, QuickTicketSelectEntry entry, GUID userId, boolean userHasPermission) {
        if (!entry.isFolder() || userHasPermission) {
            return true;
        }
        QuickTicketFolderVO folder = quickTicketManager.getFolder(GUID.valueOf((String)entry.getKey()));
        ArrayList<GUID> usersInList = new ArrayList<GUID>();
        ArrayList<GUID> GroupsInList = new ArrayList<GUID>();
        if (folder == null || userId == null) {
            return false;
        }
        Set groupsForUser = UserGroupManager.getInstance().getGroupsForUser(userId);
        List<UsersOrGroupsSelection.SelectedMember> folderPermission = folder.getFolderPermission();
        if (folderPermission == null) {
            return true;
        }
        for (UsersOrGroupsSelection.SelectedMember qtFolderPermission : folderPermission) {
            if (qtFolderPermission.getType() == Type.user) {
                usersInList.add(qtFolderPermission.getId());
                continue;
            }
            GroupsInList.add(qtFolderPermission.getId());
        }
        if (usersInList.contains(userId)) {
            return true;
        }
        for (UserGroupInfo userGroups : groupsForUser) {
            if (!GroupsInList.contains(userGroups.getID())) continue;
            return true;
        }
        return false;
    }

    private static int matchFilter(String filter, QuickTicketVO quickTicket) {
        List<ApplicableActionDataVO> actionsData;
        if (filter == null) {
            return 1;
        }
        String matchTerm = filter.toLowerCase();
        if (quickTicket.getQuickTicketName().toLowerCase().indexOf(matchTerm) > -1) {
            return 30;
        }
        MutableTicketData ticketData = quickTicket.getTicketData();
        if (ticketData != null) {
            for (TicketField field : ticketData.getIncludedFields()) {
                String name = field.getLabel(ClientLocale.getThreadLocale());
                if (name != null && name.toLowerCase().indexOf(matchTerm) > -1) {
                    return 20;
                }
                Object value = ticketData.get(field);
                if (value == null || value.toString().toLowerCase().indexOf(matchTerm) <= -1) continue;
                return 10;
            }
        }
        if ((actionsData = quickTicket.getActionsData()) != null) {
            for (ApplicableActionDataVO action : actionsData) {
                MutableReaStepData reaStepData;
                ReaStepTextVO reaStepText = action.getReaStepText();
                if (reaStepText != null) {
                    String text;
                    String string = text = reaStepText.hasHtmlContent() ? TicketTextFunctions.convertToPlainText((String)reaStepText.getText()) : reaStepText.getText();
                    if (text.indexOf(matchTerm) > -1) {
                        return 20;
                    }
                }
                if ((reaStepData = action.getReaStepData()) == null) continue;
                for (ReaStepField field : reaStepData.getIncludedFields()) {
                    Object value = reaStepData.get(field);
                    if (value == null || value.toString().toLowerCase().indexOf(matchTerm) <= -1) continue;
                    return 10;
                }
            }
        }
        return 0;
    }

    private static void addQuickTicketDetails(final QuickTicketSelectEntry entry, final QuickTicketVO quickTicket) {
        List<ApplicableActionDataVO> actionsData;
        ArrayList<LocalizedKeyWithIcon> ticketFields = new ArrayList<LocalizedKeyWithIcon>();
        ArrayList<LocalizedKeyWithIcon> actions = new ArrayList<LocalizedKeyWithIcon>();
        MutableTicketData ticketData = quickTicket.getTicketData();
        if (ticketData != null) {
            List fieldDefs = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
            Set includedFields = ticketData.getIncludedFields().stream().map(tf -> tf.getKey()).collect(Collectors.toSet());
            for (TicketFieldDefinition definition : fieldDefs) {
                if (!includedFields.contains(definition.getKey())) continue;
                ticketFields.add(new LocalizedKeyWithIcon("", definition.getDisplayName(), ""));
            }
        }
        if ((actionsData = quickTicket.getActionsData()) != null) {
            ActionVO editReaStepTextAction = (ActionVO)ActionManager.getInstance().get(-22);
            for (ApplicableActionDataVO actionVO : actionsData) {
                if (actionVO.getUniqueActionID().equals(editReaStepTextAction.getUniqueID())) {
                    ReaStepTextVO reaStepText;
                    ExtensionArguments extensionArguments = actionVO.getExtensionArguments();
                    if (extensionArguments == null) continue;
                    if (extensionArguments.containsExtArg(AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES)) {
                        ticketFields.add(new LocalizedKeyWithIcon("", QuickTicketServerPlugin.CLIENT_MSG.getMsg("configuration.quickticket.edit.field.attachments", new Object[0]), ""));
                    }
                    if ((reaStepText = actionVO.getReaStepText()) == null) continue;
                    ticketFields.add(new LocalizedKeyWithIcon("", QuickTicketServerPlugin.CLIENT_MSG.getMsg("configuration.quickticket.edit.field.htmleditor", new Object[0]), ""));
                    continue;
                }
                ActionVO action = TicketManager.getTicketActionChecker().getActionByUniqueID(actionVO.getUniqueActionID(), -1);
                if (action == null) continue;
                actions.add(new LocalizedKeyWithIcon(actionVO.getUniqueActionID(), action.getDisplayValue(), "data/0/" + action.getStatusID()));
            }
        }
        if (!ticketFields.isEmpty()) {
            ticketFields.sort(new Comparator<LocalizedKeyWithIcon>(){

                @Override
                public int compare(LocalizedKeyWithIcon o1, LocalizedKeyWithIcon o2) {
                    return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
                }
            });
            entry.addDetail(new QuickTicketSelectEntryDetail(QuickTicketServerPlugin.CLIENT_MSG.getMsg("configuration.quicktickets.detail.quickticketfields", new Object[]{ticketFields.size()}), ticketFields, ", "));
        }
        if (!actions.isEmpty()) {
            entry.addDetail(new QuickTicketSelectEntryDetail(QuickTicketServerPlugin.CLIENT_MSG.getMsg("configuration.quicktickets.detail.quickticketactions", new Object[]{actions.size()}), actions, " \u2192 "));
        }
        ServerPluginManager.getInstance().runIfPluginLoaded("taskplanner.helpdesk", () -> new Executable(){

            public void execute() {
                TasksWithQTs tasksWithQTs = TasksWithQTs.getInstance();
                if (tasksWithQTs.isAvailable()) {
                    GUID qtId = quickTicket.getID();
                    entry.setReferencedInTasks(!tasksWithQTs.getTasksIDsWithQuickTicketJob(qtId).isEmpty() || !tasksWithQTs.getTasksIDsWithQuickTicketAction(qtId).isEmpty());
                }
            }
        });
    }
}

