/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.eventlog;

import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.logging.EventLog;
import java.util.Locale;
import java.util.Properties;
import javax.annotation.Nonnull;

public enum QuickTicketEventsForTicketEventLog {
    QuickTicketApplied;

    private static final EventLog<QuickTicketEventsForTicketEventLog> TICKET_EVENT_LOG;

    public void log(@Nonnull GUID qtID, @Nonnull String qtName, int ticketId) {
        Properties props = new Properties();
        props.setProperty("id", qtID.toString());
        props.setProperty("name", qtName);
        String msgKey = "eventlog." + this.name();
        props.setProperty("ticketid", String.valueOf(ticketId));
        String msg = QuickTicketServerPlugin.MSG.getMsg(Locale.getDefault(), msgKey, new Object[]{qtName, ticketId});
        String data = new Json().toJson((Object)props);
        TICKET_EVENT_LOG.log((Enum)this, msg, data, new Object[]{ticketId});
    }

    static {
        TICKET_EVENT_LOG = EventLog.register((String)"helpdeskticket");
    }
}

