/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket;

import com.inet.error.ErrorCode;
import com.inet.error.PersistenceException;
import com.inet.field.Field;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.utils.DatabaseTransactionUtils;
import com.inet.helpdesk.plugins.quickticket.ApplicableActionDataPersistenceUnit;
import com.inet.helpdesk.plugins.quickticket.QuickTicketPersistence;
import com.inet.helpdesk.plugins.quickticket.QuickTicketPersistenceUnit;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableActionDataVO;
import com.inet.helpdesk.plugins.quickticket.api.MutableApplicableActionData;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketFolderStructureVO;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketFolderVO;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketVO;
import com.inet.id.GUID;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.remote.gui.angular.usersorgroupsselection.UsersOrGroupsSelection;
import com.inet.usersandgroups.api.FieldValidationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class QuickTicketPersistenceImpl
implements QuickTicketPersistence {
    private ConnectionFactory conFactory;
    private Map<String, ReaStepField> reaStepFieldsMap;
    private Map<String, ExtensionArguments.ExtArg> extArgsMap;

    public void init(@Nonnull ConnectionFactory connectionFactory, @Nonnull List<ReaStepField> reaStepFields, @Nonnull List<ExtensionArguments.ExtArg> extensionArguments) {
        this.conFactory = connectionFactory;
        this.reaStepFieldsMap = Collections.unmodifiableMap(reaStepFields.stream().collect(Collectors.toMap(Field::getKey, f -> f)));
        this.extArgsMap = Collections.unmodifiableMap(extensionArguments.stream().collect(Collectors.toMap(ExtensionArguments.ExtArg::getKey, ea -> ea)));
    }

    @Override
    public QuickTicketVO load(GUID quickTicketID) {
        List<QuickTicketVO> result = this.load(" WHERE QuickTicketUUID = '" + quickTicketID.toString() + "'");
        return result.isEmpty() ? null : result.get(0);
    }

    @Override
    public List<GUID> listAll() {
        return this.list("");
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL does not add user input arguments")
    private List<GUID> list(String wherePartOfSqlStatement) {
        ArrayList<GUID> result = new ArrayList<GUID>();
        String sql = "SELECT QuickTicketUUID FROM tblQuickTickets" + wherePartOfSqlStatement;
        try (Connection con = this.conFactory.getConnection();
             Statement stm = con.createStatement();
             ResultSet rs = stm.executeQuery(sql);){
            while (rs.next()) {
                GUID quickTicketID;
                String idValue = rs.getString(1);
                try {
                    quickTicketID = GUID.valueOf((String)idValue);
                }
                catch (IllegalArgumentException ex) {
                    HDLogger.error((Object)("Could not parse ID of quick-ticket stored in database: " + idValue + ". This ID will be ignored."));
                    HDLogger.error((Object)ex);
                    continue;
                }
                result.add(quickTicketID);
            }
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
        return result;
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="only GUID can be set as argument")
    private List<QuickTicketVO> load(String wherePartOfSqlStatement) {
        ArrayList<QuickTicketVO> result = new ArrayList<QuickTicketVO>();
        String sql = "SELECT * FROM tblQuickTickets" + wherePartOfSqlStatement;
        try (Connection con = this.conFactory.getConnection();
             Statement stm = con.createStatement();
             ResultSet rs = stm.executeQuery(sql);){
            while (rs.next()) {
                QuickTicketVO quickTicket;
                QuickTicketPersistenceUnit settings;
                GUID quickTicketID;
                String idValue = rs.getString("QuickTicketUUID");
                try {
                    quickTicketID = GUID.valueOf((String)idValue);
                }
                catch (IllegalArgumentException ex) {
                    HDLogger.error((Object)("Could not parse ID of quick-ticket stored in database: " + idValue + ". This quick-ticket will be ignored and treated as non-existing."));
                    HDLogger.error((Object)ex);
                    continue;
                }
                String name = rs.getString("Name");
                try {
                    InputStream inputStream = rs.getBinaryStream("Data");
                    settings = (QuickTicketPersistenceUnit)new Json().fromJson(inputStream, QuickTicketPersistenceUnit.class);
                }
                catch (JsonException | IOException ex) {
                    HDLogger.error((Object)("Could not parse data stored in database for quick-ticket with ID: " + quickTicketID.toString() + ". This quick-ticket will be ignored and treated as non-existing."));
                    HDLogger.error((Object)ex);
                    continue;
                }
                try {
                    quickTicket = this.convertToQuickTicketVO(quickTicketID, name, settings);
                }
                catch (Exception ex) {
                    HDLogger.error((Object)("Could not create valid instance of QuickTicketVO from data stored in database for quick-ticket with ID: " + quickTicketID.toString() + ". This quick-ticket will be ignored and treated as non-existing."));
                    HDLogger.error((Object)ex);
                    continue;
                }
                result.add(quickTicket);
            }
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
        return result;
    }

    private QuickTicketVO convertToQuickTicketVO(GUID id, String name, QuickTicketPersistenceUnit settings) {
        MutableTicketData ticketData = new MutableTicketData();
        HashMap<String, String> persistedTicketFields = settings.getFields();
        List ticketFields = DynamicExtensionManager.getInstance().get(TicketField.class);
        for (String fieldKey : persistedTicketFields.keySet()) {
            String msg;
            TicketField field = ticketFields.stream().filter(f -> f.getKey().equals(fieldKey)).findFirst().orElse(null);
            if (field == null) continue;
            String jsonData = persistedTicketFields.get(fieldKey);
            try {
                Object value = jsonData == null || jsonData.equals("null") ? null : new Json().fromJson(jsonData, field.getValueType());
                ticketData.put(field, value);
            }
            catch (JsonException jex) {
                msg = String.format("[Quick-Tickets] Could not deserialize value of field \"%s\" defined for quick-ticket with ID \"%s\". This field will be ignored. Its value can be corrected by defining new value in quick-ticket.", field.getKey(), id.toString());
                HDLogger.warn((Object)msg);
                HDLogger.warn((Object)((Object)jex));
            }
            catch (FieldValidationException fve) {
                msg = String.format("[Quick-Tickets] Value of field \"%s\" defined for quick-ticket with ID \"%s\" is corrupted or invalid. This field will be ignored. Its value can be corrected by defining new value in quick-ticket.", field.getKey(), id.toString());
                HDLogger.warn((Object)msg);
                HDLogger.warn((Object)((Object)fve));
            }
        }
        ExtensionArguments applyQtActionExtArgs = ExtensionArguments.create();
        HashMap<String, String> persistedApplyQtActionExtArgs = settings.getExtArgs();
        for (String extArgKey : persistedApplyQtActionExtArgs.keySet()) {
            Object msg;
            ExtensionArguments.ExtArg extArg = this.extArgsMap.get(extArgKey);
            if (extArg == null) continue;
            String jsonData = (String)persistedApplyQtActionExtArgs.get(extArgKey);
            try {
                Object value = extArg.fromJson(jsonData);
                applyQtActionExtArgs.put(extArg, value);
            }
            catch (JsonException jex) {
                msg = String.format("[Quick-Tickets] Could not deserialize value of ext-arg \"%s\" defined for quick-ticket with ID \"%s\". This ext-arg will be ignored. Its data can be corrected by defining new data in quick-ticket.", extArg.getKey(), id.toString());
                HDLogger.warn((Object)msg);
                HDLogger.warn((Object)((Object)jex));
            }
            catch (FieldValidationException fve) {
                msg = String.format("[Quick-Tickets] Value of ext-arg \"%s\" defined for quick-ticket with ID \"%s\" is corrupted or invalid. This ext-arg will be ignored. Its data can be corrected by defining new data in quick-ticket.", extArg.getKey(), id.toString());
                HDLogger.warn((Object)msg);
                HDLogger.warn((Object)((Object)fve));
            }
        }
        ArrayList<ApplicableActionDataVO> actionsData = new ArrayList<ApplicableActionDataVO>();
        for (ApplicableActionDataPersistenceUnit actionUnit : settings.getActions()) {
            MutableReaStepData reaStepData = new MutableReaStepData();
            HashMap<String, String> persistedStepFields = actionUnit.getFields();
            for (String fieldKey : persistedStepFields.keySet()) {
                String msg;
                ReaStepField field = this.reaStepFieldsMap.get(fieldKey);
                if (field == null) continue;
                String jsonData = (String)persistedStepFields.get(fieldKey);
                try {
                    Object value = new Json().fromJson(jsonData, field.getValueType());
                    reaStepData.put(field, value);
                }
                catch (JsonException jex) {
                    msg = String.format("[Quick-Tickets] Could not deserialize value of rea-step field \"%s\" defined for one of actions from quick-ticket with ID \"%s\". This field will be ignored. Its value can be corrected by defining new value in quick-ticket.", field.getKey(), id.toString());
                    HDLogger.warn((Object)msg);
                    HDLogger.warn((Object)((Object)jex));
                }
                catch (FieldValidationException fve) {
                    msg = String.format("[Quick-Tickets] Value of rea-step field \"%s\" defined for one of actions from quick-ticket with ID \"%s\" is corrupted or invalid. This field will be ignored. Its value can be corrected by defining new value in quick-ticket.", field.getKey(), id.toString());
                    HDLogger.warn((Object)msg);
                    HDLogger.warn((Object)((Object)fve));
                }
            }
            ExtensionArguments extArgs = ExtensionArguments.create();
            HashMap<String, String> persistedExtArgs = actionUnit.getExtArgs();
            for (String extArgKey : persistedExtArgs.keySet()) {
                String msg;
                ExtensionArguments.ExtArg extArg = this.extArgsMap.get(extArgKey);
                if (extArg == null) continue;
                String jsonData = (String)persistedExtArgs.get(extArgKey);
                try {
                    Object value = extArg.fromJson(jsonData);
                    extArgs.put(extArg, value);
                }
                catch (JsonException jex) {
                    msg = String.format("[Quick-Tickets] Could not deserialize value of ext-arg \"%s\" defined for one of actions from quick-ticket with ID \"%s\". This ext-arg will be ignored. Its data can be corrected by defining new data in quick-ticket.", extArg.getKey(), id.toString());
                    HDLogger.warn((Object)msg);
                    HDLogger.warn((Object)((Object)jex));
                }
                catch (FieldValidationException fve) {
                    msg = String.format("[Quick-Tickets] Value of ext-arg \"%s\" defined for one of actions from quick-ticket with ID \"%s\" is corrupted or invalid. This ext-arg will be ignored. Its data can be corrected by defining new data in quick-ticket.", extArg.getKey(), id.toString());
                    HDLogger.warn((Object)msg);
                    HDLogger.warn((Object)((Object)fve));
                }
            }
            ReaStepTextVO stepText = actionUnit.getReaStepText();
            try {
                ApplicableActionDataVO.throwIfUndefinedStepTextIsNotAllowed(actionUnit.getUniqueID(), stepText);
            }
            catch (IllegalArgumentException ex) {
                stepText = ReaStepTextVO.empty();
                String msg = String.format("[Quick-Tickets] There is persisted data with undefined rea-step text for one of actions from quick-ticket with ID \"%s\". Since undefined rea-step text is not allowed for action with ID \"%s\", it will be treated as empty text instead. Undefined rea-step text can be corrected by defining new data in quick-ticket.", id.toString(), actionUnit.getUniqueID());
                HDLogger.warn((Object)msg);
                HDLogger.warn((Object)ex);
            }
            ApplicableActionDataVO vo = ApplicableActionDataVO.create(actionUnit.getUniqueID(), reaStepData, stepText, extArgs);
            actionsData.add(vo);
        }
        if (ticketData.isEmpty() && actionsData.isEmpty()) {
            return QuickTicketVO.createReplacementForQtWithNoData(id, name, applyQtActionExtArgs);
        }
        return QuickTicketVO.create(id, name, ticketData, applyQtActionExtArgs, actionsData);
    }

    @Override
    public void saveNew(GUID quickTicketID, String quickTicketName, MutableTicketData ticketData, ExtensionArguments extArgs, List<MutableApplicableActionData> actionsData) {
        QuickTicketPersistenceUnit persistenceUnit = this.convertToQuickTicketPersistenceUnit(ticketData, extArgs, actionsData);
        String jsonData = new Json().toJson((Object)persistenceUnit);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonData.getBytes(StandardCharsets.UTF_8));
        String sql = "INSERT INTO tblQuickTickets (QuickTicketUUID, Name, Data) VALUES (?,?,?)";
        try (Connection con = this.conFactory.getConnection();
             PreparedStatement pstm = con.prepareStatement(sql);){
            pstm.setString(1, quickTicketID.toString());
            pstm.setString(2, quickTicketName);
            pstm.setBinaryStream(3, inputStream);
            pstm.executeUpdate();
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
    }

    @Override
    public void save(GUID quickTicketID, String quickTicketName, MutableTicketData ticketData, ExtensionArguments extArgs, List<MutableApplicableActionData> actionsData) {
        QuickTicketPersistenceUnit persistenceUnit = this.convertToQuickTicketPersistenceUnit(ticketData, extArgs, actionsData);
        String jsonData = new Json().toJson((Object)persistenceUnit);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonData.getBytes(StandardCharsets.UTF_8));
        String sql = "UPDATE tblQuickTickets SET Name = ?, Data = ? WHERE QuickTicketUUID = ?";
        try (Connection con = this.conFactory.getConnection();
             PreparedStatement pstm = con.prepareStatement(sql);){
            pstm.setString(1, quickTicketName);
            pstm.setBinaryStream(2, inputStream);
            pstm.setString(3, quickTicketID.toString());
            pstm.executeUpdate();
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
    }

    private QuickTicketPersistenceUnit convertToQuickTicketPersistenceUnit(MutableTicketData ticketData, ExtensionArguments extArgs, List<MutableApplicableActionData> actionsData) {
        HashMap<String, String> jsonizedValues = new HashMap<String, String>();
        for (Object field : ticketData.getIncludedFields()) {
            Object value = ticketData.get((TicketField)field);
            String jsonData = value == null ? null : new Json().toJson(value);
            jsonizedValues.put(field.getKey(), jsonData);
        }
        HashMap<String, String> applyQtActionExtArgs = new HashMap<String, String>();
        for (ExtensionArguments.ExtArg arg : extArgs.getIncludedExtArgs()) {
            Object value = extArgs.get(arg);
            String jsonData = arg.toJson(value);
            applyQtActionExtArgs.put(arg.getKey(), jsonData);
        }
        ArrayList<ApplicableActionDataPersistenceUnit> actionUnits = new ArrayList<ApplicableActionDataPersistenceUnit>();
        for (MutableApplicableActionData action : actionsData) {
            HashMap<String, String> fields = new HashMap<String, String>();
            MutableReaStepData reaStepData = action.getReaStepData();
            for (ReaStepField reaStepField : reaStepData.getIncludedFields()) {
                Iterator value = reaStepData.get(reaStepField);
                String jsonData = new Json().toJson(value);
                fields.put(reaStepField.getKey(), jsonData);
            }
            HashMap<String, String> actionExtArgs = new HashMap<String, String>();
            ExtensionArguments arguments = action.getExtensionArguments();
            for (ExtensionArguments.ExtArg arg : arguments.getIncludedExtArgs()) {
                Object value = arguments.get(arg);
                String jsonData = arg.toJson(value);
                actionExtArgs.put(arg.getKey(), jsonData);
            }
            ApplicableActionDataPersistenceUnit unit = new ApplicableActionDataPersistenceUnit(action.getUniqueActionID(), fields, action.getReaStepText(), actionExtArgs);
            actionUnits.add(unit);
        }
        return new QuickTicketPersistenceUnit(jsonizedValues, applyQtActionExtArgs, actionUnits);
    }

    @Override
    public void delete(GUID quickTicketID) {
        String sql = "DELETE FROM tblQuickTickets WHERE QuickTicketUUID = ?";
        try (Connection con = this.conFactory.getConnection();
             PreparedStatement pstm = con.prepareStatement(sql);){
            pstm.setString(1, quickTicketID.toString());
            pstm.executeUpdate();
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Integer getIntID(GUID quickTicketID) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public <R> R inTransaction(Callable<R> operation) {
        try {
            return (R)DatabaseTransactionUtils.executeAsTransaction((ConnectionFactory)this.conFactory, connection -> {
                try {
                    return operation.call();
                }
                catch (PersistenceException pe) {
                    throw pe;
                }
                catch (Exception e) {
                    throw PersistenceException.createWithCode((Throwable)e, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
                }
            });
        }
        catch (SQLException e) {
            throw PersistenceException.createWithCode((Throwable)e, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
    }

    @Override
    public QuickTicketFolderVO loadFolder(GUID folderID) {
        List<QuickTicketFolderVO> result = this.loadFolders(" WHERE FolderUUID = '" + folderID.toString() + "'");
        return result.isEmpty() ? null : result.get(0);
    }

    @Override
    public QuickTicketFolderStructureVO loadFolderStructure() {
        List<QuickTicketFolderVO> allFolders = this.loadFolders("");
        return QuickTicketFolderStructureVO.create(allFolders);
    }

    @Override
    public List<GUID> listQuickTicketsInFolder(@Nullable GUID folderID) {
        if (folderID == null) {
            return this.list(" WHERE FolderUUID IS NULL");
        }
        return this.list(" WHERE FolderUUID = " + folderID.toSQLString());
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Only <empty> or condition with given GUID is passed in")
    private List<QuickTicketFolderVO> loadFolders(String wherePartOfSqlStatement) {
        ArrayList<QuickTicketFolderVO> result = new ArrayList<QuickTicketFolderVO>();
        String sql = "SELECT * FROM tblQuickTicketFolders" + wherePartOfSqlStatement;
        try (Connection con = this.conFactory.getConnection();
             Statement stm = con.createStatement();
             ResultSet rs = stm.executeQuery(sql);){
            while (rs.next()) {
                QuickTicketFolderVO folder;
                GUID parentID;
                GUID folderID;
                String folderIDString = rs.getString("FolderUUID");
                try {
                    folderID = GUID.valueOf((String)folderIDString);
                }
                catch (IllegalArgumentException ex) {
                    HDLogger.error((Object)("Could not parse ID of quick-ticket folder stored in database: " + folderIDString + ". This folder will be ignored and treated as non-existing."));
                    HDLogger.error((Object)ex);
                    continue;
                }
                String parentIDString = rs.getString("ParentUUID");
                try {
                    parentID = parentIDString == null ? null : GUID.valueOf((String)parentIDString);
                }
                catch (IllegalArgumentException ex) {
                    HDLogger.error((Object)("Could not parse parentID of quick-ticket folder stored in database: " + parentIDString + ". There will be no parent set for folder with ID: " + folderID.toString()));
                    HDLogger.error((Object)ex);
                    parentID = null;
                }
                String folderName = rs.getString("Name");
                try {
                    QuickTicketFolderVO.throwIfNameIsInvalid(folderName);
                }
                catch (IllegalArgumentException ex) {
                    String nameReplacement = "unknown";
                    HDLogger.error((Object)("Name \"" + folderName + "\" is stored in database for quick-ticket folder with ID: " + folderID.toString() + ". This name is invalid and  will be replaced with: " + nameReplacement));
                    HDLogger.error((Object)ex);
                    folderName = nameReplacement;
                }
                InputStream memberships = rs.getBinaryStream("Memberships");
                ArrayList permissions = null;
                try {
                    if (memberships != null && memberships.available() > 0) {
                        permissions = (ArrayList)new Json().fromJson(memberships, ArrayList.class, new Type[]{UsersOrGroupsSelection.SelectedMember.class});
                    }
                }
                catch (Throwable ex) {
                    HDLogger.error((Object)("Memberships \"are stored in database for quick-ticket folder with ID: " + folderID.toString() + ". This memberships are invalid and  will be replaced with null"));
                    HDLogger.error((Object)ex);
                    memberships = null;
                }
                if (Objects.equals(parentID, folderID)) {
                    HDLogger.error((Object)("Found that quick-ticket folder, which is stored in database, references itself as own parent. There will be no parent set for folder with ID: " + folderID.toString()));
                    parentID = null;
                }
                try {
                    folder = QuickTicketFolderVO.create(parentID, folderID, folderName, permissions);
                }
                catch (Exception ex) {
                    HDLogger.error((Object)("Could not create valid instance of QuickTicketFolderVO from data stored in database for folder with ID: " + folderID.toString() + ". This folder will be ignored and treated as non-existing."));
                    HDLogger.error((Object)ex);
                    continue;
                }
                result.add(folder);
            }
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
        return result;
    }

    @Override
    public void setFolder(GUID quickTicketID, @Nullable GUID folderID) {
        String sql = "UPDATE tblQuickTickets SET FolderUUID = ? WHERE QuickTicketUUID = ?";
        try (Connection con = this.conFactory.getConnection();
             PreparedStatement pstm = con.prepareStatement(sql);){
            pstm.setString(1, folderID == null ? null : folderID.toString());
            pstm.setString(2, quickTicketID.toString());
            pstm.executeUpdate();
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
    }

    @Override
    public void saveNewFolder(@Nullable GUID parentID, GUID folderID, String folderName, @Nullable List<UsersOrGroupsSelection.SelectedMember> folderPermission) {
        String sql = "INSERT INTO tblQuickTicketFolders (FolderUUID, ParentUUID, Name, Memberships) VALUES (?,?,?,?)";
        try (Connection con = this.conFactory.getConnection();
             PreparedStatement pstm = con.prepareStatement(sql);){
            pstm.setString(1, folderID.toString());
            pstm.setString(2, parentID == null ? null : parentID.toString());
            pstm.setString(3, folderName);
            pstm.setBinaryStream(4, (InputStream)(folderPermission == null ? null : new FastByteArrayInputStream(new Json().toJson(folderPermission).getBytes(StandardCharsets.UTF_8))));
            pstm.executeUpdate();
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
    }

    @Override
    public void saveFolder(@Nullable GUID parentID, GUID folderID, String folderName, List<UsersOrGroupsSelection.SelectedMember> folderPermission) {
        String sql = "UPDATE tblQuickTicketFolders SET ParentUUID = ?, Name = ?, Memberships = ? WHERE FolderUUID = ?";
        try (Connection con = this.conFactory.getConnection();
             PreparedStatement pstm = con.prepareStatement(sql);){
            pstm.setString(1, parentID == null ? null : parentID.toString());
            pstm.setString(2, folderName);
            pstm.setBinaryStream(3, (InputStream)(folderPermission == null ? null : new FastByteArrayInputStream(new Json().toJson(folderPermission).getBytes(StandardCharsets.UTF_8))));
            pstm.setString(4, folderID.toString());
            pstm.executeUpdate();
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
    }

    @Override
    public void deleteFolder(GUID folderID) {
        String sql = "DELETE FROM tblQuickTicketFolders WHERE FolderUUID = ?";
        try (Connection con = this.conFactory.getConnection();
             PreparedStatement pstm = con.prepareStatement(sql);){
            pstm.setString(1, folderID.toString());
            pstm.executeUpdate();
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
    }
}

