/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.processbridge.api;

import com.inet.annotations.InternalApi;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.report.Engine;
import com.inet.report.EngineRenderData;
import com.inet.report.ReportException;
import com.inet.report.processbridge.api.LittleEndianInputStream;
import com.inet.viewer.PrinterJobProgress;
import com.inet.viewer.RenderData;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;

@InternalApi
public class ApiHelper {
    public static Engine createEngine(String format) throws ReportException {
        return new Engine(format);
    }

    public static void setReportFile(Engine eng, String url) throws ReportException {
        eng.setReportFile(url);
    }

    public static void setPrompt(Engine eng, String name, String value) throws ReportException {
        eng.setPrompt(name, value);
    }

    public static void setData(Engine eng, String[] columns, int rowCount, byte[] serializedData) throws ReportException, IOException {
        Object[][] objectArray;
        LittleEndianInputStream littleEndianInputStream = new LittleEndianInputStream((InputStream)new FastByteArrayInputStream(serializedData));
        int n = columns.length;
        for (Object[] objectArray2 : objectArray = new Object[rowCount][n]) {
            for (int i = 0; i < n; ++i) {
                int n2 = littleEndianInputStream.read();
                objectArray2[i] = switch (n2) {
                    case -1 -> throw new EOFException();
                    case 0 -> null;
                    case 1 -> (byte)littleEndianInputStream.read();
                    case 2 -> littleEndianInputStream.readShortLE();
                    case 3 -> littleEndianInputStream.readIntLE();
                    case 4 -> littleEndianInputStream.readLongLE();
                    case 5 -> new Float(littleEndianInputStream.readFloatLE());
                    case 6 -> new Double(littleEndianInputStream.readDoubleLE());
                    case 7 -> littleEndianInputStream.readBoolean();
                    case 8 -> new BigDecimal(littleEndianInputStream.readString());
                    case 9 -> littleEndianInputStream.readString();
                    case 10 -> {
                        long var14_14 = littleEndianInputStream.readLongLE();
                        int var16_15 = (int)(var14_14 / 1000L);
                        int var17_16 = (int)(var14_14 % 1000L * 1000000L);
                        yield new Timestamp(70, 0, 1, 0, 0, var16_15, var17_16);
                    }
                    case 11 -> new Time(0, 0, littleEndianInputStream.readIntLE());
                    case 12 -> littleEndianInputStream.readBytesLE();
                    default -> throw new IOException("Unknown type: " + n2);
                };
            }
        }
        eng.setData(columns, objectArray);
    }

    public static List<String> getAvailablePrinters() {
        PrintService[] printServiceArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PrintService printService : printServiceArray = PrintServiceLookup.lookupPrintServices(null, null)) {
            arrayList.add(printService.getName());
        }
        return arrayList;
    }

    public static void printToPrinter(Engine engine, String printerName) throws PrinterException {
        PrintService printService = null;
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        for (PrintService printService2 : printServiceArray) {
            if (!printerName.equals(printService2.getName())) continue;
            printService = printService2;
            break;
        }
        if (printService == null) {
            throw new PrinterException("Printer '" + printerName + "' not found");
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintService(printService);
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        PrinterJobProgress printerJobProgress = new PrinterJobProgress(null, printerJob, (PrintRequestAttributeSet)hashPrintRequestAttributeSet, (RenderData)new a(engine));
        printerJobProgress.startProgress();
        printerJobProgress.waitUntilFinished();
    }

    private static class a
    extends EngineRenderData {
        private Engine a;

        public a(Engine engine) {
            super("");
            this.a = engine;
        }

        protected Engine checkEngine(Properties props) throws ReportException {
            if (!this.a.isFinish()) {
                this.a.execute();
            }
            return this.a;
        }
    }
}

