/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.processbridge.api;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.PDFComparer;
import com.inet.pdfc.config.ColorSetting;
import com.inet.pdfc.config.DefaultProfile;
import com.inet.pdfc.config.DefaultSetting;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.SettingUtil;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.config.VisibilitySetting;
import com.inet.pdfc.config.XMLProfile;
import com.inet.pdfc.error.ExceptionDataFactory;
import com.inet.pdfc.error.PdfcException;
import com.inet.pdfc.error.PresenterExceptionData;
import com.inet.pdfc.generator.message.InfoData;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.model.PagedElement;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.presenter.DifferencesPDFPresenter;
import com.inet.pdfc.presenter.DifferencesPNGPresenter;
import com.inet.pdfc.presenter.DifferencesPrintPresenter;
import com.inet.pdfc.presenter.ExportPresenter;
import com.inet.pdfc.presenter.JsonPresenter;
import com.inet.pdfc.presenter.ReportPDFPresenter;
import com.inet.pdfc.presenter.ReportPresenter;
import com.inet.pdfc.processbridge.PdfcProcessBridgeServerPlugin;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.results.ResultModelUpdater;
import com.inet.pdfc.results.filter.PerModificationResultFilter;
import com.inet.pdfc.results.filter.ResultFilter;
import com.inet.pdfc.results.painter.Painter;
import com.inet.pdfc.util.Pair;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.EnumSyntax;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.TextSyntax;
import javax.print.attribute.URISyntax;

@InternalApi
@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="process bridge run only locally")
public class ApiHelper {
    public static void setProfileProperties(PDFComparer comparer, Properties values) {
        DefaultProfile defaultProfile = new DefaultProfile();
        defaultProfile.putValues(values);
        comparer.setProfile((IProfile)defaultProfile);
    }

    private static VisibilitySetting a(String string) {
        for (DiffGroup.GroupType groupType : DiffGroup.GroupType.valuesVisible()) {
            if (!groupType.name().equalsIgnoreCase(string)) continue;
            return groupType;
        }
        for (VisibilitySetting visibilitySetting : SettingUtil.getAvailableVisibilitySetting()) {
            if (!visibilitySetting.name().equalsIgnoreCase(string)) continue;
            return visibilitySetting;
        }
        return new Painter.HighlightColorSetting(string);
    }

    private static ColorSetting b(String string) {
        for (DiffGroup.GroupType groupType : DiffGroup.GroupType.valuesVisible()) {
            if (!groupType.name().equalsIgnoreCase(string)) continue;
            return groupType;
        }
        for (ColorSetting colorSetting : SettingUtil.getAvailableColorSetting()) {
            if (!colorSetting.name().equalsIgnoreCase(string)) continue;
            return colorSetting;
        }
        return new Painter.HighlightColorSetting(string);
    }

    public static void batchCompare(PDFComparer comparer, String directory1, String directory2) throws PdfcException {
        comparer.batchCompare(new File(directory1), new File(directory2));
    }

    static Settings a(Properties properties) {
        String string;
        DefaultSetting defaultSetting = new DefaultSetting();
        Color color = null;
        boolean bl = false;
        for (String string2 : properties.stringPropertyNames()) {
            string = properties.getProperty(string2);
            if (!string2.toLowerCase().contains("ALLOUTLINEMARKER".toLowerCase())) continue;
            if (string2.contains("_VISIBILITY")) {
                if (string.equalsIgnoreCase("visible") || string.equalsIgnoreCase("true")) {
                    bl = true;
                } else if (string.equalsIgnoreCase("hidden") || string.equalsIgnoreCase("false")) {
                    bl = false;
                }
                defaultSetting.setEnabled(bl, new VisibilitySetting[]{Settings.METAOPTION.ALLOUTLINEMARKER});
                continue;
            }
            if (!string2.contains("_COLOR")) continue;
            color = SettingUtil.hexToColor((String)string);
            if (color == null) {
                PdfcProcessBridgeServerPlugin.LOGGER.warn((Object)("The setting key '" + string2 + "' has wrong color format. Please check the property. The color format can be defined using 6 or 8 characters (0-9 and a-f). The current value is " + string));
            }
            defaultSetting.setColor(color, (ColorSetting)Settings.METAOPTION.ALLOUTLINEMARKER);
        }
        for (String string2 : properties.stringPropertyNames()) {
            ColorSetting colorSetting;
            Serializable serializable;
            string = properties.getProperty(string2);
            if (string2.contains("_VISIBILITY")) {
                serializable = null;
                if (string.equalsIgnoreCase("visible") || string.equalsIgnoreCase("true")) {
                    serializable = Boolean.valueOf(true);
                } else if (string.equalsIgnoreCase("hidden") || string.equalsIgnoreCase("false")) {
                    serializable = Boolean.valueOf(false);
                }
                if (serializable == null) {
                    PdfcProcessBridgeServerPlugin.LOGGER.warn((Object)("The setting key '" + string2 + "' has wrong format. Please check the property. The visibility can be defined with visible/hidden. The current value is " + string));
                    continue;
                }
                colorSetting = ApiHelper.a(string2.replace("_VISIBILITY", ""));
                defaultSetting.setEnabled(((Boolean)serializable).booleanValue(), new VisibilitySetting[]{colorSetting});
                continue;
            }
            if (string2.contains("_COLOR")) {
                serializable = SettingUtil.hexToColor((String)string);
                if (serializable == null) {
                    PdfcProcessBridgeServerPlugin.LOGGER.warn((Object)("The setting key '" + string2 + "' has wrong color format. Please check the property. The color format can be defined using 6 or 8 characters (0-9 and a-f). The current value is " + string));
                    continue;
                }
                colorSetting = ApiHelper.b(string2.replace("_COLOR", ""));
                defaultSetting.setColor((Color)serializable, colorSetting);
                continue;
            }
            PdfcProcessBridgeServerPlugin.LOGGER.warn((Object)("The setting key '" + string2 + "' cann't evaluated. Please check the property."));
        }
        return defaultSetting;
    }

    public static void setSettings(PDFComparer comparer, Properties values) {
        comparer.setSettings(ApiHelper.a(values));
    }

    public static void setProfileName(PDFComparer comparer, String name) {
        comparer.setProfile(name);
    }

    public static void loadXMLProfile(PDFComparer comparer, String profileFile) throws InvalidPropertiesFormatException {
        comparer.setProfile((IProfile)new XMLProfile(new File(profileFile)));
    }

    public static DifferencesPDFPresenter createDifferencesPDFPresenter(String target, boolean isFolder) {
        return new DifferencesPDFPresenter(new File(target), isFolder);
    }

    public static DifferencesPDFPresenter createDifferencesPDFPresenterStream(OutputStream target) {
        return new DifferencesPDFPresenter(target);
    }

    public static DifferencesPNGPresenter createDifferencesPNGPresenter(String target, boolean isFolder) {
        return new DifferencesPNGPresenter(new File(target), isFolder);
    }

    public static ReportPresenter createReportPresenter(boolean detailed, boolean appendSettings, String format, String target, boolean isFolder) {
        return new ReportPresenter(detailed, appendSettings, format, new File(target), isFolder);
    }

    public static ReportPDFPresenter createReportPDFPresenter(boolean detailed, boolean appendSettings, String format, String target, boolean isFolder) {
        return new ReportPDFPresenter(detailed, appendSettings, new File(target), isFolder);
    }

    public static JsonPresenter createJsonPresenter() {
        return new JsonPresenter();
    }

    public static DifferencesPrintPresenter createDifferencesPrintPresenter(Map<String, String> props) {
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        if (props != null) {
            block8: for (Map.Entry<String, String> entry : props.entrySet()) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                block4 : switch (string) {
                    case "PrinterName": {
                        PrintService[] printServiceArray;
                        for (PrintService printService2 : printServiceArray = PrinterJob.lookupPrintServices()) {
                            if (!string2.equalsIgnoreCase(printService2.getName())) continue;
                            printService = printService2;
                            break block4;
                        }
                        continue block8;
                    }
                    default: {
                        try {
                            Class<?> clazz = Class.forName("javax.print.attribute.standard." + string);
                            if (EnumSyntax.class.isAssignableFrom(clazz)) {
                                ApiHelper.a(hashPrintRequestAttributeSet, string2, clazz);
                                continue block8;
                            }
                            if (TextSyntax.class.isAssignableFrom(clazz)) {
                                ApiHelper.b(hashPrintRequestAttributeSet, string2, clazz);
                                continue block8;
                            }
                            if (URISyntax.class.isAssignableFrom(clazz)) {
                                ApiHelper.c(hashPrintRequestAttributeSet, string2, clazz);
                                continue block8;
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                        PdfcProcessBridgeServerPlugin.LOGGER.warn((Object)("Unknown print attribute: " + string));
                    }
                }
            }
        }
        return new DifferencesPrintPresenter(printService, (PrintRequestAttributeSet)hashPrintRequestAttributeSet);
    }

    private static void a(PrintRequestAttributeSet printRequestAttributeSet, String string, Class<?> clazz) {
        for (Field field : clazz.getFields()) {
            if (!Attribute.class.isAssignableFrom(field.getType())) continue;
            try {
                Attribute attribute = (Attribute)field.get(null);
                if (attribute == null || !field.getName().equalsIgnoreCase(string) && !string.equalsIgnoreCase(attribute.toString())) continue;
                printRequestAttributeSet.add(attribute);
                return;
            }
            catch (Throwable throwable) {
                PdfcProcessBridgeServerPlugin.LOGGER.error(throwable);
            }
        }
        PdfcProcessBridgeServerPlugin.LOGGER.warn((Object)("Unknown print attribute value: " + string + " for key " + clazz.getSimpleName()));
    }

    private static void b(PrintRequestAttributeSet printRequestAttributeSet, String string, Class<?> clazz) {
        try {
            Constructor<?> constructor = clazz.getConstructor(String.class, Locale.class);
            printRequestAttributeSet.add((Attribute)constructor.newInstance(string, null));
        }
        catch (Throwable throwable) {
            PdfcProcessBridgeServerPlugin.LOGGER.error(throwable);
        }
        PdfcProcessBridgeServerPlugin.LOGGER.warn((Object)("Unknown print attribute value: " + string + " for key " + clazz.getSimpleName()));
    }

    private static void c(PrintRequestAttributeSet printRequestAttributeSet, String string, Class<?> clazz) {
        try {
            Constructor<?> constructor = clazz.getConstructor(URI.class);
            printRequestAttributeSet.add((Attribute)constructor.newInstance(new URI(string)));
        }
        catch (Throwable throwable) {
            PdfcProcessBridgeServerPlugin.LOGGER.error(throwable);
        }
        PdfcProcessBridgeServerPlugin.LOGGER.warn((Object)("Unknown print attribute value: " + string + " for key " + clazz.getSimpleName()));
    }

    public static void setExportPresenterBackgroundColor(ExportPresenter presenter, Integer argb) {
        presenter.setBackgroundColor(argb == null ? null : new Color(argb, true));
    }

    public static int getDifferenceCount(ResultModel model, String type, boolean filtered) {
        Modification.ModificationType modificationType = Modification.ModificationType.add;
        for (Modification.ModificationType modificationType2 : Modification.ModificationType.values()) {
            if (!modificationType2.toString().equalsIgnoreCase(type)) continue;
            modificationType = modificationType2;
            break;
        }
        return model.getDifferences(modificationType, filtered);
    }

    public static List<Map<String, String>> getDifferenceGroupsList(ResultModel model, boolean filtered) {
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        List list = model.getDifferences(filtered);
        Map<Modification, String> map = ApiHelper.a(model);
        for (DiffGroup diffGroup : list) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Rectangle rectangle = diffGroup.getBounds(true);
            hashMap.put("boundsFirst", rectangle.x + ";" + rectangle.y + ";" + rectangle.width + ";" + rectangle.height);
            Rectangle rectangle2 = diffGroup.getBounds(false);
            hashMap.put("boundsSecond", rectangle2.x + ";" + rectangle2.y + ";" + rectangle2.width + ";" + rectangle2.height);
            hashMap.put("type", diffGroup.getType().getTyp());
            StringBuilder stringBuilder = new StringBuilder(diffGroup.getType().toString()).append(": [");
            stringBuilder.append(diffGroup.getRemovedElements().stream().map(pagedElement -> pagedElement.getLabel()).collect(Collectors.joining(", ")));
            stringBuilder.append("] -> [");
            stringBuilder.append(diffGroup.getAddedElements().stream().map(pagedElement -> pagedElement.getLabel()).collect(Collectors.joining(", ")));
            stringBuilder.append("]");
            hashMap.put("message", stringBuilder.toString());
            String string = diffGroup.getModifications().stream().map(modification -> (String)map.get(modification)).collect(Collectors.joining(","));
            hashMap.put("keys", string);
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    @Nonnull
    private static Map<Modification, String> a(@Nonnull ResultModel resultModel) {
        List list = resultModel.getDifferences(false);
        HashMap<Modification, String> hashMap = new HashMap<Modification, String>();
        int n = 0;
        int n2 = 0;
        for (DiffGroup diffGroup : list) {
            List list2 = diffGroup.getModifications();
            n2 = 0;
            for (Modification modification : list2) {
                hashMap.put(modification, n + "-" + n2);
                ++n2;
            }
            ++n;
        }
        return hashMap;
    }

    @Nonnull
    private static Map<String, Modification> b(@Nonnull ResultModel resultModel) {
        List list = resultModel.getDifferences(false);
        HashMap<String, Modification> hashMap = new HashMap<String, Modification>();
        int n = 0;
        int n2 = 0;
        for (DiffGroup diffGroup : list) {
            List list2 = diffGroup.getModifications();
            n2 = 0;
            for (Modification modification : list2) {
                hashMap.put(n + "-" + n2, modification);
                ++n2;
            }
            ++n;
        }
        return hashMap;
    }

    public static List<Map<String, String>> getDifferences(@Nonnull ResultModel model, boolean filtered) {
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        Map<Modification, String> map = ApiHelper.a(model);
        List list = model.getDifferences(filtered);
        for (DiffGroup diffGroup : list) {
            List list2 = diffGroup.getModifications();
            for (Modification modification : list2) {
                Cloneable cloneable;
                PagedElement pagedElement;
                Object object2;
                String string = map.get(modification);
                List list3 = modification.getAffectedElements(true);
                int n = 0;
                for (Object object2 : list3) {
                    pagedElement = new HashMap();
                    cloneable = object2.getBounds();
                    pagedElement.put("bounds", (int)((RectangularShape)cloneable).getX() + ";" + (int)((RectangularShape)cloneable).getY() + ";" + (int)((RectangularShape)cloneable).getWidth() + ";" + (int)((RectangularShape)cloneable).getHeight());
                    pagedElement.put("page", "" + object2.getPageIndex());
                    pagedElement.put("type", diffGroup.getType().name());
                    pagedElement.put("message", modification.getMessage());
                    pagedElement.put("element", object2.getLabel());
                    pagedElement.put("document", "1");
                    pagedElement.put("key", string + "_" + n);
                    arrayList.add((Map<String, String>)pagedElement);
                    ++n;
                }
                n = 0;
                List list4 = modification.getAffectedElements(false);
                object2 = list4.iterator();
                while (object2.hasNext()) {
                    pagedElement = (PagedElement)object2.next();
                    cloneable = new HashMap();
                    Rectangle2D rectangle2D = pagedElement.getBounds();
                    cloneable.put("bounds", (int)rectangle2D.getX() + ";" + (int)rectangle2D.getY() + ";" + (int)rectangle2D.getWidth() + ";" + (int)rectangle2D.getHeight());
                    cloneable.put("page", "" + pagedElement.getPageIndex());
                    cloneable.put("type", diffGroup.getType().name());
                    cloneable.put("message", modification.getMessage());
                    cloneable.put("element", pagedElement.getLabel());
                    cloneable.put("document", "2");
                    cloneable.put("key", string + "_" + n);
                    arrayList.add((Map<String, String>)((Object)cloneable));
                    ++n;
                }
            }
        }
        return arrayList;
    }

    public static void setDifferencesToHide(@Nonnull ResultModel result, List<String> keys) {
        Object object;
        PerModificationResultFilter perModificationResultFilter = new PerModificationResultFilter();
        if (keys != null && keys.size() > 0) {
            object = ApiHelper.b(result);
            for (String string : keys) {
                Modification modification;
                int n = string.indexOf("_");
                if (n > 0) {
                    string = string.substring(0, n);
                }
                if ((modification = (Modification)object.get(string)) != null) {
                    perModificationResultFilter.addModificationsToFilter(new Modification[]{modification});
                    continue;
                }
                PDFCCore.LOGGER_CORE.debug((Object)("No modification found for key " + string));
            }
        }
        object = new ResultModelUpdater(result);
        ArrayList arrayList = new ArrayList(object.getResultFilters());
        arrayList.stream().forEach(arg_0 -> ApiHelper.a((ResultModelUpdater)object, perModificationResultFilter, arg_0));
        if (keys != null && keys.size() > 0) {
            object.addResultFilter((ResultFilter)perModificationResultFilter);
        }
    }

    public static Map<String, String> getComparisonParameters(ResultModel model) {
        InfoData infoData = model.getComparisonParameters();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("firstPageCount", String.valueOf(infoData.getFirstPageCount()));
        hashMap.put("secondPageCount", String.valueOf(infoData.getSecondPageCount()));
        hashMap.put("firstFile", infoData.getFirstFile().getPath());
        hashMap.put("secondFile", infoData.getSecondFile().getPath());
        return hashMap;
    }

    public static PresenterExceptionData[] getPresenterExceptionData(PDFComparer comparer) {
        PdfcProcessBridgeServerPlugin.LOGGER.debug((Object)("Exception Count = " + comparer.getPresenterExceptions().size()));
        return comparer.getPresenterExceptions().toArray(new PresenterExceptionData[0]);
    }

    public static PresenterExceptionData executePresenter(BasePresenter presenter, ResultModel result) {
        try {
            presenter.executeImmediately(result);
            return null;
        }
        catch (Exception exception) {
            String string = result.getComparisonParameters().getFirstFile().getName();
            String string2 = result.getComparisonParameters().getSecondFile().getName();
            return new PresenterExceptionData(ExceptionDataFactory.createExceptionData((Throwable)exception), presenter.getExtensionName(), new Pair((Object)string, (Object)string2));
        }
    }

    private static /* synthetic */ void a(ResultModelUpdater resultModelUpdater, PerModificationResultFilter perModificationResultFilter, ResultFilter resultFilter) {
        resultModelUpdater.removeResultFilter((ResultFilter)perModificationResultFilter);
    }
}

