/*
 * Decompiled with CFR 0.152.
 */
package com.inet.store.client.plugin.help.content;

import com.inet.annotations.JsonData;
import com.inet.config.ConfigurationManager;
import com.inet.help.api.model.VirtualHelpPage;
import com.inet.lib.markdown.MarkDown2Html;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.website.WellKnownWebsites;
import com.inet.store.client.plugin.help.a;
import com.inet.store.client.plugin.help.c;
import com.inet.store.client.shared.PluginMergedDetails;
import com.inet.store.client.ui.data.PluginHistoryResponse;
import com.inet.store.client.ui.handler.g;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class PluginHelpPage
extends VirtualHelpPage {
    private PluginMergedDetails plugin;
    private String pluginPageDocument;
    private boolean isLoaded;

    public PluginHelpPage(PluginMergedDetails plugin) {
        this.plugin = plugin;
        this.isLoaded = Arrays.asList(ServerPluginManager.getInstance().getLoadedPlugins()).contains(plugin.getId());
    }

    @Nonnull
    public String getExtensionName() {
        return this.getKey();
    }

    @Nonnull
    public static String getPluginKey(PluginMergedDetails plugin) {
        return "pluginstore.page." + plugin.getId();
    }

    @Nonnull
    public String getKey() {
        return PluginHelpPage.getPluginKey(this.plugin);
    }

    @Nonnull
    public String getTitle() {
        return this.plugin.getName();
    }

    public String getUrl() {
        return this.getKey();
    }

    public String getPageKeyForUrl(String url, Locale locale) {
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        return url.equals(this.getKey()) ? this.getKey() : null;
    }

    public boolean isKeyFromPage(@Nonnull String key, Locale locale) {
        return this.getKey().equals(key);
    }

    public URL getResourceForName(String name) {
        return this.getKey().equals(name) ? a.a(name, () -> this.getPluginHelpPage()) : null;
    }

    private String getPluginHelpPage() {
        if (this.pluginPageDocument == null) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<h1 class=\"header\">");
            stringBuilder.append("<span class=\"title\">");
            stringBuilder.append(PluginHelpPage.uiEncoded(this.plugin.getName()));
            stringBuilder.append("</span>");
            stringBuilder.append("<span class=\"plugininfo\">");
            stringBuilder.append(String.format("<span class=\"status %s\">%s</span>", this.isLoaded ? "active" : "inactive", PluginHelpPage.uiEncoded(this.isLoaded ? c.Z.getMsg("plugininfo.active", new Object[0]) : c.Z.getMsg("plugininfo.inactive", new Object[0]))));
            Boolean bl = !StringFunctions.isEmpty((String)this.plugin.getBetaVersion());
            String string = WellKnownWebsites.STORE_BASE_URL;
            if (!ConfigurationManager.isHelpCenterMode()) {
                string = "../store/";
            }
            String string2 = URLEncoder.encode(this.plugin.getId(), StandardCharsets.UTF_8);
            stringBuilder.append("<a href=\"" + string + "pid/" + string2 + "\" >");
            stringBuilder.append("<img src=\"?method=store.icon&pid=" + string2 + "&beta=" + bl.toString() + "&version=\" />");
            stringBuilder.append("</a>");
            stringBuilder.append("</span>");
            stringBuilder.append("</h1>");
            stringBuilder.append("<div class=\"level1\">");
            stringBuilder.append("<p class=\"plugininfo hint\">");
            stringBuilder.append(PluginHelpPage.uiEncoded(c.Z.getMsg("plugininfo.hint", new Object[0])));
            stringBuilder.append("</p>");
            stringBuilder.append("</div>");
            MarkDown2Html markDown2Html = new MarkDown2Html();
            String string3 = this.plugin.getDescription();
            if (!StringFunctions.isEmpty((String)string3)) {
                object = markDown2Html.convert(string3);
                stringBuilder.append("<div class=\"level1\">");
                stringBuilder.append((String)object);
                stringBuilder.append("</div>");
            }
            if ((object = g.g(this.plugin)) != null) {
                String string4;
                String string5 = ((PluginHistoryResponse)object).getMigration();
                if (!StringFunctions.isEmpty((String)string5)) {
                    stringBuilder.append("<h2>");
                    stringBuilder.append(PluginHelpPage.uiEncoded(c.Z.getMsg("changelog.migration", new Object[0])));
                    stringBuilder.append("</h2>");
                    stringBuilder.append("<div class=\"level2\">");
                    stringBuilder.append(string5);
                    stringBuilder.append("</div>");
                }
                if (!StringFunctions.isEmpty((String)(string4 = ((PluginHistoryResponse)object).getChangelog()))) {
                    stringBuilder.append("<h2>");
                    stringBuilder.append(PluginHelpPage.uiEncoded(c.Z.getMsg("changelog.changelog", new Object[0])));
                    stringBuilder.append("</h2>");
                    stringBuilder.append("<div class=\"level2\">");
                    stringBuilder.append(string4);
                    stringBuilder.append("</div>");
                }
            }
            this.pluginPageDocument = stringBuilder.toString();
        }
        return this.pluginPageDocument;
    }

    private static String uiEncoded(@Nullable String input) {
        return input == null ? "" : StringFunctions.encodeHTML((String)input, (boolean)false);
    }

    public VirtualHelpPage getSpecificHelpPage(@Nonnull String key, Locale locale) {
        return new PluginHelpPage(this.plugin);
    }

    public boolean addRootPageToRoots() {
        return true;
    }

    public boolean showInToc() {
        return SystemPermissionChecker.isAdministrator();
    }
}

