/*
 * Decompiled with CFR 0.152.
 */
package com.inet.store.client.internal;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.error.ErrorCode;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.StringFunctions;
import com.inet.shared.utils.Version;
import com.inet.store.client.internal.MavenChannel;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class ArtifactKey
implements Cloneable {
    public static final String JAR = "jar";
    public static final String PLUGIN = "plugin";
    private static final String LETTER_CLASSIFIER_PREFIX = "abcdefghijklmnopqrstuvwxyz0123456789";
    @Nonnull
    private String id;
    @Nonnull
    private String version;
    @Nonnull
    private MavenChannel channel;
    @JsonExcludeNull
    private String classifier;
    private transient Version versionValue;

    protected ArtifactKey() {
    }

    public ArtifactKey(@Nonnull ArtifactKey key) {
        this(key.getId(), key.getClassifier(), key.getVersion(), key.getChannel());
    }

    protected ArtifactKey(@Nonnull String id, @Nonnull String version, @Nonnull MavenChannel channel) {
        this.id = Objects.requireNonNull(id);
        this.version = Objects.requireNonNull(version);
        this.channel = Objects.requireNonNull(channel);
        if (id.contains("..")) {
            throw new IllegalArgumentException(id);
        }
        if (version.contains("..")) {
            throw new IllegalArgumentException(version);
        }
    }

    protected ArtifactKey(@Nonnull String id, @Nullable String classifier, @Nonnull String version, @Nonnull MavenChannel channel) {
        this(id, version, channel);
        this.classifier = classifier;
    }

    public int hashCode() {
        try {
            return this.getIdWithClassifier().hashCode() + this.version.hashCode() + this.channel.hashCode();
        }
        catch (NullPointerException nullPointerException) {
            return -1;
        }
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArtifactKey)) {
            return false;
        }
        ArtifactKey artifactKey = (ArtifactKey)obj;
        return this.getIdWithClassifier().equals(artifactKey.getIdWithClassifier()) && this.version.equals(artifactKey.version) && this.channel.equals((Object)artifactKey.channel);
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getComparableId() {
        return this.getIdWithClassifier();
    }

    @Nonnull
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    @Nonnull
    public Version getVersionValue() {
        Version version = this.versionValue;
        if (version == null) {
            this.versionValue = version = new Version(this.version);
        }
        return version;
    }

    @Nonnull
    public MavenChannel getChannel() {
        return this.channel;
    }

    @Nonnull
    public <T extends ArtifactKey> T clone(@Nonnull MavenChannel channel) {
        try {
            ArtifactKey artifactKey = (ArtifactKey)this.clone();
            artifactKey.channel = Objects.requireNonNull(channel);
            return (T)artifactKey;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (RuntimeException)ErrorCode.throwAny((Throwable)cloneNotSupportedException);
        }
    }

    @Nonnull
    public String getStoragePluginDetailKey() {
        return this.getIdWithClassifier() + "-" + String.valueOf((Object)this.channel);
    }

    @Nonnull
    public String toString() {
        try {
            return String.join((CharSequence)"-", this.getIdWithClassifier(), this.version, this.channel.toString()).replaceAll("-+", "-");
        }
        catch (NullPointerException nullPointerException) {
            throw new ClientMessageException("The provided artifcat key is misconfigured.");
        }
    }

    @Nonnull
    private String getIdWithClassifier() {
        Object object = this.id;
        String string = this.classifier;
        if (!StringFunctions.isEmpty((String)string)) {
            switch (string) {
                case "jar": 
                case "plugin": {
                    break;
                }
                default: {
                    if (LETTER_CLASSIFIER_PREFIX.indexOf(string.charAt(0)) >= 0) {
                        object = (String)object + "-";
                    }
                    object = (String)object + string;
                }
            }
        }
        return object;
    }

    @Nonnull
    public static ArtifactKey from(@Nonnull String id, @Nullable String classifier, @Nonnull String version, @Nonnull MavenChannel channel) {
        String[] stringArray;
        if (StringFunctions.isEmpty((String)classifier) && (stringArray = id.split("-", 2)).length > 1) {
            id = stringArray[0];
            classifier = stringArray[1];
        }
        return new ArtifactKey(id, classifier, version, channel);
    }

    @Nonnull
    public static ArtifactKey from(@Nonnull ArtifactKey artifactKey, @Nullable String classifier) {
        ArtifactKey artifactKey2 = new ArtifactKey(artifactKey);
        if (!StringFunctions.isEmpty((String)classifier)) {
            artifactKey2.classifier = classifier;
        }
        return artifactKey2;
    }
}

