/*
 * Decompiled with CFR 0.152.
 */
package com.inet.store.client.internal;

import com.inet.annotations.JsonData;
import com.inet.lib.util.StringFunctions;
import com.inet.store.client.internal.ArtifactKey;
import com.inet.store.client.internal.MavenChannel;
import com.inet.store.client.internal.ReleaseNotesUtils;
import com.inet.store.client.internal.StateStorage;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class PluginDetail
extends ArtifactKey {
    private String app;
    private String icon;
    private String teaser;
    private int screenshotCount;
    private String changelog;
    private String migration;
    private Map<String, String> displayNames = new HashMap<String, String>();
    private Map<String, String> descriptions = new HashMap<String, String>();
    private List<String> categories;
    @Nonnull
    private List<String> dependencies;
    @Nonnull
    private List<String> optionalDependencies;
    private long size;
    private String sha1;
    private Collection<String> flags;

    private PluginDetail() {
        this.dependencies = new ArrayList<String>();
        this.optionalDependencies = new ArrayList<String>();
    }

    public PluginDetail(@Nonnull String id, @Nonnull String version, @Nonnull MavenChannel channel, String app, String icon, String teaser, int screenshotCount, String changelog, String migration, Map<String, String> displayNames, Map<String, String> descriptions, List<String> categories, @Nonnull List<String> dependencies, @Nonnull List<String> optionalDependencies, long size, String sha1, Collection<String> flags) {
        super(id, version, channel);
        this.app = app;
        this.icon = icon;
        this.teaser = teaser;
        this.screenshotCount = screenshotCount;
        this.changelog = changelog;
        this.migration = migration;
        this.displayNames = displayNames;
        this.descriptions = descriptions;
        this.categories = categories;
        this.dependencies = dependencies;
        this.optionalDependencies = optionalDependencies;
        this.size = size;
        this.sha1 = sha1;
        this.flags = flags;
    }

    @Nonnull
    String getDisplayName(@Nonnull Locale locale) {
        return PluginDetail.getLocalizedData(locale, this.displayNames, this.getId());
    }

    String getDescription(@Nonnull Locale locale) {
        return PluginDetail.getLocalizedData(locale, this.descriptions, "");
    }

    static String getLocalizedData(Locale locale, Map<String, String> source, String defaultValue) {
        String string = source.get(locale.getLanguage());
        if (StringFunctions.isEmpty((String)string) && StringFunctions.isEmpty((String)(string = source.get("en")))) {
            if (source.size() > 0) {
                string = source.values().iterator().next();
            }
            if (StringFunctions.isEmpty((String)string)) {
                string = defaultValue;
            }
        }
        return string;
    }

    private static byte @Nullable [] getBytes(@Nullable String data) {
        if (data == null) {
            return null;
        }
        return Base64.getDecoder().decode(data);
    }

    public String getApp() {
        return this.app;
    }

    public Collection<String> getFlags() {
        return this.flags;
    }

    public byte @Nullable [] getIcon() {
        return PluginDetail.getBytes(this.icon);
    }

    void saveTeaser(StateStorage storage) {
        String string = this.teaser;
        if (StringFunctions.isEmpty((String)string)) {
            return;
        }
        String string2 = this.getStoragePluginDetailKey();
        storage.b(string2 + "-teaser", PluginDetail.getBytes(string));
        this.teaser = "";
    }

    @Nullable
    Supplier<byte[]> getTeaser(StateStorage storage) {
        String string = this.teaser;
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            String string2 = this.getStoragePluginDetailKey();
            return () -> storage.a(string2 + "-teaser", byte[].class, new Type[0]);
        }
        return () -> PluginDetail.getBytes(string);
    }

    int getScreenshotCount() {
        return this.screenshotCount;
    }

    @Nonnull
    protected IntFunction<byte[]> getScreenshots(StateStorage storage) {
        String string = this.getStoragePluginDetailKey();
        return i2 -> storage.a(PluginDetail.getStorageScreenshotKey(string, i2), byte[].class, new Type[0]);
    }

    @Nonnull
    static String getStorageScreenshotKey(String detailKey, int screenshotIdx) {
        return detailKey + "-" + screenshotIdx;
    }

    @Nonnull
    String getStorageScreenshotKey(int screenshotIdx) {
        return PluginDetail.getStorageScreenshotKey(this.getStoragePluginDetailKey(), screenshotIdx);
    }

    @Nonnull
    public Function<String, String> getGeneralLogs(StateStorage storage, Locale locale) {
        return version -> {
            String string = storage.a(this.getStorageChangelogKey((String)version), String.class, new Type[0]);
            if (StringFunctions.isEmpty((String)string) && this.getVersion().startsWith((String)version)) {
                string = this.getChangelog();
            }
            return ReleaseNotesUtils.createLocalizedChanges(string, "general", locale.getLanguage());
        };
    }

    @Nonnull
    protected Function<String, String> getChangelogs(StateStorage storage, Locale locale) {
        return version -> {
            String string = storage.a(this.getStorageChangelogKey((String)version), String.class, new Type[0]);
            if (StringFunctions.isEmpty((String)string) && this.getVersion().startsWith((String)version)) {
                string = this.getChangelog();
            }
            return ReleaseNotesUtils.createLocalizedChanges(string, "changes", locale.getLanguage());
        };
    }

    @Nonnull
    protected Function<String, String> getMigrations(StateStorage storage, Locale locale) {
        return version -> {
            String string = storage.a(this.getStorageMigrationKey((String)version), String.class, new Type[0]);
            if (StringFunctions.isEmpty((String)string) && this.getVersion().startsWith((String)version)) {
                string = this.getMigration();
            }
            return ReleaseNotesUtils.createLocalizedChanges(string, "migration", locale.getLanguage());
        };
    }

    @Nonnull
    protected Collection<String> getChanges(StateStorage storage) {
        List<String> list = storage.a(this.getStorageChangelogKey("changes"), List.class, new Type[0]);
        if (list == null || list.isEmpty()) {
            list = List.of(this.getChangesVersion());
        }
        return list;
    }

    public final String getChangesVersion() {
        return this.getVersionValue().getMajor() + "." + this.getVersionValue().getMinor();
    }

    @Nonnull
    String getStorageChangelogKey(String version) {
        return this.getStoragePluginDetailKey() + "-changelog-" + version;
    }

    @Nonnull
    String getStorageMigrationKey(String version) {
        return this.getStoragePluginDetailKey() + "-migration-" + version;
    }

    @Nonnull
    List<String> getCategories() {
        return this.categories != null ? this.categories : Collections.emptyList();
    }

    @Nullable
    protected String getChangelog() {
        return this.changelog;
    }

    @Nullable
    protected String getMigration() {
        return this.migration;
    }

    @Nonnull
    public Collection<String> getDependencies() {
        return this.dependencies;
    }

    @Nonnull
    public Collection<String> getOptionalDependencies() {
        return this.optionalDependencies;
    }

    public long getArtifactSize() {
        return this.size;
    }

    public String getSha1() {
        return this.sha1;
    }
}

