/*
 * Decompiled with CFR 0.152.
 */
package com.inet.store.client.plugin.help.content;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.help.api.model.VirtualHelpPage;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.help.HelpPage;
import com.inet.store.client.internal.PluginConfigManager;
import com.inet.store.client.plugin.help.content.PluginCategoryHelpPage;
import java.net.URL;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@JsonData
public class PluginStoreHelpPage
extends VirtualHelpPage {
    private static final Map<Locale, PluginStoreHelpPage> PLUGIN_STORE_PAGES_CACHE = new HashMap<Locale, PluginStoreHelpPage>();
    public static final String PLUGINSTORE_HELPPAGE = "pluginstore";
    private List<? extends HelpPage> childPages = null;

    @Nonnull
    public String getExtensionName() {
        return PLUGINSTORE_HELPPAGE;
    }

    @Nonnull
    public String getKey() {
        return PLUGINSTORE_HELPPAGE;
    }

    @Nonnull
    public String getTitle() {
        return PLUGINSTORE_HELPPAGE;
    }

    public String getPageKeyForUrl(String url, Locale locale) {
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        return url.equals(PLUGINSTORE_HELPPAGE) ? PLUGINSTORE_HELPPAGE : null;
    }

    public boolean isKeyFromPage(@Nonnull String key, Locale locale) {
        return PLUGINSTORE_HELPPAGE.equals(key);
    }

    public URL getResourceForName(String name) {
        return null;
    }

    public VirtualHelpPage getSpecificHelpPage(@Nonnull String key, Locale locale) {
        PluginStoreHelpPage pluginStoreHelpPage = PLUGIN_STORE_PAGES_CACHE.get(locale);
        if (pluginStoreHelpPage == null) {
            pluginStoreHelpPage = new PluginStoreHelpPage();
            PLUGIN_STORE_PAGES_CACHE.put(locale, pluginStoreHelpPage);
        }
        return pluginStoreHelpPage;
    }

    public boolean addRootPageToRoots() {
        return true;
    }

    public <T extends HelpPage> List<T> getChildPages() {
        if (this.childPages == null || this.childPages.isEmpty()) {
            List<LocalizedKey> list = PluginConfigManager.getInstance().getCategories(true, null, null);
            list.sort(Comparator.comparing(LocalizedKey::getDisplayName, String.CASE_INSENSITIVE_ORDER));
            this.childPages = list.stream().map(v -> new PluginCategoryHelpPage((LocalizedKey)v)).collect(Collectors.toList());
        }
        return this.childPages;
    }

    public boolean showInToc() {
        return SystemPermissionChecker.isAdministrator();
    }

    public void reset() {
        PLUGIN_STORE_PAGES_CACHE.clear();
    }
}

