/*
 * Decompiled with CFR 0.152.
 */
package com.inet.store.client.plugin.help.content;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.help.api.model.VirtualHelpPage;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.help.HelpPage;
import com.inet.store.client.internal.PluginConfigManager;
import com.inet.store.client.plugin.help.a;
import com.inet.store.client.plugin.help.c;
import com.inet.store.client.plugin.help.content.PluginHelpPage;
import com.inet.store.client.shared.PluginMergedDetails;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@JsonData
public class PluginCategoryHelpPage
extends VirtualHelpPage {
    private List<? extends HelpPage> childPages = null;
    private LocalizedKey category;
    private String categoryDocument;
    private List<PluginMergedDetails> plugins;

    public PluginCategoryHelpPage(LocalizedKey category) {
        this.category = category;
    }

    @Nonnull
    public String getExtensionName() {
        return this.getKey();
    }

    @Nonnull
    public String getKey() {
        return "pluginstore." + this.category.getKey();
    }

    @Nonnull
    public String getTitle() {
        return this.category.getDisplayName();
    }

    public String getUrl() {
        return this.getKey();
    }

    public String getPageKeyForUrl(String url, Locale locale) {
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        return url.equals(this.getKey()) ? this.getKey() : null;
    }

    public boolean isKeyFromPage(@Nonnull String key, Locale locale) {
        return this.getKey().equals(key);
    }

    public URL getResourceForName(String name) {
        return this.getKey().equals(name) ? a.a(name, () -> this.getCategoryHelpPage()) : null;
    }

    private String getCategoryHelpPage() {
        if (this.categoryDocument == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<h1>");
            stringBuilder.append(this.category.getDisplayName());
            stringBuilder.append("</h1>");
            stringBuilder.append("<div class=\"level1\">");
            stringBuilder.append("<p>");
            stringBuilder.append(c.Z.getMsg("pluginstore.help.category", new Object[]{this.category.getDisplayName()}));
            stringBuilder.append("</p>");
            stringBuilder.append("<ul>");
            for (PluginMergedDetails pluginMergedDetails : this.plugins) {
                stringBuilder.append("<li>");
                String string = PluginHelpPage.getPluginKey(pluginMergedDetails);
                String string2 = String.format("<a href=\"%s\" data-contextid=\"%s\">%s</a>", string, string, pluginMergedDetails.getName());
                stringBuilder.append(string2);
                stringBuilder.append("</a></li>");
            }
            stringBuilder.append("</ul>");
            stringBuilder.append("</div>");
            this.categoryDocument = stringBuilder.toString();
        }
        return this.categoryDocument;
    }

    public VirtualHelpPage getSpecificHelpPage(@Nonnull String key, Locale locale) {
        return new PluginCategoryHelpPage(this.category);
    }

    public boolean addRootPageToRoots() {
        return true;
    }

    public <T extends HelpPage> List<T> getChildPages() {
        if (this.childPages == null || this.childPages.isEmpty()) {
            ArrayList<PluginMergedDetails> arrayList = new ArrayList<PluginMergedDetails>(PluginConfigManager.getInstance().getPrimaryPlugins(this.category.getKey()));
            arrayList.sort(Comparator.comparing(PluginMergedDetails::getName, String.CASE_INSENSITIVE_ORDER));
            this.childPages = arrayList.stream().map(p2 -> new PluginHelpPage((PluginMergedDetails)p2)).collect(Collectors.toList());
            this.plugins = arrayList;
        }
        return this.childPages;
    }

    public boolean showInToc() {
        return SystemPermissionChecker.isAdministrator() && this.getChildPages().size() > 0;
    }
}

