/*
 * Decompiled with CFR 0.152.
 */
package com.inet.store.client.internal;

import com.inet.annotations.InternalApi;
import com.inet.cache.MemoryStoreMap;
import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.config.RecoveryConfigValue;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.error.ErrorCode;
import com.inet.globalbanner.GlobalBanner;
import com.inet.globalbanner.GlobalBannerManager;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.utils.UserAgent;
import com.inet.id.GUID;
import com.inet.lib.i18n.LocalizedIOException;
import com.inet.lib.io.FastBufferedInputStream;
import com.inet.lib.json.Json;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.logging.SystemEventLog;
import com.inet.notification.Notification;
import com.inet.notification.NotificationGenerator;
import com.inet.notification.NotificationManager;
import com.inet.notification.PermissionNotificationGenerator;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.Executable;
import com.inet.plugin.ServerPluginDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.fs.ArchiveFile;
import com.inet.plugin.fs.FileResourceFile;
import com.inet.plugin.fs.PersistenceResourceFile;
import com.inet.plugin.fs.ResourceFile;
import com.inet.plugin.fs.ServletResourceFile;
import com.inet.plugin.website.WebsiteDownloadConnector;
import com.inet.plugin.website.WellKnownWebsites;
import com.inet.plugin.website.data.WebsiteDownloadResponseData;
import com.inet.process.ProcessStarter;
import com.inet.search.AbstractSearchDataCache;
import com.inet.search.SearchDataCache;
import com.inet.search.SearchTag;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.tokenizers.CollectionSearchTokenizer;
import com.inet.search.tokenizers.NoTokenTokenizer;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.search.tokenizers.TextSearchTokenizer;
import com.inet.shared.servlet.ServletUtils;
import com.inet.shared.utils.Version;
import com.inet.store.client.PluginStoreClientPlugin;
import com.inet.store.client.internal.ArtifactKey;
import com.inet.store.client.internal.MavenChannel;
import com.inet.store.client.internal.PluginDetail;
import com.inet.store.client.internal.ReleaseNotesUtils;
import com.inet.store.client.internal.ScreenshotKey;
import com.inet.store.client.internal.StateStorage;
import com.inet.store.client.internal.c;
import com.inet.store.client.internal.d;
import com.inet.store.client.shared.AvailableState;
import com.inet.store.client.shared.InstallSource;
import com.inet.store.client.shared.PluginChangesResponseData;
import com.inet.store.client.shared.PluginMergedDetails;
import com.inet.store.client.shared.PluginStoreFilter;
import com.inet.thread.ThreadUtils;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;

@InternalApi
public class PluginConfigManager {
    private static final String j = WellKnownWebsites.STORE_BASE_URL + "api/pluginstore/v1";
    private static PluginConfigManager k;
    public static final I18nMessages MSG;
    private final StateStorage l = new StateStorage();
    private final MemoryStoreMap<String, Object> m = new MemoryStoreMap(300, true);
    private static final ConfigValue<Map<String, Boolean>> n;
    public static final ConfigValue<Boolean> STORE_BETAVERSION;
    @Nonnull
    private static final GUID o;
    @Nonnull
    private static final GUID p;
    public static final ConfigValue<Integer> STORE_UPDATEINTERVAL;
    private final Map<String, com.inet.store.client.internal.b> q = new ConcurrentHashMap<String, com.inet.store.client.internal.b>();
    private final Map<String, ServerPluginDescription> r = new ConcurrentHashMap<String, ServerPluginDescription>();
    private final List<c> s = new CopyOnWriteArrayList<c>();
    private final boolean deinstallable;
    private b t;
    private PluginStoreFilter u;
    public static final String PLUGIN_INETCORE_ID = "inetcore";
    public static final String PLUGIN_REPORTING_ID = "reporting";
    public static final String PLUGIN_HELPDESK_ID = "helpdesk";
    public static final String PLUGIN_COWORK_ID = "cowork";
    public static final String PLUGIN_PDFC_ID = "pdfc";
    private static final AtomicBoolean v;
    private List<String> w;

    public PluginConfigManager() {
        boolean bl = this.deinstallable = !this.isPublicStore() && ServerPluginManager.getInstance().getPluginDir() instanceof FileResourceFile;
        if (!this.isPublicStore()) {
            this.u = (PluginStoreFilter)ServerPluginManager.getInstance().getOptionalInstance(PluginStoreFilter.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PluginConfigManager getInstance() {
        if (k != null) return k;
        PluginConfigManager pluginConfigManager = (PluginConfigManager)ServerPluginManager.getInstance().getOptionalInstance(PluginConfigManager.class);
        Class<PluginConfigManager> clazz = PluginConfigManager.class;
        synchronized (PluginConfigManager.class) {
            k = pluginConfigManager != null ? pluginConfigManager : new PluginConfigManager();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return k;
        }
    }

    public boolean isPublicStore() {
        return false;
    }

    public Set<ArtifactKey> getAvailableMinorVersions() throws IOException {
        throw new UnsupportedOperationException();
    }

    private boolean a(@Nullable List<String> list, Certificate @Nonnull [] certificateArray) {
        if (list == null || list.size() != certificateArray.length) {
            return false;
        }
        for (int i2 = 0; i2 < certificateArray.length; ++i2) {
            Certificate certificate = certificateArray[i2];
            String string = ((X509Certificate)certificate).getSerialNumber().toString();
            if (string.equals(list.get(i2))) continue;
            return false;
        }
        return true;
    }

    private void a(@Nonnull HttpURLConnection httpURLConnection) throws IOException {
        Certificate[] certificateArray;
        boolean bl;
        List list = this.w;
        if (list == null) {
            this.w = list = this.a("/certificate", null, List.class, new Type[]{String.class});
        }
        boolean bl2 = bl = !this.a(list, certificateArray = ((HttpsURLConnection)httpURLConnection).getServerCertificates());
        if (bl) {
            this.w = list = this.a("/certificate", null, List.class, new Type[]{String.class});
            bl = !this.a(list, certificateArray);
        }
        if (v.compareAndSet(!bl, bl)) {
            GlobalBannerManager globalBannerManager = GlobalBannerManager.getInstance();
            if (bl) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Certificate certificate : certificateArray) {
                    int n2;
                    String string;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(" => ");
                    }
                    if ((string = ((X509Certificate)certificate).getSubjectX500Principal().getName()).startsWith("CN=")) {
                        string = string.substring(3);
                    }
                    if ((n2 = string.indexOf(44)) > 0) {
                        string = string.substring(0, n2);
                    }
                    stringBuilder.append(string);
                    LogManager.getConfigLogger().error((Object)certificate);
                }
                globalBannerManager.registerGlobalBanner((GlobalBanner)new com.inet.store.client.internal.a(j, stringBuilder.toString()));
            } else {
                globalBannerManager.unregisterGlobalBanner("store.wrong.certificate");
            }
        }
        if (bl) {
            throw new SSLException("Man-in-the-middle detected");
        }
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Input come from plugin store")
    private InputStream a(String string, Object object) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(j + string).openConnection();
        httpURLConnection.setConnectTimeout(5000);
        httpURLConnection.setReadTimeout(15000);
        httpURLConnection.setInstanceFollowRedirects(true);
        httpURLConnection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        httpURLConnection.setRequestProperty("Accept", "application/json; charset=utf-8");
        httpURLConnection.setRequestProperty("User-Agent", UserAgent.getUserAgent((String)"pluginstore"));
        if (object != null) {
            httpURLConnection.setDoOutput(true);
            new Json().toJson(object, httpURLConnection.getOutputStream());
        }
        InputStream inputStream = httpURLConnection.getInputStream();
        if (httpURLConnection instanceof HttpsURLConnection && !string.endsWith("/certificate")) {
            this.a(httpURLConnection);
        }
        return new FastBufferedInputStream(inputStream);
    }

    @Nullable
    private <T> T a(String string, Object object, Class<T> clazz, Type ... typeArray) {
        Long l2 = System.currentTimeMillis();
        this.l.b("lastStoreQueryTime", l2);
        try {
            InputStream inputStream = this.a(string, object);
            Object object2 = new Json().fromJson(inputStream, clazz, typeArray);
            this.l.g("serverError");
            this.l.b("lastSuccessStoreQueryTime", l2);
            return (T)object2;
        }
        catch (Throwable throwable) {
            this.l.b("serverError", StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable));
            LogManager.getConfigLogger().warn((Object)(String.valueOf(throwable) + " on connect to " + j));
            if ("/certificate".equals(string)) {
                throw (RuntimeException)ErrorCode.throwAny((Throwable)throwable);
            }
            return null;
        }
    }

    @Nonnull
    protected List<ArtifactKey> storeListAllPlugins() {
        List<ArtifactKey> list = this.l.a("storeAllPlugins", List.class, new Type[]{ArtifactKey.class});
        return list != null ? list : Collections.emptyList();
    }

    @Nonnull
    private List<ArtifactKey> f() {
        StringBuilder stringBuilder = new StringBuilder("/list/").append(ApplicationDescription.get().getStoreProductId()).append('/').append("25.10.233").append("/Beta");
        List list = this.a(stringBuilder.toString(), null, List.class, new Type[]{ArtifactKey.class});
        if (list != null) {
            if (this.u != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ArtifactKey artifactKey = (ArtifactKey)iterator.next();
                    if (this.u.test(artifactKey.getId())) continue;
                    iterator.remove();
                }
            }
            this.l.b("storeAllPlugins", list);
            return list;
        }
        return this.storeListAllPlugins();
    }

    protected static Map<String, Map<String, List<ArtifactKey>>> groupArtifactkeys(@Nonnull Collection<? extends ArtifactKey> keys) {
        HashMap<String, Map<String, List<ArtifactKey>>> hashMap = new HashMap<String, Map<String, List<ArtifactKey>>>();
        for (ArtifactKey artifactKey : keys) {
            Version version;
            String string;
            List<ArtifactKey> list;
            String string2 = artifactKey.getId();
            Map<String, List<ArtifactKey>> map = hashMap.get(string2);
            if (map == null) {
                map = new HashMap<String, List<ArtifactKey>>();
                hashMap.put(string2, map);
            }
            if ((list = map.get(string = (version = artifactKey.getVersionValue()).getMajor() + "." + version.getMinor())) == null) {
                list = new ArrayList<ArtifactKey>();
                map.put(string, list);
            }
            list.add(artifactKey);
        }
        return hashMap;
    }

    @Nonnull
    protected List<PluginDetail> storePluginDetails(@Nonnull Collection<ArtifactKey> keys) {
        ArrayList<PluginDetail> arrayList = new ArrayList<PluginDetail>();
        for (ArtifactKey artifactKey : keys) {
            PluginDetail pluginDetail = this.l.a(artifactKey.getStoragePluginDetailKey(), PluginDetail.class, new Type[0]);
            if (pluginDetail == null) continue;
            arrayList.add(pluginDetail);
        }
        return arrayList;
    }

    @Nonnull
    private List<PluginDetail> a(@Nonnull Collection<ArtifactKey> hashSet) {
        HashSet hashSet2 = this.l.a("PluginRefreshKeys", HashSet.class, new Type[]{ArtifactKey.class});
        if (hashSet2 != null) {
            hashSet2.addAll(hashSet);
            hashSet = hashSet2;
        }
        if (hashSet.isEmpty()) {
            return Collections.emptyList();
        }
        this.l.b("PluginRefreshKeys", hashSet);
        List list = this.a("/details", hashSet, List.class, new Type[]{PluginDetail.class});
        if (list != null) {
            list.parallelStream().forEach(pluginDetail -> {
                pluginDetail.saveTeaser(this.l);
                this.l.b(pluginDetail.getStoragePluginDetailKey(), pluginDetail);
            });
            ForkJoinPool.commonPool().execute(() -> {
                for (PluginDetail pluginDetail : list) {
                    Map map;
                    Object object;
                    Object object2;
                    try {
                        InputStream inputStream = this.a("/changes", new ArtifactKey(pluginDetail));
                        object2 = (PluginChangesResponseData)new Json().fromJson(inputStream, PluginChangesResponseData.class);
                        object = Objects.requireNonNullElse(((PluginChangesResponseData)object2).getChangelogs(), Collections.emptyMap());
                        for (Map.Entry entry : object.entrySet()) {
                            this.l.b(pluginDetail.getStorageChangelogKey((String)entry.getKey()), entry.getValue());
                        }
                        map = Objects.requireNonNullElse(((PluginChangesResponseData)object2).getMigrations(), Collections.emptyMap());
                        for (Map.Entry entry : map.entrySet()) {
                            this.l.b(pluginDetail.getStorageMigrationKey((String)entry.getKey()), entry.getValue());
                        }
                        Collection object32 = Stream.concat(object.keySet().stream(), map.keySet().stream()).collect(Collectors.toSet());
                        this.l.b(pluginDetail.getStorageChangelogKey("changes"), object32);
                    }
                    catch (IOException iOException) {
                        LogManager.getConfigLogger().error((Object)("Changelogs and Migration info not found for plugin: '" + pluginDetail.getId() + "' with message: " + StringFunctions.getUserFriendlyErrorMessage((Throwable)iOException)));
                    }
                    int n2 = pluginDetail.getScreenshotCount();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        try {
                            object = this.a("/screenshot", new ScreenshotKey(pluginDetail, i2));
                            map = (Map)IOFunctions.readBytes((InputStream)object);
                            this.l.b(pluginDetail.getStorageScreenshotKey(i2), map);
                            continue;
                        }
                        catch (IOException iOException) {
                            LogManager.getConfigLogger().error((Object)("Screenshot not found: " + pluginDetail.getId()));
                        }
                    }
                    while (this.l.exists((String)(object2 = pluginDetail.getStorageScreenshotKey(n2)))) {
                        this.l.g((String)object2);
                        ++n2;
                    }
                }
                if (!list.isEmpty()) {
                    this.clearCache();
                }
                this.l.g("PluginRefreshKeys");
            });
            return list;
        }
        return Collections.emptyList();
    }

    @Nullable
    public String getServerError() {
        return this.l.a("serverError", String.class, new Type[0]);
    }

    public long getLastStoreQueryTime() {
        Long l2 = this.l.a("lastStoreQueryTime", Long.class, new Type[0]);
        return l2 == null ? 0L : l2;
    }

    public long getLastSuccessfulStoreQueryTime() {
        Long l2 = this.l.a("lastSuccessStoreQueryTime", Long.class, new Type[0]);
        return l2 == null ? 0L : l2;
    }

    @Nonnull
    public IndexSearchEngine<PluginMergedDetails> getSearchEngine(boolean beta) {
        String string = "engine:" + ClientLocale.getThreadLocale().getLanguage() + beta;
        IndexSearchEngine indexSearchEngine = (IndexSearchEngine)this.m.get((Object)string);
        if (indexSearchEngine == null) {
            final List<PluginMergedDetails> list = this.getPlugins(beta);
            indexSearchEngine = new IndexSearchEngine();
            try {
                indexSearchEngine.addTag(PluginConfigManager.a("id", (SearchTokenizer)new NoTokenTokenizer(), 0));
                indexSearchEngine.addTag(PluginConfigManager.a("name", (SearchTokenizer)TextSearchTokenizer.DEFAULT, 100000));
                indexSearchEngine.addTag(PluginConfigManager.a("description", (SearchTokenizer)TextSearchTokenizer.DEFAULT, 5000));
                indexSearchEngine.addTag(new SearchTag("category.primary", (SearchTokenizer)TextSearchTokenizer.DEFAULT, 0));
                indexSearchEngine.addTag(new SearchTag("category", (SearchTokenizer)new CollectionSearchTokenizer(), 0));
                if (this.isPublicStore()) {
                    indexSearchEngine.addTag(new SearchTag("app", (SearchTokenizer)new NoTokenTokenizer(), 0));
                    indexSearchEngine.addTag(PluginConfigManager.a("version", (SearchTokenizer)new NoTokenTokenizer(), 0));
                    indexSearchEngine.addTag(new SearchTag("flags", (SearchTokenizer)new CollectionSearchTokenizer(), 0));
                }
                indexSearchEngine.setData((SearchDataCache)new AbstractSearchDataCache<PluginMergedDetails>(){

                    public Map<String, Object> a(@Nonnull PluginMergedDetails pluginMergedDetails) {
                        return new d(pluginMergedDetails);
                    }

                    public Iterator<PluginMergedDetails> iterator() {
                        return list.iterator();
                    }

                    public /* synthetic */ Map getCacheEntry(@Nonnull Object object) {
                        return this.a((PluginMergedDetails)object);
                    }
                });
            }
            catch (IOException iOException) {
                ErrorCode.throwAny((Throwable)iOException);
            }
            this.m.put((Object)string, (Object)indexSearchEngine);
        }
        return indexSearchEngine;
    }

    @Nonnull
    public Collection<PluginMergedDetails> getPrimaryPlugins(@Nonnull String categoryId) {
        return this.getPlugins(null, categoryId, "category.primary", true, null, null);
    }

    @Nonnull
    public Collection<PluginMergedDetails> getPlugins(@Nullable String searchTerm, @Nullable String categoryId, boolean beta, @Nullable String app, String minorVersion) {
        return this.getPlugins(searchTerm, categoryId, "category", beta, app, minorVersion);
    }

    @Nonnull
    public Collection<PluginMergedDetails> getPlugins(@Nullable String searchTerm, @Nullable String categoryId, @Nonnull String categoryKey, boolean beta, @Nullable String app, String minorVersion) {
        OrSearchExpression orSearchExpression;
        TextSearchCommandBuilder textSearchCommandBuilder;
        SearchCommand searchCommand;
        IndexSearchEngine<PluginMergedDetails> indexSearchEngine = this.getSearchEngine(beta);
        if (StringFunctions.isEmpty((String)searchTerm)) {
            searchCommand = new SearchCommand(new SearchExpression[0]);
        } else {
            textSearchCommandBuilder = new TextSearchCommandBuilder(indexSearchEngine, searchTerm);
            searchCommand = textSearchCommandBuilder.build();
        }
        textSearchCommandBuilder = searchCommand.getSearchExpression();
        if (!StringFunctions.isEmpty((String)categoryId)) {
            textSearchCommandBuilder.add((SearchExpression)new SearchCondition(categoryKey, SearchCondition.SearchTermOperator.Equals, (Object)categoryId));
        }
        if (!StringFunctions.isEmpty((String)app)) {
            orSearchExpression = new HashSet();
            orSearchExpression.add(PLUGIN_INETCORE_ID);
            orSearchExpression.add(PLUGIN_COWORK_ID);
            orSearchExpression.add(app);
            OrSearchExpression orSearchExpression2 = new OrSearchExpression();
            orSearchExpression2.add((Object)new SearchCondition("app", SearchCondition.SearchTermOperator.IN, (Object)orSearchExpression));
            orSearchExpression2.add((Object)new SearchCondition("flags", SearchCondition.SearchTermOperator.Equals, (Object)app));
            textSearchCommandBuilder.add((SearchExpression)orSearchExpression2);
        }
        if (!StringFunctions.isEmpty((String)minorVersion)) {
            orSearchExpression = new OrSearchExpression();
            orSearchExpression.add((Object)new SearchCondition("version", SearchCondition.SearchTermOperator.Equals, (Object)minorVersion));
            orSearchExpression.add((Object)new SearchCondition("version", SearchCondition.SearchTermOperator.StartsWith, (Object)(minorVersion + ".")));
            textSearchCommandBuilder.add((SearchExpression)orSearchExpression);
        }
        if (textSearchCommandBuilder.isEmpty()) {
            textSearchCommandBuilder.add((SearchExpression)new SearchCondition("name", SearchCondition.SearchTermOperator.StartsWith, (Object)""));
        }
        return indexSearchEngine.simpleSearch(searchCommand);
    }

    @Nonnull
    protected Set<String> getInstalledPluginsIDs() {
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(serverPluginManager.getAvailablePlugins()));
        hashSet.addAll(this.r.keySet());
        return hashSet;
    }

    /*
     * WARNING - void declaration
     */
    @Nonnull
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Input come from admin")
    protected List<PluginMergedDetails> getPlugins(boolean beta) {
        Object object;
        Object object2;
        Map<String, List<ArtifactKey>> map;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Locale locale = ClientLocale.getThreadLocale();
        Map<String, Map<String, List<ArtifactKey>>> map2 = PluginConfigManager.groupArtifactkeys(this.storeListAllPlugins());
        ArrayList<PluginMergedDetails> arrayList = new ArrayList<PluginMergedDetails>();
        File file = this.a(false);
        boolean bl = ConfigurationManager.isRecoveryMode();
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        for (String object92 : this.getInstalledPluginsIDs()) {
            void var12_14;
            boolean list;
            if (this.q.get(object92) == com.inet.store.client.internal.b.g) continue;
            Object object7 = object6 = this.a(object92, bl) ? AvailableState.Activated : AvailableState.Deactivated;
            if (bl) {
                Object var12_15 = null;
                list = object6 == AvailableState.Activated;
            } else {
                list = serverPluginManager.isPluginLoaded(object92);
                object5 = serverPluginManager.getPluginLoadError(object92);
                if (object5 instanceof Throwable) {
                    String string = MSG.getMsg("err.fatal", new Object[]{StringFunctions.getUserFriendlyErrorMessage((Throwable)((Throwable)object5))});
                } else if (object5 == ServerPluginManager.PluginLoadFailCause.DISABLED) {
                    Object var12_17 = null;
                } else if (object5 == ServerPluginManager.PluginLoadFailCause.DEPENDENCY) {
                    String string = MSG.getMsg("plugin.error.dependency", new Object[0]);
                } else if (object5 == ServerPluginManager.PluginLoadFailCause.VERSION) {
                    String string = MSG.getMsg("plugin.error.version", new Object[0]);
                } else if (object5 != null) {
                    String string = object5.toString();
                } else {
                    Object var12_21 = null;
                }
            }
            object5 = this.a(object92);
            if (object5 == null) continue;
            Version version = object5.getVersion();
            object4 = null;
            object3 = null;
            map = map2.remove(object92);
            if (map != null) {
                object2 = (List)map.values().iterator().next();
                object2.sort((artifactKey, artifactKey2) -> artifactKey2.getVersionValue().compareTo(artifactKey.getVersionValue()));
                for (int i2 = 0; i2 < object2.size() && !version.isHigherOrEquals(((ArtifactKey)(object = (ArtifactKey)object2.get(i2))).getVersionValue()); ++i2) {
                    if (beta || MavenChannel.Release == ((ArtifactKey)object).getChannel()) {
                        object4 = object;
                        break;
                    }
                    if (object3 != null) continue;
                    object3 = ((ArtifactKey)object).getVersion();
                }
                if ((object4 != null || beta && object3 != null) && object6 != AvailableState.Deactivated && (!PLUGIN_INETCORE_ID.equals(object92) || file != null)) {
                    object6 = AvailableState.Updateable;
                }
            }
            object2 = this.a((ServerPluginDescription)object5, locale, (AvailableState)((Object)object6), (String)var12_14, list, (ArtifactKey)object4, (String)object3);
            arrayList.add((PluginMergedDetails)object2);
        }
        ArrayList arrayList2 = new ArrayList();
        HashMap<CallSite, String> hashMap = new HashMap<CallSite, String>();
        object6 = new HashMap();
        for (Map<String, List<ArtifactKey>> map3 : map2.values()) {
            block5: for (Map.Entry entry : map3.entrySet()) {
                object4 = (List)entry.getValue();
                object4.sort((artifactKey, artifactKey2) -> artifactKey2.getVersionValue().compareTo(artifactKey.getVersionValue()));
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    map = (ArtifactKey)object3.next();
                    if (!beta && ((ArtifactKey)((Object)map)).getChannel() == MavenChannel.Beta) {
                        hashMap.put((CallSite)((Object)(((ArtifactKey)((Object)map)).getId() + (String)entry.getKey())), ((ArtifactKey)((Object)map)).getVersion());
                        continue;
                    }
                    if ("jar".equals(((ArtifactKey)((Object)map)).getClassifier())) {
                        object2 = new File(file, ((ArtifactKey)((Object)map)).getId() + ".jar");
                        if (file == null || !((File)object2).exists()) continue;
                        if (!((HashMap)object6).containsKey(((ArtifactKey)((Object)map)).getId())) {
                            a a2 = null;
                            try {
                                object = new File(new File(file, "pending-update"), ((ArtifactKey)((Object)map)).getId() + ".jar");
                                a2 = this.a((File)(((File)object).exists() ? object : object2));
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            ((HashMap)object6).put(((ArtifactKey)((Object)map)).getId(), a2);
                        }
                    }
                    arrayList2.add(map);
                    continue block5;
                }
            }
        }
        List<PluginDetail> list = this.storePluginDetails(arrayList2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object8;
            AvailableState availableState;
            object5 = (PluginDetail)iterator.next();
            String string = ((PluginDetail)object5).getApp();
            object4 = ((ArtifactKey)object5).getId();
            map = object3 = ((ArtifactKey)object5).getVersion();
            object2 = ((ArtifactKey)object5).getVersionValue();
            String string2 = ((PluginDetail)object5).getDisplayName(locale);
            object = ((PluginDetail)object5).getDescription(locale);
            List<String> list2 = ((PluginDetail)object5).getCategories();
            boolean bl2 = false;
            boolean bl3 = true;
            boolean bl4 = this.deinstallable;
            AvailableState availableState2 = this.q.get(object4) != com.inet.store.client.internal.b.f ? AvailableState.Installable : (availableState = this.a((String)object4, bl) ? AvailableState.Activated : AvailableState.Deactivated);
            if (((HashMap)object6).containsKey(object4)) {
                availableState = AvailableState.Updateable;
                object8 = (a)((HashMap)object6).get(object4);
                if (object8 != null) {
                    object3 = ((a)object8).version;
                    if (object8 != null && new Version((String)object3).isHigherOrEquals((Version)object2)) {
                        availableState = AvailableState.Activated;
                        map = null;
                    }
                }
                bl2 = true;
                bl4 = false;
                bl3 = false;
            }
            object8 = new PluginMergedDetails(string, (String)object4, (String)object3, availableState, null, bl2, string2, (String)object, list2, ((PluginDetail)object5).getIcon(), ((PluginDetail)object5).getTeaser(this.l), ((PluginDetail)object5).getScreenshotCount(), ((PluginDetail)object5).getScreenshots(this.l), ((PluginDetail)object5).getChanges(this.l), ((PluginDetail)object5).getGeneralLogs(this.l, locale), ((PluginDetail)object5).getChangelogs(this.l, locale), ((PluginDetail)object5).getMigrations(this.l, locale), ((PluginDetail)object5).getDependencies(), ((PluginDetail)object5).getOptionalDependencies(), ((PluginDetail)object5).getArtifactSize(), (String)((Object)map), (String)hashMap.get((String)object4 + object2.getMajor() + "." + object2.getMinor()), false, ((ArtifactKey)object5).getChannel(), InstallSource.Unknown, bl3, bl4, ((PluginDetail)object5).getFlags());
            arrayList.add((PluginMergedDetails)object8);
        }
        return arrayList;
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="No user input for URl is used.")
    private PluginMergedDetails a(@Nonnull ServerPluginDescription serverPluginDescription, @Nonnull Locale locale, AvailableState availableState, String string2, boolean bl, ArtifactKey artifactKey, String string3) {
        boolean bl2;
        Set set;
        Set set2;
        long l2;
        Function<String, String> function;
        Function<String, String> function2;
        Function<String, String> function3;
        IntFunction<byte[]> intFunction;
        int n3;
        String string4;
        Collection<String> collection;
        Supplier<byte[]> supplier;
        Object object2;
        byte[] byArray;
        List<String> list;
        String string5;
        String string6;
        PluginDetail pluginDetail;
        MavenChannel mavenChannel;
        String string7;
        if (artifactKey == null) {
            string7 = null;
            mavenChannel = null;
            pluginDetail = null;
        } else {
            string7 = artifactKey.getVersion();
            mavenChannel = artifactKey.getChannel();
            pluginDetail = this.l.a(artifactKey.getStoragePluginDetailKey(), PluginDetail.class, new Type[0]);
        }
        String string8 = serverPluginDescription.getVersionString();
        String string9 = null;
        String string10 = serverPluginDescription.getId();
        ResourceFile resourceFile = serverPluginDescription.getLocation();
        if (pluginDetail == null) {
            string6 = serverPluginDescription.getDisplayName("id", locale);
            string5 = serverPluginDescription.getDescription(locale);
            list = Arrays.asList(serverPluginDescription.getGroup().split(";"));
            Map<String, byte[]> map = this.c(serverPluginDescription);
            byArray = map.get("icon.svg");
            if (byArray == null) {
                byArray = PluginConfigManager.a(serverPluginDescription.getIcon());
            }
            supplier = (object2 = map.get("teaser.png")) != null ? () -> PluginConfigManager.b((byte[])object2) : null;
            ArrayList<String> arrayList = new ArrayList<String>();
            collection = new HashSet<String>();
            for (Map.Entry<String, byte[]> object3 : map.entrySet()) {
                String string11;
                string4 = object3.getKey();
                if (string4.startsWith("screenshot_")) {
                    arrayList.add(string4);
                    continue;
                }
                if (string4.startsWith("migration/migration.") && string4.endsWith(".txt")) {
                    string11 = ReleaseNotesUtils.createLocalizedChanges(PluginConfigManager.a(object3.getValue()), "migration", locale.getLanguage());
                    if (StringFunctions.isEmpty((String)string11)) continue;
                    collection.add(string4.substring("migration/migration.".length(), string4.length() - 4));
                    continue;
                }
                if (!string4.startsWith("changelog/changelog.") || !string4.endsWith(".txt") || StringFunctions.isEmpty((String)(string11 = ReleaseNotesUtils.createLocalizedChanges(PluginConfigManager.a(object3.getValue()), "changes", locale.getLanguage())))) continue;
                collection.add(string4.substring("changelog/changelog.".length(), string4.length() - 4));
            }
            n3 = arrayList.size();
            intFunction = n2 -> {
                Map<String, byte[]> map = this.c(serverPluginDescription);
                return map.get(arrayList.get(n2));
            };
            function3 = string -> {
                Map<String, byte[]> map = this.c(serverPluginDescription);
                byte[] byArray = map.get("migration/migration." + string + ".txt");
                return ReleaseNotesUtils.createLocalizedChanges(PluginConfigManager.a(byArray), "migration", locale.getLanguage());
            };
            function2 = string -> {
                Map<String, byte[]> map = this.c(serverPluginDescription);
                byte[] byArray = map.get("changelog/changelog." + string + ".txt");
                return ReleaseNotesUtils.createLocalizedChanges(PluginConfigManager.a(byArray), "changes", locale.getLanguage());
            };
            function = string -> {
                Map<String, byte[]> map = this.c(serverPluginDescription);
                byte[] byArray = map.get("changelog/changelog." + string + ".txt");
                return ReleaseNotesUtils.createLocalizedChanges(PluginConfigManager.a(byArray), "general", locale.getLanguage());
            };
            if (resourceFile != null) {
                l2 = resourceFile.length();
            } else {
                try {
                    URL uRL = serverPluginDescription.getServerPlugin().getClass().getProtectionDomain().getCodeSource().getLocation();
                    URLConnection uRLConnection = uRL.openConnection();
                    l2 = uRLConnection.getContentLength();
                    uRLConnection.getInputStream().close();
                }
                catch (Throwable throwable) {
                    l2 = -1L;
                }
            }
            set2 = serverPluginDescription.getDependencyIds();
            set = serverPluginDescription.getOptionalDependencyIds();
        } else {
            string6 = pluginDetail.getDisplayName(locale);
            string5 = pluginDetail.getDescription(locale);
            list = pluginDetail.getCategories();
            byArray = pluginDetail.getIcon();
            supplier = pluginDetail.getTeaser(this.l);
            n3 = pluginDetail.getScreenshotCount();
            intFunction = pluginDetail.getScreenshots(this.l);
            collection = pluginDetail.getChanges(this.l);
            function = pluginDetail.getGeneralLogs(this.l, locale);
            function2 = pluginDetail.getChangelogs(this.l, locale);
            function3 = pluginDetail.getMigrations(this.l, locale);
            l2 = pluginDetail.getArtifactSize();
            set2 = pluginDetail.getDependencies();
            set = pluginDetail.getOptionalDependencies();
        }
        boolean bl3 = PluginConfigManager.b(serverPluginDescription);
        object2 = (Object)this.b(string10);
        boolean bl4 = this.a(serverPluginDescription);
        boolean bl5 = bl2 = !this.isPublicStore() && (resourceFile instanceof FileResourceFile || resourceFile instanceof PersistenceResourceFile);
        if (bl2 && !bl4) {
            List list2 = ServerPluginManager.getInstance().getPluginDirs();
            if (list2.size() == 1 || resourceFile == null) {
                bl2 = false;
            } else {
                string4 = (ResourceFile)list2.get(list2.size() - 1);
                bl2 = resourceFile.getPath().startsWith(string4.getPath());
            }
        }
        return new PluginMergedDetails(string9, string10, string8, availableState, string2, bl, string6, string5, list, byArray, supplier, n3, intFunction, collection, function, function2, function3, set2, set, l2, string7, string3, bl3, mavenChannel, (InstallSource)((Object)object2), bl4, bl2, serverPluginDescription.getFlags());
    }

    private boolean a(ServerPluginDescription serverPluginDescription) {
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        String string = serverPluginManager.getCorePluginId();
        String string2 = serverPluginDescription.getId();
        if (serverPluginDescription.getFlags().contains("core") || serverPluginDescription.getFlags().contains("hidden") || string2.equals(string)) {
            return false;
        }
        for (String string3 : serverPluginManager.getAvailablePlugins()) {
            ServerPluginDescription serverPluginDescription2 = this.a(string3);
            if (serverPluginDescription2 == null || !serverPluginDescription2.getDependencyIds().contains(string2) || !serverPluginDescription2.getFlags().contains("core") && !serverPluginDescription2.getFlags().contains("hidden") && !string3.equals(string)) continue;
            return false;
        }
        return true;
    }

    private static boolean b(@Nonnull ServerPluginDescription serverPluginDescription) {
        List list = ServerPluginManager.getInstance().getPluginDirs();
        if (list.size() == 1) {
            return false;
        }
        String string = serverPluginDescription.getId();
        String string2 = string + ".zip";
        for (ResourceFile resourceFile : list) {
            if (resourceFile.createChild(string2).exists()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public PluginMergedDetails getPlugin(String id, boolean beta, String minorVersion) {
        Object object;
        IndexSearchEngine<PluginMergedDetails> indexSearchEngine = this.getSearchEngine(beta);
        SearchCommand searchCommand = new SearchCommand("id", SearchCondition.SearchTermOperator.Equals, (Object)id);
        if (!StringFunctions.isEmpty((String)minorVersion)) {
            object = new OrSearchExpression();
            object.add((Object)new SearchCondition("version", SearchCondition.SearchTermOperator.Equals, (Object)minorVersion));
            object.add((Object)new SearchCondition("version", SearchCondition.SearchTermOperator.StartsWith, (Object)(minorVersion + ".")));
            searchCommand.getSearchExpression().add((SearchExpression)object);
        }
        return (object = indexSearchEngine.simpleSearch(searchCommand)).isEmpty() ? null : (PluginMergedDetails)object.iterator().next();
    }

    public List<LocalizedKey> getCategories(boolean beta, String app, String minorVersion) {
        return this.a(beta, app, minorVersion, false);
    }

    private List<LocalizedKey> a(boolean bl, String string, String string2, boolean bl2) {
        ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
        HashSet<String> hashSet = new HashSet<String>();
        for (PluginMergedDetails pluginMergedDetails : this.getPlugins(null, null, bl, string, string2)) {
            for (String string3 : pluginMergedDetails.getCategories()) {
                String string4;
                if (!hashSet.add(string3)) continue;
                try {
                    string4 = ServerPluginDescription.PLUGIN_CATEGORIES_MSG.getBundle(ClientLocale.getThreadLocale()).getString("group." + string3);
                }
                catch (MissingResourceException missingResourceException) {
                    Map map;
                    ServerPluginDescription serverPluginDescription = this.a(pluginMergedDetails.getId());
                    if (serverPluginDescription != null && pluginMergedDetails.getCategories().size() == 1) {
                        string4 = serverPluginDescription.getDisplayName("group", ClientLocale.getThreadLocale());
                    }
                    if (bl2) {
                        map = this.a("/category/" + string3, hashSet, Map.class, new Type[]{String.class, String.class});
                        if (map != null) {
                            this.l.b("category-" + string3, map);
                        }
                    } else {
                        map = this.l.a("category-" + string3, Map.class, new Type[]{String.class, String.class});
                    }
                    string4 = map != null ? PluginDetail.getLocalizedData(ClientLocale.getThreadLocale(), map, string3) : string3;
                }
                arrayList.add(new LocalizedKey(string3, string4));
            }
        }
        return arrayList;
    }

    public void downloadPlugin(String id, boolean beta, String minorVersion) throws IOException {
        PluginMergedDetails pluginMergedDetails = this.getPlugin(id, beta, minorVersion);
        if (pluginMergedDetails == null) {
            LogManager.getConfigLogger().error((Object)("Download plugin " + id + " with version " + minorVersion + " not found"));
            throw new IOException("Plugin ID '" + id + "' is not available.");
        }
        String string = pluginMergedDetails.getUpdatedVersion();
        MavenChannel mavenChannel = pluginMergedDetails.getUpdatedChannel();
        LogManager.getConfigLogger().info((Object)("Download plugin " + id + " with version " + minorVersion + " find version " + string + " on channel " + String.valueOf((Object)mavenChannel)));
        if (string == null || mavenChannel == null) {
            LogManager.getConfigLogger().info((Object)("No download available for: " + id + " - This plugin may have been installed in parallel."));
            return;
        }
        ArtifactKey artifactKey = ArtifactKey.from(id, null, string, mavenChannel);
        try {
            this.a(artifactKey);
        }
        catch (UnknownHostException unknownHostException) {
            LogManager.getConfigLogger().debug((Object)unknownHostException);
            throw new LocalizedIOException(() -> MSG.getMsg("err.downloadUnknownHost", new Object[]{pluginMergedDetails.getName(), unknownHostException.getMessage()}), (Throwable)unknownHostException);
        }
        catch (IOException iOException) {
            LogManager.getConfigLogger().debug((Object)iOException);
            throw new LocalizedIOException(() -> MSG.getMsg("err.download", new Object[]{pluginMergedDetails.getName(), StringFunctions.getUserFriendlyErrorMessage((Throwable)iOException)}), (Throwable)iOException);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Input come from admin")
    void a(@Nonnull ArtifactKey artifactKey) throws IOException {
        this.j();
        try (InputStream inputStream = this.a("/download", new ArtifactKey(artifactKey));){
            InstallSource installSource = MavenChannel.Release == artifactKey.getChannel() ? InstallSource.Release : InstallSource.Beta;
            this.a(inputStream, installSource, SystemEventLog.PluginInstalled);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Input come from admin")
    public void uninstallPlugin(@Nonnull String id, boolean onlyUpdate) {
        this.j();
        List list = ServerPluginManager.getInstance().getPluginDirs();
        if (onlyUpdate) {
            ServerPluginDescription serverPluginDescription;
            ResourceFile resourceFile = (ResourceFile)list.get(list.size() - 1);
            this.a(id, resourceFile);
            resourceFile = ((ResourceFile)list.get(0)).createChild(id + ".zip");
            if (resourceFile.exists() && (serverPluginDescription = ServerPluginDescription.create((ResourceFile)resourceFile, null, (Logger)LogManager.getConfigLogger())) != null) {
                this.r.put(id, serverPluginDescription);
                this.m.clear();
                return;
            }
        } else {
            ResourceFile resourceFile2;
            for (ResourceFile resourceFile2 : list) {
                this.a(id, resourceFile2);
            }
            ServerPluginDescription serverPluginDescription = this.a(id);
            if (serverPluginDescription != null && (resourceFile2 = serverPluginDescription.getLocation()) != null) {
                new File(resourceFile2.toString()).delete();
            }
        }
        SystemEventLog.PluginUninstalled.log(new Object[]{id});
        this.r.remove(id);
        this.q.put(id, com.inet.store.client.internal.b.g);
        this.a(id, InstallSource.Unknown);
        this.m.clear();
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Input come from admin")
    private void a(String string, ResourceFile resourceFile) {
        if (resourceFile instanceof FileResourceFile) {
            File file = ((FileResourceFile)resourceFile).getFile();
            File file2 = new File(file, string + ".zip");
            file2.delete();
        } else if (resourceFile instanceof PersistenceResourceFile) {
            PersistenceEntry persistenceEntry = ((PersistenceResourceFile)resourceFile).getEntry();
            PersistenceEntry persistenceEntry2 = persistenceEntry.resolve(string + ".zip");
            persistenceEntry2.deleteValue();
        }
    }

    @Nullable
    public ArtifactKey uploadPlugin(InputStream input) throws IOException, ClientMessageException {
        return this.a(input, InstallSource.SideLoad, SystemEventLog.PluginUploaded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Input come from admin")
    private ArtifactKey a(InputStream inputStream, InstallSource installSource, SystemEventLog systemEventLog) throws IOException, ClientMessageException {
        this.j();
        List list = ServerPluginManager.getInstance().getPluginDirs();
        ResourceFile resourceFile = (ResourceFile)list.get(list.size() - 1);
        File file = null;
        try {
            Object object;
            ServerPluginDescription serverPluginDescription;
            File file2;
            if (resourceFile instanceof FileResourceFile) {
                file2 = ((FileResourceFile)resourceFile).getFile();
                file2.mkdirs();
            } else if (resourceFile instanceof PersistenceResourceFile) {
                file2 = null;
            } else {
                throw new InternalError(resourceFile.getClass().getName());
            }
            file = File.createTempFile("~tmp", ".plugin", file2);
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                IOFunctions.copyData((InputStream)inputStream, (OutputStream)fileOutputStream);
            }
            fileOutputStream = new FileResourceFile(file);
            ServerPluginDescription serverPluginDescription2 = ServerPluginDescription.create((ResourceFile)fileOutputStream, null, (Logger)LogManager.getConfigLogger());
            if (serverPluginDescription2 == null) {
                ArtifactKey artifactKey = this.a(file, installSource, systemEventLog);
                return artifactKey;
            }
            String string = serverPluginDescription2.getDependencyVersion(PLUGIN_INETCORE_ID);
            if (!StringFunctions.isEmpty((String)string) && (serverPluginDescription = this.a(PLUGIN_INETCORE_ID)) != null && !serverPluginDescription.getVersionString().startsWith(string)) {
                throw new ClientMessageException(MSG.getMsg("err.incompatibleVersion", new Object[]{serverPluginDescription2.getDisplayName("id", ClientLocale.getThreadLocale()), serverPluginDescription2.getVersionString(), serverPluginDescription.getVersionString()}));
            }
            string = serverPluginDescription2.getId();
            if (IOFunctions.isPathTraversal((String)string)) {
                serverPluginDescription = null;
                return serverPluginDescription;
            }
            serverPluginDescription = this.a(string);
            if (serverPluginDescription != null && serverPluginDescription.getVersion().isHigherThan(serverPluginDescription2.getVersion())) {
                throw new ClientMessageException(MSG.getMsg("err.newerVersionInstalled", new Object[]{serverPluginDescription2.getDisplayName("id", ClientLocale.getThreadLocale()), serverPluginDescription2.getVersionString(), serverPluginDescription.getVersionString()}));
            }
            if (resourceFile instanceof FileResourceFile) {
                object = new File(file2, string + ".zip");
                fileOutputStream = new FileResourceFile((File)object);
                try (ThreadUtils.Semaphore semaphore = PluginConfigManager.a((ResourceFile)fileOutputStream);){
                    ThreadUtils.Semaphore semaphore2 = semaphore;
                    synchronized (semaphore2) {
                        ((File)object).delete();
                        try {
                            Files.move(file.toPath(), ((File)object).toPath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (Throwable throwable) {
                            throw new ClientMessageException(MSG.getMsg("err.overridePlugin", new Object[]{serverPluginDescription2.getDisplayName("id", ClientLocale.getThreadLocale()), StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable)}));
                        }
                    }
                }
            }
            if (resourceFile instanceof PersistenceResourceFile) {
                object = ((PersistenceResourceFile)resourceFile).getEntry();
                object = object.resolve(string + ".zip");
                fileOutputStream = new PersistenceResourceFile((PersistenceEntry)object);
                try (ThreadUtils.Semaphore semaphore = PluginConfigManager.a((ResourceFile)fileOutputStream);){
                    ThreadUtils.Semaphore semaphore3 = semaphore;
                    synchronized (semaphore3) {
                        try (FileInputStream fileInputStream = new FileInputStream(file);){
                            object.setInputStream((InputStream)fileInputStream);
                        }
                    }
                }
            }
            if ((serverPluginDescription2 = ServerPluginDescription.create((ResourceFile)fileOutputStream, null, (Logger)LogManager.getConfigLogger())) == null) {
                object = null;
                return object;
            }
            this.r.put(string, serverPluginDescription2);
            this.q.put(string, com.inet.store.client.internal.b.f);
            this.a(string, installSource);
            this.m.clear();
            systemEventLog.log(new Object[]{string, serverPluginDescription2.getVersionString()});
            object = ArtifactKey.from(string, null, serverPluginDescription2.getVersionString(), MavenChannel.Uploaded);
            return object;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Input come from admin")
    private ArtifactKey a(@Nonnull File file, InstallSource installSource, SystemEventLog systemEventLog) throws IOException, ClientMessageException {
        a a2 = this.a(file);
        if (a2 == null) {
            return null;
        }
        File file2 = this.a(true);
        if (file2 == null) {
            throw new ClientMessageException(MSG.getMsg("err.coredir", new Object[0]));
        }
        String string = a2.key.getId() + ".jar";
        if (!new File(file2, string).exists()) {
            throw new ClientMessageException(MSG.getMsg("err.notcorefile", new Object[]{string, new File(file2, string)}));
        }
        File file3 = new File(file2, "pending-update");
        file3.mkdirs();
        if (!file3.isDirectory()) {
            LogManager.getConfigLogger().warn((Object)("Update directory for core file was not created: " + String.valueOf(file3)));
            throw new ClientMessageException(MSG.getMsg("err.coredir", new Object[0]));
        }
        File file4 = new File(file3, string);
        try (ThreadUtils.Semaphore semaphore = PluginConfigManager.a((ResourceFile)new FileResourceFile(file4));){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                file4.delete();
                try {
                    Files.move(file.toPath(), file4.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable) {
                    throw new ClientMessageException(MSG.getMsg("err.overridePlugin", new Object[]{string, StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable)}));
                }
            }
        }
        this.q.put(a2.id, com.inet.store.client.internal.b.f);
        semaphore = ServerPluginManager.getInstance().getPluginDescription(a2.id);
        if (semaphore != null) {
            this.r.put(a2.id, ServerPluginDescription.create((ServerPluginDescription)semaphore, (String)a2.version));
            this.a(a2.id, installSource);
            this.m.clear();
        }
        systemEventLog.log(new Object[]{a2.id, a2.version});
        return a2.key;
    }

    @Nullable
    private a a(@Nonnull File file) throws IOException {
        try (ArchiveFile archiveFile = new FileResourceFile(file).createArchiveFile();){
            ZipEntry zipEntry = archiveFile.getEntry("META-INF/MANIFEST.MF");
            if (zipEntry == null) {
                a a2 = null;
                return a2;
            }
            Properties properties = new Properties();
            properties.load(archiveFile.getInputStream(zipEntry));
            a a3 = new a();
            a3.id = properties.getProperty("Specification-Title");
            if (a3.id == null) {
                a3.id = properties.getProperty("Implementation-Title");
            }
            a3.version = properties.getProperty("Specification-Version");
            if (a3.version == null) {
                a3.version = properties.getProperty("Implementation-Version");
            }
            if (a3.id == null || a3.version == null || IOFunctions.isPathTraversal((String)a3.id)) {
                a a4 = null;
                return a4;
            }
            a3.key = ArtifactKey.from(a3.id, null, a3.version, MavenChannel.Uploaded);
            a a5 = a3;
            return a5;
        }
    }

    @Nullable
    private File a(boolean bl) {
        URL uRL = this.g();
        if (uRL == null) {
            return null;
        }
        File file = IOFunctions.getFile((URL)uRL);
        if (!(file.getName().endsWith(".jar") && ProcessStarter.isProcessStarterRunning() && Persistence.isFilePersistence())) {
            if (bl) {
                LogManager.getConfigLogger().warn((Object)("Detected core file: " + String.valueOf(file)));
            }
            return null;
        }
        return file.getParentFile();
    }

    @Nullable
    URL g() {
        return ProcessStarter.class.getProtectionDomain().getCodeSource().getLocation();
    }

    @Nullable
    private ServerPluginDescription a(String string) {
        ServerPluginDescription serverPluginDescription = this.r.get(string);
        if (serverPluginDescription != null) {
            return serverPluginDescription;
        }
        return ServerPluginManager.getInstance().getPluginDescription(string);
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Input come from plugin store")
    private static byte @Nullable [] a(@Nullable URL uRL) {
        if (uRL == null) {
            return null;
        }
        try {
            return IOFunctions.readBytes((InputStream)uRL.openStream());
        }
        catch (IOException iOException) {
            LogManager.getConfigLogger().error((Throwable)iOException);
            return null;
        }
    }

    public boolean deactivate(String targetPluginId) {
        return this.a(targetPluginId, SystemEventLog.PluginDeactivated, false);
    }

    public boolean activate(String targetPluginId) {
        return this.a(targetPluginId, SystemEventLog.PluginActivated, true);
    }

    private boolean a(String string, SystemEventLog systemEventLog, boolean bl) {
        this.j();
        systemEventLog.log(new Object[]{string});
        Configuration configuration = PluginConfigManager.h();
        Map map = (Map)n.get();
        map.put(string, bl);
        configuration.putValue(ConfigKey.PLUGINS_ACTIVATED, (Object)map);
        this.m.clear();
        boolean bl2 = ServerPluginManager.getInstance().isPluginLoaded(string);
        return bl2 != bl;
    }

    @Nonnull
    private static Configuration h() {
        Configuration configuration = null;
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        String string = ConfigurationManager.getRecoveryConfiguration();
        if (string != null) {
            configuration = configurationManager.get(string);
        }
        if (configuration == null) {
            configuration = configurationManager.getCurrent();
        }
        return configuration;
    }

    private boolean a(String string, boolean bl) {
        Boolean bl2 = (Boolean)((Map)n.get()).get(string);
        if (bl2 != null) {
            return bl2;
        }
        if (bl) {
            ServerPluginDescription serverPluginDescription = this.a(string);
            if (serverPluginDescription == null) {
                return false;
            }
            return !serverPluginDescription.getFlags().contains("optional");
        }
        return ServerPluginManager.getInstance().isPluginLoaded(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Map<String, byte[]> c(@Nonnull ServerPluginDescription serverPluginDescription) {
        Object object;
        Object object2;
        URL uRL;
        String string = "description:" + serverPluginDescription.getId();
        Map map = (TreeMap)this.m.get((Object)string);
        if (map != null) {
            return map;
        }
        map = new TreeMap();
        ResourceFile resourceFile = serverPluginDescription.getLocation();
        if (resourceFile == null && PLUGIN_INETCORE_ID.equals(serverPluginDescription.getId())) {
            try {
                uRL = this.g();
                if (uRL == null) {
                    object2 = ServletUtils.getServletContext();
                    if (object2 != null) {
                        resourceFile = new ServletResourceFile(object2, "/WEB-INF/lib/inetcore.jar");
                    }
                } else if ("file".equals(uRL.getProtocol())) {
                    object2 = IOFunctions.getFile((URL)uRL);
                    resourceFile = new FileResourceFile((File)object2);
                } else {
                    object2 = ServletUtils.getServletContext();
                    if (object2 != null) {
                        object = uRL.getPath();
                        int n2 = ((String)object).indexOf("/WEB-INF/lib/");
                        if (n2 > 0) {
                            object = ((String)object).substring(n2);
                        }
                        resourceFile = new ServletResourceFile(object2, (String)object);
                    }
                }
            }
            catch (Throwable throwable) {
                LogManager.getConfigLogger().error(throwable);
            }
        }
        if (resourceFile == null || !resourceFile.exists()) {
            map = Collections.emptyMap();
            this.m.put((Object)string, map);
            return map;
        }
        try {
            uRL = PluginConfigManager.a(resourceFile);
            try {
                object2 = uRL;
                synchronized (object2) {
                    object = resourceFile.createArchiveFile();
                    try {
                        ZipEntry zipEntry;
                        while ((zipEntry = object.getNextEntry()) != null) {
                            String string2 = zipEntry.getName();
                            if (!string2.startsWith("plugin.properties.d/")) continue;
                            String string3 = string2.substring("plugin.properties.d/".length());
                            byte[] byArray = IOFunctions.readBytes((InputStream)object.getInputStream(zipEntry));
                            map.put((String)string3, (byte[])byArray);
                        }
                    }
                    finally {
                        if (object != null) {
                            object.close();
                        }
                    }
                }
            }
            finally {
                if (uRL != null) {
                    uRL.close();
                }
            }
        }
        catch (Throwable throwable) {
            LogManager.getConfigLogger().error("Corrupt file " + String.valueOf(resourceFile), throwable);
        }
        this.m.put((Object)string, map);
        return map;
    }

    private static ThreadUtils.Semaphore a(@Nonnull ResourceFile resourceFile) {
        return ThreadUtils.getSemaphore((Object)resourceFile.getAbsolutePath());
    }

    @Nullable
    private static String a(byte @Nullable [] byArray) {
        return byArray == null ? null : new String(byArray, StandardCharsets.UTF_8);
    }

    private void a(@Nonnull String string, InstallSource installSource) {
        Map<String, InstallSource> map = this.i();
        InstallSource installSource2 = map.get(string);
        if (installSource2 == installSource) {
            return;
        }
        map.put(string, installSource);
        this.l.b("installSources", map);
    }

    @Nonnull
    private InstallSource b(@Nonnull String string) {
        Map<String, InstallSource> map = this.i();
        InstallSource installSource = map.get(string);
        return installSource == null ? InstallSource.Unknown : installSource;
    }

    @Nonnull
    private Map<String, InstallSource> i() {
        Map map = (HashMap)this.m.get((Object)"installSources");
        if (map == null) {
            map = this.l.a("installSources", Map.class, new Type[]{String.class, InstallSource.class});
            if (map == null) {
                map = new HashMap();
            }
            this.m.put((Object)"installSources", map);
        }
        return map;
    }

    public void startUpdateTask() {
        long l2;
        if (this.isPublicStore()) {
            return;
        }
        b b2 = this.t;
        b b3 = this.t = new b();
        if (b2 != null) {
            b2.cancel();
        }
        if ((l2 = ((Integer)STORE_UPDATEINTERVAL.get()).longValue()) <= 0L) {
            NotificationManager.getInstance().unregisterGenerator(o);
            NotificationManager.getInstance().clearGeneratorState(o);
            return;
        }
        ForkJoinPool.commonPool().execute(() -> {
            long l3 = l2 * 86400000L;
            long l4 = this.getLastStoreQueryTime();
            long l5 = l3 - (System.currentTimeMillis() - l4);
            if (l5 < 10000L || this.l.exists("updateRunning") || this.l.exists("PluginRefreshKeys")) {
                l5 = 10000L;
            }
            DefaultTimer.getInstance().schedule((DefaultTimerTask)b3, l5, l3);
            if (l5 > 10000L) {
                b3.a(this.getWebsiteDownload());
                b3.m();
            }
        });
    }

    public void silentUpdate(boolean forcedUpdate) {
        long l2;
        if (this.t == null) {
            return;
        }
        if (!forcedUpdate && (l2 = this.getLastStoreQueryTime()) + 3600000L > System.currentTimeMillis()) {
            return;
        }
        ForkJoinPool.commonPool().execute(() -> this.t.run());
    }

    public void blockingUpdate() {
        if (this.t == null) {
            this.startUpdateTask();
            if (this.t == null) {
                return;
            }
        }
        b b2 = this.t;
        b2.runImpl();
        b b3 = b2;
        synchronized (b3) {
            while (true) {
                if (!b2.A) {
                    return;
                }
                try {
                    ((Object)((Object)b2)).wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    ErrorCode.throwAny((Throwable)interruptedException);
                }
            }
        }
    }

    public boolean isUpdateRunning() {
        return this.l.a("updateRunning", String.class, new Type[0]) != null;
    }

    public WebsiteDownloadResponseData getWebsiteDownload() {
        return this.l.a("WebsiteDownload", WebsiteDownloadResponseData.class, new Type[0]);
    }

    public String getChangesDocument(Locale locale) {
        if (Locale.GERMAN.getLanguage().equals(locale.getLanguage())) {
            return this.l.a("ChangesDocumentDE", String.class, new Type[0]);
        }
        return this.l.a("ChangesDocumentEN", String.class, new Type[0]);
    }

    public void addListener(@Nonnull c listener) {
        this.s.add(listener);
    }

    private void j() throws AccessDeniedException {
        if (!SystemPermissionChecker.checkAccess((Permission)Permission.CONFIGURATION)) {
            throw new AccessDeniedException(Permission.CONFIGURATION);
        }
    }

    protected void clearCache() {
        this.m.clear();
        for (c c2 : this.s) {
            try {
                c2.o();
            }
            catch (Exception exception) {
                LogManager.getConfigLogger().error((Throwable)exception);
            }
        }
    }

    @Nonnull
    public static String getAppName(@Nonnull String key) {
        return switch (key) {
            case PLUGIN_REPORTING_ID -> "i-net Clear Reports";
            case PLUGIN_PDFC_ID -> "i-net PDFC";
            case PLUGIN_HELPDESK_ID -> "i-net HelpDesk";
            case PLUGIN_COWORK_ID -> "i-net CoWork";
            case PLUGIN_INETCORE_ID -> "i-net Enterprise";
            default -> key;
        };
    }

    @Nonnull
    private static SearchTag a(@Nonnull String string, @Nonnull SearchTokenizer searchTokenizer, int n2) {
        return new SearchTag(string, searchTokenizer, n2, () -> MSG.getMsg("searchtag." + string, new Object[0]));
    }

    private static /* synthetic */ byte[] b(byte[] byArray) {
        return byArray;
    }

    static {
        MSG = new I18nMessages("com.inet.store.client.internal.i18n.PluginLabels", PluginConfigManager.class);
        n = new RecoveryConfigValue(ConfigKey.PLUGINS_ACTIVATED);
        STORE_BETAVERSION = new RecoveryConfigValue(PluginStoreClientPlugin.KEY_STORE_BETAVERSION);
        o = GUID.valueOf((String)"bp8wa194qt6iqiwoaq3szzadv");
        p = GUID.valueOf((String)"epjdltr0vvevf5jnrqr0qmfps");
        STORE_UPDATEINTERVAL = new RecoveryConfigValue<Integer>(PluginStoreClientPlugin.KEY_STORE_UPDATEINTERVAL){

            protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
                super.setValue(strValue);
                if (STORE_UPDATEINTERVAL != null && ServerPluginManager.getInstance().getState() == ServerPluginManager.ServerPluginManagerState.INIT) {
                    PluginConfigManager.getInstance().startUpdateTask();
                }
            }
        };
        v = new AtomicBoolean();
    }

    private static class a {
        ArtifactKey key;
        String id;
        String version;

        private a() {
        }
    }

    private class b
    extends DefaultTimerTask {
        private boolean A;

        private b() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runImpl() {
            try {
                b b2 = this;
                synchronized (b2) {
                    block17: {
                        if (!this.A) break block17;
                        return;
                    }
                    this.A = true;
                }
                PluginConfigManager.this.l.b("updateRunning", "true");
                this.l();
            }
            finally {
                PluginConfigManager.this.l.b("updateRunning", null);
                b b3 = this;
                synchronized (b3) {
                    this.A = false;
                    ((Object)((Object)this)).notifyAll();
                }
            }
        }

        private void l() {
            Object throwable;
            for (c object32 : PluginConfigManager.this.s) {
                try {
                    object32.b(true);
                }
                catch (Throwable list) {
                    LogManager.getConfigLogger().error(list);
                }
            }
            String string = PluginConfigManager.this.getServerError();
            ArrayList<ArtifactKey> arrayList = new ArrayList<ArtifactKey>();
            List<ArtifactKey> list = PluginConfigManager.this.f();
            Map<String, Map<String, List<ArtifactKey>>> map = PluginConfigManager.groupArtifactkeys(list);
            for (Map<String, List<ArtifactKey>> bl : map.values()) {
                block8: for (Map.Entry<String, List<ArtifactKey>> entry : bl.entrySet()) {
                    List<ArtifactKey> list2 = entry.getValue();
                    list2.sort((artifactKey, artifactKey2) -> artifactKey2.getVersionValue().compareTo(artifactKey.getVersionValue()));
                    boolean bl2 = false;
                    for (ArtifactKey artifactKey3 : list2) {
                        if (artifactKey3.getChannel() == MavenChannel.Beta) {
                            if (bl2) continue;
                            this.a(arrayList, artifactKey3);
                            bl2 = true;
                            continue;
                        }
                        this.a(arrayList, artifactKey3);
                        continue block8;
                    }
                }
            }
            List<PluginDetail> list3 = PluginConfigManager.this.a((Collection<ArtifactKey>)arrayList);
            PluginConfigManager.this.a(true, null, null, true);
            PluginConfigManager.this.m.clear();
            boolean bl = !list3.isEmpty();
            try {
                WebsiteDownloadResponseData websiteDownloadResponseData;
                class A
                extends WebsiteDownloadConnector {
                    A() {
                        this.init();
                    }

                    String getChangesDocument(@Nonnull Locale locale) throws IOException {
                        return super.getChangesDocument(locale, ((Boolean)STORE_BETAVERSION.get()).booleanValue(), false);
                    }
                }
                throwable = new A();
                WebsiteDownloadResponseData websiteDownloadResponseData2 = throwable.getWebsiteDownloadResponseData(((Boolean)STORE_BETAVERSION.get()).booleanValue());
                if (websiteDownloadResponseData2 != null && ((websiteDownloadResponseData = PluginConfigManager.this.getWebsiteDownload()) == null || new Version(websiteDownloadResponseData2.getVersion()).isHigherThan(new Version(websiteDownloadResponseData.getVersion())))) {
                    PluginConfigManager.this.l.b("WebsiteDownload", websiteDownloadResponseData2);
                    String string2 = ((A)((Object)throwable)).getChangesDocument(Locale.ENGLISH);
                    PluginConfigManager.this.l.b("ChangesDocumentEN", string2);
                    string2 = ((A)((Object)throwable)).getChangesDocument(Locale.GERMAN);
                    PluginConfigManager.this.l.b("ChangesDocumentDE", string2);
                    bl = true;
                    this.a(websiteDownloadResponseData2);
                }
            }
            catch (Throwable throwable2) {
                LogManager.getConfigLogger().debug((Object)throwable2);
            }
            this.m();
            this.b(list3);
            throwable = PluginConfigManager.this.getServerError();
            if (string != null && throwable == null || string == null && throwable != null) {
                bl = true;
            }
            for (c c2 : PluginConfigManager.this.s) {
                try {
                    if (bl) {
                        c2.o();
                    }
                    c2.b(false);
                }
                catch (Throwable throwable3) {
                    LogManager.getConfigLogger().error(throwable3);
                }
            }
        }

        private void a(@Nonnull List<ArtifactKey> list, @Nonnull ArtifactKey artifactKey) {
            String string = artifactKey.getStoragePluginDetailKey();
            PluginDetail pluginDetail = PluginConfigManager.this.l.a(string, PluginDetail.class, new Type[0]);
            if (pluginDetail == null || !Objects.equals(artifactKey.getVersion(), pluginDetail.getVersion())) {
                list.add(artifactKey);
            }
        }

        @SuppressFBWarnings(value={"UNSAFE_HASH_EQUALS"}, justification="no client access")
        private void b(List<PluginDetail> list) {
            Object object;
            ServerPluginDescription serverPluginDescription;
            InstallSource installSource;
            String string;
            String string2;
            boolean bl = false;
            List list2 = ServerPluginManager.getInstance().getPluginDirs();
            String string3 = string2 = list2.size() > 1 ? ((ResourceFile)list2.get(0)).getAbsolutePath() : null;
            if (string2 != null) {
                for (Map.Entry object2 : new HashSet<Map.Entry<String, InstallSource>>(PluginConfigManager.this.i().entrySet())) {
                    string = (String)object2.getKey();
                    installSource = (InstallSource)((Object)object2.getValue());
                    serverPluginDescription = PluginConfigManager.this.a(string);
                    if (serverPluginDescription == null || installSource == InstallSource.Unknown) {
                        PluginConfigManager.this.a(string, (InstallSource)null);
                        bl = true;
                        continue;
                    }
                    object = serverPluginDescription.getLocation();
                    if (object == null || !object.getAbsolutePath().startsWith(string2)) continue;
                    PluginConfigManager.this.a(string, (InstallSource)null);
                    bl = true;
                }
            }
            block5: for (PluginDetail pluginDetail : list) {
                ResourceFile resourceFile;
                string = pluginDetail.getId();
                installSource = PluginConfigManager.this.b(string);
                if (installSource == InstallSource.Unknown || (serverPluginDescription = PluginConfigManager.this.a(string)) == null || serverPluginDescription.getVersion().compareTo(pluginDetail.getVersionValue()) != 0) continue;
                object = pluginDetail.getSha1();
                MavenChannel mavenChannel = pluginDetail.getChannel();
                switch (installSource) {
                    case Release: {
                        if (mavenChannel != MavenChannel.Release) break;
                        continue block5;
                    }
                    case Beta: {
                        if (mavenChannel != MavenChannel.Beta) break;
                        continue block5;
                    }
                }
                if (!((resourceFile = serverPluginDescription.getLocation()) instanceof FileResourceFile) || !this.b(((FileResourceFile)resourceFile).getFile()).equals(object)) continue;
                PluginConfigManager.this.a(string, mavenChannel == MavenChannel.Release ? InstallSource.Release : InstallSource.Beta);
                bl = true;
            }
            if (bl) {
                PluginConfigManager.this.m.clear();
            }
        }

        @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_SHA1"}, justification="no security, only a checksum")
        private String b(File file) {
            try {
                byte[] byArray = IOFunctions.readBytes((File)file);
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                messageDigest.update(byArray);
                byArray = messageDigest.digest();
                return EncodingFunctions.toHexString((byte[])byArray, (int)byArray.length);
            }
            catch (Exception exception) {
                ErrorCode.throwAny((Throwable)exception);
                return null;
            }
        }

        private void m() {
            Collection<PluginMergedDetails> collection = PluginConfigManager.this.getPlugins(null, null, (Boolean)STORE_BETAVERSION.get(), null, null);
            HashSet<String> hashSet = new HashSet<String>();
            for (PluginMergedDetails pluginMergedDetails : collection) {
                if (pluginMergedDetails.getAvailableState() != AvailableState.Updateable) continue;
                hashSet.add(pluginMergedDetails.getId());
            }
            if (hashSet.isEmpty()) {
                NotificationManager.getInstance().unregisterGenerator(o);
                NotificationManager.getInstance().clearGeneratorState(o);
                return;
            }
            HashSet hashSet2 = PluginConfigManager.this.l.a("PluginsWithUpdate", HashSet.class, new Type[]{String.class});
            if (hashSet2 == null || !hashSet2.containsAll(hashSet)) {
                final int n2 = hashSet.size();
                NotificationManager.getInstance().registerGenerator((NotificationGenerator)new PermissionNotificationGenerator(){

                    public String getPeriodKey() {
                        return String.valueOf(n2);
                    }

                    @Nonnull
                    public GUID getId() {
                        return o;
                    }

                    public String getGroupingKey() {
                        return "notificationgroup.store";
                    }

                    @Nonnull
                    public Notification createNotification() {
                        Notification notification = new Notification(MSG.getMsg("notification.pluginupdate.title", new Object[0]), MSG.getMsg("notification.pluginupdate.msg", new Object[]{n2}));
                        notification.setTargetUrl("store/installed");
                        return notification;
                    }
                });
                PluginConfigManager.this.l.b("PluginsWithUpdate", hashSet);
            }
            ServerPluginManager.getInstance().runIfPluginLoaded("help", () -> new Executable(){

                public void execute() {
                    com.inet.store.client.plugin.help.a.y();
                }
            });
        }

        private void a(WebsiteDownloadResponseData websiteDownloadResponseData) {
            if (websiteDownloadResponseData == null) {
                return;
            }
            Version version = ApplicationDescription.get().getVersion();
            Version version2 = new Version(websiteDownloadResponseData.getVersion());
            if (version2.isHigherThan(version)) {
                final String string = websiteDownloadResponseData.getVersion();
                final Date date = websiteDownloadResponseData.getLastUpdateDate();
                NotificationManager.getInstance().registerGenerator((NotificationGenerator)new PermissionNotificationGenerator(){

                    public String getPeriodKey() {
                        return string;
                    }

                    @Nonnull
                    public GUID getId() {
                        return p;
                    }

                    public String getGroupingKey() {
                        return "notificationgroup.store";
                    }

                    @Nonnull
                    public Notification createNotification() {
                        String string2 = DateFormat.getDateInstance(2).format(date);
                        Notification notification = new Notification(MSG.getMsg("notification.appupdate.title", new Object[0]), MSG.getMsg("notification.appupdate.msg", new Object[]{string, string2}));
                        notification.setTargetUrl("store/installed");
                        return notification;
                    }
                });
            } else {
                NotificationManager.getInstance().unregisterGenerator(p);
                NotificationManager.getInstance().clearGeneratorState(p);
            }
        }
    }
}

