/*
 * Decompiled with CFR 0.152.
 */
package com.inet.store.client.shared;

import com.inet.annotations.InternalApi;
import com.inet.shared.utils.Version;
import com.inet.store.client.internal.MavenChannel;
import com.inet.store.client.shared.AvailableState;
import com.inet.store.client.shared.InstallSource;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class PluginMergedDetails {
    private final String app;
    private final String id;
    private final AvailableState state;
    private final String error;
    private final boolean running;
    private final String name;
    private final String description;
    private final String version;
    private final List<String> categories;
    private final byte[] ah;
    private Supplier<byte[]> ai;
    private int screenshotCount;
    private IntFunction<byte[]> aj;
    private Function<String, String> ak;
    private Function<String, String> al;
    private Function<String, String> am;
    private Collection<String> an;
    private Collection<String> ao;
    private Collection<String> ap;
    private long size;
    private String updatedVersion;
    private MavenChannel aq;
    private String betaVersion;
    private boolean ar;
    private InstallSource as;
    private boolean deactivatable;
    private boolean deinstallable;
    private Collection<String> flags;

    public PluginMergedDetails(String app, String id, String version, AvailableState state, String error, boolean running, String name, String description, List<String> categories, byte @Nullable [] icon, Supplier<byte[]> teaser, int screenshotCount, IntFunction<byte[]> screenshots, @Nonnull Collection<String> changes, @Nonnull Function<String, String> generallog, @Nonnull Function<String, String> changelog, @Nonnull Function<String, String> migration, Collection<String> dependencies, Collection<String> optionalDependencies, long size, String updatedVersion, String betaVersion, boolean isUpdated, MavenChannel updatedChannel, InstallSource installSource, boolean deactivatable, boolean deinstallable, Collection<String> flags) {
        this.app = app;
        this.id = id;
        this.state = state;
        this.error = error;
        this.running = running;
        this.name = name;
        this.description = description;
        this.version = version;
        this.categories = categories;
        this.ah = icon;
        this.ai = teaser;
        this.screenshotCount = screenshotCount;
        this.aj = screenshots;
        this.ak = generallog;
        this.al = changelog;
        this.am = migration;
        this.an = changes;
        this.ao = dependencies;
        this.ap = optionalDependencies;
        this.size = size;
        this.updatedVersion = updatedVersion;
        this.betaVersion = betaVersion;
        this.ar = isUpdated;
        this.aq = updatedChannel;
        this.as = installSource;
        this.deactivatable = deactivatable;
        this.deinstallable = deinstallable;
        this.flags = flags;
    }

    public String getApp() {
        return this.app;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version.toString();
    }

    @Nonnull
    public Collection<String> getFlags() {
        Collection<String> collection = this.flags;
        return collection != null ? collection : Collections.emptySet();
    }

    public AvailableState getAvailableState() {
        return this.state;
    }

    public boolean isRunning() {
        return this.running;
    }

    public String getName() {
        if (this.name != null) {
            return MessageFormat.format(this.name, null);
        }
        return null;
    }

    public String getDescription() {
        if (this.description != null) {
            return MessageFormat.format(this.description, null);
        }
        return null;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public byte @Nullable [] getIcon() {
        return this.ah;
    }

    public byte @Nullable [] loadTeaser() {
        return this.ai != null ? this.ai.get() : null;
    }

    public boolean hasTeaser() {
        return this.ai != null;
    }

    public int getScreenshotCount() {
        return this.screenshotCount;
    }

    public byte @Nullable [] loadScreenshot(int idx) {
        return this.aj != null ? this.aj.apply(idx) : null;
    }

    @Nonnull
    public Collection<String> getChanges() {
        return this.an;
    }

    @Nullable
    public String getChangelog() {
        return this.getChangelog(this.getMajorMinorVersion());
    }

    @Nullable
    public String getChangelog(@Nonnull Version version) {
        return this.al != null ? this.al.apply(version.toString()) : null;
    }

    @Nullable
    public String getGeneralLog() {
        return this.getGeneralLog(this.getMajorMinorVersion());
    }

    @Nullable
    public String getGeneralLog(@Nonnull Version version) {
        return this.ak != null ? this.ak.apply(version.toString()) : null;
    }

    @Nullable
    public String getMigration() {
        return this.getMigration(this.getMajorMinorVersion());
    }

    public static Version getMajorMinorVersion(String version) {
        Version version2 = new Version(version);
        return new Version(version2.getMajor() + "." + version2.getMinor());
    }

    public Version getMajorMinorVersion() {
        return PluginMergedDetails.getMajorMinorVersion(this.version);
    }

    @Nullable
    public String getMigration(@Nonnull Version version) {
        return this.am != null ? this.am.apply(version.toString()) : null;
    }

    @Nonnull
    public Collection<String> getDependencies() {
        return this.ao;
    }

    @Nonnull
    public Collection<String> getOptionalDependencies() {
        return this.ap;
    }

    public long getArtifactSize() {
        return this.size;
    }

    public String getUpdatedVersion() {
        return this.updatedVersion;
    }

    public MavenChannel getUpdatedChannel() {
        return this.aq;
    }

    public String getBetaVersion() {
        return this.betaVersion;
    }

    public boolean isUpdated() {
        return this.ar;
    }

    public String getError() {
        return this.error;
    }

    public InstallSource getInstallSource() {
        return this.as;
    }

    public boolean isDeactivatable() {
        return this.deactivatable;
    }

    public boolean isDeinstallable() {
        return this.deinstallable;
    }
}

