/*
 * Decompiled with CFR 0.152.
 */
package com.inet.store.client.internal;

import com.inet.annotations.InternalApi;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.store.client.PluginStoreClientPlugin;
import com.inet.store.client.internal.PluginConfigManager;
import com.inet.store.client.shared.PluginMergedDetails;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;

@InternalApi
public class ReleaseNotesUtils {
    public static final List<String> GROUP_LABELS = Arrays.asList("general", "changes", "bugfixes", "security", "migration");
    private static final String O = ServerPluginManager.getInstance().getCorePluginId();
    private static final Comparator<PluginMergedDetails> P = (pluginMergedDetails, pluginMergedDetails2) -> {
        boolean bl;
        if (O.equals(pluginMergedDetails.getId())) {
            return -1;
        }
        if (O.equals(pluginMergedDetails2.getId())) {
            return 1;
        }
        boolean bl2 = pluginMergedDetails.getDependencies().contains(O);
        if (bl2 != (bl = pluginMergedDetails2.getDependencies().contains(O))) {
            return bl2 ? -1 : 1;
        }
        return pluginMergedDetails.getName().compareToIgnoreCase(pluginMergedDetails2.getName());
    };

    public static Map<String, Map<String, String>> createGroupedChanges(String changelog, String defaultGroup) {
        HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>();
        String string = defaultGroup;
        String string2 = "en";
        if (!StringFunctions.isEmpty((String)changelog)) {
            String[] stringArray;
            for (String string3 : stringArray = changelog.replace("\r", "").trim().split("\n")) {
                String[] stringArray2;
                String[] stringArray3;
                String string4 = string3.trim();
                if (string4.startsWith("[") && string4.endsWith("]")) {
                    stringArray3 = string4.substring(1, string4.length() - 1).toLowerCase().split(":", 2);
                    if ("meta".equals(stringArray3[0])) {
                        if (stringArray3.length != 2 || StringFunctions.isEmpty((String)stringArray3[1])) continue;
                        stringArray2 = stringArray3[1].split(":", 2);
                        ReleaseNotesUtils.a(hashMap, Objects.requireNonNullElse(stringArray2[0], ""), Objects.requireNonNullElse(stringArray3[0], ""), Objects.requireNonNullElse(stringArray2[1], ""));
                        continue;
                    }
                    string = stringArray3[0];
                    string2 = stringArray3.length > 1 ? stringArray3[1] : "en";
                    continue;
                }
                stringArray3 = (String[])hashMap.get(string2);
                if (stringArray3 == null) {
                    stringArray3 = new TreeMap(new GroupedLabelsComparator());
                    hashMap.put(string2, (Map<String, String>)stringArray3);
                }
                stringArray2 = "\n";
                if ("general".equals(string)) {
                    stringArray2 = (String)stringArray2 + "\n";
                }
                stringArray3.merge(string, string3.stripTrailing() + (String)stringArray2, String::concat);
            }
        }
        hashMap.entrySet().forEach(entry2 -> ((Map)entry2.getValue()).entrySet().forEach(entry -> {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            while (!"general".equals(string) && string2.endsWith("\n\n")) {
                string2 = string2.substring(0, string2.length() - 1);
                entry.setValue(string2);
            }
        }));
        return hashMap;
    }

    private static void a(@Nonnull Map<String, Map<String, String>> map, @Nonnull String string, @Nonnull String string2, @Nonnull String string3) {
        Map<String, String> map2 = map.get(string2);
        if (map2 == null) {
            map2 = new TreeMap<String, String>(new GroupedLabelsComparator());
            map2.put(string, "");
            map.put(string2, map2);
        }
        if ("meta".equals(string2)) {
            map2.put(string, string3);
        } else {
            map2.merge(string, string3 + (StringFunctions.isEmpty((String)string3) ? "" : "\n"), String::concat);
        }
    }

    public static String groupLabelForKey(String key) {
        assert (GROUP_LABELS.contains(key));
        return PluginStoreClientPlugin.CLIENT_MSG.getMsg("releasenotes.group." + key, new Object[0]);
    }

    public static String createLocalizedChanges(String changelog, String defaultGroup, String language) {
        if (!StringFunctions.isEmpty((String)changelog) && !"meta".equals(language)) {
            Map<String, Map<String, String>> map = ReleaseNotesUtils.createGroupedChanges(changelog, defaultGroup);
            Map<String, String> map2 = map.get(language);
            if (map2 == null) {
                map2 = map.get("en");
                Objects.requireNonNull(map2);
            }
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            ArrayList<@Nonnull Map.Entry<String, String>> arrayList = new ArrayList<Map.Entry<String, String>>(map2.entrySet());
            arrayList.sort(Comparator.comparingInt(entry -> GROUP_LABELS.indexOf(entry.getKey())));
            for (Map.Entry entry2 : arrayList) {
                String string = (String)entry2.getValue();
                if (StringFunctions.isEmpty((String)string) || !"general".equals(defaultGroup) && "general".equals(entry2.getKey()) || "general".equals(defaultGroup) && !"general".equals(entry2.getKey())) continue;
                if (bl || !Arrays.asList("changes", "migration", "general").contains(entry2.getKey())) {
                    stringBuilder.append("#### ").append(PluginStoreClientPlugin.CLIENT_MSG.getMsg("releasenotes.group." + (String)entry2.getKey(), new Object[0])).append("\n");
                    bl = true;
                }
                stringBuilder.append(string);
            }
            changelog = stringBuilder.toString();
        }
        return changelog;
    }

    public static Set<PluginMergedDetails> getInstalledAndSortedPluginDescriptions() {
        PluginConfigManager pluginConfigManager = PluginConfigManager.getInstance();
        Set<String> set = pluginConfigManager.getInstalledPluginsIDs();
        TreeSet<PluginMergedDetails> treeSet = new TreeSet<PluginMergedDetails>(P);
        for (String string : set) {
            PluginMergedDetails pluginMergedDetails = pluginConfigManager.getPlugin(string, false, null);
            treeSet.add(pluginMergedDetails);
        }
        return treeSet;
    }

    @InternalApi
    public static final class GroupedLabelsComparator
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            return Integer.compare(GROUP_LABELS.indexOf(o1), GROUP_LABELS.indexOf(o2));
        }
    }
}

