/*
 * Decompiled with CFR 0.152.
 */
package com.inet.store.client.setup;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigurationManager;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.website.WellKnownWebsites;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.api.SetupStep;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.SetupStepProblems;
import com.inet.setupwizard.api.StepConfiguration;
import com.inet.setupwizard.api.StepConfigurationStorage;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepExecutionProgressInfo;
import com.inet.setupwizard.api.StepExecutionWarnings;
import com.inet.setupwizard.api.StepKey;
import com.inet.setupwizard.api.StepsRepository;
import com.inet.shared.utils.ProductionEnvironmentCheck;
import com.inet.shared.utils.Version;
import com.inet.store.client.internal.PluginConfigManager;
import com.inet.store.client.setup.UpdatePluginSetupStepConfig;
import com.inet.store.client.setup.b;
import com.inet.store.client.shared.AvailableState;
import com.inet.store.client.shared.PluginMergedDetails;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class c
extends SetupStep<UpdatePluginSetupStepConfig> {
    private static final StepKey ab = new StepKey("UpdatePluginsStep");
    private boolean ac;
    private final Supplier<PluginConfigManager> aa;
    private final Supplier<ServerPluginManager> ad;
    private b ae;

    public c(Supplier<PluginConfigManager> supplier, Supplier<ServerPluginManager> supplier2) {
        this.aa = supplier;
        this.ad = supplier2;
        this.ae = new b(supplier);
    }

    public c() {
        this(() -> PluginConfigManager.getInstance(), () -> ServerPluginManager.getInstance());
    }

    public StepKey stepKey() {
        return ab;
    }

    public String getStepDisplayName() {
        return PluginConfigManager.MSG.getMsg("setup.updatePluginStep.displayname", new Object[0]);
    }

    private Set<String> A() {
        PluginConfigManager pluginConfigManager = this.aa.get();
        Set<String> set = pluginConfigManager.getPlugins(null, null, false, null, null).stream().filter(pluginMergedDetails -> pluginMergedDetails.getAvailableState() == AvailableState.Updateable).map(PluginMergedDetails::getId).collect(Collectors.toSet());
        if (!pluginConfigManager.isPublicStore() && System.getProperty("setupautoexecution", "false").equalsIgnoreCase("true")) {
            Map map = (Map)ConfigurationManager.getInstance().getCurrent().getValue(ConfigKey.PLUGINS_ACTIVATED);
            for (Map.Entry entry : map.entrySet()) {
                PluginMergedDetails pluginMergedDetails2;
                String string = (String)entry.getKey();
                Boolean bl = (Boolean)entry.getValue();
                if (bl == null || !bl.booleanValue() || (pluginMergedDetails2 = pluginConfigManager.getPlugin(string, false, null)) == null || pluginMergedDetails2.getAvailableState() != AvailableState.Installable) continue;
                set.add(string);
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingTasks() {
        Object object;
        PluginConfigManager pluginConfigManager;
        if (!ProductionEnvironmentCheck.inProduction()) {
            return false;
        }
        Version version = c.getLastMigratedVersionOf((String)this.ad.get().getCorePluginId());
        if (version == null) {
            if (!System.getProperty("setupautoexecution", "false").equalsIgnoreCase("true")) {
                SetupLogger.LOGGER.debug((Object)"[PluginUpdate] Nothing to do in new installation");
                return false;
            }
        } else {
            pluginConfigManager = this.ad.get().getPluginDescription(this.ad.get().getCorePluginId()).getVersion();
            if (version.getMajor() == pluginConfigManager.getMajor() && version.getMinor() == pluginConfigManager.getMinor()) {
                SetupLogger.LOGGER.debug((Object)"[PluginUpdate] Core is up-to-date");
                return false;
            }
        }
        pluginConfigManager = this.aa.get();
        if (!this.ac) {
            object = this;
            synchronized (object) {
                if (!this.ac) {
                    pluginConfigManager.blockingUpdate();
                    this.ac = true;
                }
            }
        }
        object = this.A();
        SetupLogger.LOGGER.debug((Object)("[PluginUpdate] Plugins to Update: " + String.valueOf(object)));
        return !object.isEmpty() || this.ae.hasPendingTasks();
    }

    public SetupStep.ExecutionRestriction getExecutionRestriction() {
        return SetupStep.ExecutionRestriction.ONCE_PER_SETUP;
    }

    public boolean a(UpdatePluginSetupStepConfig updatePluginSetupStepConfig) {
        return true;
    }

    public void a(UpdatePluginSetupStepConfig updatePluginSetupStepConfig, Map<String, String> map) throws StepExecutionException {
        if (!ProductionEnvironmentCheck.inProduction()) {
            return;
        }
        PluginConfigManager pluginConfigManager = this.aa.get();
        try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
            Set<String> set = this.A();
            this.ae.a(pluginConfigManager, set);
            if (!this.c(pluginConfigManager, set)) {
                List<PluginMergedDetails> list = this.b(pluginConfigManager, set);
                double d2 = 100.0 / (double)list.size();
                double d3 = 0.0;
                int n2 = 1;
                for (PluginMergedDetails pluginMergedDetails : list) {
                    int n3 = n2;
                    this.getStepExecutionProgressListener().progressInfoUpdated(new StepExecutionProgressInfo((int)d3, () -> {
                        String string = pluginConfigManager.getPlugin(pluginMergedDetails.getId(), false, null).getName();
                        return PluginConfigManager.MSG.getMsg("setup.updatePluginStep.currentPlugin", new Object[]{string, n3, list.size()});
                    }));
                    switch (pluginMergedDetails.getAvailableState()) {
                        case Activated: {
                            SetupLogger.LOGGER.warn((Object)("[PluginUpdate] Plugin already installed:" + pluginMergedDetails.getId()));
                            break;
                        }
                        case InProgress: {
                            SetupLogger.LOGGER.warn((Object)("[PluginUpdate] Plugin is in progress:" + pluginMergedDetails.getId()));
                            break;
                        }
                        case Installable: 
                        case Updateable: {
                            SetupLogger.LOGGER.info((Object)String.format("Update Plugin %s to %s", pluginMergedDetails.getName(), pluginMergedDetails.getUpdatedVersion()));
                            try {
                                pluginConfigManager.downloadPlugin(pluginMergedDetails.getId(), false, null);
                            }
                            catch (IOException iOException) {
                                SetupLogger.LOGGER.error((Throwable)iOException);
                                StepExecutionWarnings.get().error(() -> PluginConfigManager.MSG.getMsg("setup.updatePluginStep.couldNotUpdatePlugin", new Object[]{pluginMergedDetails.getName(), StringFunctions.getUserFriendlyErrorMessage((Throwable)iOException)}));
                            }
                        }
                        case Deactivated: {
                            pluginConfigManager.activate(pluginMergedDetails.getId());
                            break;
                        }
                    }
                    d3 += d2;
                    ++n2;
                }
            }
            this.ae.a(pluginConfigManager);
        }
    }

    private List<PluginMergedDetails> b(PluginConfigManager pluginConfigManager, Set<String> set) {
        ArrayList<PluginMergedDetails> arrayList = new ArrayList<PluginMergedDetails>(set.size());
        for (String string : set) {
            PluginMergedDetails pluginMergedDetails = pluginConfigManager.getPlugin(string, false, null);
            if (pluginMergedDetails == null) {
                SetupLogger.LOGGER.info((Object)("[PluginUpdate] Plugin to activate does not exist:" + string));
                continue;
            }
            if (pluginMergedDetails.getAvailableState() == AvailableState.Activated) {
                SetupLogger.LOGGER.info((Object)("[PluginUpdate] Plugin already installed:" + pluginMergedDetails.getId()));
                continue;
            }
            arrayList.add(pluginMergedDetails);
        }
        return arrayList;
    }

    private boolean c(PluginConfigManager pluginConfigManager, Set<String> set) {
        if (pluginConfigManager.getServerError() != null) {
            String[] stringArray;
            ArrayList<String> arrayList = new ArrayList<String>();
            Version version = ApplicationDescription.get().getVersion();
            for (String stringArray2 : set) {
                String[] stringArray3 = pluginConfigManager.getPlugin(stringArray2, false, null);
                if (stringArray3 == null || !stringArray3.isRunning()) {
                    arrayList.add(stringArray2);
                    continue;
                }
                Version version2 = new Version(stringArray3.getVersion());
                if (!version.isHigherThan(version2)) continue;
                arrayList.add(stringArray2);
            }
            ServerPluginManager serverPluginManager = this.ad.get();
            for (String string : stringArray = serverPluginManager.getAvailablePlugins()) {
                Object object = serverPluginManager.getPluginLoadError(string);
                if (ServerPluginManager.PluginLoadFailCause.VERSION != object && ServerPluginManager.PluginLoadFailCause.DEPENDENCY != object || arrayList.contains(string)) continue;
                arrayList.add(string);
            }
            if (arrayList.isEmpty()) {
                return false;
            }
            Collections.sort(arrayList);
            SetupLogger.LOGGER.warn((Object)("Cannot update plugins: " + pluginConfigManager.getServerError()));
            StepExecutionWarnings.get().warn(() -> {
                String string = "<a href=\"" + WellKnownWebsites.STORE_BASE_URL + "\" target=\"_blank\">Public Store</a>";
                String string2 = "<a href=\"../store\" target=\"_blank\">Store</a>";
                Object object = PluginConfigManager.MSG.getMsg("setup.updatePluginStep.cannotConnectToStore", new Object[]{string, string2});
                object = (String)object + "<ul>";
                for (String string3 : arrayList) {
                    object = (String)object + "<li> <a href=\"" + WellKnownWebsites.STORE_BASE_URL + "pid/" + string3 + "\" target=\"_blank\">" + string3 + "</a></li> ";
                }
                object = (String)object + "</ul>";
                return object;
            });
            return true;
        }
        return false;
    }

    public SetupStepPriority getPriority() {
        return new SetupStepPriority(6);
    }

    public InfoMessageGetter b(UpdatePluginSetupStepConfig updatePluginSetupStepConfig) {
        return () -> PluginConfigManager.MSG.getMsg("setup.updatePluginStep.executionMessage", new Object[0]);
    }

    public UpdatePluginSetupStepConfig a(StepConfigurationStorage stepConfigurationStorage, StepsRepository stepsRepository, UpdatePluginSetupStepConfig updatePluginSetupStepConfig, StepKey stepKey) {
        PluginConfigManager pluginConfigManager = this.aa.get();
        return new UpdatePluginSetupStepConfig(pluginConfigManager.getServerError() == null);
    }

    public SetupStepProblems c(UpdatePluginSetupStepConfig updatePluginSetupStepConfig) {
        if (updatePluginSetupStepConfig != null && updatePluginSetupStepConfig.isFirstInvocation()) {
            SetupStepProblems setupStepProblems = new SetupStepProblems();
            setupStepProblems.addError("Dummy");
            return setupStepProblems;
        }
        return super.findProblemsWithConfig((StepConfiguration)updatePluginSetupStepConfig);
    }

    public /* synthetic */ StepConfiguration updateConfiguration(StepConfigurationStorage stepConfigurationStorage, StepsRepository stepsRepository, StepConfiguration stepConfiguration, StepKey stepKey) {
        return this.a(stepConfigurationStorage, stepsRepository, (UpdatePluginSetupStepConfig)stepConfiguration, stepKey);
    }

    public /* synthetic */ InfoMessageGetter getExecutionInfoMessage(StepConfiguration stepConfiguration) {
        return this.b((UpdatePluginSetupStepConfig)stepConfiguration);
    }

    public /* synthetic */ void execute(StepConfiguration stepConfiguration, Map map) throws StepExecutionException {
        this.a((UpdatePluginSetupStepConfig)stepConfiguration, map);
    }

    public /* synthetic */ SetupStepProblems findProblemsWithConfig(StepConfiguration stepConfiguration) {
        return this.c((UpdatePluginSetupStepConfig)stepConfiguration);
    }

    public /* synthetic */ boolean doesRequireToRestartServerAfterExecution(StepConfiguration stepConfiguration) {
        return this.a((UpdatePluginSetupStepConfig)stepConfiguration);
    }
}

