/*
 * Decompiled with CFR 0.152.
 */
package com.inet.store.client.plugin.help;

import com.inet.classloader.I18nMessages;
import com.inet.help.api.HelpPageContentProcessor;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.SessionStore;
import com.inet.lib.markdown.MarkDown2Html;
import com.inet.lib.markdown.MarkDownExtension;
import com.inet.lib.util.Scope;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.help.HelpPage;
import com.inet.shared.utils.Version;
import com.inet.store.client.internal.PluginConfigManager;
import com.inet.store.client.internal.ReleaseNotesUtils;
import com.inet.store.client.plugin.help.b;
import com.inet.store.client.shared.PluginMergedDetails;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

public class c
implements HelpPageContentProcessor {
    private static final b Y = new b();
    public static final I18nMessages Z = new I18nMessages("com.inet.store.client.plugin.help.i18n.Language", c.class);

    public void process(@Nonnull String helpKey, @Nonnull Document helpPage, @Nonnull List<HelpPage> pages, @Nonnull Locale locale) {
        Elements elements = helpPage.getElementsByTag("abbr");
        String string = ApplicationDescription.get().getStoreProductId();
        for (Element element : elements) {
            Element element2;
            Element element3;
            if (!element.text().equals("RELEASE-INFORMATION") || (element3 = element.parent()) == null || (element2 = element3.parent()) == null) continue;
            Element element4 = element2;
            Version version = this.z();
            element2.children().remove();
            Element element5 = element2.previousElementSibling();
            if (element5 != null && "h1".equals(element5.tagName())) {
                element5.remove();
            }
            try (Scope scope = ClientLocale.scope((Locale)locale);){
                Set<PluginMergedDetails> set = ReleaseNotesUtils.getInstalledAndSortedPluginDescriptions();
                element2 = this.a(element2, set, (PluginMergedDetails pluginMergedDetails) -> {
                    String string2 = pluginMergedDetails.getId();
                    if (!string.equals(string2) && !"inetcore".equals(string2)) {
                        return null;
                    }
                    return pluginMergedDetails.getGeneralLog();
                }, Z.getMsg("changelog.information", new Object[0]));
                if (version == null) {
                    element2 = this.a(element2, set, (PluginMergedDetails pluginMergedDetails) -> pluginMergedDetails.getMigration(), Z.getMsg("changelog.migration", new Object[0]));
                    element2 = this.a(element2, set, (PluginMergedDetails pluginMergedDetails) -> pluginMergedDetails.getChangelog(), Z.getMsg("changelog.plugins", new Object[0]));
                } else {
                    element2 = this.a(element2, set, (PluginMergedDetails pluginMergedDetails) -> this.a(version, pluginMergedDetails.getChanges(), (Version version) -> pluginMergedDetails.getMigration((Version)version), (Version version) -> Z.getMsg("changelog.migration.version", new Object[]{version.toString()})), Z.getMsg("changelog.migration", new Object[0]));
                    element2 = this.a(element2, set, (PluginMergedDetails pluginMergedDetails) -> this.a(version, pluginMergedDetails.getChanges(), (Version version) -> pluginMergedDetails.getChangelog((Version)version), (Version version) -> Z.getMsg("changelog.plugins.version", new Object[]{version.toString()})), Z.getMsg("changelog.plugins", new Object[0]));
                }
                if (!PluginConfigManager.getInstance().isPublicStore()) {
                    Element element6 = new Element("div");
                    element6.attr("ng-controller", "controllerHelpHistoryWrapper");
                    element2.appendChild((Node)element6);
                }
            }
            if (element4.hasText()) continue;
            element4.remove();
        }
    }

    @Nullable
    private Version z() {
        Object object;
        String[] stringArray;
        Version version = null;
        HttpServletRequest httpServletRequest = SessionStore.getHttpServletRequest();
        String string = "";
        if (httpServletRequest != null) {
            string = httpServletRequest.getRequestURI();
        } else {
            stringArray = SessionStore.getHttpSession();
            if (stringArray == null) {
                return version;
            }
            object = stringArray.getAttribute("helpContentKeyExtension");
            if (object != null) {
                string = new String(object.toString());
            }
        }
        if (!StringFunctions.isEmpty((String)string) && (stringArray = string.split("history/", 2)).length == 2) {
            object = stringArray[1].split("/", 2)[0];
            version = new Version((String)object);
        }
        return version;
    }

    private Element a(Element element, Set<PluginMergedDetails> set, Function<PluginMergedDetails, String> function, String string) {
        Element element2 = element;
        Element element3 = null;
        if (!StringFunctions.isEmpty((String)string)) {
            element3 = new Element("h1");
            element3.text(string);
            element3.id(string.toLowerCase().replaceAll("[^a-z0-9]", "-"));
            element.after((Node)element3);
            element2 = element3;
        }
        MarkDown2Html markDown2Html = new MarkDown2Html().hardbreak(true).blankTarget(true);
        markDown2Html.extension((MarkDownExtension)Y);
        boolean bl = false;
        String string2 = ApplicationDescription.get().getStoreProductId();
        for (PluginMergedDetails pluginMergedDetails : set) {
            Element element4;
            String string3 = function.apply(pluginMergedDetails);
            if (StringFunctions.isEmpty((String)string3)) continue;
            String string4 = markDown2Html.convert(string3.trim());
            bl = true;
            String string5 = "level1 changelog";
            if (!string2.equals(pluginMergedDetails.getId())) {
                element4 = new Element("h2");
                element4.text(pluginMergedDetails.getName());
                element4.id(pluginMergedDetails.getName().toLowerCase().replaceAll("[^a-z0-9]", "-"));
                element2.after((Node)element4);
                element2 = element4;
                string5 = "level2 changelog";
            }
            element4 = new Element("div").addClass(string5);
            element4.html(string4);
            element2.after((Node)element4);
            element2 = element4;
        }
        if (!bl && element3 != null) {
            element3.remove();
            return element;
        }
        return element2;
    }

    public static String h(String string) {
        Set<PluginMergedDetails> set = ReleaseNotesUtils.getInstalledAndSortedPluginDescriptions();
        StringBuilder stringBuilder = new StringBuilder();
        c.a(stringBuilder, set, pluginMergedDetails -> pluginMergedDetails.getMigration());
        if (stringBuilder.length() > 0) {
            stringBuilder.insert(0, "# " + Z.getMsg("changelog.migration", new Object[0]) + "\n");
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        c.a(stringBuilder2, set, pluginMergedDetails -> pluginMergedDetails.getChangelog());
        if (stringBuilder2.length() > 0) {
            stringBuilder2.insert(0, "# " + Z.getMsg("changelog.plugins", new Object[0]) + "\n");
        }
        return string.replace("RELEASE-INFORMATION", stringBuilder.toString() + stringBuilder2.toString());
    }

    private static void a(StringBuilder stringBuilder, Set<PluginMergedDetails> set, Function<PluginMergedDetails, String> function) {
        for (PluginMergedDetails pluginMergedDetails : set) {
            String string = function.apply(pluginMergedDetails);
            if (StringFunctions.isEmpty((String)string)) continue;
            if (!ApplicationDescription.get().getStoreProductId().equals(pluginMergedDetails.getId())) {
                stringBuilder.append("## ");
                stringBuilder.append(pluginMergedDetails.getName());
                stringBuilder.append("\n");
            }
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
    }

    private String a(@Nonnull Version version3, Collection<String> collection, Function<Version, String> function, Function<Version, String> function2) {
        List list = collection.stream().map(string -> new Version(string)).filter(version2 -> version2.isHigherOrEquals(version3)).collect(Collectors.toList());
        list.sort((version, version2) -> version2.compareTo(version));
        StringBuilder stringBuilder = new StringBuilder();
        Version version4 = null;
        for (Version version5 : list) {
            Version version6 = PluginMergedDetails.getMajorMinorVersion(version5.toString());
            String string2 = function.apply(version5);
            if (StringFunctions.isEmpty((String)string2)) continue;
            if (version4 == null || version6.compareTo(version4) != 0) {
                version4 = version6;
                stringBuilder.append("[");
                stringBuilder.append(function2.apply(version6));
                stringBuilder.append("]");
            }
            stringBuilder.append("\n");
            stringBuilder.append(string2);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

