/*
 * Decompiled with CFR 0.152.
 */
package com.inet.store.client.internal;

import com.inet.annotations.InternalApi;
import com.inet.lib.io.FastBufferedInputStream;
import com.inet.lib.io.FastBufferedOutputStream;
import com.inet.lib.json.Bon;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.thread.ThreadUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class StateStorage {
    private final PersistenceEntry R = Persistence.getRecoveryEnabledInstance().resolve("plugins/cache");

    @Nonnull
    private PersistenceEntry f(@Nonnull String string) {
        string = Base64.getUrlEncoder().withoutPadding().encodeToString(string.getBytes(StandardCharsets.UTF_8));
        return this.R.resolve(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void b(@Nonnull String string, @Nullable Object object) {
        PersistenceEntry persistenceEntry = this.f(string);
        try (ThreadUtils.Semaphore semaphore = ThreadUtils.getSemaphore((Object)persistenceEntry);){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                block18: {
                    if (object != null) break block18;
                    persistenceEntry.deleteValue();
                    return;
                }
                try (FastBufferedOutputStream fastBufferedOutputStream = new FastBufferedOutputStream((OutputStream)new GZIPOutputStream((OutputStream)new FastBufferedOutputStream(persistenceEntry.getOutputStream())));){
                    new Bon().toBinary(object, (OutputStream)fastBufferedOutputStream);
                }
                catch (IOException iOException) {
                    LogManager.getConfigLogger().error((Throwable)iOException);
                }
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Nullable
    <T> T a(@Nonnull String string, Class<T> clazz, Type ... typeArray) {
        PersistenceEntry persistenceEntry = null;
        try {
            persistenceEntry = this.f(string);
            try (ThreadUtils.Semaphore semaphore = ThreadUtils.getSemaphore((Object)persistenceEntry);){
                ThreadUtils.Semaphore semaphore2 = semaphore;
                synchronized (semaphore2) {
                    Object object;
                    block23: {
                        InputStream inputStream;
                        block21: {
                            T t;
                            block22: {
                                inputStream = persistenceEntry.getInputStream();
                                if (inputStream != null) break block21;
                                t = null;
                                if (inputStream == null) break block22;
                                inputStream.close();
                            }
                            return t;
                        }
                        object = new Bon().fromBinary((InputStream)new FastBufferedInputStream((InputStream)new GZIPInputStream(inputStream)), clazz, typeArray);
                        if (inputStream == null) break block23;
                        {
                            catch (Throwable throwable) {
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                        }
                        inputStream.close();
                    }
                    return (T)object;
                }
            }
        }
        catch (Throwable throwable) {
            Logger logger = LogManager.getConfigLogger();
            String string2 = "Error reading store cache value for key: " + string;
            if (persistenceEntry != null) {
                string2 = string2 + ", persitence file: " + persistenceEntry.getPath();
            }
            logger.warn((Object)string2);
            logger.warn((Object)throwable);
            return null;
        }
    }

    void g(@Nonnull String string) {
        this.b(string, null);
    }

    public boolean exists(@Nonnull String key) {
        return this.f(key).exists();
    }
}

