/*
 * Decompiled with CFR 0.152.
 */
package com.inet.store.client.ui.data;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.lib.markdown.MarkDown2Html;
import com.inet.plugin.ServerPluginDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.IModule;
import com.inet.remote.gui.ModuleManager;
import com.inet.store.client.internal.MavenChannel;
import com.inet.store.client.internal.PluginConfigManager;
import com.inet.store.client.internal.e;
import com.inet.store.client.shared.AvailableState;
import com.inet.store.client.shared.InstallSource;
import com.inet.store.client.shared.PluginMergedDetails;
import com.inet.store.client.ui.data.DependencyDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonData
public class PluginDetailsDescription {
    private String id;
    private AvailableState state;
    private boolean running;
    private boolean updated;
    private String error;
    private String name;
    private String description;
    private long size;
    private String installSource;
    private String version;
    private String updatedVersion;
    private boolean beta;
    private String betaVersion;
    private List<String> categories;
    private List<DependencyDescription> dependencies;
    private List<DependencyDescription> optionalDependencies;
    private List<DependencyDescription> requiredBy;
    private List<DependencyDescription> extendedBy;
    private int screenshotsCount;
    private String changelog;
    private String migration;
    private List<LocalizedKey> availableForProduct;
    private boolean deactivatable;
    private boolean deinstallable;
    private List<LocalizedKey> apps;
    private boolean isJar;
    private boolean hasMoreChanges;

    public static PluginDetailsDescription from(PluginMergedDetails plugin, boolean betaVersions, String version) {
        Object object;
        PluginDetailsDescription pluginDetailsDescription = new PluginDetailsDescription();
        pluginDetailsDescription.id = plugin.getId();
        pluginDetailsDescription.state = plugin.getAvailableState();
        if (e.p().d(plugin.getId())) {
            pluginDetailsDescription.state = AvailableState.InProgress;
        }
        pluginDetailsDescription.running = plugin.isRunning();
        pluginDetailsDescription.updated = plugin.isUpdated();
        pluginDetailsDescription.error = plugin.getError();
        pluginDetailsDescription.name = plugin.getName();
        pluginDetailsDescription.description = plugin.getDescription();
        pluginDetailsDescription.size = plugin.getArtifactSize();
        pluginDetailsDescription.installSource = plugin.getInstallSource().name();
        pluginDetailsDescription.version = plugin.getVersion();
        if (plugin.getInstallSource() == InstallSource.Beta) {
            pluginDetailsDescription.version = pluginDetailsDescription.version + " (Beta)";
        }
        if (plugin.getInstallSource() == InstallSource.SideLoad) {
            pluginDetailsDescription.version = pluginDetailsDescription.version + " (SideLoad)";
        }
        pluginDetailsDescription.beta = MavenChannel.Beta == plugin.getUpdatedChannel();
        pluginDetailsDescription.updatedVersion = plugin.getUpdatedVersion();
        if (pluginDetailsDescription.beta) {
            pluginDetailsDescription.updatedVersion = pluginDetailsDescription.updatedVersion + " (Beta)";
        }
        pluginDetailsDescription.betaVersion = plugin.getBetaVersion();
        pluginDetailsDescription.categories = plugin.getCategories();
        pluginDetailsDescription.screenshotsCount = plugin.getScreenshotCount();
        MarkDown2Html markDown2Html = new MarkDown2Html().hardbreak(true).blankTarget(true);
        pluginDetailsDescription.changelog = markDown2Html.convert(plugin.getChangelog());
        pluginDetailsDescription.migration = markDown2Html.convert(plugin.getMigration());
        pluginDetailsDescription.hasMoreChanges = plugin.getChanges().size() > 1;
        pluginDetailsDescription.deactivatable = plugin.isDeactivatable();
        pluginDetailsDescription.deinstallable = plugin.isDeinstallable();
        boolean bl = PluginConfigManager.getInstance().isPublicStore();
        Collection<String> collection = plugin.getDependencies();
        pluginDetailsDescription.dependencies = collection.stream().map(id -> {
            PluginMergedDetails pluginMergedDetails = PluginConfigManager.getInstance().getPlugin((String)id, betaVersions, version);
            if (pluginMergedDetails != null) {
                boolean bl;
                boolean bl2 = bl = plugin.getAvailableState() != AvailableState.Installable && !pluginMergedDetails.isRunning();
                boolean bl3 = bl ? false : plugin.getAvailableState() == AvailableState.Deactivated;
                return new DependencyDescription((String)id, pluginMergedDetails.getName(), bl, bl3, false);
            }
            boolean bl = bl ? false : AvailableState.Installable == plugin.getAvailableState();
            return new DependencyDescription((String)id, (String)id, true, false, bl);
        }).sorted((a2, b2) -> Objects.requireNonNullElse(a2.getDisplayName(), "").compareToIgnoreCase(Objects.requireNonNullElse(b2.getDisplayName(), ""))).collect(Collectors.toList());
        Collection<String> collection2 = plugin.getOptionalDependencies();
        pluginDetailsDescription.optionalDependencies = collection2.stream().map(id -> {
            PluginMergedDetails pluginMergedDetails = PluginConfigManager.getInstance().getPlugin((String)id, betaVersions, version);
            if (pluginMergedDetails != null) {
                boolean bl;
                boolean bl2 = bl ? false : (bl = pluginMergedDetails.getAvailableState() == AvailableState.Deactivated);
                boolean bl3 = bl ? false : AvailableState.Installable == pluginMergedDetails.getAvailableState();
                return new DependencyDescription((String)id, pluginMergedDetails.getName(), false, bl, bl3);
            }
            return null;
        }).filter(d2 -> d2 != null).sorted((a2, b2) -> a2.getDisplayName().compareToIgnoreCase(b2.getDisplayName())).collect(Collectors.toList());
        pluginDetailsDescription.requiredBy = new ArrayList<DependencyDescription>();
        pluginDetailsDescription.extendedBy = new ArrayList<DependencyDescription>();
        Collection<PluginMergedDetails> collection3 = PluginConfigManager.getInstance().getPlugins(null, null, betaVersions, null, version);
        for (PluginMergedDetails object2 : collection3) {
            Object object3;
            boolean bl2;
            boolean bl3;
            object = object2.getDependencies();
            boolean bl4 = bl ? false : (bl3 = object2.getAvailableState() == AvailableState.Deactivated);
            boolean bl5 = bl ? false : (bl2 = AvailableState.Installable == object2.getAvailableState());
            if (object.contains(plugin.getId())) {
                pluginDetailsDescription.requiredBy.add(new DependencyDescription(object2.getId(), object2.getName(), false, bl3, bl2));
            }
            if (!(object3 = object2.getOptionalDependencies()).contains(plugin.getId())) continue;
            pluginDetailsDescription.extendedBy.add(new DependencyDescription(object2.getId(), object2.getName(), false, bl3, bl2));
        }
        if (bl) {
            var9_9 = plugin.getFlags();
            pluginDetailsDescription.availableForProduct = new ArrayList<LocalizedKey>();
            String string = plugin.getApp();
            switch (string) {
                case "inetcore": {
                    pluginDetailsDescription.availableForProduct.add(new LocalizedKey("reporting", PluginConfigManager.getAppName("reporting")));
                    pluginDetailsDescription.availableForProduct.add(new LocalizedKey("helpdesk", PluginConfigManager.getAppName("helpdesk")));
                    pluginDetailsDescription.availableForProduct.add(new LocalizedKey("pdfc", PluginConfigManager.getAppName("pdfc")));
                    pluginDetailsDescription.availableForProduct.add(new LocalizedKey("cowork", PluginConfigManager.getAppName("cowork")));
                    break;
                }
                case "reporting": {
                    pluginDetailsDescription.availableForProduct.add(new LocalizedKey("reporting", PluginConfigManager.getAppName("reporting")));
                    if (var9_9.contains("helpdesk")) {
                        pluginDetailsDescription.availableForProduct.add(new LocalizedKey("helpdesk", PluginConfigManager.getAppName("helpdesk")));
                    }
                    if (var9_9.contains("pdfc")) {
                        pluginDetailsDescription.availableForProduct.add(new LocalizedKey("pdfc", PluginConfigManager.getAppName("pdfc")));
                    }
                    if (!var9_9.contains("cowork")) break;
                    pluginDetailsDescription.availableForProduct.add(new LocalizedKey("cowork", PluginConfigManager.getAppName("cowork")));
                    break;
                }
                case "pdfc": {
                    pluginDetailsDescription.availableForProduct.add(new LocalizedKey("pdfc", PluginConfigManager.getAppName("pdfc")));
                    if (var9_9.contains("reporting")) {
                        pluginDetailsDescription.availableForProduct.add(new LocalizedKey("reporting", PluginConfigManager.getAppName("reporting")));
                    }
                    if (var9_9.contains("helpdesk")) {
                        pluginDetailsDescription.availableForProduct.add(new LocalizedKey("helpdesk", PluginConfigManager.getAppName("helpdesk")));
                    }
                    if (!var9_9.contains("cowork")) break;
                    pluginDetailsDescription.availableForProduct.add(new LocalizedKey("cowork", PluginConfigManager.getAppName("cowork")));
                    break;
                }
                case "helpdesk": {
                    pluginDetailsDescription.availableForProduct.add(new LocalizedKey("helpdesk", PluginConfigManager.getAppName("helpdesk")));
                    if (var9_9.contains("reporting")) {
                        pluginDetailsDescription.availableForProduct.add(new LocalizedKey("reporting", PluginConfigManager.getAppName("reporting")));
                    }
                    if (var9_9.contains("pdfc")) {
                        pluginDetailsDescription.availableForProduct.add(new LocalizedKey("pdfc", PluginConfigManager.getAppName("pdfc")));
                    }
                    if (!var9_9.contains("cowork")) break;
                    pluginDetailsDescription.availableForProduct.add(new LocalizedKey("cowork", PluginConfigManager.getAppName("cowork")));
                    break;
                }
                case "cowork": {
                    pluginDetailsDescription.availableForProduct.add(new LocalizedKey("reporting", PluginConfigManager.getAppName("reporting")));
                    pluginDetailsDescription.availableForProduct.add(new LocalizedKey("helpdesk", PluginConfigManager.getAppName("helpdesk")));
                    pluginDetailsDescription.availableForProduct.add(new LocalizedKey("pdfc", PluginConfigManager.getAppName("pdfc")));
                    pluginDetailsDescription.availableForProduct.add(new LocalizedKey("cowork", PluginConfigManager.getAppName("cowork")));
                }
            }
            pluginDetailsDescription.isJar = var9_9.contains("jar");
        } else {
            var9_9 = new ArrayList<LocalizedKey>();
            ServerPluginDescription serverPluginDescription = ServerPluginManager.getInstance().getPluginDescription(plugin.getId());
            if (serverPluginDescription != null && !"pluginstore.client".equals(serverPluginDescription.getId())) {
                object = serverPluginDescription.getClassLoader();
                ModuleManager moduleManager = ModuleManager.getInstance();
                List list = moduleManager.getPaths();
                for (String string : list) {
                    IModule iModule = moduleManager.getModule(string);
                    if (!iModule.getClass().getClassLoader().equals(object)) continue;
                    var9_9.add(new LocalizedKey(iModule.getPath(), iModule.getName()));
                }
            }
            pluginDetailsDescription.apps = var9_9;
        }
        return pluginDetailsDescription;
    }
}

