/*
 * Decompiled with CFR 0.152.
 */
package com.inet.store.client.ui.data;

import com.inet.annotations.JsonData;
import com.inet.lib.util.StringFunctions;
import com.inet.store.client.internal.MavenChannel;
import com.inet.store.client.internal.e;
import com.inet.store.client.shared.AvailableState;
import com.inet.store.client.shared.PluginMergedDetails;

@JsonData
public class PluginDescription {
    private String id;
    private String version;
    private String displayName;
    private String description;
    private boolean faulty;
    private AvailableState state;
    private boolean beta;
    private boolean isJar;

    private PluginDescription() {
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static PluginDescription from(PluginMergedDetails plugin) {
        int n2;
        PluginDescription pluginDescription = new PluginDescription();
        pluginDescription.id = plugin.getId();
        pluginDescription.version = plugin.getUpdatedVersion();
        if (StringFunctions.isEmpty((String)pluginDescription.version)) {
            pluginDescription.version = plugin.getVersion();
        }
        pluginDescription.displayName = plugin.getName();
        pluginDescription.description = plugin.getDescription();
        if (pluginDescription.description != null && (n2 = pluginDescription.description.indexOf(10, 10)) > 0) {
            pluginDescription.description = pluginDescription.description.substring(0, n2).trim();
        }
        pluginDescription.state = plugin.getAvailableState();
        if (e.p().d(plugin.getId())) {
            pluginDescription.state = AvailableState.InProgress;
        }
        pluginDescription.faulty = !StringFunctions.isEmpty((String)plugin.getError());
        pluginDescription.beta = MavenChannel.Beta == plugin.getUpdatedChannel();
        pluginDescription.isJar = plugin.getFlags().contains("jar");
        return pluginDescription;
    }
}

