/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.spi.searchlistener;

import com.inet.id.GUID;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceListener;
import com.inet.persistence.spi.searchlistener.NotfifyIndexChangeEvent;
import com.inet.persistence.spi.searchlistener.RegisterSearchListenerMatcherEvent;
import com.inet.persistence.spi.searchlistener.RegisterSearchListenerTokenEvent;
import com.inet.persistence.spi.searchlistener.SearchListenerContainer;
import com.inet.search.SearchTag;
import com.inet.search.index.SearchResultListener;
import com.inet.shared.utils.WeakValueMap;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;

public class SearchListenerManager {
    private final WeakValueMap<GUID, SearchResultListener<?>> listeners = new WeakValueMap();
    private final Map<SearchResultListener<?>, GUID> listenerIDs = Collections.synchronizedMap(new WeakHashMap());
    @Nonnull
    private final Persistence persistence;
    private final ConcurrentHashMap<String, SearchListenerContainer<?>> containers = new ConcurrentHashMap();
    private Set<GUID> cloudPossibleChangedListeners = ConcurrentHashMap.newKeySet();
    private AtomicBoolean cloudPossibleChangedListenersTimer = new AtomicBoolean();

    public SearchListenerManager(@Nonnull Persistence persistence) {
        this.persistence = persistence;
        persistence.registerListener((PersistenceListener)new NotfifyIndexChangeListener());
        persistence.registerListener((PersistenceListener)new RegisterSearchListenerTokenListener());
        persistence.registerListener((PersistenceListener)new RegisterSearchListenerMatcherListener());
    }

    @Nonnull
    public <ID> SearchListenerContainer<ID> createContainer(@Nonnull String indexName, @Nonnull SearchTag searchTag) {
        String indexTagID = indexName + "|" + searchTag.getTag();
        SearchListenerContainer container = new SearchListenerContainer(this.persistence, this, indexTagID, searchTag);
        this.containers.put(indexTagID, container);
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    GUID getListenerID(@Nonnull SearchResultListener<?> listener) {
        SearchListenerManager searchListenerManager = this;
        synchronized (searchListenerManager) {
            GUID id = this.listenerIDs.get(listener);
            if (id == null) {
                id = GUID.generateNew();
                this.listenerIDs.put(listener, id);
                this.listeners.put((Object)id, listener);
            }
            return id;
        }
    }

    void notifyChangedListeners(@Nonnull List<GUID> listenerIDs) {
        this.cloudPossibleChangedListeners.addAll(listenerIDs);
        if (this.cloudPossibleChangedListenersTimer.compareAndSet(false, true)) {
            DefaultTimerTask task = new DefaultTimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runImpl() throws Throwable {
                    HashSet<GUID> ids;
                    SearchListenerManager.this.cloudPossibleChangedListenersTimer.set(false);
                    Set<GUID> set = SearchListenerManager.this.cloudPossibleChangedListeners;
                    synchronized (set) {
                        ids = new HashSet<GUID>(SearchListenerManager.this.cloudPossibleChangedListeners);
                        SearchListenerManager.this.cloudPossibleChangedListeners.clear();
                    }
                    if (!ids.isEmpty()) {
                        SearchListenerManager.this.persistence.sendEvent((Object)new NotfifyIndexChangeEvent(ids));
                    }
                }
            };
            DefaultTimer.getInstance().schedule(task, 200L);
        }
    }

    class NotfifyIndexChangeListener
    implements PersistenceListener<NotfifyIndexChangeEvent> {
        NotfifyIndexChangeListener() {
        }

        public void eventReceived(@Nonnull NotfifyIndexChangeEvent event) {
            for (GUID guid : event.getIds()) {
                SearchResultListener listener = (SearchResultListener)SearchListenerManager.this.listeners.get((Object)guid);
                if (listener == null) continue;
                listener.markPossibleChanged();
            }
            ForkJoinPool.commonPool().execute(() -> {
                for (SearchResultListener listener : SearchListenerManager.this.listeners.values()) {
                    if (listener == null) continue;
                    listener.check();
                }
            });
        }
    }

    class RegisterSearchListenerTokenListener
    implements PersistenceListener<RegisterSearchListenerTokenEvent> {
        RegisterSearchListenerTokenListener() {
        }

        public void eventReceived(@Nonnull RegisterSearchListenerTokenEvent event) {
            SearchListenerContainer<?> container = SearchListenerManager.this.containers.get(event.indexTagID);
            if (container != null) {
                container.handleCloudTokenChangedListener(event);
            }
        }
    }

    class RegisterSearchListenerMatcherListener
    implements PersistenceListener<RegisterSearchListenerMatcherEvent> {
        RegisterSearchListenerMatcherListener() {
        }

        public void eventReceived(@Nonnull RegisterSearchListenerMatcherEvent event) {
            SearchListenerContainer<?> container = SearchListenerManager.this.containers.get(event.indexTagID);
            if (container != null) {
                container.handleCloudMatcherChangedListener(event);
            }
        }
    }
}

