/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.mongodb;

import com.inet.cache.shutdown.ShutdownFinalizer;
import com.inet.cache.shutdown.ShutdownManager;
import com.inet.http.security.CombinedProvider;
import com.inet.id.GUID;
import com.inet.persistence.EventLogPersistence;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.persistence.PersistenceListener;
import com.inet.persistence.SearchIndexPersistence;
import com.inet.persistence.mongodb.MongoDbEventLogPersistence;
import com.inet.persistence.mongodb.MongoDbLocks;
import com.inet.persistence.mongodb.MongoDbPersistenceEntry;
import com.inet.persistence.mongodb.MongoDbPublishSubscribe;
import com.inet.persistence.mongodb.MongoDbSearchIndexPersistence;
import com.inet.persistence.spi.PersistenceLogger;
import com.inet.persistence.spi.events.NodeCounter;
import com.inet.persistence.spi.events.PersistenceListenerContainer;
import com.inet.persistence.spi.searchlistener.SearchListenerManager;
import com.inet.persistence.spi.util.PersistenceUtils;
import com.inet.thread.ServerLock;
import com.mongodb.BasicDBObject;
import com.mongodb.ConnectionString;
import com.mongodb.MongoSecurityException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import com.mongodb.lang.Nullable;
import java.net.UnknownHostException;
import javax.annotation.Nonnull;
import org.bson.Document;
import org.bson.conversions.Bson;

class MongoDbPersistence
implements Persistence {
    private static MongoClient mongo;
    private static MongoDatabase database;
    private static MongoCollection<Document> fs;
    private static GridFSBucket gridFS;
    private static String CLIENT_ID;
    private final PersistenceListenerContainer listeners = new PersistenceListenerContainer();
    private static MongoDbPublishSubscribe pubsub;
    private static NodeCounter nodeCounter;
    private final MongoDbLocks locks = new MongoDbLocks();
    private static SearchListenerManager searchListenerManager;

    private static void cleanup() {
        if (mongo == null) {
            return;
        }
        if (pubsub != null) {
            pubsub.stop();
            pubsub = null;
        }
        if (nodeCounter != null) {
            nodeCounter.onShutdown();
            nodeCounter = null;
        }
        mongo.close();
        mongo = null;
    }

    MongoDbPersistence(String uri) throws UnknownHostException {
        int logLevel = PersistenceLogger.LOGGER.getLogLevel();
        PersistenceLogger.LOGGER.setLogLevel(4);
        String ssl_ca_certs = PersistenceUtils.getQueryParams(uri).get("ssl_ca_certs");
        if (ssl_ca_certs != null) {
            CombinedProvider.addCertificates((String)ssl_ca_certs);
        }
        ConnectionString clientURI = new ConnectionString(uri);
        try {
            MongoDbPersistence.init(clientURI, "inet");
        }
        catch (MongoSecurityException ex) {
            String databaseName = clientURI.getDatabase();
            if (databaseName == null) {
                throw ex;
            }
            uri = uri.replace("/" + databaseName, "/");
            clientURI = new ConnectionString(uri);
            MongoDbPersistence.init(clientURI, databaseName);
        }
        PersistenceLogger.LOGGER.setLogLevel(logLevel);
        fs = database.getCollection("fs.files");
        MongoDbPersistenceEntry.createIndexes(fs);
        pubsub = new MongoDbPublishSubscribe(this.listeners);
        pubsub.start(CLIENT_ID);
        nodeCounter = new NodeCounter(this);
        this.registerListener(nodeCounter);
        searchListenerManager = new SearchListenerManager(this);
    }

    private static void init(ConnectionString clientURI, String fallbackDatabaseName) {
        MongoDbPersistence.cleanup();
        mongo = MongoClients.create((ConnectionString)clientURI);
        String databaseName = clientURI.getDatabase();
        if (databaseName == null) {
            databaseName = fallbackDatabaseName;
        }
        database = mongo.getDatabase(databaseName);
        database.runCommand((Bson)new BasicDBObject("ping", (Object)"1"));
    }

    static MongoDatabase getDatabase() {
        return database;
    }

    static MongoCollection<Document> getFileSystem() {
        return fs;
    }

    static GridFSBucket getGridFS() {
        if (gridFS == null) {
            gridFS = GridFSBuckets.create((MongoDatabase)database);
        }
        return gridFS;
    }

    static SearchListenerManager getSearchListenerManager() {
        return searchListenerManager;
    }

    @Nonnull
    public PersistenceEntry resolve(@Nonnull String path) {
        return new MongoDbPersistenceEntry(path);
    }

    @Nonnull
    public EventLogPersistence getEventLogPersistence(String name) {
        return new MongoDbEventLogPersistence(name);
    }

    public <T> void registerListener(@Nonnull PersistenceListener<T> listener) {
        this.listeners.addListener(listener);
    }

    public <T> void sendEvent(@Nonnull T event) {
        MongoDbPublishSubscribe pubsub = MongoDbPersistence.pubsub;
        if (pubsub != null) {
            pubsub.send(event, CLIENT_ID);
        }
    }

    public int getNodeCount() {
        return nodeCounter.getNodeCount();
    }

    public void registerNodeListener(@Nonnull PersistenceListener<Boolean> listener) {
        nodeCounter.addListener(listener);
    }

    public <ID> SearchIndexPersistence<ID> getSearchIndexPersistence(@Nonnull String name) {
        return new MongoDbSearchIndexPersistence(name);
    }

    @Nullable
    public ServerLock tryLock(@Nonnull String key) {
        return this.locks.tryLock(key);
    }

    @Nullable
    public ServerLock tryReadLock(@Nonnull String key) {
        return this.locks.tryReadWriteLock(key, false);
    }

    @Nullable
    public ServerLock tryWriteLock(@Nonnull String key) {
        return this.locks.tryReadWriteLock(key, true);
    }

    @Nonnull
    public ServerLock getReadLock(@Nonnull String key, long timeout) {
        return this.locks.getReadWriteLock(key, false, timeout);
    }

    @Nonnull
    public ServerLock getWriteLock(@Nonnull String key, long timeout) {
        return this.locks.getReadWriteLock(key, true, timeout);
    }

    static {
        CLIENT_ID = GUID.generateNew().toString();
        ShutdownManager.add((ShutdownFinalizer)new ShutdownFinalizer(){

            public void onShutdown() {
                MongoDbPersistence.cleanup();
            }

            public int order() {
                return 1000001;
            }
        });
    }
}

