/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.dynamodb;

import com.inet.persistence.dynamodb.DynamoDbPersistence;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

class AsyncBatch {
    private final WriteRequest.Builder writePutBuilder = WriteRequest.builder();
    private final WriteRequest.Builder writeDeleteBuilder = WriteRequest.builder();
    private final PutRequest.Builder putBuilder = PutRequest.builder();
    private final DeleteRequest.Builder deleteBuilder = DeleteRequest.builder();
    @Nonnull
    private LinkedHashMap<Map<String, AttributeValue>, WriteRequest> writeOperations = AsyncBatch.newMap();
    private final String tableName;
    private int writeCount;
    private String[] pks;

    @Nonnull
    private static LinkedHashMap<Map<String, AttributeValue>, WriteRequest> newMap() {
        return new LinkedHashMap<Map<String, AttributeValue>, WriteRequest>(25, 0.75f, true);
    }

    AsyncBatch(@Nonnull String tableName) {
        this(tableName, null);
    }

    AsyncBatch(@Nonnull String tableName, String ... pks) {
        this.tableName = tableName;
        this.pks = pks;
    }

    void addPutItem(@Nonnull Map<String, AttributeValue> item) {
        this.checkBatch();
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        for (int i = 0; i < this.pks.length; ++i) {
            String k = this.pks[i];
            key.put(k, item.get(k));
        }
        this.writeOperations.put(key, (WriteRequest)this.writePutBuilder.putRequest((PutRequest)this.putBuilder.item(item).build()).build());
    }

    void addDeleteItem(@Nonnull Map<String, AttributeValue> key) {
        this.checkBatch();
        this.writeOperations.put(key, (WriteRequest)this.writeDeleteBuilder.deleteRequest((DeleteRequest)this.deleteBuilder.key(key).build()).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBatch() {
        if (this.writeOperations.size() == 25) {
            Collection<WriteRequest> operations = this.writeOperations.values();
            this.writeOperations = new LinkedHashMap(25);
            AsyncBatch asyncBatch = this;
            synchronized (asyncBatch) {
                ++this.writeCount;
            }
            ForkJoinPool.commonPool().execute(() -> {
                this.writeBatch(operations);
                AsyncBatch asyncBatch = this;
                synchronized (asyncBatch) {
                    --this.writeCount;
                    this.notifyAll();
                }
            });
        }
    }

    private void writeBatch(@Nonnull Collection<WriteRequest> operations) {
        BatchWriteItemRequest write;
        BatchWriteItemResponse response;
        Map items = Collections.singletonMap(this.tableName, operations);
        do {
            write = (BatchWriteItemRequest)BatchWriteItemRequest.builder().requestItems(items).build();
        } while (!(items = (response = DynamoDbPersistence.getClient().batchWriteItem(write)).unprocessedItems()).isEmpty());
    }

    void flush() {
        if (!this.writeOperations.isEmpty()) {
            Collection<WriteRequest> operations = this.writeOperations.values();
            this.writeOperations = AsyncBatch.newMap();
            this.writeBatch(operations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void flushAndWait() {
        this.flush();
        AsyncBatch asyncBatch = this;
        synchronized (asyncBatch) {
            while (this.writeCount != 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            return;
        }
    }
}

