/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.azure.cosmos;

import com.inet.error.ErrorCode;
import java.util.ArrayDeque;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;

class MonoQueue {
    private final ArrayDeque<QueuedSubscriber> queue;
    private final int maxSize;

    MonoQueue(int maxSize) {
        this.maxSize = maxSize;
        this.queue = new ArrayDeque(maxSize);
    }

    void add(@Nonnull Mono<?> mono) {
        this.add(mono, null);
    }

    void add(@Nonnull Mono<?> mono, @Nullable Consumer<Throwable> errorConsumer) {
        if (this.queue.size() >= this.maxSize) {
            this.queue.pollFirst().block();
        }
        QueuedSubscriber subscriber = new QueuedSubscriber(errorConsumer);
        mono.subscribe((CoreSubscriber)subscriber);
        this.queue.addLast(subscriber);
    }

    void block() {
        while (this.queue.size() > 0) {
            this.queue.pollFirst().block();
        }
    }

    private static final class QueuedSubscriber
    implements CoreSubscriber<Object> {
        private final CountDownLatch count = new CountDownLatch(1);
        private Throwable error;
        private Consumer<Throwable> errorConsumer;

        public QueuedSubscriber(Consumer<Throwable> errorConsumer) {
            this.errorConsumer = errorConsumer;
        }

        public void onNext(Object t) {
            this.count.countDown();
        }

        public void onError(Throwable t) {
            if (this.error == null) {
                this.error = t;
            } else {
                this.error.addSuppressed(t);
            }
            this.count.countDown();
        }

        public void onComplete() {
            this.count.countDown();
        }

        public void onSubscribe(Subscription s) {
            s.request(Long.MAX_VALUE);
        }

        void block() {
            try {
                this.count.await();
            }
            catch (InterruptedException ex) {
                ErrorCode.throwAny((Throwable)ex);
            }
            Throwable th = this.error;
            if (th != null) {
                if (this.errorConsumer != null) {
                    try {
                        this.errorConsumer.accept(th);
                        return;
                    }
                    catch (Exception ex) {
                        th = ex;
                    }
                }
                th.addSuppressed(new Exception("#block terminated with an error"));
                ErrorCode.throwAny((Throwable)th);
            }
        }
    }
}

