/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.dynamodb;

import com.inet.id.GUID;
import com.inet.lib.util.NetworkFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.EventLog;
import com.inet.persistence.EventLogPersistence;
import com.inet.persistence.dynamodb.DynamoDbPersistence;
import com.inet.persistence.dynamodb.DynamoDbUtils;
import com.inet.persistence.spi.PersistenceHelper;
import com.inet.usersandgroups.api.user.UserAccount;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.services.dynamodb.model.ProjectionType;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ResourceInUseException;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.dynamodb.model.TimeToLiveSpecification;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveRequest;
import software.amazon.awssdk.services.dynamodb.waiters.DynamoDbWaiter;

class DynamoDbEventLogPersistence
implements EventLogPersistence {
    private static final String TABLE_NAME = "events";
    @Nonnull
    private static String tableName = "events";
    private static final String ID = "id";
    private static final String EXPIRE = "expire";
    private static final String EVENTLOG = "eventlog";
    private static final String TIME = "time";
    private static final String ACCOUNT_ID = "account_id";
    private static final String ACCOUNT_NAME = "account_name";
    private static final String EVENT = "event";
    private static final String MESSAGE = "message";
    private static final String DATA = "data";
    private static final String EXTRA = "extra_";
    private static final String NODE = "node";
    private static final long DAYS30 = 2592000L;
    private static final String IDX_TIME = "idx_time";
    private final String name;

    DynamoDbEventLogPersistence(String name) {
        this.name = name;
    }

    static void createTable(DynamoDbClient client) {
        try {
            tableName = DynamoDbPersistence.getTablePrefix() + TABLE_NAME;
            AttributeDefinition[] attrs = new AttributeDefinition[]{(AttributeDefinition)AttributeDefinition.builder().attributeName(EVENTLOG).attributeType(ScalarAttributeType.S).build(), (AttributeDefinition)AttributeDefinition.builder().attributeName(ID).attributeType(ScalarAttributeType.S).build(), (AttributeDefinition)AttributeDefinition.builder().attributeName(TIME).attributeType(ScalarAttributeType.S).build()};
            KeySchemaElement log = (KeySchemaElement)KeySchemaElement.builder().attributeName(EVENTLOG).keyType(KeyType.HASH).build();
            KeySchemaElement id = (KeySchemaElement)KeySchemaElement.builder().attributeName(ID).keyType(KeyType.RANGE).build();
            KeySchemaElement time = (KeySchemaElement)KeySchemaElement.builder().attributeName(TIME).keyType(KeyType.RANGE).build();
            Projection projection = (Projection)Projection.builder().projectionType(ProjectionType.ALL).build();
            LocalSecondaryIndex idxtime = (LocalSecondaryIndex)LocalSecondaryIndex.builder().indexName(IDX_TIME).projection(projection).keySchema(new KeySchemaElement[]{log, time}).build();
            CreateTableRequest tableRequest = (CreateTableRequest)CreateTableRequest.builder().attributeDefinitions(attrs).keySchema(new KeySchemaElement[]{log, id}).localSecondaryIndexes(new LocalSecondaryIndex[]{idxtime}).billingMode(BillingMode.PAY_PER_REQUEST).tableName(tableName).build();
            client.createTable(tableRequest);
            DynamoDbWaiter dbWaiter = client.waiter();
            dbWaiter.waitUntilTableExists((DescribeTableRequest)DescribeTableRequest.builder().tableName(tableName).build());
            TimeToLiveSpecification timeSpec = (TimeToLiveSpecification)TimeToLiveSpecification.builder().enabled(Boolean.valueOf(true)).attributeName(EXPIRE).build();
            UpdateTimeToLiveRequest timeToLiveRequest = (UpdateTimeToLiveRequest)UpdateTimeToLiveRequest.builder().tableName(tableName).timeToLiveSpecification(timeSpec).build();
            client.updateTimeToLive(timeToLiveRequest);
        }
        catch (ResourceInUseException resourceInUseException) {
            // empty catch block
        }
    }

    public void write(EventLog.EventData eventData) {
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        DynamoDbEventLogPersistence.put(item, EVENTLOG, this.name);
        DynamoDbEventLogPersistence.put(item, ID, GUID.generateNew().toString());
        item.put(EXPIRE, AttributeValue.fromN((String)String.valueOf(System.currentTimeMillis() / 1000L + 2592000L)));
        DynamoDbEventLogPersistence.put(item, TIME, PersistenceHelper.ISO_INSTANT.format(Instant.ofEpochMilli(eventData.getTimeMillis())));
        UserAccount account = eventData.getAccount();
        if (account != null) {
            DynamoDbEventLogPersistence.put(item, ACCOUNT_ID, account.getID().toString());
            DynamoDbEventLogPersistence.put(item, ACCOUNT_NAME, account.getDisplayName());
        }
        DynamoDbEventLogPersistence.put(item, EVENT, eventData.getEvent());
        DynamoDbEventLogPersistence.put(item, MESSAGE, eventData.getMessage());
        DynamoDbEventLogPersistence.put(item, DATA, eventData.getData());
        Object[] extra = eventData.getExtraColumns();
        if (extra != null) {
            for (int i = 0; i < extra.length; ++i) {
                Object value = extra[i];
                String str = value == null ? "" : value.toString();
                DynamoDbEventLogPersistence.put(item, EXTRA + i, str);
            }
        }
        item.put(NODE, AttributeValue.fromS((String)NetworkFunctions.getLocalHostName()));
        DynamoDbUtils.putItem(tableName, item);
    }

    private static void put(@Nonnull HashMap<String, AttributeValue> item, @Nonnull String key, @Nullable String value) {
        if (!StringFunctions.isEmpty((String)value)) {
            item.put(key, AttributeValue.fromS((String)value));
        }
    }

    public void close() {
    }

    @Nonnull
    private QueryRequest.Builder createQueryBuilder() {
        return QueryRequest.builder().tableName(tableName).indexName(IDX_TIME).scanIndexForward(Boolean.TRUE).keyConditionExpression("eventlog=:log").expressionAttributeValues(Collections.singletonMap(":log", AttributeValue.fromS((String)this.name)));
    }

    public void delete() {
        QueryRequest.Builder builder = this.createQueryBuilder().projectionExpression("eventlog,id");
        DynamoDbUtils.batchDelete(builder);
    }

    public Iterator<String[]> getEvents(final int columnCount) {
        final QueryRequest.Builder builder = this.createQueryBuilder();
        return new Iterator<String[]>(){
            private String[] row;
            private ArrayDeque<Map<String, AttributeValue>> list;
            private Map<String, AttributeValue> lastEvaluatedKey;
            {
                this.row = new String[columnCount];
                this.list = new ArrayDeque();
            }

            @Override
            public boolean hasNext() {
                while (this.list.isEmpty() && (this.lastEvaluatedKey == null || !this.lastEvaluatedKey.isEmpty())) {
                    QueryResponse response = DynamoDbPersistence.getClient().query((QueryRequest)builder.build());
                    response.items();
                    this.list.addAll(response.items());
                    this.lastEvaluatedKey = response.lastEvaluatedKey();
                    builder.exclusiveStartKey(this.lastEvaluatedKey);
                }
                return !this.list.isEmpty();
            }

            @Override
            public String[] next() {
                if (this.hasNext()) {
                    Map<String, AttributeValue> item = this.list.pop();
                    String[] row = this.row;
                    DynamoDbEventLogPersistence.set(row, 0, item, DynamoDbEventLogPersistence.TIME);
                    DynamoDbEventLogPersistence.set(row, 1, item, DynamoDbEventLogPersistence.ACCOUNT_ID);
                    DynamoDbEventLogPersistence.set(row, 2, item, DynamoDbEventLogPersistence.ACCOUNT_NAME);
                    DynamoDbEventLogPersistence.set(row, 3, item, DynamoDbEventLogPersistence.EVENT);
                    DynamoDbEventLogPersistence.set(row, 4, item, DynamoDbEventLogPersistence.MESSAGE);
                    DynamoDbEventLogPersistence.set(row, 5, item, DynamoDbEventLogPersistence.DATA);
                    for (int i = 6; i < row.length - 1; ++i) {
                        DynamoDbEventLogPersistence.set(row, i, item, DynamoDbEventLogPersistence.EXTRA + (i - 6));
                    }
                    DynamoDbEventLogPersistence.set(row, row.length - 1, item, DynamoDbEventLogPersistence.NODE);
                    return row;
                }
                throw new NoSuchElementException();
            }
        };
    }

    private static void set(String[] row, int idx, Map<String, AttributeValue> item, String key) {
        String str;
        if (row.length <= idx) {
            return;
        }
        AttributeValue attr = item.get(key);
        if (attr == null) {
            str = "";
        } else {
            str = attr.s();
            if (str == null) {
                str = "";
            }
        }
        row[idx] = str;
    }
}

