/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosDiagnosticsThresholds;
import com.azure.cosmos.CosmosEndToEndOperationLatencyPolicyConfig;
import com.azure.cosmos.ReadConsistencyStrategy;
import com.azure.cosmos.implementation.apachecommons.collections.list.UnmodifiableList;
import com.azure.cosmos.models.DedicatedGatewayRequestOptions;
import com.azure.cosmos.util.Beta;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class CosmosRequestOptions {
    private CosmosEndToEndOperationLatencyPolicyConfig endToEndOperationLatencyConfig;
    private ConsistencyLevel consistencyLevel;
    private Boolean contentResponseOnWriteEnabled;
    private Boolean nonIdempotentWriteRetriesEnabled;
    private DedicatedGatewayRequestOptions dedicatedGatewayRequestOptions;
    private String throughputControlGroupName;
    private CosmosDiagnosticsThresholds thresholds;
    private Boolean scanInQueryEnabled;
    private List<String> excludeRegions;
    private Integer maxDegreeOfParallelism;
    private Integer maxBufferedItemCount;
    private Integer responseContinuationTokenLimitInKb;
    private Integer maxItemCount;
    private Boolean queryMetricsEnabled;
    private Boolean indexMetricsEnabled;
    private Integer maxPrefetchPageCount;
    private String queryName;
    private Set<String> keywordIdentifiers;
    private ReadConsistencyStrategy readConsistencyStrategy;
    private static final Set<String> EMPTY_KEYWORD_IDENTIFIERS = Collections.unmodifiableSet(new HashSet());

    public CosmosRequestOptions setCosmosEndToEndLatencyPolicyConfig(CosmosEndToEndOperationLatencyPolicyConfig endToEndOperationLatencyPolicyConfig) {
        this.endToEndOperationLatencyConfig = endToEndOperationLatencyPolicyConfig;
        return this;
    }

    public CosmosRequestOptions setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_69_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosRequestOptions setReadConsistencyStrategy(ReadConsistencyStrategy readConsistencyStrategy) {
        this.readConsistencyStrategy = readConsistencyStrategy;
        return this;
    }

    public CosmosRequestOptions setContentResponseOnWriteEnabled(Boolean contentResponseOnWriteEnabled) {
        this.contentResponseOnWriteEnabled = contentResponseOnWriteEnabled;
        return this;
    }

    public CosmosRequestOptions setNonIdempotentWriteRetriesEnabled(Boolean nonIdempotentWriteRetriesEnabled) {
        this.nonIdempotentWriteRetriesEnabled = nonIdempotentWriteRetriesEnabled;
        return this;
    }

    public CosmosRequestOptions setDedicatedGatewayRequestOptions(DedicatedGatewayRequestOptions dedicatedGatewayRequestOptions) {
        this.dedicatedGatewayRequestOptions = dedicatedGatewayRequestOptions;
        return this;
    }

    public CosmosRequestOptions setExcludeRegions(List<String> excludeRegions) {
        this.excludeRegions = excludeRegions;
        return this;
    }

    public CosmosRequestOptions setThroughputControlGroupName(String throughputControlGroupName) {
        this.throughputControlGroupName = throughputControlGroupName;
        return this;
    }

    public CosmosRequestOptions setDiagnosticsThresholds(CosmosDiagnosticsThresholds thresholds) {
        this.thresholds = thresholds;
        return this;
    }

    public CosmosRequestOptions setScanInQueryEnabled(Boolean scanInQueryEnabled) {
        this.scanInQueryEnabled = scanInQueryEnabled;
        return this;
    }

    public CosmosRequestOptions setMaxDegreeOfParallelism(Integer maxDegreeOfParallelism) {
        this.maxDegreeOfParallelism = maxDegreeOfParallelism;
        return this;
    }

    public CosmosRequestOptions setMaxBufferedItemCount(Integer maxBufferedItemCount) {
        this.maxBufferedItemCount = maxBufferedItemCount;
        return this;
    }

    public CosmosRequestOptions setResponseContinuationTokenLimitInKb(Integer responseContinuationTokenLimitInKb) {
        this.responseContinuationTokenLimitInKb = responseContinuationTokenLimitInKb;
        return this;
    }

    public CosmosRequestOptions setMaxItemCount(Integer maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public CosmosRequestOptions setQueryMetricsEnabled(Boolean queryMetricsEnabled) {
        this.queryMetricsEnabled = queryMetricsEnabled;
        return this;
    }

    public CosmosRequestOptions setIndexMetricsEnabled(Boolean indexMetricsEnabled) {
        this.indexMetricsEnabled = indexMetricsEnabled;
        return this;
    }

    public CosmosRequestOptions setMaxPrefetchPageCount(Integer maxPrefetchPageCount) {
        this.maxPrefetchPageCount = maxPrefetchPageCount;
        return this;
    }

    public CosmosRequestOptions setQueryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    public CosmosRequestOptions setKeywordIdentifiers(Set<String> keywordIdentifiers) {
        this.keywordIdentifiers = keywordIdentifiers != null ? Collections.unmodifiableSet(keywordIdentifiers) : EMPTY_KEYWORD_IDENTIFIERS;
        return this;
    }

    public Integer getMaxItemCount() {
        return this.maxItemCount;
    }

    public Boolean isQueryMetricsEnabled() {
        return this.queryMetricsEnabled;
    }

    public Boolean isIndexMetricsEnabled() {
        return this.indexMetricsEnabled;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public Integer getMaxPrefetchPageCount() {
        return this.maxPrefetchPageCount;
    }

    public Integer getResponseContinuationTokenLimitInKb() {
        return this.responseContinuationTokenLimitInKb;
    }

    public Integer getMaxBufferedItemCount() {
        return this.maxBufferedItemCount;
    }

    public Integer getMaxDegreeOfParallelism() {
        return this.maxDegreeOfParallelism;
    }

    public List<String> getExcludedRegions() {
        if (this.excludeRegions == null) {
            return null;
        }
        return UnmodifiableList.unmodifiableList(this.excludeRegions);
    }

    public Boolean isScanInQueryEnabled() {
        return this.scanInQueryEnabled;
    }

    public CosmosDiagnosticsThresholds getDiagnosticsThresholds() {
        return this.thresholds;
    }

    public String getThroughputControlGroupName() {
        return this.throughputControlGroupName;
    }

    public DedicatedGatewayRequestOptions getDedicatedGatewayRequestOptions() {
        return this.dedicatedGatewayRequestOptions;
    }

    public Boolean getNonIdempotentWriteRetriesEnabled() {
        return this.nonIdempotentWriteRetriesEnabled;
    }

    public Boolean isContentResponseOnWriteEnabled() {
        return this.contentResponseOnWriteEnabled;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    @Beta(value=Beta.SinceVersion.V4_69_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public ReadConsistencyStrategy getReadConsistencyStrategy() {
        return this.readConsistencyStrategy;
    }

    public CosmosEndToEndOperationLatencyPolicyConfig getCosmosEndToEndLatencyPolicyConfig() {
        return this.endToEndOperationLatencyConfig;
    }

    public Set<String> getKeywordIdentifiers() {
        return this.keywordIdentifiers;
    }
}

