/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.ClientEncryptionIncludedPath;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class ClientEncryptionPolicy {
    private JsonSerializable jsonSerializable;
    @JsonProperty(value="includedPaths")
    private List<ClientEncryptionIncludedPath> includedPaths;
    @JsonProperty(value="policyFormatVersion")
    private int policyFormatVersion;

    public ClientEncryptionPolicy(List<ClientEncryptionIncludedPath> paths) {
        this.policyFormatVersion = 1;
        ClientEncryptionPolicy.validateIncludedPaths(paths, this.policyFormatVersion);
        this.includedPaths = paths;
    }

    public ClientEncryptionPolicy(List<ClientEncryptionIncludedPath> paths, int policyFormatVersion) {
        if (policyFormatVersion > 2 || policyFormatVersion < 1) {
            throw new IllegalArgumentException("Supported versions of client encryption policy are 1 and 2.");
        }
        this.policyFormatVersion = policyFormatVersion;
        ClientEncryptionPolicy.validateIncludedPaths(paths, policyFormatVersion);
        this.includedPaths = paths;
    }

    public ClientEncryptionPolicy() {
        this.jsonSerializable = new JsonSerializable();
    }

    public List<ClientEncryptionIncludedPath> getIncludedPaths() {
        return this.includedPaths;
    }

    public int getPolicyFormatVersion() {
        return this.policyFormatVersion;
    }

    void validatePartitionKeyPathsIfEncrypted(List<List<String>> partitionKeyPathTokens) {
        Preconditions.checkNotNull(partitionKeyPathTokens, "partitionKeyPathTokens cannot be null");
        for (List<String> tokensInPath : partitionKeyPathTokens) {
            Preconditions.checkNotNull(tokensInPath);
            if (tokensInPath.size() <= 0) continue;
            String topLevelToken = tokensInPath.get(0);
            List encrypterPartitionKeyPath = this.includedPaths.stream().filter(clientEncryptionIncludedPath -> clientEncryptionIncludedPath.getPath().substring(1).equals(topLevelToken)).collect(Collectors.toList());
            if (encrypterPartitionKeyPath.size() <= 0) continue;
            if (this.policyFormatVersion < 2) {
                throw new IllegalArgumentException(String.format("Path %s which is part of the partition key cannot be encrypted with PolicyFormatVersion %s. Please use PolicyFormatVersion 2.", topLevelToken, this.policyFormatVersion));
            }
            if (((String)encrypterPartitionKeyPath.stream().map(encrypter -> encrypter.getEncryptionType()).findFirst().orElse(null)).equals("Deterministic")) continue;
            throw new IllegalArgumentException(String.format("Path %s which is part of the partition key has to be encrypted with Deterministic type Encryption.", topLevelToken));
        }
    }

    private static void validateIncludedPaths(List<ClientEncryptionIncludedPath> clientEncryptionIncludedPath, int policyFormatVersion) {
        ArrayList<String> includedPathsList = new ArrayList<String>();
        for (ClientEncryptionIncludedPath path : clientEncryptionIncludedPath) {
            ClientEncryptionPolicy.validateClientEncryptionIncludedPath(path, policyFormatVersion);
            if (includedPathsList.contains(path.getPath())) {
                throw new IllegalArgumentException("Duplicate Path found in clientEncryptionIncludedPath.");
            }
            includedPathsList.add(path.getPath());
        }
    }

    private static void validateClientEncryptionIncludedPath(ClientEncryptionIncludedPath clientEncryptionIncludedPath, int policyFormatVersion) {
        if (clientEncryptionIncludedPath == null) {
            throw new IllegalArgumentException("clientEncryptionIncludedPath is null");
        }
        if (StringUtils.isEmpty(clientEncryptionIncludedPath.getPath())) {
            throw new IllegalArgumentException("path in clientEncryptionIncludedPath is empty");
        }
        if (clientEncryptionIncludedPath.getPath().charAt(0) != '/' || clientEncryptionIncludedPath.getPath().lastIndexOf(47) != 0) {
            throw new IllegalArgumentException("Invalid path " + clientEncryptionIncludedPath.getPath());
        }
        if (clientEncryptionIncludedPath.getPath().substring(1).equals("id")) {
            if (policyFormatVersion < 2) {
                throw new IllegalArgumentException(String.format("Path %s cannot be encrypted with policyFormatVersion %s.", clientEncryptionIncludedPath.getPath(), policyFormatVersion));
            }
            if (!clientEncryptionIncludedPath.getEncryptionType().equals("Deterministic")) {
                throw new IllegalArgumentException(String.format("Only deterministic encryption type is supported for path %s.", clientEncryptionIncludedPath.getPath()));
            }
        }
        if (StringUtils.isEmpty(clientEncryptionIncludedPath.getClientEncryptionKeyId())) {
            throw new IllegalArgumentException("clientEncryptionKeyId in clientEncryptionIncludedPath is empty");
        }
        if (StringUtils.isEmpty(clientEncryptionIncludedPath.getEncryptionType())) {
            throw new IllegalArgumentException("encryptionType in clientEncryptionIncludedPath is empty");
        }
        if (!clientEncryptionIncludedPath.getEncryptionType().equals("Deterministic") && !clientEncryptionIncludedPath.getEncryptionType().equals("Randomized")) {
            throw new IllegalArgumentException("EncryptionType should be either 'Deterministic' or 'Randomized'.");
        }
        if (StringUtils.isEmpty(clientEncryptionIncludedPath.getEncryptionAlgorithm())) {
            throw new IllegalArgumentException("encryptionAlgorithm in clientEncryptionIncludedPath is empty");
        }
        if (!clientEncryptionIncludedPath.getEncryptionAlgorithm().equals("AEAD_AES_256_CBC_HMAC_SHA256")) {
            throw new IllegalArgumentException("EncryptionAlgorithm should be 'AEAD_AES_256_CBC_HMAC_SHA256'.");
        }
    }
}

